/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.xml;

import org.openrewrite.RefactorVisitorSupport;
import org.openrewrite.Tree;
import org.openrewrite.refactor.Formatter;
import org.openrewrite.xml.XmlSourceVisitor;
import org.openrewrite.xml.tree.Xml;

public abstract class XmlRefactorVisitor
extends XmlSourceVisitor<Xml>
implements RefactorVisitorSupport {
    protected Formatter formatter;

    public Xml defaultTo(Tree t) {
        return (Xml)t;
    }

    @Override
    public Xml visitDocument(Xml.Document document) {
        this.formatter = new Formatter((Tree)document);
        Xml.Document d = document;
        d = d.withProlog((Xml.Prolog)this.refactor(d.getProlog()));
        return d.withRoot((Xml.Tag)this.refactor(d.getRoot()));
    }

    @Override
    public Xml visitProlog(Xml.Prolog prolog) {
        Xml.Prolog p = prolog;
        p = p.withXmlDecl((Xml.ProcessingInstruction)this.refactor(p.getXmlDecl()));
        return p.withMisc(this.refactor(p.getMisc()));
    }

    @Override
    public Xml visitDocTypeDecl(Xml.DocTypeDecl docTypeDecl) {
        Xml.DocTypeDecl d = docTypeDecl;
        d = d.withName((Xml.Ident)this.refactor(d.getName()));
        d = d.withExternalId((Xml.Ident)this.refactor(d.getExternalId()));
        d = d.withExternalSubsets((Xml.DocTypeDecl.ExternalSubsets)this.refactor(d.getExternalSubsets()));
        return d.withInternalSubset(this.refactor(d.getInternalSubset()));
    }

    @Override
    public Xml visitElement(Xml.Element element) {
        return element.withSubset(element.getSubset());
    }

    @Override
    public Xml visitTag(Xml.Tag tag) {
        Xml.Tag t = tag;
        t = t.withAttributes(this.refactor(t.getAttributes()));
        t = t.withContent(this.refactor(t.getContent()));
        return t.withClosing((Xml.Tag.Closing)this.refactor(t.getClosing()));
    }

    @Override
    public Xml visitAttribute(Xml.Attribute attribute) {
        Xml.Attribute a = attribute;
        a = a.withKey((Xml.Ident)this.refactor(a.getKey()));
        return a.withValue((Xml.Attribute.Value)this.refactor(a.getValue()));
    }

    @Override
    public Xml visitProcessingInstruction(Xml.ProcessingInstruction pi) {
        return pi.withAttributes(this.refactor(pi.getAttributes()));
    }

    @Override
    public Xml.Tag enclosingTag() {
        return (Xml.Tag)this.getCursor().firstEnclosing(Xml.Tag.class);
    }

    public Xml.Tag enclosingRootTag() {
        return this.getCursor().getPathAsStream().filter(t -> t instanceof Xml.Tag).map(Xml.Tag.class::cast).reduce((t1, t2) -> t2).orElseThrow(() -> new IllegalStateException("No root tag. This operation should be called from a cursor scope that is inside of the root tag."));
    }
}

