/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.tree;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.tree.J;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\t\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\n\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u000b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\f\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\r\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017\u00a8\u0006\u0015"}, d2={"Lorg/openrewrite/java/tree/ClassDeclTest;", "", "enumUnnecessarilyTerminatedWithSemicolon", "", "jp", "Lorg/openrewrite/java/JavaParser;", "enumWithEmptyParameters", "enumWithParameters", "enumWithoutParameters", "extends", "fields", "format", "formatAnnotation", "formatInterface", "implements", "innerClass", "methods", "modifierOrdering", "modifiers", "multipleClassDeclarationsInOneCompilationUnit", "strictfpClass", "rewrite-test"})
public interface ClassDeclTest {
    @Test
    public void multipleClassDeclarationsInOneCompilationUnit(@NotNull JavaParser var1);

    @Test
    public void modifiers(@NotNull JavaParser var1);

    @Test
    public void fields(@NotNull JavaParser var1);

    @Test
    public void methods(@NotNull JavaParser var1);

    @Test
    public void implements(@NotNull JavaParser var1);

    @Test
    public void extends(@NotNull JavaParser var1);

    @Test
    public void format(@NotNull JavaParser var1);

    @Test
    public void formatInterface(@NotNull JavaParser var1);

    @Test
    public void formatAnnotation(@NotNull JavaParser var1);

    @Test
    public void enumWithParameters(@NotNull JavaParser var1);

    @Test
    public void enumWithoutParameters(@NotNull JavaParser var1);

    @Test
    public void enumUnnecessarilyTerminatedWithSemicolon(@NotNull JavaParser var1);

    @Test
    public void enumWithEmptyParameters(@NotNull JavaParser var1);

    @Test
    public void modifierOrdering(@NotNull JavaParser var1);

    @Test
    public void innerClass(@NotNull JavaParser var1);

    @Test
    public void strictfpClass(@NotNull JavaParser var1);

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=3)
    public static final class DefaultImpls {
        /*
         * WARNING - void declaration
         */
        @Test
        public static void multipleClassDeclarationsInOneCompilationUnit(@NotNull ClassDeclTest $this, @NotNull JavaParser jp) {
            Collection<String> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            J.CompilationUnit a = (J.CompilationUnit)jp.parse(new String[]{"\n            public class A {}\n            class B {}\n        "}).get(0);
            List list = CollectionsKt.listOf((Object[])new String[]{"A", "B"});
            J.CompilationUnit compilationUnit = a;
            Intrinsics.checkNotNullExpressionValue((Object)compilationUnit, (String)"a");
            List list2 = compilationUnit.getClasses();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"a.classes");
            Iterable iterable = list2;
            List list3 = list;
            boolean $i$f$map = false;
            void var5_6 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                J.ClassDecl classDecl = (J.ClassDecl)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                void v3 = it;
                Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"it");
                String string = v3.getSimpleName();
                collection.add(string);
            }
            collection = (List)destination$iv$iv;
            Assertions.assertEquals((Object)list3, (Object)CollectionsKt.sorted((Iterable)collection));
        }

        @Test
        public static void modifiers(@NotNull ClassDeclTest $this, @NotNull JavaParser jp) {
            J.CompilationUnit a;
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            J.CompilationUnit compilationUnit = a = (J.CompilationUnit)jp.parse(new String[]{"public class A {}"}).get(0);
            Intrinsics.checkNotNullExpressionValue((Object)compilationUnit, (String)"a");
            Assertions.assertTrue((boolean)((J.ClassDecl)compilationUnit.getClasses().get(0)).hasModifier("public"));
        }

        @Test
        public static void fields(@NotNull ClassDeclTest $this, @NotNull JavaParser jp) {
            J.CompilationUnit a;
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            J.CompilationUnit compilationUnit = a = (J.CompilationUnit)jp.parse(new String[]{"\n            import java.util.*;\n            public class A {\n                List l;\n            }\n        "}).get(0);
            Intrinsics.checkNotNullExpressionValue((Object)compilationUnit, (String)"a");
            Object e = compilationUnit.getClasses().get(0);
            Intrinsics.checkNotNullExpressionValue(e, (String)"a.classes[0]");
            Assertions.assertEquals((int)1, (int)((J.ClassDecl)e).getFields().size());
        }

        @Test
        public static void methods(@NotNull ClassDeclTest $this, @NotNull JavaParser jp) {
            J.CompilationUnit a;
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            J.CompilationUnit compilationUnit = a = (J.CompilationUnit)jp.parse(new String[]{"\n            public class A {\n                public void fun() {}\n            }\n        "}).get(0);
            Intrinsics.checkNotNullExpressionValue((Object)compilationUnit, (String)"a");
            Object e = compilationUnit.getClasses().get(0);
            Intrinsics.checkNotNullExpressionValue(e, (String)"a.classes[0]");
            Assertions.assertEquals((int)1, (int)((J.ClassDecl)e).getMethods().size());
        }

        @Test
        public static void implements(@NotNull ClassDeclTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String b = "public interface B {}";
            String a = "public class A implements B {}";
            Object e = jp.parse(new String[]{a, b}).get(0);
            Intrinsics.checkNotNullExpressionValue(e, (String)"jp.parse(a, b)[0]");
            Object e2 = ((J.CompilationUnit)e).getClasses().get(0);
            Intrinsics.checkNotNullExpressionValue(e2, (String)"jp.parse(a, b)[0].classes[0]");
            Object object = ((J.ClassDecl)e2).getImplements();
            Assertions.assertEquals((int)1, object != null && (object = object.getFrom()) != null ? Integer.valueOf(object.size()) : null);
        }

        @Test
        public static void extends(@NotNull ClassDeclTest $this, @NotNull JavaParser jp) {
            J.ClassDecl aClass;
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String b = "public class B {}";
            String a = "public class A extends B {}";
            Object e = jp.parse(new String[]{a, b}).get(0);
            Intrinsics.checkNotNullExpressionValue(e, (String)"jp.parse(a, b)[0]");
            J.ClassDecl classDecl = aClass = (J.ClassDecl)((J.CompilationUnit)e).getClasses().get(0);
            Intrinsics.checkNotNullExpressionValue((Object)classDecl, (String)"aClass");
            Assertions.assertNotNull((Object)classDecl.getExtends());
        }

        @Test
        public static void format(@NotNull ClassDeclTest $this, @NotNull JavaParser jp) {
            Object v3;
            String string;
            block1: {
                Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
                String b = "public class B<T> {}";
                String a = "@Deprecated public class A < T > extends B < T > {}";
                Object e = jp.parse(new String[]{a, b}).get(0);
                Intrinsics.checkNotNullExpressionValue(e, (String)"jp.parse(a, b)[0]");
                List list = ((J.CompilationUnit)e).getClasses();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"jp.parse(a, b)[0].classes");
                Iterable iterable = list;
                string = a;
                boolean bl = false;
                Iterable iterable2 = iterable;
                boolean bl2 = false;
                for (Object t : iterable2) {
                    J.ClassDecl it = (J.ClassDecl)t;
                    boolean bl3 = false;
                    J.ClassDecl classDecl = it;
                    Intrinsics.checkNotNullExpressionValue((Object)classDecl, (String)"it");
                    if (!Intrinsics.areEqual((Object)classDecl.getSimpleName(), (Object)"A")) continue;
                    v3 = t;
                    break block1;
                }
                v3 = null;
            }
            Object var13_13 = v3;
            J.ClassDecl classDecl = var13_13;
            Assertions.assertEquals((Object)string, (Object)(classDecl != null ? classDecl.printTrimmed() : null));
        }

        @Test
        public static void formatInterface(@NotNull ClassDeclTest $this, @NotNull JavaParser jp) {
            Object v3;
            String string;
            block1: {
                Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
                String b = "public interface B {}";
                String a = "public interface A extends B {}";
                Object e = jp.parse(new String[]{a, b}).get(0);
                Intrinsics.checkNotNullExpressionValue(e, (String)"jp.parse(a, b)[0]");
                List list = ((J.CompilationUnit)e).getClasses();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"jp.parse(a, b)[0].classes");
                Iterable iterable = list;
                string = a;
                boolean bl = false;
                Iterable iterable2 = iterable;
                boolean bl2 = false;
                for (Object t : iterable2) {
                    J.ClassDecl it = (J.ClassDecl)t;
                    boolean bl3 = false;
                    J.ClassDecl classDecl = it;
                    Intrinsics.checkNotNullExpressionValue((Object)classDecl, (String)"it");
                    if (!Intrinsics.areEqual((Object)classDecl.getSimpleName(), (Object)"A")) continue;
                    v3 = t;
                    break block1;
                }
                v3 = null;
            }
            Object var13_13 = v3;
            J.ClassDecl classDecl = var13_13;
            Assertions.assertEquals((Object)string, (Object)(classDecl != null ? classDecl.printTrimmed() : null));
        }

        @Test
        public static void formatAnnotation(@NotNull ClassDeclTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String a = "public @interface Produces { }";
            Object e = jp.parse(new String[]{a}).get(0);
            Intrinsics.checkNotNullExpressionValue(e, (String)"jp.parse(a)[0]");
            Assertions.assertEquals((Object)a, (Object)((J.ClassDecl)((J.CompilationUnit)e).getClasses().get(0)).printTrimmed());
        }

        @Test
        public static void enumWithParameters(@NotNull ClassDeclTest $this, @NotNull JavaParser jp) {
            J.CompilationUnit a;
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String aSrc = "public enum A {\n    ONE(1),\n    TWO(2);\n\n    A(int n) {}\n}";
            J.CompilationUnit compilationUnit = a = (J.CompilationUnit)jp.parse(new String[]{aSrc}).get(0);
            Intrinsics.checkNotNullExpressionValue((Object)compilationUnit, (String)"a");
            Object e = compilationUnit.getClasses().get(0);
            Intrinsics.checkNotNullExpressionValue(e, (String)"a.classes[0]");
            Assertions.assertTrue((boolean)(((J.ClassDecl)e).getKind() instanceof J.ClassDecl.Kind.Enum));
            Object e2 = a.getClasses().get(0);
            Intrinsics.checkNotNullExpressionValue(e2, (String)"a.classes[0]");
            J.EnumValueSet enumValueSet = ((J.ClassDecl)e2).getEnumValues();
            Assertions.assertEquals((Object)"ONE(1),\nTWO(2);", (Object)(enumValueSet != null ? enumValueSet.printTrimmed() : null));
            Assertions.assertEquals((Object)aSrc, (Object)a.printTrimmed());
        }

        @Test
        public static void enumWithoutParameters(@NotNull ClassDeclTest $this, @NotNull JavaParser jp) {
            J.CompilationUnit a;
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            J.CompilationUnit compilationUnit = a = (J.CompilationUnit)jp.parse(new String[]{"public enum A { ONE, TWO }"}).get(0);
            Intrinsics.checkNotNullExpressionValue((Object)compilationUnit, (String)"a");
            Assertions.assertEquals((Object)"public enum A { ONE, TWO }", (Object)((J.ClassDecl)compilationUnit.getClasses().get(0)).printTrimmed());
            Object e = a.getClasses().get(0);
            Intrinsics.checkNotNullExpressionValue(e, (String)"a.classes[0]");
            J.EnumValueSet enumValueSet = ((J.ClassDecl)e).getEnumValues();
            Assertions.assertEquals((Object)"ONE, TWO", (Object)(enumValueSet != null ? enumValueSet.printTrimmed() : null));
        }

        @Test
        public static void enumUnnecessarilyTerminatedWithSemicolon(@NotNull ClassDeclTest $this, @NotNull JavaParser jp) {
            J.CompilationUnit a;
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            J.CompilationUnit compilationUnit = a = (J.CompilationUnit)jp.parse(new String[]{"public enum A { ONE ; }"}).get(0);
            Intrinsics.checkNotNullExpressionValue((Object)compilationUnit, (String)"a");
            Object e = compilationUnit.getClasses().get(0);
            Intrinsics.checkNotNullExpressionValue(e, (String)"a.classes[0]");
            Assertions.assertEquals((Object)"{ ONE ; }", (Object)((J.ClassDecl)e).getBody().printTrimmed());
        }

        @Test
        public static void enumWithEmptyParameters(@NotNull ClassDeclTest $this, @NotNull JavaParser jp) {
            J.CompilationUnit a;
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            J.CompilationUnit compilationUnit = a = (J.CompilationUnit)jp.parse(new String[]{"public enum A { ONE ( ), TWO ( ) }"}).get(0);
            Intrinsics.checkNotNullExpressionValue((Object)compilationUnit, (String)"a");
            Assertions.assertEquals((Object)"public enum A { ONE ( ), TWO ( ) }", (Object)((J.ClassDecl)compilationUnit.getClasses().get(0)).printTrimmed());
            Object e = a.getClasses().get(0);
            Intrinsics.checkNotNullExpressionValue(e, (String)"a.classes[0]");
            J.EnumValueSet enumValueSet = ((J.ClassDecl)e).getEnumValues();
            Assertions.assertEquals((Object)"ONE ( ), TWO ( )", (Object)(enumValueSet != null ? enumValueSet.printTrimmed() : null));
        }

        @Test
        public static void modifierOrdering(@NotNull ClassDeclTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            J.CompilationUnit a = (J.CompilationUnit)jp.parse(new String[]{"public /* abstract */ final abstract class A {}"}).get(0);
            Assertions.assertEquals((Object)"public /* abstract */ final abstract class A {}", (Object)a.printTrimmed());
        }

        @Test
        public static void innerClass(@NotNull ClassDeclTest $this, @NotNull JavaParser jp) {
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            String aSrc = "public class A {\n    public enum B {\n        ONE,\n        TWO\n    }\n\n    private B b;\n}";
            Assertions.assertEquals((Object)aSrc, (Object)((J.CompilationUnit)jp.parse(new String[]{aSrc}).get(0)).printTrimmed());
        }

        @Test
        public static void strictfpClass(@NotNull ClassDeclTest $this, @NotNull JavaParser jp) {
            J.CompilationUnit a;
            Intrinsics.checkNotNullParameter((Object)jp, (String)"jp");
            J.CompilationUnit compilationUnit = a = (J.CompilationUnit)jp.parse(new String[]{"public strictfp class A {}"}).get(0);
            Intrinsics.checkNotNullExpressionValue((Object)compilationUnit, (String)"a");
            Assertions.assertEquals((Object)((J.ClassDecl)compilationUnit.getClasses().get(0)).printTrimmed(), (Object)"public strictfp class A {}");
        }
    }
}

