/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.tree;

import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017\u00a8\u0006\u0007"}, d2={"Lorg/openrewrite/java/tree/UnaryTest;", "", "format", "", "jp", "Lorg/openrewrite/java/JavaParser;", "negation", "rewrite-test"})
public interface UnaryTest {
    @Test
    public void negation(@NotNull JavaParser var1);

    @Test
    public void format(@NotNull JavaParser var1);

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=3)
    public static final class DefaultImpls {
        @Test
        public static void negation(UnaryTest $this, @NotNull JavaParser jp) {
            J.CompilationUnit a;
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            J.CompilationUnit compilationUnit = a = (J.CompilationUnit)jp.parse(new String[]{"\n            public class A {\n                boolean b = !(1 == 2);\n            }\n        "}).get(0);
            Intrinsics.checkExpressionValueIsNotNull((Object)compilationUnit, (String)"a");
            Object e = compilationUnit.getClasses().get(0);
            Intrinsics.checkExpressionValueIsNotNull(e, (String)"a.classes[0]");
            Object e2 = ((J.ClassDecl)e).getFields().get(0);
            Intrinsics.checkExpressionValueIsNotNull(e2, (String)"a.classes[0].fields[0]");
            Object e3 = ((J.VariableDecls)e2).getVars().get(0);
            Intrinsics.checkExpressionValueIsNotNull(e3, (String)"a.classes[0].fields[0].vars[0]");
            Expression expression = ((J.VariableDecls.NamedVar)e3).getInitializer();
            if (expression == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.openrewrite.java.tree.J.Unary");
            }
            J.Unary unary = (J.Unary)expression;
            Assertions.assertTrue((boolean)(unary.getOperator() instanceof J.Unary.Operator.Not));
            Assertions.assertTrue((boolean)(unary.getExpr() instanceof J.Parentheses));
        }

        /*
         * WARNING - void declaration
         */
        @Test
        public static void format(UnaryTest $this, @NotNull JavaParser jp) {
            void prefix;
            List list;
            J.CompilationUnit a;
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            J.CompilationUnit compilationUnit = a = (J.CompilationUnit)jp.parse(new String[]{"\n            public class A {\n                int i = 0;\n                int j = ++i;\n                int k = i ++;\n            }\n        "}).get(0);
            Intrinsics.checkExpressionValueIsNotNull((Object)compilationUnit, (String)"a");
            Object e = compilationUnit.getClasses().get(0);
            Intrinsics.checkExpressionValueIsNotNull(e, (String)"a.classes[0]");
            List list2 = list = ((J.ClassDecl)e).getFields().subList(1, 3);
            boolean bl = false;
            J.VariableDecls variableDecls = (J.VariableDecls)list2.get(0);
            list2 = list;
            bl = false;
            J.VariableDecls postfix = (J.VariableDecls)list2.get(1);
            Assertions.assertEquals((Object)"int j = ++i", (Object)prefix.printTrimmed());
            Assertions.assertEquals((Object)"int k = i ++", (Object)postfix.printTrimmed());
        }
    }
}

