/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.tree;

import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.TestKt;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.Statement;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017\u00a8\u0006\b"}, d2={"Lorg/openrewrite/java/tree/ContinueTest;", "", "continueFromLabeledWhileLoop", "", "jp", "Lorg/openrewrite/java/JavaParser;", "continueFromWhileLoop", "formatContinueLabeled", "rewrite-test"})
public interface ContinueTest {
    @Test
    public void continueFromWhileLoop(@NotNull JavaParser var1);

    @Test
    public void continueFromLabeledWhileLoop(@NotNull JavaParser var1);

    @Test
    public void formatContinueLabeled(@NotNull JavaParser var1);

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=3)
    public static final class DefaultImpls {
        @Test
        public static void continueFromWhileLoop(ContinueTest $this, @NotNull JavaParser jp) {
            J.CompilationUnit a;
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            J.CompilationUnit compilationUnit = a = jp.parse("\n            public class A {\n                public void test() {\n                    while(true) continue;\n                }\n            }\n        ", new String[0]);
            Intrinsics.checkExpressionValueIsNotNull((Object)compilationUnit, (String)"a");
            Statement statement = TestKt.firstMethodStatement(compilationUnit);
            if (statement == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.openrewrite.java.tree.J.WhileLoop");
            }
            J.WhileLoop whileLoop = (J.WhileLoop)statement;
            Assertions.assertTrue((boolean)(whileLoop.getBody() instanceof J.Continue));
            Statement statement2 = whileLoop.getBody();
            if (statement2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.openrewrite.java.tree.J.Continue");
            }
            Assertions.assertNull((Object)((J.Continue)statement2).getLabel());
        }

        @Test
        public static void continueFromLabeledWhileLoop(ContinueTest $this, @NotNull JavaParser jp) {
            J.CompilationUnit a;
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            J.CompilationUnit compilationUnit = a = jp.parse("\n            public class A {\n                public void test() {\n                    labeled: while(true)\n                        continue labeled;\n                }\n            }\n        ", new String[0]);
            Intrinsics.checkExpressionValueIsNotNull((Object)compilationUnit, (String)"a");
            Statement statement = TestKt.firstMethodStatement(compilationUnit);
            if (statement == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.openrewrite.java.tree.J.Label");
            }
            Statement statement2 = ((J.Label)statement).getStatement();
            if (statement2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.openrewrite.java.tree.J.WhileLoop");
            }
            J.WhileLoop whileLoop = (J.WhileLoop)statement2;
            Assertions.assertTrue((boolean)(whileLoop.getBody() instanceof J.Continue));
            Statement statement3 = whileLoop.getBody();
            if (statement3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.openrewrite.java.tree.J.Continue");
            }
            J.Ident ident = ((J.Continue)statement3).getLabel();
            Assertions.assertEquals((Object)"labeled", (Object)(ident != null ? ident.getSimpleName() : null));
        }

        @Test
        public static void formatContinueLabeled(ContinueTest $this, @NotNull JavaParser jp) {
            J.CompilationUnit a;
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            J.CompilationUnit compilationUnit = a = jp.parse("\n            public class A {\n                public void test() {\n                    labeled : while(true)\n                        continue labeled;\n                }\n            }\n        ", new String[0]);
            Intrinsics.checkExpressionValueIsNotNull((Object)compilationUnit, (String)"a");
            Statement statement = TestKt.firstMethodStatement(compilationUnit);
            if (statement == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.openrewrite.java.tree.J.Label");
            }
            Statement statement2 = ((J.Label)statement).getStatement();
            if (statement2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.openrewrite.java.tree.J.WhileLoop");
            }
            J.WhileLoop whileLoop = (J.WhileLoop)statement2;
            Assertions.assertEquals((Object)"continue labeled", (Object)whileLoop.getBody().printTrimmed());
        }
    }
}

