/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.search;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.assertj.core.api.Assertions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.jupiter.api.Test;
import org.openrewrite.Tree;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaSourceVisitor;
import org.openrewrite.java.tree.J;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\bf\u0018\u0000 \f2\u00020\u0001:\u0001\fJ\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\t\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\n\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u000b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017\u00a8\u0006\r"}, d2={"Lorg/openrewrite/java/search/FindAnnotationTest;", "", "doesNotMatchNotFullyQualifiedAnnotations", "", "jp", "Lorg/openrewrite/java/JavaParser;", "matchesAnnotationOnField", "matchesAnnotationOnMethod", "matchesNamedParameters", "matchesNamedParametersRegardlessOfOrder", "matchesSimpleFullyQualifiedAnnotation", "matchesSingleAnnotationParameter", "Companion", "rewrite-test"})
public interface FindAnnotationTest {
    public static final Companion Companion = org.openrewrite.java.search.FindAnnotationTest$Companion.$$INSTANCE;
    @NotNull
    public static final String foo = "\n            package com.netflix.foo;\n            public @interface Foo {\n                String bar();\n                String baz();\n            }\n        ";

    @Test
    public void matchesSimpleFullyQualifiedAnnotation(@NotNull JavaParser var1);

    @Test
    public void matchesAnnotationOnMethod(@NotNull JavaParser var1);

    @Test
    public void matchesAnnotationOnField(@NotNull JavaParser var1);

    @Test
    public void doesNotMatchNotFullyQualifiedAnnotations(@NotNull JavaParser var1);

    @Test
    public void matchesSingleAnnotationParameter(@NotNull JavaParser var1);

    @Test
    public void matchesNamedParameters(@NotNull JavaParser var1);

    @Test
    public void matchesNamedParametersRegardlessOfOrder(@NotNull JavaParser var1);

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=3)
    public static final class DefaultImpls {
        @Test
        public static void matchesSimpleFullyQualifiedAnnotation(FindAnnotationTest $this, @NotNull JavaParser jp) {
            J.CompilationUnit a;
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            J.CompilationUnit compilationUnit = a = jp.parse("\n            @Deprecated\n            public class A {}\n        ", new String[0]);
            Intrinsics.checkExpressionValueIsNotNull((Object)compilationUnit, (String)"a");
            List list = ((J.ClassDecl)compilationUnit.getClasses().get(0)).findAnnotations("@java.lang.Deprecated");
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"a.classes[0].findAnnotat\u2026(\"@java.lang.Deprecated\")");
            Collection collection = list;
            boolean bl = false;
            org.junit.jupiter.api.Assertions.assertTrue((!collection.isEmpty() ? 1 : 0) != 0);
        }

        @Test
        public static void matchesAnnotationOnMethod(FindAnnotationTest $this, @NotNull JavaParser jp) {
            J.CompilationUnit a;
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            J.CompilationUnit compilationUnit = a = jp.parse("\n            public class A {\n                @Deprecated\n                public void foo() {}\n            }\n        ", new String[0]);
            Intrinsics.checkExpressionValueIsNotNull((Object)compilationUnit, (String)"a");
            Object e = compilationUnit.getClasses().get(0);
            Intrinsics.checkExpressionValueIsNotNull(e, (String)"a.classes[0]");
            List list = ((J.MethodDecl)((J.ClassDecl)e).getMethods().get(0)).findAnnotations("@java.lang.Deprecated");
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"a.classes[0].methods[0].\u2026(\"@java.lang.Deprecated\")");
            J.Annotation deprecated = (J.Annotation)CollectionsKt.firstOrNull((List)list);
            org.junit.jupiter.api.Assertions.assertNotNull((Object)deprecated);
            Assertions.assertThat((String)((String)new JavaSourceVisitor<String>(deprecated){
                final /* synthetic */ J.Annotation $deprecated;

                @Nullable
                public String defaultTo(@Nullable Tree t) {
                    return null;
                }

                @Nullable
                public String visitAnnotation(@Nullable J.Annotation annotation) {
                    String string;
                    if (annotation == this.$deprecated) {
                        J.MethodDecl methodDecl = this.enclosingMethod();
                        string = methodDecl != null ? methodDecl.getSimpleName() : null;
                    } else {
                        string = (String)super.visitAnnotation(annotation);
                    }
                    return string;
                }
                {
                    this.$deprecated = $captured_local_variable$0;
                    this.setCursoringOn();
                }
            }.visit((Tree)a))).isEqualTo("foo");
        }

        @Test
        public static void matchesAnnotationOnField(FindAnnotationTest $this, @NotNull JavaParser jp) {
            J.CompilationUnit a;
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            J.CompilationUnit compilationUnit = a = jp.parse("\n            public class A {\n                @Deprecated String s;\n            }\n        ", new String[0]);
            Intrinsics.checkExpressionValueIsNotNull((Object)compilationUnit, (String)"a");
            Object e = compilationUnit.getClasses().get(0);
            Intrinsics.checkExpressionValueIsNotNull(e, (String)"a.classes[0]");
            List list = ((J.VariableDecls)((J.ClassDecl)e).getFields().get(0)).findAnnotations("@java.lang.Deprecated");
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"a.classes[0].fields[0].f\u2026(\"@java.lang.Deprecated\")");
            Collection collection = list;
            boolean bl = false;
            org.junit.jupiter.api.Assertions.assertTrue((!collection.isEmpty() ? 1 : 0) != 0);
        }

        @Test
        public static void doesNotMatchNotFullyQualifiedAnnotations(FindAnnotationTest $this, @NotNull JavaParser jp) {
            J.CompilationUnit a;
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            J.CompilationUnit compilationUnit = a = jp.parse("\n            @Deprecated\n            public class A {}\n        ", new String[0]);
            Intrinsics.checkExpressionValueIsNotNull((Object)compilationUnit, (String)"a");
            org.junit.jupiter.api.Assertions.assertTrue((boolean)((J.ClassDecl)compilationUnit.getClasses().get(0)).findAnnotations("@Deprecated").isEmpty());
        }

        @Test
        public static void matchesSingleAnnotationParameter(FindAnnotationTest $this, @NotNull JavaParser jp) {
            J.CompilationUnit a;
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            J.CompilationUnit compilationUnit = a = jp.parse("\n            @SuppressWarnings(\"deprecation\")\n            public class A {}\n        ", new String[0]);
            Intrinsics.checkExpressionValueIsNotNull((Object)compilationUnit, (String)"a");
            List list = ((J.ClassDecl)compilationUnit.getClasses().get(0)).findAnnotations("@java.lang.SuppressWarnings(\"deprecation\")");
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"a.classes[0].findAnnotat\u2026rnings(\"deprecation\")\"\"\")");
            Collection collection = list;
            boolean bl = false;
            org.junit.jupiter.api.Assertions.assertTrue((!collection.isEmpty() ? 1 : 0) != 0);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)((J.ClassDecl)a.getClasses().get(0)).findAnnotations("@java.lang.SuppressWarnings(\"foo\")").isEmpty());
        }

        @Test
        public static void matchesNamedParameters(FindAnnotationTest $this, @NotNull JavaParser jp) {
            J.CompilationUnit a;
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            J.CompilationUnit compilationUnit = a = jp.parse("\n            import com.netflix.foo.Foo;\n            @Foo(bar=\"quux\", baz=\"bar\")\n            public class A {}\n        ", FindAnnotationTest.foo);
            Intrinsics.checkExpressionValueIsNotNull((Object)compilationUnit, (String)"a");
            List list = ((J.ClassDecl)compilationUnit.getClasses().get(0)).findAnnotations("@com.netflix.foo.Foo(bar=\"quux\",baz=\"bar\")");
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"a.classes[0].findAnnotat\u2026bar=\"quux\",baz=\"bar\")\"\"\")");
            Collection collection = list;
            boolean bl = false;
            org.junit.jupiter.api.Assertions.assertTrue((!collection.isEmpty() ? 1 : 0) != 0);
            org.junit.jupiter.api.Assertions.assertTrue((boolean)((J.ClassDecl)a.getClasses().get(0)).findAnnotations("@com.netflix.foo.Foo(bar=\"qux\",baz=\"bar\")").isEmpty());
        }

        @Test
        public static void matchesNamedParametersRegardlessOfOrder(FindAnnotationTest $this, @NotNull JavaParser jp) {
            J.CompilationUnit a;
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            J.CompilationUnit compilationUnit = a = jp.parse("\n            import com.netflix.foo.Foo;\n            @Foo(bar=\"quux\", baz=\"bar\")\n            public class A {}\n        ", FindAnnotationTest.foo);
            Intrinsics.checkExpressionValueIsNotNull((Object)compilationUnit, (String)"a");
            List list = ((J.ClassDecl)compilationUnit.getClasses().get(0)).findAnnotations("@com.netflix.foo.Foo(baz=\"bar\",bar=\"quux\")");
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"a.classes[0].findAnnotat\u2026baz=\"bar\",bar=\"quux\")\"\"\")");
            Collection collection = list;
            boolean bl = false;
            org.junit.jupiter.api.Assertions.assertTrue((!collection.isEmpty() ? 1 : 0) != 0);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/openrewrite/java/search/FindAnnotationTest$Companion;", "", "()V", "foo", "", "rewrite-test"})
    public static final class Companion {
        @NotNull
        public static final String foo = "\n            package com.netflix.foo;\n            public @interface Foo {\n                String bar();\n                String baz();\n            }\n        ";
        static final /* synthetic */ Companion $$INSTANCE;

        private Companion() {
        }

        static {
            Companion companion;
            $$INSTANCE = companion = new Companion();
        }
    }
}

