/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Test;
import org.openrewrite.Change;
import org.openrewrite.Refactor;
import org.openrewrite.SourceVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.TestKt;
import org.openrewrite.java.UseStaticImport;
import org.openrewrite.java.tree.J;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017\u00a8\u0006\u0006"}, d2={"Lorg/openrewrite/java/UseStaticImportTest;", "", "replaceWithStaticImports", "", "jp", "Lorg/openrewrite/java/JavaParser;", "rewrite-test"})
public interface UseStaticImportTest {
    @Test
    public void replaceWithStaticImports(@NotNull JavaParser var1);

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=3)
    public static final class DefaultImpls {
        @Test
        public static void replaceWithStaticImports(UseStaticImportTest $this, @NotNull JavaParser jp) {
            J.CompilationUnit fixed2;
            SourceVisitor[] sourceVisitorArray;
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            String asserts = "package asserts;\n\npublic class Assert {\n    public static void assertTrue(boolean b) {}\n    public static void assertFalse(boolean b) {}\n    public static void assertEquals(int m, int n) {}\n}";
            String test = "package test;\n\nimport asserts.Assert;\n            \nclass Test {\n    void test() {\n        Assert.assertTrue(true);\n        Assert.assertFalse(false);\n        Assert.assertEquals(1, 2);\n    }\n}";
            UseStaticImport useStaticImport = new UseStaticImport();
            int n = 0;
            SourceVisitor[] sourceVisitorArray2 = sourceVisitorArray = new SourceVisitor[1];
            Refactor refactor = jp.parse(test, asserts).refactor();
            boolean bl = false;
            boolean bl2 = false;
            UseStaticImport $this$apply = useStaticImport;
            boolean bl3 = false;
            $this$apply.setMethod("asserts.Assert assert*(..)");
            UseStaticImport useStaticImport2 = useStaticImport;
            sourceVisitorArray[n] = (SourceVisitor)useStaticImport2;
            Change change = refactor.visit(sourceVisitorArray2).fix();
            Intrinsics.checkExpressionValueIsNotNull((Object)change, (String)"jp.parse(test, asserts).\u2026t*(..)\")\n        }).fix()");
            J.CompilationUnit compilationUnit = fixed2 = (J.CompilationUnit)change.getFixed();
            Intrinsics.checkExpressionValueIsNotNull((Object)compilationUnit, (String)"fixed");
            TestKt.assertRefactored(compilationUnit, "package test;\n\nimport static asserts.Assert.*;\n\nclass Test {\n    void test() {\n        assertTrue(true);\n        assertFalse(false);\n        assertEquals(1, 2);\n    }\n}");
        }
    }
}

