/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Test;
import org.openrewrite.Change;
import org.openrewrite.SourceVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.TestKt;
import org.openrewrite.java.UnwrapParentheses;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017\u00a8\u0006\u0007"}, d2={"Lorg/openrewrite/java/UnwrapParenthesesTest;", "", "unwrapAssignment", "", "jp", "Lorg/openrewrite/java/JavaParser;", "unwrapIfCondition", "rewrite-test"})
public interface UnwrapParenthesesTest {
    @Test
    public void unwrapAssignment(@NotNull JavaParser var1);

    @Test
    public void unwrapIfCondition(@NotNull JavaParser var1);

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=3)
    public static final class DefaultImpls {
        @Test
        public static void unwrapAssignment(UnwrapParenthesesTest $this, @NotNull JavaParser jp) {
            J.CompilationUnit fixed2;
            J.CompilationUnit a;
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            J.CompilationUnit compilationUnit = a = jp.parse("public class A {\n    boolean a;\n    {\n        a = (true);\n    }\n}", new String[0]);
            Intrinsics.checkExpressionValueIsNotNull((Object)compilationUnit, (String)"a");
            Object e = compilationUnit.getClasses().get(0);
            Intrinsics.checkExpressionValueIsNotNull(e, (String)"a.classes[0]");
            J.Block block = ((J.ClassDecl)e).getBody();
            Intrinsics.checkExpressionValueIsNotNull((Object)block, (String)"a.classes[0].body");
            Object e2 = block.getStatements().get(1);
            if (e2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.openrewrite.java.tree.J.Block<*>");
            }
            Object e3 = ((J.Block)e2).getStatements().get(0);
            if (e3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.openrewrite.java.tree.J.Assign");
            }
            Expression expression = ((J.Assign)e3).getAssignment();
            if (expression == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.openrewrite.java.tree.J.Parentheses<*>");
            }
            J.Parentheses assignment = (J.Parentheses)expression;
            Change change = a.refactor().visit(new SourceVisitor[]{(SourceVisitor)new UnwrapParentheses(assignment)}).fix();
            Intrinsics.checkExpressionValueIsNotNull((Object)change, (String)"a.refactor().visit(Unwra\u2026theses(assignment)).fix()");
            J.CompilationUnit compilationUnit2 = fixed2 = (J.CompilationUnit)change.getFixed();
            Intrinsics.checkExpressionValueIsNotNull((Object)compilationUnit2, (String)"fixed");
            TestKt.assertRefactored(compilationUnit2, "\n            public class A {\n                boolean a;\n                {\n                    a = true;\n                }\n            }\n        ");
        }

        @Test
        public static void unwrapIfCondition(UnwrapParenthesesTest $this, @NotNull JavaParser jp) {
            J.CompilationUnit fixed2;
            J.CompilationUnit a;
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            J.CompilationUnit compilationUnit = a = jp.parse("public class A {\n    {\n        if((true)) {}\n    }\n}", new String[0]);
            Intrinsics.checkExpressionValueIsNotNull((Object)compilationUnit, (String)"a");
            Object e = compilationUnit.getClasses().get(0);
            Intrinsics.checkExpressionValueIsNotNull(e, (String)"a.classes[0]");
            J.Block block = ((J.ClassDecl)e).getBody();
            Intrinsics.checkExpressionValueIsNotNull((Object)block, (String)"a.classes[0].body");
            Object e2 = block.getStatements().get(0);
            if (e2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.openrewrite.java.tree.J.Block<*>");
            }
            Object e3 = ((J.Block)e2).getStatements().get(0);
            if (e3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.openrewrite.java.tree.J.If");
            }
            J.Parentheses parentheses2 = ((J.If)e3).getIfCondition();
            Intrinsics.checkExpressionValueIsNotNull((Object)parentheses2, (String)"((a.classes[0].body.stat\u2026s[0] as J.If).ifCondition");
            J j = parentheses2.getTree();
            if (j == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.openrewrite.java.tree.J.Parentheses<*>");
            }
            J.Parentheses cond = (J.Parentheses)j;
            Change change = a.refactor().visit(new SourceVisitor[]{(SourceVisitor)new UnwrapParentheses(cond)}).fix();
            Intrinsics.checkExpressionValueIsNotNull((Object)change, (String)"a.refactor().visit(UnwrapParentheses(cond)).fix()");
            J.CompilationUnit compilationUnit2 = fixed2 = (J.CompilationUnit)change.getFixed();
            Intrinsics.checkExpressionValueIsNotNull((Object)compilationUnit2, (String)"fixed");
            TestKt.assertRefactored(compilationUnit2, "\n            public class A {\n                {\n                    if(true) {}\n                }\n            }\n        ");
        }
    }
}

