/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.junit.jupiter.api.Test;
import org.openrewrite.Change;
import org.openrewrite.Refactor;
import org.openrewrite.SourceVisitor;
import org.openrewrite.java.ChangeMethodTargetToVariable;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.TestKt;
import org.openrewrite.java.tree.J;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0017\u00a8\u0006\u0007"}, d2={"Lorg/openrewrite/java/ChangeMethodTargetToVariableTest;", "", "refactorExplicitStaticToVariable", "", "jp", "Lorg/openrewrite/java/JavaParser;", "refactorStaticImportToVariable", "rewrite-test"})
public interface ChangeMethodTargetToVariableTest {
    @Test
    public void refactorExplicitStaticToVariable(@NotNull JavaParser var1);

    @Test
    public void refactorStaticImportToVariable(@NotNull JavaParser var1);

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=3)
    public static final class DefaultImpls {
        @Test
        public static void refactorExplicitStaticToVariable(ChangeMethodTargetToVariableTest $this, @NotNull JavaParser jp) {
            J.CompilationUnit fixed2;
            SourceVisitor[] sourceVisitorArray;
            J.CompilationUnit cu;
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            String a = "package a;\npublic class A {\n   public void foo() {}\n}";
            String b = "package b;\npublic class B {\n   public static void foo() {}\n}";
            String c = "import a.*;\nimport b.B;\npublic class C {\n   A a;\n   public void test() {\n       B.foo();\n   }\n}";
            J.CompilationUnit compilationUnit = cu = jp.parse(c, new String[]{a, b});
            Intrinsics.checkExpressionValueIsNotNull((Object)compilationUnit, (String)"cu");
            J.VariableDecls f = (J.VariableDecls)((J.ClassDecl)compilationUnit.getClasses().get(0)).findFields("a.A").get(0);
            ChangeMethodTargetToVariable changeMethodTargetToVariable = new ChangeMethodTargetToVariable();
            int n = 0;
            SourceVisitor[] sourceVisitorArray2 = sourceVisitorArray = new SourceVisitor[1];
            Refactor refactor = cu.refactor();
            boolean bl = false;
            boolean bl2 = false;
            ChangeMethodTargetToVariable $this$apply = changeMethodTargetToVariable;
            boolean bl3 = false;
            $this$apply.setMethod("b.B foo()");
            J.VariableDecls variableDecls = f;
            Intrinsics.checkExpressionValueIsNotNull((Object)variableDecls, (String)"f");
            Object e = variableDecls.getVars().get(0);
            Intrinsics.checkExpressionValueIsNotNull(e, (String)"f.vars[0]");
            $this$apply.setVariable(((J.VariableDecls.NamedVar)e).getSimpleName());
            ChangeMethodTargetToVariable changeMethodTargetToVariable2 = changeMethodTargetToVariable;
            sourceVisitorArray[n] = (SourceVisitor)changeMethodTargetToVariable2;
            Change change = refactor.visit(sourceVisitorArray2).fix();
            Intrinsics.checkExpressionValueIsNotNull((Object)change, (String)"cu.refactor()\n          \u2026})\n                .fix()");
            J.CompilationUnit compilationUnit2 = fixed2 = (J.CompilationUnit)change.getFixed();
            Intrinsics.checkExpressionValueIsNotNull((Object)compilationUnit2, (String)"fixed");
            TestKt.assertRefactored(compilationUnit2, "\n            import a.A;\n            public class C {\n               A a;\n               public void test() {\n                   a.foo();\n               }\n            }\n        ");
        }

        @Test
        public static void refactorStaticImportToVariable(ChangeMethodTargetToVariableTest $this, @NotNull JavaParser jp) {
            J.CompilationUnit fixed2;
            SourceVisitor[] sourceVisitorArray;
            J.CompilationUnit cu;
            Intrinsics.checkParameterIsNotNull((Object)jp, (String)"jp");
            String a = "package a;\npublic class A {\n   public void foo() {}\n}";
            String b = "package b;\npublic class B {\n   public static void foo() {}\n}";
            String c = "import a.*;\nimport static b.B.*;\npublic class C {\n   A a;\n   public void test() {\n       foo();\n   }\n}";
            J.CompilationUnit compilationUnit = cu = jp.parse(c, new String[]{a, b});
            Intrinsics.checkExpressionValueIsNotNull((Object)compilationUnit, (String)"cu");
            J.VariableDecls f = (J.VariableDecls)((J.ClassDecl)compilationUnit.getClasses().get(0)).findFields("a.A").get(0);
            ChangeMethodTargetToVariable changeMethodTargetToVariable = new ChangeMethodTargetToVariable();
            int n = 0;
            SourceVisitor[] sourceVisitorArray2 = sourceVisitorArray = new SourceVisitor[1];
            Refactor refactor = cu.refactor();
            boolean bl = false;
            boolean bl2 = false;
            ChangeMethodTargetToVariable $this$apply = changeMethodTargetToVariable;
            boolean bl3 = false;
            $this$apply.setMethod("b.B foo()");
            J.VariableDecls variableDecls = f;
            Intrinsics.checkExpressionValueIsNotNull((Object)variableDecls, (String)"f");
            Object e = variableDecls.getVars().get(0);
            Intrinsics.checkExpressionValueIsNotNull(e, (String)"f.vars[0]");
            $this$apply.setVariable(((J.VariableDecls.NamedVar)e).getSimpleName());
            ChangeMethodTargetToVariable changeMethodTargetToVariable2 = changeMethodTargetToVariable;
            sourceVisitorArray[n] = (SourceVisitor)changeMethodTargetToVariable2;
            Change change = refactor.visit(sourceVisitorArray2).fix();
            Intrinsics.checkExpressionValueIsNotNull((Object)change, (String)"cu.refactor()\n          \u2026})\n                .fix()");
            J.CompilationUnit compilationUnit2 = fixed2 = (J.CompilationUnit)change.getFixed();
            Intrinsics.checkExpressionValueIsNotNull((Object)compilationUnit2, (String)"fixed");
            TestKt.assertRefactored(compilationUnit2, "\n            import a.A;\n            public class C {\n               A a;\n               public void test() {\n                   a.foo();\n               }\n            }\n        ");
        }
    }
}

