/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.impl;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.psi.PyBinaryExpression;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyElementType;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.impl.PyEvaluator;
import java.nio.file.Paths;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyPathEvaluator
extends PyEvaluator {
    private final String myContainingFilePath;

    public PyPathEvaluator(String containingFilePath) {
        this.myContainingFilePath = containingFilePath;
    }

    @Nullable
    public static String evaluatePath(PyExpression expr) {
        if (expr == null) {
            return null;
        }
        VirtualFile vFile = expr.getContainingFile().getVirtualFile();
        Object result = new PyPathEvaluator(vFile == null ? null : vFile.getPath()).evaluate(expr);
        return result instanceof String ? (String)result : null;
    }

    @Override
    @Nullable
    protected Object evaluateCall(@NotNull PyCallExpression expression) {
        Object argValue;
        PyReferenceExpression callee;
        if (expression == null) {
            PyPathEvaluator.$$$reportNull$$$0(0);
        }
        PyExpression[] args = expression.getArguments();
        if (expression.isCalleeText("resolve") && (callee = (PyReferenceExpression)expression.getCallee()) != null && callee.getQualifier() instanceof PyCallExpression) {
            return this.evaluate(callee.getQualifier());
        }
        if (expression.isCalleeText("Path") && args.length >= 1) {
            return this.evaluate(args[0]);
        }
        if (expression.isCalleeText("dirname") && args.length == 1) {
            argValue = this.evaluate(args[0]);
            return argValue instanceof String ? Paths.get((String)argValue, new String[0]).getParent().toFile().getPath() : null;
        }
        if (expression.isCalleeText("join") && args.length >= 1) {
            return this.evaluatePathInJoin(args, args.length);
        }
        if (expression.isCalleeText("normpath", "realpath") && args.length == 1) {
            return this.evaluate(args[0]);
        }
        if (expression.isCalleeText("abspath") && args.length == 1) {
            argValue = this.evaluate(args[0]);
            if (!(argValue instanceof String)) {
                return null;
            }
            if (FileUtil.isAbsolutePlatformIndependent((String)((String)argValue))) {
                return argValue;
            }
            String path = Paths.get(this.myContainingFilePath, new String[0]).resolveSibling((String)argValue).toFile().getPath();
            return FileUtil.toSystemIndependentName((String)path);
        }
        return super.evaluateCall(expression);
    }

    @Override
    @Nullable
    protected Object evaluateReference(@NotNull PyReferenceExpression expression) {
        Object qualifier;
        if (expression == null) {
            PyPathEvaluator.$$$reportNull$$$0(1);
        }
        if ("pardir".equals(expression.getName())) {
            return "..";
        }
        if ("curdir".equals(expression.getName())) {
            return ".";
        }
        if (!expression.isQualified() && "__file__".equals(expression.getReferencedName())) {
            return FileUtil.toSystemIndependentName((String)this.myContainingFilePath);
        }
        if ("parent".equals(expression.getName()) && expression.isQualified() && (qualifier = this.evaluate(expression.getQualifier())) instanceof String) {
            return Paths.get((String)qualifier, new String[0]).getParent().toFile().getPath();
        }
        return super.evaluateReference(expression);
    }

    public String evaluatePathInJoin(PyExpression[] args, int endElement) {
        String result = null;
        for (int i = 0; i < endElement; ++i) {
            Object arg = this.evaluate(args[i]);
            if (!(arg instanceof String)) {
                return null;
            }
            result = result == null ? (String)arg : FileUtil.toSystemIndependentName((String)Paths.get(result, (String)arg).toFile().getPath());
        }
        return result;
    }

    @Override
    @Nullable
    protected Object evaluateBinary(@NotNull PyBinaryExpression expression) {
        PyElementType operator;
        if (expression == null) {
            PyPathEvaluator.$$$reportNull$$$0(2);
        }
        if ((operator = expression.getOperator()) == PyTokenTypes.DIV) {
            Object lhs = this.evaluate(expression.getLeftExpression());
            Object rhs = this.evaluate(expression.getRightExpression());
            if (lhs instanceof String && rhs instanceof String) {
                return FileUtil.toSystemIndependentName((String)Paths.get((String)lhs, (String)rhs).toFile().getPath());
            }
        }
        return super.evaluateBinary(expression);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "expression";
        objectArray2[1] = "com/jetbrains/python/psi/impl/PyPathEvaluator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "evaluateCall";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "evaluateReference";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "evaluateBinary";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

