/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.PsiFileWithStubSupport;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.ObjectStubTree;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.psi.stubs.StubBase;
import com.intellij.psi.stubs.StubTree;
import com.intellij.psi.stubs.StubTreeBuilder;
import com.intellij.psi.tree.IStubFileElementType;
import com.intellij.util.SmartList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiFileStubImpl<T extends PsiFile>
extends StubBase<T>
implements PsiFileStub<T> {
    public static final IStubFileElementType TYPE = new IStubFileElementType(Language.ANY);
    private volatile T myFile;
    private volatile String myInvalidationReason;
    private volatile PsiFileStub[] myStubRoots;

    public PsiFileStubImpl(T file) {
        super(null, null);
        this.myFile = file;
    }

    @Override
    public T getPsi() {
        return this.myFile;
    }

    @Override
    public void setPsi(@NotNull T psi) {
        if (psi == null) {
            PsiFileStubImpl.$$$reportNull$$$0(0);
        }
        this.myFile = psi;
    }

    public void clearPsi(@NotNull String reason) {
        if (reason == null) {
            PsiFileStubImpl.$$$reportNull$$$0(1);
        }
        this.myInvalidationReason = reason;
        this.myFile = null;
    }

    @Override
    @Nullable
    public String getInvalidationReason() {
        return this.myInvalidationReason;
    }

    @Override
    public IStubElementType getStubType() {
        return null;
    }

    @Override
    @NotNull
    public IStubFileElementType getType() {
        IStubFileElementType iStubFileElementType = TYPE;
        if (iStubFileElementType == null) {
            PsiFileStubImpl.$$$reportNull$$$0(2);
        }
        return iStubFileElementType;
    }

    public PsiFileStub @NotNull [] getStubRoots() {
        if (this.myStubRoots != null) {
            if (this.myStubRoots == null) {
                PsiFileStubImpl.$$$reportNull$$$0(3);
            }
            return this.myStubRoots;
        }
        PsiElement psi = this.getPsi();
        if (psi == null) {
            PsiFileStub[] psiFileStubArray = new PsiFileStub[]{this};
            if (psiFileStubArray == null) {
                PsiFileStubImpl.$$$reportNull$$$0(4);
            }
            return psiFileStubArray;
        }
        FileViewProvider viewProvider = psi.getViewProvider();
        PsiFile stubBindingRoot = viewProvider.getStubBindingRoot();
        StubTree baseTree = PsiFileStubImpl.getOrCalcStubTree(stubBindingRoot);
        if (baseTree != null) {
            PsiFileStub[] rootsArray;
            SmartList<PsiFileStub> roots = new SmartList<PsiFileStub>(baseTree.getRoot());
            List stubbedRoots = StubTreeBuilder.getStubbedRoots((FileViewProvider)viewProvider);
            for (Pair stubbedRoot : stubbedRoots) {
                StubTree secondaryStubTree;
                if (stubbedRoot.second == stubBindingRoot || (secondaryStubTree = PsiFileStubImpl.getOrCalcStubTree((PsiFile)stubbedRoot.second)) == null) continue;
                PsiFileStub root = secondaryStubTree.getRoot();
                roots.add(root);
            }
            for (PsiFileStub root : rootsArray = roots.toArray(PsiFileStub.EMPTY_ARRAY)) {
                if (!(root instanceof PsiFileStubImpl)) continue;
                ((PsiFileStubImpl)root).setStubRoots(rootsArray);
            }
            this.myStubRoots = rootsArray;
            if (rootsArray == null) {
                PsiFileStubImpl.$$$reportNull$$$0(5);
            }
            return rootsArray;
        }
        if (PsiFileStub.EMPTY_ARRAY == null) {
            PsiFileStubImpl.$$$reportNull$$$0(6);
        }
        return PsiFileStub.EMPTY_ARRAY;
    }

    private static StubTree getOrCalcStubTree(PsiFile stubBindingRoot) {
        StubTree result = null;
        if (stubBindingRoot instanceof PsiFileWithStubSupport && (result = ((PsiFileWithStubSupport)stubBindingRoot).getStubTree()) == null && stubBindingRoot instanceof PsiFileImpl) {
            result = ((PsiFileImpl)stubBindingRoot).calcStubTree();
        }
        return result;
    }

    public void setStubRoots(PsiFileStub @NotNull [] roots) {
        if (roots == null) {
            PsiFileStubImpl.$$$reportNull$$$0(7);
        }
        if (roots.length == 0) {
            Logger.getInstance(this.getClass()).error("Incorrect psi file stub roots count" + this + "," + this.getStubType());
        }
        this.myStubRoots = roots;
    }

    public boolean rootsAreSet() {
        return this.myStubRoots != null;
    }

    public final String getDiagnostics() {
        ObjectStubTree stubTree = ObjectStubTree.getStubTree(this);
        T file = this.myFile;
        return this + "(file='" + file + '\'' + ", invalidationReason=" + this.myInvalidationReason + ", stubRoots='" + Arrays.toString(this.myStubRoots) + '\'' + ", stubTree='" + stubTree + '\'' + ')';
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psi";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reason";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/stubs/PsiFileStubImpl";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/stubs/PsiFileStubImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getStubRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setPsi";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "clearPsi";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setStubRoots";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

