/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.text;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.CharFilter;
import com.intellij.openapi.util.text.Formats;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.LineColumn;
import com.intellij.openapi.util.text.NaturalComparator;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.util.text.Strings;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.LineSeparator;
import com.intellij.util.NotNullFunction;
import com.intellij.util.SmartList;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.text.CharSequenceSubSequence;
import com.intellij.util.text.MergingCharSequence;
import java.beans.Introspector;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class StringUtil
extends StringUtilRt {
    public static final String ELLIPSIS = "\u2026";
    public static final String THREE_DOTS = "...";
    public static final String NON_BREAK_SPACE = "\u00a0";
    public static final Function<String, String> QUOTER = s -> "\"" + s + "\"";
    public static final Function<String, String> SINGLE_QUOTER = s -> "'" + s + "'";
    private static final String[] ourLowerCaseWords = new String[]{"a", "an", "and", "as", "at", "but", "by", "down", "for", "from", "in", "into", "near", "nor", "of", "on", "onto", "or", "out", "over", "per", "so", "the", "to", "until", "unto", "up", "upon", "via", "with"};
    private static final String[] ourOtherNonCapitalizableWords = new String[]{"iOS", "iPhone", "iPad", "iMac"};
    private static final List<String> MN_QUOTED = Arrays.asList("&&", "__");
    private static final List<String> MN_CHARS = Arrays.asList("&", "_");
    private static final Pattern UNICODE_CHAR = Pattern.compile("\\\\u[\\da-fA-F]{4}");

    @NotNull
    public static MergingCharSequence replaceSubSequence(@NotNull CharSequence charSeq, int start, int end, @NotNull CharSequence replacement) {
        if (charSeq == null) {
            StringUtil.$$$reportNull$$$0(0);
        }
        if (replacement == null) {
            StringUtil.$$$reportNull$$$0(1);
        }
        return new MergingCharSequence(new MergingCharSequence(new CharSequenceSubSequence(charSeq, 0, start), replacement), new CharSequenceSubSequence(charSeq, end, charSeq.length()));
    }

    @Contract(pure=true)
    @NotNull
    public static List<String> getWordsInStringLongestFirst(@NotNull String find) {
        if (find == null) {
            StringUtil.$$$reportNull$$$0(2);
        }
        List<String> words = StringUtil.getWordsIn(find);
        words.sort((o1, o2) -> o2.length() - o1.length());
        List<String> list = words;
        if (list == null) {
            StringUtil.$$$reportNull$$$0(3);
        }
        return list;
    }

    @Contract(pure=true)
    @NotNull
    public static String escapePattern(@NotNull String text) {
        if (text == null) {
            StringUtil.$$$reportNull$$$0(4);
        }
        return StringUtil.replace(StringUtil.replace(text, "'", "''"), "{", "'{'");
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    @Contract(pure=true)
    @NotNull
    public static <T> com.intellij.util.Function<T, String> createToStringFunction(@NotNull Class<T> cls) {
        if (cls == null) {
            StringUtil.$$$reportNull$$$0(5);
        }
        com.intellij.util.Function<Object, String> function = Object::toString;
        if (function == null) {
            StringUtil.$$$reportNull$$$0(6);
        }
        return function;
    }

    @Contract(pure=true)
    @NotNull
    public static String replace(@NotNull String text, @NotNull String oldS, @NotNull String newS) {
        if (text == null) {
            StringUtil.$$$reportNull$$$0(7);
        }
        if (oldS == null) {
            StringUtil.$$$reportNull$$$0(8);
        }
        if (newS == null) {
            StringUtil.$$$reportNull$$$0(9);
        }
        String string = StringUtil.replace(text, oldS, newS, false);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(10);
        }
        return string;
    }

    @Contract(pure=true)
    @NotNull
    public static String replaceIgnoreCase(@NotNull String text, @NotNull String oldS, @NotNull String newS) {
        if (text == null) {
            StringUtil.$$$reportNull$$$0(11);
        }
        if (oldS == null) {
            StringUtil.$$$reportNull$$$0(12);
        }
        if (newS == null) {
            StringUtil.$$$reportNull$$$0(13);
        }
        String string = StringUtil.replace(text, oldS, newS, true);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(14);
        }
        return string;
    }

    @Deprecated
    @Contract(pure=true)
    @ApiStatus.ScheduledForRemoval
    @NotNull
    public static String replaceChar(@NotNull String buffer, char oldChar, char newChar) {
        if (buffer == null) {
            StringUtil.$$$reportNull$$$0(15);
        }
        String string = buffer.replace(oldChar, newChar);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(16);
        }
        return string;
    }

    @Contract(pure=true)
    public static String replace(@NotNull String text, @NotNull String oldS, @NotNull String newS, boolean ignoreCase) {
        if (text == null) {
            StringUtil.$$$reportNull$$$0(17);
        }
        if (oldS == null) {
            StringUtil.$$$reportNull$$$0(18);
        }
        if (newS == null) {
            StringUtil.$$$reportNull$$$0(19);
        }
        if (text.length() < oldS.length()) {
            return text;
        }
        StringBuilder newText = null;
        int i = 0;
        while (i < text.length()) {
            int index;
            int n = index = ignoreCase ? StringUtil.indexOfIgnoreCase(text, oldS, i) : text.indexOf(oldS, i);
            if (index < 0) {
                if (i == 0) {
                    return text;
                }
                newText.append(text, i, text.length());
                break;
            }
            if (newText == null) {
                if (text.length() == oldS.length()) {
                    return newS;
                }
                newText = new StringBuilder(text.length() - i);
            }
            newText.append(text, i, index);
            newText.append(newS);
            i = index + oldS.length();
        }
        return newText != null ? newText.toString() : "";
    }

    @Contract(pure=true)
    public static int indexOfIgnoreCase(@NotNull String where, @NotNull String what, int fromIndex) {
        if (where == null) {
            StringUtil.$$$reportNull$$$0(20);
        }
        if (what == null) {
            StringUtil.$$$reportNull$$$0(21);
        }
        return Strings.indexOfIgnoreCase(where, what, fromIndex);
    }

    @Contract(pure=true)
    public static int indexOfIgnoreCase(@NotNull CharSequence where, @NotNull CharSequence what, int fromIndex) {
        if (where == null) {
            StringUtil.$$$reportNull$$$0(22);
        }
        if (what == null) {
            StringUtil.$$$reportNull$$$0(23);
        }
        return Strings.indexOfIgnoreCase(where, what, fromIndex);
    }

    @Contract(pure=true)
    public static int indexOfIgnoreCase(@NotNull String where, char what, int fromIndex) {
        if (where == null) {
            StringUtil.$$$reportNull$$$0(24);
        }
        return Strings.indexOfIgnoreCase(where, what, fromIndex);
    }

    @Contract(pure=true)
    public static int lastIndexOfIgnoreCase(@NotNull String where, char c, int fromIndex) {
        if (where == null) {
            StringUtil.$$$reportNull$$$0(25);
        }
        for (int i = Math.min(fromIndex, where.length() - 1); i >= 0; --i) {
            if (!StringUtil.charsEqualIgnoreCase(where.charAt(i), c)) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static boolean containsIgnoreCase(@NotNull String where, @NotNull String what) {
        if (where == null) {
            StringUtil.$$$reportNull$$$0(26);
        }
        if (what == null) {
            StringUtil.$$$reportNull$$$0(27);
        }
        return StringUtil.indexOfIgnoreCase(where, what, 0) >= 0;
    }

    @Contract(pure=true)
    public static boolean endsWithIgnoreCase(@NotNull String str, @NotNull String suffix) {
        if (str == null) {
            StringUtil.$$$reportNull$$$0(28);
        }
        if (suffix == null) {
            StringUtil.$$$reportNull$$$0(29);
        }
        return Strings.endsWithIgnoreCase(str, suffix);
    }

    @Contract(pure=true)
    public static boolean startsWithIgnoreCase(@NotNull String str, @NotNull String prefix) {
        if (str == null) {
            StringUtil.$$$reportNull$$$0(30);
        }
        if (prefix == null) {
            StringUtil.$$$reportNull$$$0(31);
        }
        return StringUtilRt.startsWithIgnoreCase(str, prefix);
    }

    @Contract(pure=true)
    @NotNull
    public static String stripHtml(@NotNull String html, boolean convertBreaks) {
        if (html == null) {
            StringUtil.$$$reportNull$$$0(32);
        }
        return StringUtil.stripHtml(html, convertBreaks ? "\n\n" : null);
    }

    @Contract(pure=true)
    @NotNull
    public static String stripHtml(@NotNull String html, @Nullable String breaks) {
        if (html == null) {
            StringUtil.$$$reportNull$$$0(33);
        }
        if (breaks != null) {
            html = html.replaceAll("<br/?>", breaks);
        }
        String string = html.replaceAll("<(.|\n)*?>", "");
        if (string == null) {
            StringUtil.$$$reportNull$$$0(34);
        }
        return string;
    }

    @Contract(value="null -> null; !null -> !null", pure=true)
    public static String toLowerCase(@Nullable String str) {
        return Strings.toLowerCase(str);
    }

    @Contract(pure=true)
    @NlsSafe
    @NotNull
    public static String getPackageName(@NotNull String fqName) {
        if (fqName == null) {
            StringUtil.$$$reportNull$$$0(35);
        }
        return StringUtil.getPackageName(fqName, '.');
    }

    @Contract(pure=true)
    @NlsSafe
    @NotNull
    public static String getPackageName(@NotNull String fqName, char separator) {
        int lastPointIdx;
        if (fqName == null) {
            StringUtil.$$$reportNull$$$0(36);
        }
        if ((lastPointIdx = fqName.lastIndexOf(separator)) >= 0) {
            String string = fqName.substring(0, lastPointIdx);
            if (string == null) {
                StringUtil.$$$reportNull$$$0(37);
            }
            return string;
        }
        return "";
    }

    @Contract(pure=true)
    public static int getLineBreakCount(@NotNull CharSequence text) {
        if (text == null) {
            StringUtil.$$$reportNull$$$0(38);
        }
        int count = 0;
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c == '\n') {
                ++count;
                continue;
            }
            if (c != '\r') continue;
            if (i + 1 < text.length() && text.charAt(i + 1) == '\n') {
                ++i;
            }
            ++count;
        }
        return count;
    }

    @Contract(pure=true)
    public static boolean containsLineBreak(@NotNull CharSequence text) {
        if (text == null) {
            StringUtil.$$$reportNull$$$0(39);
        }
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (!StringUtil.isLineBreak(c)) continue;
            return true;
        }
        return false;
    }

    @Contract(pure=true)
    public static boolean isLineBreak(char c) {
        return c == '\n' || c == '\r';
    }

    @Contract(pure=true)
    @NotNull
    public static String escapeLineBreak(@NotNull String text) {
        if (text == null) {
            StringUtil.$$$reportNull$$$0(40);
        }
        StringBuilder buffer = new StringBuilder(text.length());
        block4: for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            switch (c) {
                case '\n': {
                    buffer.append("\\n");
                    continue block4;
                }
                case '\r': {
                    buffer.append("\\r");
                    continue block4;
                }
                default: {
                    buffer.append(c);
                }
            }
        }
        String string = buffer.toString();
        if (string == null) {
            StringUtil.$$$reportNull$$$0(41);
        }
        return string;
    }

    @Contract(pure=true)
    public static boolean endsWithLineBreak(@NotNull CharSequence text) {
        int len;
        if (text == null) {
            StringUtil.$$$reportNull$$$0(42);
        }
        return (len = text.length()) > 0 && StringUtil.isLineBreak(text.charAt(len - 1));
    }

    @Contract(pure=true)
    public static int lineColToOffset(@NotNull CharSequence text, int line, int col) {
        if (text == null) {
            StringUtil.$$$reportNull$$$0(43);
        }
        int curLine = 0;
        int offset = 0;
        while (line != curLine) {
            if (offset == text.length()) {
                return -1;
            }
            char c = text.charAt(offset);
            if (c == '\n') {
                ++curLine;
            } else if (c == '\r') {
                ++curLine;
                if (offset < text.length() - 1 && text.charAt(offset + 1) == '\n') {
                    ++offset;
                }
            }
            ++offset;
        }
        return offset + col;
    }

    @Contract(pure=true)
    public static int offsetToLineNumber(@NotNull CharSequence text, int offset) {
        LineColumn lineColumn;
        if (text == null) {
            StringUtil.$$$reportNull$$$0(44);
        }
        return (lineColumn = StringUtil.offsetToLineColumn(text, offset)) != null ? lineColumn.line : -1;
    }

    @Contract(pure=true)
    public static LineColumn offsetToLineColumn(@NotNull CharSequence text, int offset) {
        if (text == null) {
            StringUtil.$$$reportNull$$$0(45);
        }
        int curLine = 0;
        int curLineStart = 0;
        for (int curOffset = 0; curOffset < offset; ++curOffset) {
            if (curOffset == text.length()) {
                return null;
            }
            char c = text.charAt(curOffset);
            if (c == '\n') {
                ++curLine;
                curLineStart = curOffset + 1;
                continue;
            }
            if (c != '\r') continue;
            ++curLine;
            if (curOffset < text.length() - 1 && text.charAt(curOffset + 1) == '\n') {
                ++curOffset;
            }
            curLineStart = curOffset + 1;
        }
        return LineColumn.of((int)curLine, (int)(offset - curLineStart));
    }

    @Contract(pure=true)
    public static int difference(@NotNull String s1, @NotNull String s2) {
        int i;
        if (s1 == null) {
            StringUtil.$$$reportNull$$$0(46);
        }
        if (s2 == null) {
            StringUtil.$$$reportNull$$$0(47);
        }
        int[][] a = new int[s1.length()][s2.length()];
        for (i = 0; i < s1.length(); ++i) {
            a[i][0] = i;
        }
        for (int j = 0; j < s2.length(); ++j) {
            a[0][j] = j;
        }
        for (i = 1; i < s1.length(); ++i) {
            for (int j = 1; j < s2.length(); ++j) {
                a[i][j] = Math.min(Math.min(a[i - 1][j - 1] + (s1.charAt(i) == s2.charAt(j) ? 0 : 1), a[i - 1][j] + 1), a[i][j - 1] + 1);
            }
        }
        return a[s1.length() - 1][s2.length() - 1];
    }

    @Contract(pure=true)
    @NotNull
    public static String wordsToBeginFromUpperCase(@NotNull String s) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(48);
        }
        return StringUtil.fixCapitalization(s, ourLowerCaseWords, true, true);
    }

    @Contract(pure=true)
    @NotNull
    public static String wordsToBeginFromLowerCase(@NotNull String s) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(49);
        }
        return StringUtil.fixCapitalization(s, ArrayUtilRt.EMPTY_STRING_ARRAY, false, true);
    }

    @Contract(pure=true)
    @NotNull
    public static String toTitleCase(@NotNull String s) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(50);
        }
        return StringUtil.fixCapitalization(s, ArrayUtilRt.EMPTY_STRING_ARRAY, true, false);
    }

    @NotNull
    private static String fixCapitalization(@NotNull String s, String @NotNull [] wordsToIgnore, boolean title, boolean mnemonics) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(51);
        }
        if (wordsToIgnore == null) {
            StringUtil.$$$reportNull$$$0(52);
        }
        StringBuilder buffer = null;
        int length = s.length();
        for (int i = 0; i < length; ++i) {
            boolean lastWord;
            char prevPrevChar;
            char prevChar = i == 0 ? (char)' ' : (char)s.charAt(i - 1);
            char currChar = s.charAt(i);
            if (Character.isLetterOrDigit(prevChar) || prevChar == 39 || !Character.isLetterOrDigit(currChar) || !title && !Character.isUpperCase(currChar)) continue;
            int start = i++;
            while (i < length) {
                char c = s.charAt(i);
                if ((!mnemonics || c != '&' && c != '_') && !Character.isLetterOrDigit(c)) break;
                ++i;
            }
            if (!title && i > start + 1 && !Character.isLowerCase(s.charAt(start + 1))) continue;
            char c = prevPrevChar = start > 1 ? s.charAt(start - 2) : (char)'\u0000';
            if (prevChar == '.' && (prevPrevChar == ' ' || prevPrevChar == '*') || prevChar == '~' && prevPrevChar == ' ' || StringUtil.isPreposition(s, start, i - 1, ourOtherNonCapitalizableWords)) continue;
            boolean firstWord = start == 0 || StringUtil.isPunctuation(prevPrevChar);
            boolean bl = lastWord = i >= length - 1 || StringUtil.isPunctuation(s.charAt(i + 1));
            if (title && !firstWord && !lastWord && StringUtil.isPreposition(s, start, i - 1, wordsToIgnore)) continue;
            if (buffer == null) {
                buffer = new StringBuilder(s);
            }
            buffer.setCharAt(start, title ? StringUtil.toUpperCase(currChar) : StringUtil.toLowerCase(currChar));
        }
        String string = buffer == null ? s : buffer.toString();
        if (string == null) {
            StringUtil.$$$reportNull$$$0(53);
        }
        return string;
    }

    private static boolean isPunctuation(char c) {
        return c == '.' || c == '!' || c == ':' || c == '?';
    }

    @Contract(pure=true)
    public static boolean isPreposition(@NotNull String s, int firstChar, int lastChar, String @NotNull [] prepositions) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(54);
        }
        if (prepositions == null) {
            StringUtil.$$$reportNull$$$0(55);
        }
        block0: for (String preposition : prepositions) {
            if (lastChar - firstChar + 1 != preposition.length()) continue;
            for (int j = 0; j < preposition.length(); ++j) {
                if (StringUtil.toLowerCase(s.charAt(firstChar + j)) != StringUtil.toLowerCase(preposition.charAt(j))) continue block0;
            }
            return true;
        }
        return false;
    }

    @Contract(pure=true)
    @NotNull
    public static NotNullFunction<String, String> escaper(boolean escapeSlash, @Nullable String additionalChars) {
        NotNullFunction<String, String> notNullFunction = dom -> {
            StringBuilder builder = new StringBuilder(dom.length());
            StringUtil.escapeStringCharacters(dom.length(), dom, additionalChars, escapeSlash, builder);
            return builder.toString();
        };
        if (notNullFunction == null) {
            StringUtil.$$$reportNull$$$0(56);
        }
        return notNullFunction;
    }

    public static void escapeStringCharacters(int length, @NotNull String str, @NotNull StringBuilder buffer) {
        if (str == null) {
            StringUtil.$$$reportNull$$$0(57);
        }
        if (buffer == null) {
            StringUtil.$$$reportNull$$$0(58);
        }
        StringUtil.escapeStringCharacters(length, str, "\"", buffer);
    }

    @NotNull
    public static StringBuilder escapeStringCharacters(int length, @NotNull String str, @Nullable String additionalChars, @NotNull StringBuilder buffer) {
        if (str == null) {
            StringUtil.$$$reportNull$$$0(59);
        }
        if (buffer == null) {
            StringUtil.$$$reportNull$$$0(60);
        }
        return StringUtil.escapeStringCharacters(length, str, additionalChars, true, buffer);
    }

    @NotNull
    public static StringBuilder escapeStringCharacters(int length, @NotNull String str, @Nullable String additionalChars, boolean escapeSlash, @NotNull StringBuilder buffer) {
        if (str == null) {
            StringUtil.$$$reportNull$$$0(61);
        }
        if (buffer == null) {
            StringUtil.$$$reportNull$$$0(62);
        }
        return StringUtil.escapeStringCharacters(length, str, additionalChars, escapeSlash, true, buffer);
    }

    @NotNull
    public static StringBuilder escapeStringCharacters(int length, @NotNull String str, @Nullable String additionalChars, boolean escapeSlash, boolean escapeUnicode, @NotNull StringBuilder buffer) {
        if (str == null) {
            StringUtil.$$$reportNull$$$0(63);
        }
        if (buffer == null) {
            StringUtil.$$$reportNull$$$0(64);
        }
        char prev = '\u0000';
        for (int idx = 0; idx < length; ++idx) {
            char ch = str.charAt(idx);
            switch (ch) {
                case '\b': {
                    buffer.append("\\b");
                    break;
                }
                case '\t': {
                    buffer.append("\\t");
                    break;
                }
                case '\n': {
                    buffer.append("\\n");
                    break;
                }
                case '\f': {
                    buffer.append("\\f");
                    break;
                }
                case '\r': {
                    buffer.append("\\r");
                    break;
                }
                default: {
                    if (escapeSlash && ch == '\\') {
                        buffer.append("\\\\");
                        break;
                    }
                    if (additionalChars != null && additionalChars.indexOf(ch) > -1 && (escapeSlash || prev != '\\')) {
                        buffer.append("\\").append(ch);
                        break;
                    }
                    if (escapeUnicode && !StringUtil.isPrintableUnicode(ch)) {
                        String hexCode = StringUtil.toUpperCase(Integer.toHexString(ch));
                        buffer.append("\\u");
                        int paddingCount = 4 - hexCode.length();
                        while (paddingCount-- > 0) {
                            buffer.append(0);
                        }
                        buffer.append((CharSequence)hexCode);
                        break;
                    }
                    buffer.append(ch);
                }
            }
            prev = ch;
        }
        StringBuilder stringBuilder = buffer;
        if (stringBuilder == null) {
            StringUtil.$$$reportNull$$$0(65);
        }
        return stringBuilder;
    }

    @Contract(pure=true)
    public static boolean isPrintableUnicode(char c) {
        int t = Character.getType(c);
        Character.UnicodeBlock block = Character.UnicodeBlock.of(c);
        return t != 0 && t != 13 && t != 14 && t != 15 && t != 16 && t != 18 && t != 19 && block != Character.UnicodeBlock.VARIATION_SELECTORS && block != Character.UnicodeBlock.VARIATION_SELECTORS_SUPPLEMENT;
    }

    @Contract(pure=true)
    @NotNull
    public static String escapeStringCharacters(@NotNull String s) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(66);
        }
        StringBuilder buffer = new StringBuilder(s.length());
        StringUtil.escapeStringCharacters(s.length(), s, "\"", buffer);
        String string = buffer.toString();
        if (string == null) {
            StringUtil.$$$reportNull$$$0(67);
        }
        return string;
    }

    @Contract(pure=true)
    @NotNull
    public static String escapeCharCharacters(@NotNull String s) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(68);
        }
        StringBuilder buffer = new StringBuilder(s.length());
        StringUtil.escapeStringCharacters(s.length(), s, "'", buffer);
        String string = buffer.toString();
        if (string == null) {
            StringUtil.$$$reportNull$$$0(69);
        }
        return string;
    }

    @Contract(pure=true)
    @NotNull
    public static String unescapeStringCharacters(@NotNull String s) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(70);
        }
        StringBuilder buffer = new StringBuilder(s.length());
        StringUtil.unescapeStringCharacters(s.length(), s, buffer);
        String string = buffer.toString();
        if (string == null) {
            StringUtil.$$$reportNull$$$0(71);
        }
        return string;
    }

    private static boolean isQuoteAt(@NotNull String s, int ind) {
        char ch;
        if (s == null) {
            StringUtil.$$$reportNull$$$0(72);
        }
        return (ch = s.charAt(ind)) == '\'' || ch == '\"';
    }

    @Contract(pure=true)
    public static boolean isQuotedString(@NotNull String s) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(73);
        }
        return StringUtilRt.isQuotedString(s);
    }

    @Contract(pure=true)
    @NotNull
    public static String unquoteString(@NotNull String s) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(74);
        }
        String string = StringUtilRt.unquoteString(s);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(75);
        }
        return string;
    }

    @Contract(pure=true)
    @NotNull
    public static String unquoteString(@NotNull String s, char quotationChar) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(76);
        }
        String string = StringUtilRt.unquoteString(s, quotationChar);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(77);
        }
        return string;
    }

    private static void unescapeStringCharacters(int length, @NotNull String s, @NotNull StringBuilder buffer) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(78);
        }
        if (buffer == null) {
            StringUtil.$$$reportNull$$$0(79);
        }
        boolean escaped = false;
        for (int idx = 0; idx < length; ++idx) {
            char ch = s.charAt(idx);
            if (!escaped) {
                if (ch == '\\') {
                    escaped = true;
                    continue;
                }
                buffer.append(ch);
                continue;
            }
            int octalEscapeMaxLength = 2;
            switch (ch) {
                case 'n': {
                    buffer.append('\n');
                    break;
                }
                case 'r': {
                    buffer.append('\r');
                    break;
                }
                case 'b': {
                    buffer.append('\b');
                    break;
                }
                case 't': {
                    buffer.append('\t');
                    break;
                }
                case 'f': {
                    buffer.append('\f');
                    break;
                }
                case '\'': {
                    buffer.append('\'');
                    break;
                }
                case '\"': {
                    buffer.append('\"');
                    break;
                }
                case '\\': {
                    buffer.append('\\');
                    break;
                }
                case 'u': {
                    if (idx + 4 < length) {
                        try {
                            int code = Integer.parseInt(s.substring(idx + 1, idx + 5), 16);
                            idx += 4;
                            buffer.append((char)code);
                        }
                        catch (NumberFormatException e) {
                            buffer.append("\\u");
                        }
                        break;
                    }
                    buffer.append("\\u");
                    break;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': {
                    octalEscapeMaxLength = 3;
                }
                case '4': 
                case '5': 
                case '6': 
                case '7': {
                    int escapeEnd;
                    for (escapeEnd = idx + 1; escapeEnd < length && escapeEnd < idx + octalEscapeMaxLength && StringUtil.isOctalDigit(s.charAt(escapeEnd)); ++escapeEnd) {
                    }
                    try {
                        buffer.append((char)Integer.parseInt(s.substring(idx, escapeEnd), 8));
                    }
                    catch (NumberFormatException e) {
                        throw new RuntimeException("Couldn't parse " + s.substring(idx, escapeEnd), e);
                    }
                    idx = escapeEnd - 1;
                    break;
                }
                default: {
                    buffer.append(ch);
                }
            }
            escaped = false;
        }
        if (escaped) {
            buffer.append('\\');
        }
    }

    @NotNull
    public static String unescapeAnsiStringCharacters(@NotNull String s) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(80);
        }
        StringBuilder buffer = new StringBuilder();
        int length = s.length();
        int count = 0;
        int radix = 0;
        int suffixLen = 0;
        boolean decode = false;
        boolean escaped = false;
        for (int idx = 0; idx < length; ++idx) {
            char ch = s.charAt(idx);
            if (!escaped) {
                if (ch == '\\') {
                    escaped = true;
                    continue;
                }
                buffer.append(ch);
                continue;
            }
            switch (ch) {
                case '\'': {
                    buffer.append('\'');
                    break;
                }
                case '\"': {
                    buffer.append('\"');
                    break;
                }
                case '?': {
                    buffer.append('?');
                    break;
                }
                case '\\': {
                    buffer.append('\\');
                    break;
                }
                case 'a': {
                    buffer.append('\u0007');
                    break;
                }
                case 'b': {
                    buffer.append('\b');
                    break;
                }
                case 'f': {
                    buffer.append('\f');
                    break;
                }
                case 'n': {
                    buffer.append('\n');
                    break;
                }
                case 'r': {
                    buffer.append('\r');
                    break;
                }
                case 't': {
                    buffer.append('\t');
                    break;
                }
                case 'v': {
                    buffer.append('\u000b');
                    break;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': {
                    count = 3;
                    radix = 8;
                    suffixLen = 0;
                    decode = true;
                    break;
                }
                case 'x': {
                    count = 2;
                    radix = 16;
                    suffixLen = 1;
                    decode = true;
                    break;
                }
                case 'u': {
                    count = 4;
                    radix = 16;
                    suffixLen = 1;
                    decode = true;
                    break;
                }
                case 'U': {
                    count = 8;
                    radix = 16;
                    suffixLen = 1;
                    decode = true;
                    break;
                }
                default: {
                    buffer.append(ch);
                }
            }
            if (decode) {
                decode = false;
                StringBuilder sb = new StringBuilder(count);
                for (int pos = idx + suffixLen; pos < length && count > 0; --count, ++pos) {
                    char chl = s.charAt(pos);
                    if (!(radix == 16 && StringUtil.isHexDigit(chl) || radix == 8 && StringUtil.isOctalDigit(chl))) break;
                    sb.append(chl);
                }
                if (sb.length() != 0) {
                    try {
                        long code = Long.parseLong(sb.toString(), radix);
                        idx += sb.length() + suffixLen - 1;
                        buffer.append((char)code);
                    }
                    catch (NumberFormatException e) {
                        buffer.append('\\').append(ch);
                    }
                } else {
                    buffer.append('\\').append(ch);
                }
            }
            escaped = false;
        }
        if (escaped) {
            buffer.append('\\');
        }
        String string = buffer.toString();
        if (string == null) {
            StringUtil.$$$reportNull$$$0(81);
        }
        return string;
    }

    @Contract(pure=true)
    @NotNull
    @NonNls
    public static String pluralize(@NotNull @NonNls String word) {
        if (word == null) {
            StringUtil.$$$reportNull$$$0(82);
        }
        String string = Strings.pluralize(word);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(83);
        }
        return string;
    }

    @Contract(pure=true)
    @NotNull
    public static String capitalizeWords(@NotNull String text, boolean allWords) {
        if (text == null) {
            StringUtil.$$$reportNull$$$0(84);
        }
        return StringUtil.capitalizeWords(text, " \t\n\r\f([<", allWords, true);
    }

    @Contract(pure=true)
    @NotNull
    public static String capitalizeWords(@NotNull String text, @NotNull String tokenizerDelimiters, boolean allWords, boolean leaveOriginalDelimiters) {
        if (text == null) {
            StringUtil.$$$reportNull$$$0(85);
        }
        if (tokenizerDelimiters == null) {
            StringUtil.$$$reportNull$$$0(86);
        }
        StringTokenizer tokenizer = new StringTokenizer(text, tokenizerDelimiters, leaveOriginalDelimiters);
        StringBuilder out = new StringBuilder(text.length());
        boolean toCapitalize = true;
        while (tokenizer.hasMoreTokens()) {
            String word = tokenizer.nextToken();
            if (!leaveOriginalDelimiters && out.length() > 0) {
                out.append(' ');
            }
            out.append(toCapitalize ? StringUtil.capitalize(word) : word);
            if (allWords) continue;
            toCapitalize = false;
        }
        String string = out.toString();
        if (string == null) {
            StringUtil.$$$reportNull$$$0(87);
        }
        return string;
    }

    @Contract(pure=true)
    @NotNull
    public static String decapitalize(@NotNull String s) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(88);
        }
        String string = Introspector.decapitalize(s);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(89);
        }
        return string;
    }

    @Contract(pure=true)
    public static boolean isVowel(char c) {
        return c == 'a' || c == 'e' || c == 'i' || c == 'o' || c == 'u' || c == 'y';
    }

    @Contract(pure=true)
    @NotNull
    public static String capitalize(@NotNull String s) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(90);
        }
        String string = Strings.capitalize(s);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(91);
        }
        return string;
    }

    @Contract(value="null -> false", pure=true)
    public static boolean isCapitalized(@Nullable String s) {
        return Strings.isCapitalized(s);
    }

    @Contract(pure=true)
    @NotNull
    public static String capitalizeWithJavaBeanConvention(@NotNull String s) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(92);
        }
        if (s.length() > 1 && Character.isUpperCase(s.charAt(1))) {
            String string = s;
            if (string == null) {
                StringUtil.$$$reportNull$$$0(93);
            }
            return string;
        }
        return StringUtil.capitalize(s);
    }

    @Contract(pure=true)
    public static int stringHashCode(@NotNull CharSequence chars) {
        if (chars == null) {
            StringUtil.$$$reportNull$$$0(94);
        }
        return Strings.stringHashCode(chars);
    }

    @Contract(pure=true)
    public static int stringHashCode(@NotNull CharSequence chars, int from, int to) {
        if (chars == null) {
            StringUtil.$$$reportNull$$$0(95);
        }
        return Strings.stringHashCode(chars, from, to);
    }

    @Contract(pure=true)
    public static int stringHashCode(@NotNull CharSequence chars, int from, int to, int prefixHash) {
        if (chars == null) {
            StringUtil.$$$reportNull$$$0(96);
        }
        return Strings.stringHashCode(chars, from, to, prefixHash);
    }

    @Contract(pure=true)
    public static int stringHashCode(char[] chars, int from, int to) {
        return Strings.stringHashCode(chars, from, to);
    }

    @Contract(pure=true)
    public static int stringHashCodeInsensitive(char @NotNull [] chars, int from, int to) {
        if (chars == null) {
            StringUtil.$$$reportNull$$$0(97);
        }
        return Strings.stringHashCodeInsensitive(chars, from, to);
    }

    @Contract(pure=true)
    public static int stringHashCodeInsensitive(@NotNull CharSequence chars, int from, int to) {
        if (chars == null) {
            StringUtil.$$$reportNull$$$0(98);
        }
        return Strings.stringHashCodeInsensitive(chars, from, to);
    }

    @Contract(pure=true)
    public static int stringHashCodeInsensitive(@NotNull CharSequence chars, int from, int to, int prefixHash) {
        if (chars == null) {
            StringUtil.$$$reportNull$$$0(99);
        }
        return Strings.stringHashCodeInsensitive(chars, from, to, prefixHash);
    }

    @Contract(pure=true)
    public static int stringHashCodeInsensitive(@NotNull CharSequence chars) {
        if (chars == null) {
            StringUtil.$$$reportNull$$$0(100);
        }
        return Strings.stringHashCodeInsensitive(chars);
    }

    @Contract(pure=true)
    public static int stringHashCodeIgnoreWhitespaces(@NotNull CharSequence chars) {
        if (chars == null) {
            StringUtil.$$$reportNull$$$0(101);
        }
        return Strings.stringHashCodeIgnoreWhitespaces(chars);
    }

    @Contract(pure=true)
    public static boolean startsWithConcatenation(@NotNull String string, String ... prefixes) {
        if (string == null) {
            StringUtil.$$$reportNull$$$0(102);
        }
        if (prefixes == null) {
            StringUtil.$$$reportNull$$$0(103);
        }
        int offset = 0;
        for (String prefix : prefixes) {
            int prefixLen = prefix.length();
            if (!string.regionMatches(offset, prefix, 0, prefixLen)) {
                return false;
            }
            offset += prefixLen;
        }
        return true;
    }

    @Contract(value="null -> null; !null -> !null", pure=true)
    public static String trim(@Nullable String s) {
        return Strings.trim(s);
    }

    @Contract(pure=true)
    @NotNull
    public static String trimEnd(@NotNull String s, @NotNull String suffix) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(104);
        }
        if (suffix == null) {
            StringUtil.$$$reportNull$$$0(105);
        }
        String string = Strings.trimEnd(s, suffix);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(106);
        }
        return string;
    }

    @Contract(pure=true)
    @NotNull
    public static String trimEnd(@NotNull String s, @NotNull String suffix, boolean ignoreCase) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(107);
        }
        if (suffix == null) {
            StringUtil.$$$reportNull$$$0(108);
        }
        String string = Strings.trimEnd(s, suffix, ignoreCase);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(109);
        }
        return string;
    }

    @Contract(pure=true)
    @NotNull
    public static String trimEnd(@NotNull String s, char suffix) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(110);
        }
        String string = Strings.trimEnd(s, suffix);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(111);
        }
        return string;
    }

    @Contract(pure=true)
    @NotNull
    public static String trimLog(@NotNull String text, int limit) {
        if (text == null) {
            StringUtil.$$$reportNull$$$0(112);
        }
        if (limit > 5 && text.length() > limit) {
            String string = text.substring(0, limit - 5) + " ...\n";
            if (string == null) {
                StringUtil.$$$reportNull$$$0(113);
            }
            return string;
        }
        String string = text;
        if (string == null) {
            StringUtil.$$$reportNull$$$0(114);
        }
        return string;
    }

    @Contract(pure=true)
    @NotNull
    public static String trimLeading(@NotNull String string) {
        if (string == null) {
            StringUtil.$$$reportNull$$$0(115);
        }
        String string2 = StringUtil.trimLeading((CharSequence)string).toString();
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(116);
        }
        return string2;
    }

    @Contract(pure=true)
    @NotNull
    public static CharSequence trimLeading(@NotNull CharSequence string) {
        int index;
        if (string == null) {
            StringUtil.$$$reportNull$$$0(117);
        }
        for (index = 0; index < string.length() && Character.isWhitespace(string.charAt(index)); ++index) {
        }
        CharSequence charSequence = string.subSequence(index, string.length());
        if (charSequence == null) {
            StringUtil.$$$reportNull$$$0(118);
        }
        return charSequence;
    }

    @Contract(pure=true)
    @NotNull
    public static String trimLeading(@NotNull String string, char symbol) {
        int index;
        if (string == null) {
            StringUtil.$$$reportNull$$$0(119);
        }
        for (index = 0; index < string.length() && string.charAt(index) == symbol; ++index) {
        }
        String string2 = string.substring(index);
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(120);
        }
        return string2;
    }

    @NotNull
    public static StringBuilder trimLeading(@NotNull StringBuilder builder, char symbol) {
        int index;
        if (builder == null) {
            StringUtil.$$$reportNull$$$0(121);
        }
        for (index = 0; index < builder.length() && builder.charAt(index) == symbol; ++index) {
        }
        if (index > 0) {
            builder.delete(0, index);
        }
        StringBuilder stringBuilder = builder;
        if (stringBuilder == null) {
            StringUtil.$$$reportNull$$$0(122);
        }
        return stringBuilder;
    }

    @Contract(pure=true)
    @NotNull
    public static String trimTrailing(@NotNull String string) {
        if (string == null) {
            StringUtil.$$$reportNull$$$0(123);
        }
        String string2 = StringUtil.trimTrailing((CharSequence)string).toString();
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(124);
        }
        return string2;
    }

    @Contract(pure=true)
    @NotNull
    public static CharSequence trimTrailing(@NotNull CharSequence string) {
        int index;
        if (string == null) {
            StringUtil.$$$reportNull$$$0(125);
        }
        for (index = string.length() - 1; index >= 0 && Character.isWhitespace(string.charAt(index)); --index) {
        }
        CharSequence charSequence = string.subSequence(0, index + 1);
        if (charSequence == null) {
            StringUtil.$$$reportNull$$$0(126);
        }
        return charSequence;
    }

    @Contract(pure=true)
    @NotNull
    public static String trimTrailing(@NotNull String string, char symbol) {
        int index;
        if (string == null) {
            StringUtil.$$$reportNull$$$0(127);
        }
        for (index = string.length() - 1; index >= 0 && string.charAt(index) == symbol; --index) {
        }
        String string2 = string.substring(0, index + 1);
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(128);
        }
        return string2;
    }

    @NotNull
    public static StringBuilder trimTrailing(@NotNull StringBuilder builder, char symbol) {
        int index;
        if (builder == null) {
            StringUtil.$$$reportNull$$$0(129);
        }
        for (index = builder.length() - 1; index >= 0 && builder.charAt(index) == symbol; --index) {
        }
        builder.setLength(index + 1);
        StringBuilder stringBuilder = builder;
        if (stringBuilder == null) {
            StringUtil.$$$reportNull$$$0(130);
        }
        return stringBuilder;
    }

    @Contract(value="null -> null; !null -> !null", pure=true)
    @Nullable
    public static CharSequence trim(@Nullable CharSequence s) {
        int endIndex;
        int startIndex;
        if (s == null) {
            return null;
        }
        int length = s.length();
        if (length == 0) {
            return s;
        }
        for (startIndex = 0; startIndex < length && Character.isWhitespace(s.charAt(startIndex)); ++startIndex) {
        }
        if (startIndex == length) {
            return Strings.EMPTY_CHAR_SEQUENCE;
        }
        for (endIndex = length - 1; endIndex >= startIndex && Character.isWhitespace(s.charAt(endIndex)); --endIndex) {
        }
        if (startIndex > 0 || ++endIndex < length) {
            return s.subSequence(startIndex, endIndex);
        }
        return s;
    }

    @Contract(pure=true)
    public static boolean startsWithChar(@Nullable CharSequence s, char prefix) {
        return s != null && s.length() != 0 && s.charAt(0) == prefix;
    }

    @Contract(pure=true)
    public static boolean endsWithChar(@Nullable CharSequence s, char suffix) {
        return Strings.endsWithChar(s, suffix);
    }

    @Contract(pure=true)
    @NotNull
    public static String trimStart(@NotNull String s, @NotNull String prefix) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(131);
        }
        if (prefix == null) {
            StringUtil.$$$reportNull$$$0(132);
        }
        String string = Strings.trimStart(s, prefix);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(133);
        }
        return string;
    }

    @Contract(pure=true)
    @NotNull
    public static String trimExtensions(@NotNull String name) {
        int index;
        if (name == null) {
            StringUtil.$$$reportNull$$$0(134);
        }
        String string = (index = name.indexOf(46)) < 0 ? name : name.substring(0, index);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(135);
        }
        return string;
    }

    @Contract(pure=true)
    @NotNull
    public static String pluralize(@NotNull String base, int count) {
        if (base == null) {
            StringUtil.$$$reportNull$$$0(136);
        }
        if (count == 1) {
            String string = base;
            if (string == null) {
                StringUtil.$$$reportNull$$$0(137);
            }
            return string;
        }
        return StringUtil.pluralize(base);
    }

    public static void repeatSymbol(@NotNull Appendable buffer, char symbol, int times) {
        if (buffer == null) {
            StringUtil.$$$reportNull$$$0(138);
        }
        assert (times >= 0) : times;
        try {
            for (int i = 0; i < times; ++i) {
                buffer.append(symbol);
            }
        }
        catch (IOException e) {
            Logger.getInstance(StringUtil.class).error(e);
        }
    }

    @Contract(pure=true)
    public static String defaultIfEmpty(@Nullable String value, String defaultValue) {
        return StringUtil.isEmpty(value) ? defaultValue : value;
    }

    @Contract(value="null -> false", pure=true)
    public static boolean isNotEmpty(@Nullable String s) {
        return Strings.isNotEmpty(s);
    }

    @Contract(value="null -> true", pure=true)
    public static boolean isEmpty(@Nullable String s) {
        return Strings.isEmpty(s);
    }

    @Contract(value="null -> true", pure=true)
    public static boolean isEmpty(@Nullable CharSequence cs) {
        return Strings.isEmpty(cs);
    }

    @Contract(pure=true)
    public static int length(@Nullable CharSequence cs) {
        return cs == null ? 0 : cs.length();
    }

    @Contract(pure=true)
    @NotNull
    public static String notNullize(@Nullable String s) {
        String string = Strings.notNullize(s);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(139);
        }
        return string;
    }

    @Contract(pure=true)
    @NotNull
    public static String notNullize(@Nullable String s, @NotNull String defaultValue) {
        if (defaultValue == null) {
            StringUtil.$$$reportNull$$$0(140);
        }
        String string = Strings.notNullize(s, defaultValue);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(141);
        }
        return string;
    }

    @Contract(pure=true)
    @Nullable
    public static String nullize(@Nullable String s) {
        return Strings.nullize(s, false);
    }

    @Contract(pure=true)
    @Nullable
    public static String nullize(@Nullable String s, @Nullable String defaultValue) {
        return Strings.nullize(s, defaultValue);
    }

    @Contract(pure=true)
    @Nullable
    public static String nullize(@Nullable String s, boolean nullizeSpaces) {
        return Strings.nullize(s, nullizeSpaces);
    }

    @Contract(value="null -> true", pure=true)
    public static boolean isEmptyOrSpaces(@Nullable String s) {
        return StringUtil.isEmptyOrSpaces((CharSequence)s);
    }

    @Contract(value="null -> true", pure=true)
    public static boolean isEmptyOrSpaces(@Nullable CharSequence s) {
        return Strings.isEmptyOrSpaces(s);
    }

    @Contract(pure=true)
    public static boolean isWhiteSpace(char c) {
        return Strings.isWhiteSpace(c);
    }

    @Contract(pure=true)
    @NotNull
    public static String getThrowableText(@NotNull Throwable aThrowable) {
        if (aThrowable == null) {
            StringUtil.$$$reportNull$$$0(142);
        }
        String string = ExceptionUtil.getThrowableText((Throwable)aThrowable);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(143);
        }
        return string;
    }

    @Contract(pure=true)
    @Nullable
    public static String getMessage(@NotNull Throwable e) {
        if (e == null) {
            StringUtil.$$$reportNull$$$0(144);
        }
        return ExceptionUtil.getMessage((Throwable)e);
    }

    @Contract(pure=true)
    @NotNull
    public static String repeatSymbol(char aChar, int count) {
        char[] buffer = new char[count];
        Arrays.fill(buffer, aChar);
        return new String(buffer);
    }

    @Contract(pure=true)
    @NotNull
    public static String repeat(@NotNull String s, int count) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(145);
        }
        if (count == 0) {
            return "";
        }
        assert (count >= 0) : count;
        StringBuilder sb = new StringBuilder(s.length() * count);
        for (int i = 0; i < count; ++i) {
            sb.append(s);
        }
        String string = sb.toString();
        if (string == null) {
            StringUtil.$$$reportNull$$$0(146);
        }
        return string;
    }

    @Contract(pure=true)
    @NotNull
    public static List<String> splitHonorQuotes(@NotNull String s, char separator) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(147);
        }
        List<String> list = StringUtilRt.splitHonorQuotes(s, separator);
        if (list == null) {
            StringUtil.$$$reportNull$$$0(148);
        }
        return list;
    }

    @Contract(pure=true)
    public static @Unmodifiable @NotNull List<String> split(@NotNull String s, @NotNull String separator) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(149);
        }
        if (separator == null) {
            StringUtil.$$$reportNull$$$0(150);
        }
        return StringUtil.split(s, separator, true);
    }

    @Contract(pure=true)
    public static @Unmodifiable @NotNull List<CharSequence> split(@NotNull CharSequence s, @NotNull CharSequence separator) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(151);
        }
        if (separator == null) {
            StringUtil.$$$reportNull$$$0(152);
        }
        return StringUtil.split(s, separator, true, true);
    }

    @Contract(pure=true)
    public static @Unmodifiable @NotNull List<String> split(@NotNull String s, @NotNull String separator, boolean excludeSeparator) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(153);
        }
        if (separator == null) {
            StringUtil.$$$reportNull$$$0(154);
        }
        return StringUtil.split(s, separator, excludeSeparator, true);
    }

    @Contract(pure=true)
    public static @Unmodifiable @NotNull List<String> split(@NotNull String s, @NotNull String separator, boolean excludeSeparator, boolean excludeEmptyStrings) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(155);
        }
        if (separator == null) {
            StringUtil.$$$reportNull$$$0(156);
        }
        return StringUtil.split((CharSequence)s, (CharSequence)separator, excludeSeparator, excludeEmptyStrings);
    }

    @Contract(pure=true)
    public static @Unmodifiable @NotNull List<CharSequence> split(@NotNull CharSequence s, @NotNull CharSequence separator, boolean excludeSeparator, boolean excludeEmptyStrings) {
        int index;
        if (s == null) {
            StringUtil.$$$reportNull$$$0(157);
        }
        if (separator == null) {
            StringUtil.$$$reportNull$$$0(158);
        }
        if (separator.length() == 0) {
            List<CharSequence> list = Collections.singletonList(s);
            if (list == null) {
                StringUtil.$$$reportNull$$$0(159);
            }
            return list;
        }
        ArrayList<CharSequence> result = new ArrayList<CharSequence>();
        int pos = 0;
        while ((index = StringUtil.indexOf(s, separator, pos)) != -1) {
            int nextPos = index + separator.length();
            CharSequence token = s.subSequence(pos, excludeSeparator ? index : nextPos);
            if (token.length() != 0 || !excludeEmptyStrings) {
                result.add(token);
            }
            pos = nextPos;
        }
        if (pos < s.length() || !excludeEmptyStrings && pos == s.length()) {
            result.add(s.subSequence(pos, s.length()));
        }
        ArrayList<CharSequence> arrayList = result;
        if (arrayList == null) {
            StringUtil.$$$reportNull$$$0(160);
        }
        return arrayList;
    }

    @Contract(pure=true)
    @NotNull
    public static Iterable<String> tokenize(@NotNull String s, @NotNull String separators) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(161);
        }
        if (separators == null) {
            StringUtil.$$$reportNull$$$0(162);
        }
        return StringUtil.tokenize(new StringTokenizer(s, separators));
    }

    @Contract(pure=true)
    @NotNull
    public static Iterable<String> tokenize(@NotNull StringTokenizer tokenizer) {
        if (tokenizer == null) {
            StringUtil.$$$reportNull$$$0(163);
        }
        Iterable<String> iterable = () -> new /* Unavailable Anonymous Inner Class!! */;
        if (iterable == null) {
            StringUtil.$$$reportNull$$$0(164);
        }
        return iterable;
    }

    @Contract(pure=true)
    @NotNull
    public static List<String> getWordsIn(@NotNull String text) {
        if (text == null) {
            StringUtil.$$$reportNull$$$0(165);
        }
        SmartList<String> result = null;
        int start = -1;
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            boolean isIdentifierPart = Character.isJavaIdentifierPart(c);
            if (isIdentifierPart && start == -1) {
                start = i;
            }
            if (isIdentifierPart && i == text.length() - 1) {
                if (result == null) {
                    result = new SmartList();
                }
                result.add(text.substring(start, i + 1));
                continue;
            }
            if (isIdentifierPart || start == -1) continue;
            if (result == null) {
                result = new SmartList<String>();
            }
            result.add(text.substring(start, i));
            start = -1;
        }
        if (result == null) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                StringUtil.$$$reportNull$$$0(166);
            }
            return list;
        }
        SmartList<String> smartList = result;
        if (smartList == null) {
            StringUtil.$$$reportNull$$$0(167);
        }
        return smartList;
    }

    @Contract(pure=true)
    @NotNull
    public static List<TextRange> getWordIndicesIn(@NotNull String text) {
        if (text == null) {
            StringUtil.$$$reportNull$$$0(168);
        }
        return StringUtil.getWordIndicesIn(text, null);
    }

    @Contract(pure=true)
    @NotNull
    public static List<TextRange> getWordIndicesIn(@NotNull String text, @Nullable Set<Character> separatorsSet) {
        if (text == null) {
            StringUtil.$$$reportNull$$$0(169);
        }
        SmartList<TextRange> result = new SmartList<TextRange>();
        int start = -1;
        for (int i = 0; i < text.length(); ++i) {
            boolean isIdentifierPart;
            char c = text.charAt(i);
            boolean bl = separatorsSet == null ? Character.isJavaIdentifierPart(c) : (isIdentifierPart = !separatorsSet.contains(Character.valueOf(c)));
            if (isIdentifierPart && start == -1) {
                start = i;
            }
            if (isIdentifierPart && i == text.length() - 1) {
                result.add(new TextRange(start, i + 1));
                continue;
            }
            if (isIdentifierPart || start == -1) continue;
            result.add(new TextRange(start, i));
            start = -1;
        }
        SmartList<TextRange> smartList = result;
        if (smartList == null) {
            StringUtil.$$$reportNull$$$0(170);
        }
        return smartList;
    }

    @Contract(pure=true)
    @NotNull
    public static String join(String @NotNull [] strings, @NotNull String separator) {
        if (separator == null) {
            StringUtil.$$$reportNull$$$0(171);
        }
        if (strings == null) {
            StringUtil.$$$reportNull$$$0(172);
        }
        return StringUtil.join(strings, 0, strings.length, separator);
    }

    @Contract(pure=true)
    @NotNull
    public static String join(String @NotNull [] strings, int startIndex, int endIndex, @NotNull String separator) {
        if (separator == null) {
            StringUtil.$$$reportNull$$$0(173);
        }
        if (strings == null) {
            StringUtil.$$$reportNull$$$0(174);
        }
        StringBuilder result = new StringBuilder();
        for (int i = startIndex; i < endIndex; ++i) {
            if (i > startIndex) {
                result.append(separator);
            }
            result.append(strings[i]);
        }
        String string = result.toString();
        if (string == null) {
            StringUtil.$$$reportNull$$$0(175);
        }
        return string;
    }

    @Contract(pure=true)
    public static String @NotNull [] zip(String @NotNull [] strings1, String @NotNull [] strings2, String separator) {
        if (strings1 == null) {
            StringUtil.$$$reportNull$$$0(176);
        }
        if (strings2 == null) {
            StringUtil.$$$reportNull$$$0(177);
        }
        if (strings1.length != strings2.length) {
            throw new IllegalArgumentException();
        }
        String[] result = ArrayUtil.newStringArray(strings1.length);
        for (int i = 0; i < result.length; ++i) {
            result[i] = strings1[i] + separator + strings2[i];
        }
        if (result == null) {
            StringUtil.$$$reportNull$$$0(178);
        }
        return result;
    }

    @Contract(pure=true)
    public static String @NotNull [] surround(String @NotNull [] strings, @NotNull String prefix, @NotNull String suffix) {
        if (prefix == null) {
            StringUtil.$$$reportNull$$$0(179);
        }
        if (suffix == null) {
            StringUtil.$$$reportNull$$$0(180);
        }
        if (strings == null) {
            StringUtil.$$$reportNull$$$0(181);
        }
        String[] result = ArrayUtil.newStringArray(strings.length);
        for (int i = 0; i < result.length; ++i) {
            result[i] = prefix + strings[i] + suffix;
        }
        if (result == null) {
            StringUtil.$$$reportNull$$$0(182);
        }
        return result;
    }

    @Contract(pure=true)
    @NotNull
    public static <T> String join(T @NotNull [] items, @NotNull com.intellij.util.Function<? super T, String> f, @NotNull String separator) {
        if (f == null) {
            StringUtil.$$$reportNull$$$0(183);
        }
        if (separator == null) {
            StringUtil.$$$reportNull$$$0(184);
        }
        if (items == null) {
            StringUtil.$$$reportNull$$$0(185);
        }
        String string = Strings.join(items, f, separator);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(186);
        }
        return string;
    }

    @Contract(pure=true)
    @NotNull
    public static <T> String join(@NotNull Collection<? extends T> items, @NotNull com.intellij.util.Function<? super T, String> f, @NotNull String separator) {
        if (items == null) {
            StringUtil.$$$reportNull$$$0(187);
        }
        if (f == null) {
            StringUtil.$$$reportNull$$$0(188);
        }
        if (separator == null) {
            StringUtil.$$$reportNull$$$0(189);
        }
        String string = Strings.join(items, f, separator);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(190);
        }
        return string;
    }

    @Contract(pure=true)
    @NotNull
    public static String join(@NotNull Iterable<?> items, @NotNull String separator) {
        if (items == null) {
            StringUtil.$$$reportNull$$$0(191);
        }
        if (separator == null) {
            StringUtil.$$$reportNull$$$0(192);
        }
        String string = Strings.join(items, separator);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(193);
        }
        return string;
    }

    @Contract(pure=true)
    @NotNull
    public static <T> String join(@NotNull Iterable<? extends T> items, @NotNull com.intellij.util.Function<? super T, ? extends CharSequence> f, @NotNull String separator) {
        if (items == null) {
            StringUtil.$$$reportNull$$$0(194);
        }
        if (f == null) {
            StringUtil.$$$reportNull$$$0(195);
        }
        if (separator == null) {
            StringUtil.$$$reportNull$$$0(196);
        }
        String string = Strings.join(items, f, separator);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(197);
        }
        return string;
    }

    public static <T> void join(@NotNull Iterable<? extends T> items, @NotNull com.intellij.util.Function<? super T, ? extends CharSequence> f, @NotNull String separator, @NotNull StringBuilder result) {
        if (items == null) {
            StringUtil.$$$reportNull$$$0(198);
        }
        if (f == null) {
            StringUtil.$$$reportNull$$$0(199);
        }
        if (separator == null) {
            StringUtil.$$$reportNull$$$0(200);
        }
        if (result == null) {
            StringUtil.$$$reportNull$$$0(201);
        }
        Strings.join(items, f, separator, result);
    }

    @Contract(pure=true)
    @NotNull
    public static String join(@NotNull Collection<String> strings, @NotNull String separator) {
        if (strings == null) {
            StringUtil.$$$reportNull$$$0(202);
        }
        if (separator == null) {
            StringUtil.$$$reportNull$$$0(203);
        }
        String string = Strings.join(strings, separator);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(204);
        }
        return string;
    }

    public static void join(@NotNull Collection<String> strings, @NotNull String separator, @NotNull StringBuilder result) {
        if (strings == null) {
            StringUtil.$$$reportNull$$$0(205);
        }
        if (separator == null) {
            StringUtil.$$$reportNull$$$0(206);
        }
        if (result == null) {
            StringUtil.$$$reportNull$$$0(207);
        }
        Strings.join(strings, separator, result);
    }

    @Contract(pure=true)
    @NotNull
    public static String join(int @NotNull [] strings, @NotNull String separator) {
        if (separator == null) {
            StringUtil.$$$reportNull$$$0(208);
        }
        if (strings == null) {
            StringUtil.$$$reportNull$$$0(209);
        }
        String string = Strings.join(strings, separator);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(210);
        }
        return string;
    }

    @Contract(pure=true)
    @NotNull
    public static String join(String ... strings) {
        if (strings == null) {
            StringUtil.$$$reportNull$$$0(211);
        }
        String string = Strings.join(strings);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(212);
        }
        return string;
    }

    @Contract(pure=true)
    @NotNull
    public static Collector<CharSequence, ?, String> joining() {
        Collector<CharSequence, ?, String> collector = Collectors.joining(", ");
        if (collector == null) {
            StringUtil.$$$reportNull$$$0(213);
        }
        return collector;
    }

    @Contract(pure=true)
    @NotNull
    public static String stripQuotesAroundValue(@NotNull String text) {
        int len;
        if (text == null) {
            StringUtil.$$$reportNull$$$0(214);
        }
        if ((len = text.length()) > 0) {
            int to;
            int from = StringUtil.isQuoteAt(text, 0) ? 1 : 0;
            int n = to = len > 1 && StringUtil.isQuoteAt(text, len - 1) ? len - 1 : len;
            if (from > 0 || to < len) {
                String string = text.substring(from, to);
                if (string == null) {
                    StringUtil.$$$reportNull$$$0(215);
                }
                return string;
            }
        }
        String string = text;
        if (string == null) {
            StringUtil.$$$reportNull$$$0(216);
        }
        return string;
    }

    @Contract(pure=true)
    @NotNull
    public static String formatFileSize(long fileSize) {
        String string = Formats.formatFileSize((long)fileSize);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(217);
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @Contract(pure=true)
    @NotNull
    public static String formatFileSize(long fileSize, @NotNull String string) {
        void unitSeparator;
        if (string == null) {
            StringUtil.$$$reportNull$$$0(218);
        }
        String string2 = Formats.formatFileSize((long)fileSize, (String)unitSeparator);
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(219);
        }
        return string2;
    }

    @Contract(pure=true)
    @NotNull
    @NonNls
    public static String formatDuration(long duration) {
        String string = Formats.formatDuration((long)duration);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(220);
        }
        return string;
    }

    @Contract(pure=true)
    @NotNull
    @NonNls
    public static String formatDuration(@NotNull Duration duration) {
        if (duration == null) {
            StringUtil.$$$reportNull$$$0(221);
        }
        String string = Formats.formatDuration((Duration)duration);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(222);
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    @Contract(pure=true)
    @ApiStatus.ScheduledForRemoval
    @NotNull
    @NonNls
    public static String formatDuration(long duration, @NotNull String string) {
        void unitSeparator;
        if (string == null) {
            StringUtil.$$$reportNull$$$0(223);
        }
        String string2 = Formats.formatDuration((long)duration, (String)unitSeparator);
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(224);
        }
        return string2;
    }

    @Contract(pure=true)
    @Nullable
    public static String unpluralize(@NotNull String word) {
        if (word == null) {
            StringUtil.$$$reportNull$$$0(225);
        }
        return Strings.unpluralize(word);
    }

    @Contract(pure=true)
    public static boolean containsAlphaCharacters(@NotNull String value) {
        if (value == null) {
            StringUtil.$$$reportNull$$$0(226);
        }
        for (int i = 0; i < value.length(); ++i) {
            if (!Character.isLetter(value.charAt(i))) continue;
            return true;
        }
        return false;
    }

    @Contract(pure=true)
    public static boolean containsAnyChar(@NotNull String value, @NotNull @NonNls String chars) {
        if (value == null) {
            StringUtil.$$$reportNull$$$0(227);
        }
        if (chars == null) {
            StringUtil.$$$reportNull$$$0(228);
        }
        return Strings.containsAnyChar(value, chars);
    }

    @Contract(pure=true)
    public static boolean containsAnyChar(@NotNull String value, @NotNull String chars, int start, int end) {
        if (value == null) {
            StringUtil.$$$reportNull$$$0(229);
        }
        if (chars == null) {
            StringUtil.$$$reportNull$$$0(230);
        }
        return Strings.containsAnyChar(value, chars, start, end);
    }

    @Contract(pure=true)
    public static boolean containsChar(@NotNull String value, char ch) {
        if (value == null) {
            StringUtil.$$$reportNull$$$0(231);
        }
        return Strings.containsChar(value, ch);
    }

    @Contract(pure=true)
    @NotNull
    public static String strip(@NotNull String s, @NotNull CharFilter filter) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(232);
        }
        if (filter == null) {
            StringUtil.$$$reportNull$$$0(233);
        }
        StringBuilder result = new StringBuilder(s.length());
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (!filter.accept(ch)) continue;
            result.append(ch);
        }
        String string = result.toString();
        if (string == null) {
            StringUtil.$$$reportNull$$$0(234);
        }
        return string;
    }

    @Contract(pure=true)
    @NotNull
    public static String trim(@NotNull String s, @NotNull CharFilter filter) {
        char ch;
        int start;
        if (s == null) {
            StringUtil.$$$reportNull$$$0(235);
        }
        if (filter == null) {
            StringUtil.$$$reportNull$$$0(236);
        }
        int end = s.length();
        for (start = 0; start < end && !filter.accept(ch = s.charAt(start)); ++start) {
        }
        while (start < end && !filter.accept(ch = s.charAt(end - 1))) {
            --end;
        }
        String string = s.substring(start, end);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(237);
        }
        return string;
    }

    @Contract(pure=true)
    @NotNull
    public static List<String> findMatches(@NotNull String s, @NotNull Pattern pattern) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(238);
        }
        if (pattern == null) {
            StringUtil.$$$reportNull$$$0(239);
        }
        return StringUtil.findMatches(s, pattern, 1);
    }

    @Contract(pure=true)
    @NotNull
    public static List<String> findMatches(@NotNull String s, @NotNull Pattern pattern, int groupIndex) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(240);
        }
        if (pattern == null) {
            StringUtil.$$$reportNull$$$0(241);
        }
        SmartList<String> result = new SmartList<String>();
        Matcher m = pattern.matcher(s);
        while (m.find()) {
            String group = m.group(groupIndex);
            if (group == null) continue;
            result.add(group);
        }
        SmartList<String> smartList = result;
        if (smartList == null) {
            StringUtil.$$$reportNull$$$0(242);
        }
        return smartList;
    }

    @Contract(pure=true)
    public static int findFirst(@NotNull CharSequence s, @NotNull CharFilter filter) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(243);
        }
        if (filter == null) {
            StringUtil.$$$reportNull$$$0(244);
        }
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (!filter.accept(ch)) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    @NotNull
    public static String replaceSubstring(@NotNull String string, @NotNull TextRange range, @NotNull String replacement) {
        if (string == null) {
            StringUtil.$$$reportNull$$$0(245);
        }
        if (range == null) {
            StringUtil.$$$reportNull$$$0(246);
        }
        if (replacement == null) {
            StringUtil.$$$reportNull$$$0(247);
        }
        String string2 = range.replace(string, replacement);
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(248);
        }
        return string2;
    }

    @Contract(pure=true)
    public static boolean startsWithWhitespace(@NotNull String text) {
        if (text == null) {
            StringUtil.$$$reportNull$$$0(249);
        }
        return !text.isEmpty() && Character.isWhitespace(text.charAt(0));
    }

    @Contract(pure=true)
    public static boolean isChar(CharSequence seq, int index, char c) {
        return index >= 0 && index < seq.length() && seq.charAt(index) == c;
    }

    @Contract(pure=true)
    public static boolean startsWith(@NotNull CharSequence text, @NotNull CharSequence prefix) {
        if (text == null) {
            StringUtil.$$$reportNull$$$0(250);
        }
        if (prefix == null) {
            StringUtil.$$$reportNull$$$0(251);
        }
        return StringUtilRt.startsWith(text, prefix);
    }

    @Contract(pure=true)
    public static boolean startsWith(@NotNull CharSequence text, int startIndex, @NotNull CharSequence prefix) {
        if (text == null) {
            StringUtil.$$$reportNull$$$0(252);
        }
        if (prefix == null) {
            StringUtil.$$$reportNull$$$0(253);
        }
        return Strings.startsWith(text, startIndex, prefix);
    }

    @Contract(pure=true)
    public static boolean endsWith(@NotNull CharSequence text, @NotNull CharSequence suffix) {
        if (text == null) {
            StringUtil.$$$reportNull$$$0(254);
        }
        if (suffix == null) {
            StringUtil.$$$reportNull$$$0(255);
        }
        return Strings.endsWith(text, suffix);
    }

    @Contract(pure=true)
    public static boolean endsWith(@NotNull CharSequence text, int start, int end, @NotNull CharSequence suffix) {
        if (text == null) {
            StringUtil.$$$reportNull$$$0(256);
        }
        if (suffix == null) {
            StringUtil.$$$reportNull$$$0(257);
        }
        if (start < 0 || end > text.length()) {
            throw new IllegalArgumentException("invalid offsets: start=" + start + "; end=" + end + "; text.length()=" + text.length());
        }
        int suffixLen = suffix.length();
        int delta = end - suffixLen;
        if (delta < start) {
            return false;
        }
        for (int i = 0; i < suffixLen; ++i) {
            if (text.charAt(delta + i) == suffix.charAt(i)) continue;
            return false;
        }
        return true;
    }

    @Contract(pure=true)
    @NotNull
    public static String commonPrefix(@NotNull String s1, @NotNull String s2) {
        if (s1 == null) {
            StringUtil.$$$reportNull$$$0(258);
        }
        if (s2 == null) {
            StringUtil.$$$reportNull$$$0(259);
        }
        String string = s1.substring(0, StringUtil.commonPrefixLength(s1, s2));
        if (string == null) {
            StringUtil.$$$reportNull$$$0(260);
        }
        return string;
    }

    @Contract(pure=true)
    public static int commonPrefixLength(@NotNull CharSequence s1, @NotNull CharSequence s2) {
        if (s1 == null) {
            StringUtil.$$$reportNull$$$0(261);
        }
        if (s2 == null) {
            StringUtil.$$$reportNull$$$0(262);
        }
        return StringUtil.commonPrefixLength(s1, s2, false);
    }

    @Contract(pure=true)
    public static int commonPrefixLength(@NotNull CharSequence s1, @NotNull CharSequence s2, boolean ignoreCase) {
        int i;
        if (s1 == null) {
            StringUtil.$$$reportNull$$$0(263);
        }
        if (s2 == null) {
            StringUtil.$$$reportNull$$$0(264);
        }
        int minLength = Math.min(s1.length(), s2.length());
        for (i = 0; i < minLength && Strings.charsMatch(s1.charAt(i), s2.charAt(i), ignoreCase); ++i) {
        }
        return i;
    }

    @Contract(pure=true)
    @NotNull
    public static String commonSuffix(@NotNull String s1, @NotNull String s2) {
        if (s1 == null) {
            StringUtil.$$$reportNull$$$0(265);
        }
        if (s2 == null) {
            StringUtil.$$$reportNull$$$0(266);
        }
        String string = s1.substring(s1.length() - StringUtil.commonSuffixLength(s1, s2));
        if (string == null) {
            StringUtil.$$$reportNull$$$0(267);
        }
        return string;
    }

    @Contract(pure=true)
    public static int commonSuffixLength(@NotNull CharSequence s1, @NotNull CharSequence s2) {
        int i;
        if (s1 == null) {
            StringUtil.$$$reportNull$$$0(268);
        }
        if (s2 == null) {
            StringUtil.$$$reportNull$$$0(269);
        }
        int s1Length = s1.length();
        int s2Length = s2.length();
        if (s1Length == 0 || s2Length == 0) {
            return 0;
        }
        for (i = 0; i < s1Length && i < s2Length && s1.charAt(s1Length - i - 1) == s2.charAt(s2Length - i - 1); ++i) {
        }
        return i;
    }

    @Contract(pure=true)
    public static boolean contains(@NotNull CharSequence s, int start, int end, char c) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(270);
        }
        return Strings.contains(s, start, end, c);
    }

    @Contract(pure=true)
    public static boolean containsWhitespaces(@Nullable CharSequence s) {
        if (s == null) {
            return false;
        }
        for (int i = 0; i < s.length(); ++i) {
            if (!Character.isWhitespace(s.charAt(i))) continue;
            return true;
        }
        return false;
    }

    @Contract(pure=true)
    public static int indexOf(@NotNull CharSequence s, char c) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(271);
        }
        return Strings.indexOf(s, c);
    }

    @Contract(pure=true)
    public static int indexOf(@NotNull CharSequence s, char c, int start) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(272);
        }
        return Strings.indexOf(s, c, start);
    }

    @Contract(pure=true)
    public static int indexOf(@NotNull CharSequence s, char c, int start, int end) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(273);
        }
        return Strings.indexOf(s, c, start, end);
    }

    @Contract(pure=true)
    public static boolean contains(@NotNull CharSequence sequence, @NotNull CharSequence infix) {
        if (sequence == null) {
            StringUtil.$$$reportNull$$$0(274);
        }
        if (infix == null) {
            StringUtil.$$$reportNull$$$0(275);
        }
        return Strings.contains(sequence, infix);
    }

    @Contract(pure=true)
    public static int indexOf(@NotNull CharSequence sequence, @NotNull CharSequence infix) {
        if (sequence == null) {
            StringUtil.$$$reportNull$$$0(276);
        }
        if (infix == null) {
            StringUtil.$$$reportNull$$$0(277);
        }
        return Strings.indexOf(sequence, infix);
    }

    @Contract(pure=true)
    public static int indexOf(@NotNull CharSequence sequence, @NotNull CharSequence infix, int start) {
        if (sequence == null) {
            StringUtil.$$$reportNull$$$0(278);
        }
        if (infix == null) {
            StringUtil.$$$reportNull$$$0(279);
        }
        return Strings.indexOf(sequence, infix, start);
    }

    @Contract(pure=true)
    public static int indexOf(@NotNull CharSequence sequence, @NotNull CharSequence infix, int start, int end) {
        if (sequence == null) {
            StringUtil.$$$reportNull$$$0(280);
        }
        if (infix == null) {
            StringUtil.$$$reportNull$$$0(281);
        }
        return Strings.indexOf(sequence, infix, start, end);
    }

    @Contract(pure=true)
    public static int indexOf(@NotNull CharSequence s, char c, int start, int end, boolean caseSensitive) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(282);
        }
        return Strings.indexOf(s, c, start, end, caseSensitive);
    }

    public static int indexOf(char @NotNull [] s, char c, int start, int end, boolean caseSensitive) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(283);
        }
        return Strings.indexOf(s, c, start, end, caseSensitive);
    }

    @Contract(pure=true)
    public static int indexOfSubstringEnd(@NotNull String text, @NotNull String subString) {
        int i;
        if (text == null) {
            StringUtil.$$$reportNull$$$0(284);
        }
        if (subString == null) {
            StringUtil.$$$reportNull$$$0(285);
        }
        if ((i = text.indexOf(subString)) == -1) {
            return -1;
        }
        return i + subString.length();
    }

    @Contract(pure=true)
    public static int indexOfAny(@NotNull String s, @NotNull String chars) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(286);
        }
        if (chars == null) {
            StringUtil.$$$reportNull$$$0(287);
        }
        return Strings.indexOfAny(s, chars);
    }

    @Contract(pure=true)
    public static int indexOfAny(@NotNull CharSequence s, @NotNull String chars) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(288);
        }
        if (chars == null) {
            StringUtil.$$$reportNull$$$0(289);
        }
        return Strings.indexOfAny(s, chars);
    }

    @Contract(pure=true)
    public static int indexOfAny(@NotNull String s, @NotNull String chars, int start, int end) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(290);
        }
        if (chars == null) {
            StringUtil.$$$reportNull$$$0(291);
        }
        return Strings.indexOfAny(s, chars, start, end);
    }

    @Contract(pure=true)
    public static int indexOfAny(@NotNull CharSequence s, @NotNull String chars, int start, int end) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(292);
        }
        if (chars == null) {
            StringUtil.$$$reportNull$$$0(293);
        }
        return Strings.indexOfAny(s, chars, start, end);
    }

    @Contract(pure=true)
    public static int lastIndexOfAny(@NotNull CharSequence s, @NotNull String chars) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(294);
        }
        if (chars == null) {
            StringUtil.$$$reportNull$$$0(295);
        }
        for (int i = s.length() - 1; i >= 0; --i) {
            if (!StringUtil.containsChar(chars, s.charAt(i))) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    @Nullable
    public static String substringBefore(@NotNull String text, @NotNull String subString) {
        int i;
        if (text == null) {
            StringUtil.$$$reportNull$$$0(296);
        }
        if (subString == null) {
            StringUtil.$$$reportNull$$$0(297);
        }
        if ((i = text.indexOf(subString)) == -1) {
            return null;
        }
        return text.substring(0, i);
    }

    @Contract(pure=true)
    @NotNull
    public static String substringBeforeLast(@NotNull String text, @NotNull String subString) {
        int i;
        if (text == null) {
            StringUtil.$$$reportNull$$$0(298);
        }
        if (subString == null) {
            StringUtil.$$$reportNull$$$0(299);
        }
        if ((i = text.lastIndexOf(subString)) == -1) {
            String string = text;
            if (string == null) {
                StringUtil.$$$reportNull$$$0(300);
            }
            return string;
        }
        String string = text.substring(0, i);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(301);
        }
        return string;
    }

    @Contract(pure=true)
    @Nullable
    public static String substringAfter(@NotNull String text, @NotNull String subString) {
        int i;
        if (text == null) {
            StringUtil.$$$reportNull$$$0(302);
        }
        if (subString == null) {
            StringUtil.$$$reportNull$$$0(303);
        }
        if ((i = text.indexOf(subString)) == -1) {
            return null;
        }
        return text.substring(i + subString.length());
    }

    @Contract(pure=true)
    @Nullable
    public static String substringAfterLast(@NotNull String text, @NotNull String subString) {
        int i;
        if (text == null) {
            StringUtil.$$$reportNull$$$0(304);
        }
        if (subString == null) {
            StringUtil.$$$reportNull$$$0(305);
        }
        if ((i = text.lastIndexOf(subString)) == -1) {
            return null;
        }
        return text.substring(i + subString.length());
    }

    @Contract(pure=true)
    public static int lastIndexOf(@NotNull CharSequence s, char c, int start, int end) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(306);
        }
        return StringUtilRt.lastIndexOf(s, c, start, end);
    }

    @Contract(pure=true)
    @NotNull
    public static String first(@NotNull String text, int maxLength, boolean appendEllipsis) {
        if (text == null) {
            StringUtil.$$$reportNull$$$0(307);
        }
        String string = text.length() > maxLength ? text.substring(0, maxLength) + (appendEllipsis ? THREE_DOTS : "") : text;
        if (string == null) {
            StringUtil.$$$reportNull$$$0(308);
        }
        return string;
    }

    @Contract(pure=true)
    @NotNull
    public static CharSequence first(@NotNull CharSequence text, int length, boolean appendEllipsis) {
        if (text == null) {
            StringUtil.$$$reportNull$$$0(309);
        }
        if (text.length() <= length) {
            CharSequence charSequence = text;
            if (charSequence == null) {
                StringUtil.$$$reportNull$$$0(310);
            }
            return charSequence;
        }
        if (appendEllipsis) {
            String string = text.subSequence(0, length) + THREE_DOTS;
            if (string == null) {
                StringUtil.$$$reportNull$$$0(311);
            }
            return string;
        }
        CharSequence charSequence = text.subSequence(0, length);
        if (charSequence == null) {
            StringUtil.$$$reportNull$$$0(312);
        }
        return charSequence;
    }

    @Contract(pure=true)
    @NotNull
    public static CharSequence last(@NotNull CharSequence text, int length, boolean prependEllipsis) {
        if (text == null) {
            StringUtil.$$$reportNull$$$0(313);
        }
        if (text.length() <= length) {
            CharSequence charSequence = text;
            if (charSequence == null) {
                StringUtil.$$$reportNull$$$0(314);
            }
            return charSequence;
        }
        if (prependEllipsis) {
            String string = THREE_DOTS + text.subSequence(text.length() - length, text.length());
            if (string == null) {
                StringUtil.$$$reportNull$$$0(315);
            }
            return string;
        }
        CharSequence charSequence = text.subSequence(text.length() - length, text.length());
        if (charSequence == null) {
            StringUtil.$$$reportNull$$$0(316);
        }
        return charSequence;
    }

    @Contract(pure=true)
    @NotNull
    public static String firstLast(@NotNull String text, int length) {
        if (text == null) {
            StringUtil.$$$reportNull$$$0(317);
        }
        String string = text.length() > length ? text.subSequence(0, length / 2) + ELLIPSIS + text.subSequence(text.length() - length / 2 - 1, text.length()) : text;
        if (string == null) {
            StringUtil.$$$reportNull$$$0(318);
        }
        return string;
    }

    @Contract(pure=true)
    @NotNull
    public static String escapeChar(@NotNull String str, char character) {
        if (str == null) {
            StringUtil.$$$reportNull$$$0(319);
        }
        return StringUtil.escapeChars(str, character);
    }

    @Contract(pure=true)
    @NotNull
    public static String escapeChars(@NotNull String str, char ... character) {
        if (str == null) {
            StringUtil.$$$reportNull$$$0(320);
        }
        if (character == null) {
            StringUtil.$$$reportNull$$$0(321);
        }
        StringBuilder buf = new StringBuilder(str);
        for (char c : character) {
            StringUtil.escapeChar(buf, c);
        }
        String string = buf.toString();
        if (string == null) {
            StringUtil.$$$reportNull$$$0(322);
        }
        return string;
    }

    public static void escapeChar(@NotNull StringBuilder buf, char character) {
        if (buf == null) {
            StringUtil.$$$reportNull$$$0(323);
        }
        int idx = 0;
        while ((idx = StringUtil.indexOf((CharSequence)buf, character, idx)) >= 0) {
            buf.insert(idx, "\\");
            idx += 2;
        }
    }

    @Contract(pure=true)
    @NotNull
    public static String escapeQuotes(@NotNull String str) {
        if (str == null) {
            StringUtil.$$$reportNull$$$0(324);
        }
        return StringUtil.escapeChar(str, '\"');
    }

    public static void escapeQuotes(@NotNull StringBuilder buf) {
        if (buf == null) {
            StringUtil.$$$reportNull$$$0(325);
        }
        StringUtil.escapeChar(buf, '\"');
    }

    @Contract(pure=true)
    @NotNull
    public static String escapeSlashes(@NotNull String str) {
        if (str == null) {
            StringUtil.$$$reportNull$$$0(326);
        }
        return StringUtil.escapeChar(str, '/');
    }

    @Contract(pure=true)
    @NotNull
    public static String escapeBackSlashes(@NotNull String str) {
        if (str == null) {
            StringUtil.$$$reportNull$$$0(327);
        }
        return StringUtil.escapeChar(str, '\\');
    }

    @Contract(pure=true)
    @NotNull
    public static String unescapeBackSlashes(@NotNull String str) {
        if (str == null) {
            StringUtil.$$$reportNull$$$0(328);
        }
        StringBuilder buf = new StringBuilder(str.length());
        StringUtil.unescapeChar(buf, str, '\\');
        String string = buf.toString();
        if (string == null) {
            StringUtil.$$$reportNull$$$0(329);
        }
        return string;
    }

    @Contract(pure=true)
    @NotNull
    public static String unescapeChar(@NotNull String str, char unescapeChar) {
        if (str == null) {
            StringUtil.$$$reportNull$$$0(330);
        }
        StringBuilder buf = new StringBuilder(str.length());
        StringUtil.unescapeChar(buf, str, unescapeChar);
        String string = buf.toString();
        if (string == null) {
            StringUtil.$$$reportNull$$$0(331);
        }
        return string;
    }

    private static void unescapeChar(@NotNull StringBuilder buf, @NotNull String str, char unescapeChar) {
        if (buf == null) {
            StringUtil.$$$reportNull$$$0(332);
        }
        if (str == null) {
            StringUtil.$$$reportNull$$$0(333);
        }
        int length = str.length();
        int last = length - 1;
        for (int i = 0; i < length; ++i) {
            char ch = str.charAt(i);
            if (ch == '\\' && i != last && (ch = str.charAt(++i)) != unescapeChar) {
                buf.append('\\');
            }
            buf.append(ch);
        }
    }

    public static void quote(@NotNull StringBuilder builder) {
        if (builder == null) {
            StringUtil.$$$reportNull$$$0(334);
        }
        StringUtil.quote(builder, '\"');
    }

    public static void quote(@NotNull StringBuilder builder, char quotingChar) {
        if (builder == null) {
            StringUtil.$$$reportNull$$$0(335);
        }
        builder.insert(0, quotingChar);
        builder.append(quotingChar);
    }

    @Contract(pure=true)
    @NotNull
    public static String wrapWithDoubleQuote(@NotNull String str) {
        if (str == null) {
            StringUtil.$$$reportNull$$$0(336);
        }
        String string = '\"' + str + "\"";
        if (string == null) {
            StringUtil.$$$reportNull$$$0(337);
        }
        return string;
    }

    @Deprecated
    @Contract(value="null -> null; !null -> !null", pure=true)
    public static String unescapeXml(@Nullable String text) {
        return text == null ? null : StringUtil.unescapeXmlEntities(text);
    }

    @Deprecated
    @Contract(value="null -> null; !null -> !null", pure=true)
    public static String escapeXml(@Nullable String text) {
        return text == null ? null : StringUtil.escapeXmlEntities(text);
    }

    @Contract(pure=true)
    @NotNull
    public static String unescapeXmlEntities(@NotNull String text) {
        if (text == null) {
            StringUtil.$$$reportNull$$$0(338);
        }
        String string = Strings.unescapeXmlEntities(text);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(339);
        }
        return string;
    }

    @Contract(pure=true)
    @NotNull
    public static String escapeXmlEntities(@NotNull String text) {
        if (text == null) {
            StringUtil.$$$reportNull$$$0(340);
        }
        String string = Strings.escapeXmlEntities(text);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(341);
        }
        return string;
    }

    @Contract(pure=true)
    @NotNull
    public static String removeHtmlTags(@NotNull String htmlString) {
        if (htmlString == null) {
            StringUtil.$$$reportNull$$$0(342);
        }
        return StringUtil.removeHtmlTags(htmlString, false);
    }

    @Contract(pure=true)
    @NotNull
    public static String removeHtmlTags(@NotNull String htmlString, boolean isRemoveStyleTag) {
        if (htmlString == null) {
            StringUtil.$$$reportNull$$$0(343);
        }
        if (StringUtil.isEmpty(htmlString)) {
            return "";
        }
        MyHtml2Text parser = isRemoveStyleTag ? new MyHtml2Text(true, null) : new MyHtml2Text(false, null);
        try {
            parser.parse((Reader)new StringReader(htmlString));
        }
        catch (IOException e) {
            Logger.getInstance(StringUtil.class).error(e);
        }
        String string = parser.getText();
        if (string == null) {
            StringUtil.$$$reportNull$$$0(344);
        }
        return string;
    }

    @Contract(pure=true)
    @NotNull
    @Nls
    public static String removeEllipsisSuffix(@NotNull @Nls String s) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(345);
        }
        if (s.endsWith(THREE_DOTS)) {
            String string = s.substring(0, s.length() - THREE_DOTS.length());
            if (string == null) {
                StringUtil.$$$reportNull$$$0(346);
            }
            return string;
        }
        if (s.endsWith(ELLIPSIS)) {
            String string = s.substring(0, s.length() - ELLIPSIS.length());
            if (string == null) {
                StringUtil.$$$reportNull$$$0(347);
            }
            return string;
        }
        String string = s;
        if (string == null) {
            StringUtil.$$$reportNull$$$0(348);
        }
        return string;
    }

    @Contract(pure=true)
    @NotNull
    public static String escapeMnemonics(@NotNull String text) {
        if (text == null) {
            StringUtil.$$$reportNull$$$0(349);
        }
        return StringUtil.replace(text, MN_CHARS, MN_QUOTED);
    }

    @Contract(pure=true)
    @NlsSafe
    @NotNull
    public static String htmlEmphasize(@NotNull @Nls String text) {
        if (text == null) {
            StringUtil.$$$reportNull$$$0(350);
        }
        String string = HtmlChunk.tag((String)"code").addText(text).wrapWith("b").toString();
        if (string == null) {
            StringUtil.$$$reportNull$$$0(351);
        }
        return string;
    }

    @Contract(pure=true)
    @NotNull
    public static String escapeToRegexp(@NotNull String text) {
        if (text == null) {
            StringUtil.$$$reportNull$$$0(352);
        }
        StringBuilder result = new StringBuilder(text.length());
        String string = StringUtil.escapeToRegexp(text, result).toString();
        if (string == null) {
            StringUtil.$$$reportNull$$$0(353);
        }
        return string;
    }

    @NotNull
    public static StringBuilder escapeToRegexp(@NotNull CharSequence text, @NotNull StringBuilder builder) {
        if (text == null) {
            StringUtil.$$$reportNull$$$0(354);
        }
        if (builder == null) {
            StringUtil.$$$reportNull$$$0(355);
        }
        StringBuilder stringBuilder = Strings.escapeToRegexp(text, builder);
        if (stringBuilder == null) {
            StringUtil.$$$reportNull$$$0(356);
        }
        return stringBuilder;
    }

    @Contract(pure=true)
    public static boolean isEscapedBackslash(@NotNull CharSequence text, int startOffset, int backslashOffset) {
        if (text == null) {
            StringUtil.$$$reportNull$$$0(357);
        }
        if (text.charAt(backslashOffset) != '\\') {
            return true;
        }
        boolean escaped = false;
        for (int i = startOffset; i < backslashOffset; ++i) {
            escaped = text.charAt(i) == '\\' ? !escaped : false;
        }
        return escaped;
    }

    @Contract(pure=true)
    @NotNull
    public static String replace(@NotNull String text, @NotNull List<String> from, @NotNull List<String> to) {
        if (text == null) {
            StringUtil.$$$reportNull$$$0(358);
        }
        if (from == null) {
            StringUtil.$$$reportNull$$$0(359);
        }
        if (to == null) {
            StringUtil.$$$reportNull$$$0(360);
        }
        String string = Strings.replace(text, from, to);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(361);
        }
        return string;
    }

    @Contract(pure=true)
    public static String @NotNull [] filterEmptyStrings(String @NotNull [] strings) {
        if (strings == null) {
            StringUtil.$$$reportNull$$$0(362);
        }
        int emptyCount = 0;
        for (String string : strings) {
            if (string != null && !string.isEmpty()) continue;
            ++emptyCount;
        }
        if (emptyCount == 0) {
            if (strings == null) {
                StringUtil.$$$reportNull$$$0(363);
            }
            return strings;
        }
        String[] result = ArrayUtil.newStringArray(strings.length - emptyCount);
        int count = 0;
        for (String string : strings) {
            if (string == null || string.isEmpty()) continue;
            result[count++] = string;
        }
        if (result == null) {
            StringUtil.$$$reportNull$$$0(364);
        }
        return result;
    }

    @Contract(pure=true)
    public static int countNewLines(@NotNull CharSequence text) {
        if (text == null) {
            StringUtil.$$$reportNull$$$0(365);
        }
        return StringUtil.countChars(text, '\n');
    }

    @Contract(pure=true)
    public static int countChars(@NotNull CharSequence text, char c) {
        if (text == null) {
            StringUtil.$$$reportNull$$$0(366);
        }
        return Strings.countChars(text, c);
    }

    @Contract(pure=true)
    public static int countChars(@NotNull CharSequence text, char c, int offset, boolean stopAtOtherChar) {
        if (text == null) {
            StringUtil.$$$reportNull$$$0(367);
        }
        return Strings.countChars(text, c, offset, stopAtOtherChar);
    }

    @Contract(pure=true)
    public static int countChars(@NotNull CharSequence text, char c, int start, int end, boolean stopAtOtherChar) {
        if (text == null) {
            StringUtil.$$$reportNull$$$0(368);
        }
        return Strings.countChars(text, c, start, end, stopAtOtherChar);
    }

    @Contract(pure=true)
    @Nullable
    public static String joinOrNull(String ... args) {
        if (args == null) {
            StringUtil.$$$reportNull$$$0(369);
        }
        StringBuilder r = new StringBuilder();
        for (String arg : args) {
            if (arg == null) {
                return null;
            }
            r.append(arg);
        }
        return r.toString();
    }

    @Contract(pure=true)
    @Nullable
    public static String getPropertyName(@NotNull String methodName) {
        if (methodName == null) {
            StringUtil.$$$reportNull$$$0(370);
        }
        if (methodName.startsWith("get")) {
            return Introspector.decapitalize(methodName.substring(3));
        }
        if (methodName.startsWith("is")) {
            return Introspector.decapitalize(methodName.substring(2));
        }
        if (methodName.startsWith("set")) {
            return Introspector.decapitalize(methodName.substring(3));
        }
        return null;
    }

    @Contract(pure=true)
    public static boolean isJavaIdentifierStart(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || Character.isJavaIdentifierStart(c);
    }

    @Contract(pure=true)
    public static boolean isJavaIdentifierPart(char c) {
        return c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || Character.isJavaIdentifierPart(c);
    }

    @Contract(pure=true)
    private static boolean isJavaIdentifierStart(int cp) {
        return cp >= 97 && cp <= 122 || cp >= 65 && cp <= 90 || Character.isJavaIdentifierStart(cp);
    }

    @Contract(pure=true)
    private static boolean isJavaIdentifierPart(int cp) {
        return cp >= 48 && cp <= 57 || cp >= 97 && cp <= 122 || cp >= 65 && cp <= 90 || Character.isJavaIdentifierPart(cp);
    }

    @Contract(pure=true)
    public static boolean isJavaIdentifier(@NotNull String text) {
        int len;
        if (text == null) {
            StringUtil.$$$reportNull$$$0(371);
        }
        if ((len = text.length()) == 0) {
            return false;
        }
        int point = text.codePointAt(0);
        if (!StringUtil.isJavaIdentifierStart(point)) {
            return false;
        }
        for (int i = Character.charCount(point); i < len; i += Character.charCount(point)) {
            point = text.codePointAt(i);
            if (StringUtil.isJavaIdentifierPart(point)) continue;
            return false;
        }
        return true;
    }

    @Contract(pure=true)
    @NotNull
    public static String escapeProperty(@NotNull String input, boolean isKey) {
        if (input == null) {
            StringUtil.$$$reportNull$$$0(372);
        }
        StringBuilder escaped = new StringBuilder(input.length());
        block8: for (int i = 0; i < input.length(); ++i) {
            char ch = input.charAt(i);
            switch (ch) {
                case ' ': {
                    if (isKey && i == 0) {
                        escaped.append('\\');
                    }
                    escaped.append(' ');
                    continue block8;
                }
                case '\t': {
                    escaped.append("\\t");
                    continue block8;
                }
                case '\r': {
                    escaped.append("\\r");
                    continue block8;
                }
                case '\n': {
                    escaped.append("\\n");
                    continue block8;
                }
                case '\f': {
                    escaped.append("\\f");
                    continue block8;
                }
                case '!': 
                case '#': 
                case ':': 
                case '=': 
                case '\\': {
                    escaped.append('\\');
                    escaped.append(ch);
                    continue block8;
                }
                default: {
                    if ('\u0014' < ch && ch < '\u007f') {
                        escaped.append(ch);
                        continue block8;
                    }
                    escaped.append("\\u");
                    escaped.append(Character.forDigit(ch >> 12 & 0xF, 16));
                    escaped.append(Character.forDigit(ch >> 8 & 0xF, 16));
                    escaped.append(Character.forDigit(ch >> 4 & 0xF, 16));
                    escaped.append(Character.forDigit(ch & 0xF, 16));
                }
            }
        }
        String string = escaped.toString();
        if (string == null) {
            StringUtil.$$$reportNull$$$0(373);
        }
        return string;
    }

    @Contract(pure=true)
    @NotNull
    @NlsSafe
    public static String getQualifiedName(@Nullable @NonNls String packageName, @NotNull @NonNls String className) {
        if (className == null) {
            StringUtil.$$$reportNull$$$0(374);
        }
        if (packageName == null || packageName.isEmpty()) {
            String string = className;
            if (string == null) {
                StringUtil.$$$reportNull$$$0(375);
            }
            return string;
        }
        String string = packageName + '.' + className;
        if (string == null) {
            StringUtil.$$$reportNull$$$0(376);
        }
        return string;
    }

    @Contract(pure=true)
    public static int compareVersionNumbers(@Nullable String v1, @Nullable String v2) {
        int idx;
        if (v1 == null && v2 == null) {
            return 0;
        }
        if (v1 == null) {
            return -1;
        }
        if (v2 == null) {
            return 1;
        }
        String[] part1 = v1.split("[._\\-]");
        String[] part2 = v2.split("[._\\-]");
        for (idx = 0; idx < part1.length && idx < part2.length; ++idx) {
            String p1 = part1[idx];
            String p2 = part2[idx];
            int cmp = p1.matches("\\d+") && p2.matches("\\d+") ? Integer.valueOf(p1).compareTo(Integer.valueOf(p2)) : part1[idx].compareTo(part2[idx]);
            if (cmp == 0) continue;
            return cmp;
        }
        if (part1.length != part2.length) {
            String[] parts;
            boolean left = part1.length > idx;
            String[] stringArray = parts = left ? part1 : part2;
            while (idx < parts.length) {
                String p = parts[idx];
                int cmp = p.matches("\\d+") ? Integer.valueOf(p).compareTo(0) : 1;
                if (cmp != 0) {
                    return left ? cmp : -cmp;
                }
                ++idx;
            }
        }
        return 0;
    }

    @Contract(pure=true)
    public static int getOccurrenceCount(@NotNull String text, char c) {
        if (text == null) {
            StringUtil.$$$reportNull$$$0(377);
        }
        int res = 0;
        for (int i = 0; i < text.length() && (i = text.indexOf(c, i)) >= 0; ++i) {
            ++res;
        }
        return res;
    }

    @Contract(pure=true)
    public static int getOccurrenceCount(@NotNull String text, @NotNull String s) {
        if (text == null) {
            StringUtil.$$$reportNull$$$0(378);
        }
        if (s == null) {
            StringUtil.$$$reportNull$$$0(379);
        }
        int res = 0;
        for (int i = 0; i < text.length() && (i = text.indexOf(s, i)) >= 0; ++i) {
            ++res;
        }
        return res;
    }

    @Contract(pure=true)
    @NotNull
    public static String fixVariableNameDerivedFromPropertyName(@NotNull String name) {
        if (name == null) {
            StringUtil.$$$reportNull$$$0(380);
        }
        if (StringUtil.isEmptyOrSpaces(name)) {
            String string = name;
            if (string == null) {
                StringUtil.$$$reportNull$$$0(381);
            }
            return string;
        }
        char c = name.charAt(0);
        if (StringUtil.isVowel(c)) {
            String string = "an" + Character.toUpperCase(c) + name.substring(1);
            if (string == null) {
                StringUtil.$$$reportNull$$$0(382);
            }
            return string;
        }
        String string = "a" + Character.toUpperCase(c) + name.substring(1);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(383);
        }
        return string;
    }

    @Contract(pure=true)
    @NotNull
    public static String sanitizeJavaIdentifier(@NotNull String name) {
        if (name == null) {
            StringUtil.$$$reportNull$$$0(384);
        }
        StringBuilder result = new StringBuilder(name.length());
        for (int i = 0; i < name.length(); ++i) {
            char ch = name.charAt(i);
            if (!Character.isJavaIdentifierPart(ch)) continue;
            if (result.length() == 0 && !Character.isJavaIdentifierStart(ch)) {
                result.append("_");
            }
            result.append(ch);
        }
        String string = result.toString();
        if (string == null) {
            StringUtil.$$$reportNull$$$0(385);
        }
        return string;
    }

    public static void assertValidSeparators(@NotNull CharSequence s) {
        int i;
        if (s == null) {
            StringUtil.$$$reportNull$$$0(386);
        }
        char[] chars = CharArrayUtil.fromSequenceWithoutCopying(s);
        int slashRIndex = -1;
        if (chars != null) {
            int len = s.length();
            for (i = 0; i < len; ++i) {
                if (chars[i] != '\r') continue;
                slashRIndex = i;
                break;
            }
        } else {
            int len = s.length();
            for (i = 0; i < len; ++i) {
                if (s.charAt(i) != '\r') continue;
                slashRIndex = i;
                break;
            }
        }
        if (slashRIndex != -1) {
            String context = String.valueOf(StringUtil.last(s.subSequence(0, slashRIndex), 10, true)) + StringUtil.first(s.subSequence(slashRIndex, s.length()), 10, true);
            context = StringUtil.escapeStringCharacters(context);
            throw new AssertionError((Object)("Wrong line separators: '" + context + "' at offset " + slashRIndex));
        }
    }

    @Contract(pure=true)
    @NotNull
    public static String tail(@NotNull String s, int idx) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(387);
        }
        String string = idx >= s.length() ? "" : s.substring(idx);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(388);
        }
        return string;
    }

    @Contract(pure=true)
    public static String @NotNull [] splitByLines(@NotNull String string) {
        if (string == null) {
            StringUtil.$$$reportNull$$$0(389);
        }
        return StringUtil.splitByLines(string, true);
    }

    @Contract(pure=true)
    public static String @NotNull [] splitByLines(@NotNull String string, boolean excludeEmptyStrings) {
        if (string == null) {
            StringUtil.$$$reportNull$$$0(390);
        }
        String[] stringArray = (excludeEmptyStrings ? Splitters.EOL_SPLIT_PATTERN : Splitters.EOL_SPLIT_PATTERN_WITH_EMPTY).split(string);
        if (stringArray == null) {
            StringUtil.$$$reportNull$$$0(391);
        }
        return stringArray;
    }

    @Contract(pure=true)
    public static String @NotNull [] splitByLinesDontTrim(@NotNull String string) {
        if (string == null) {
            StringUtil.$$$reportNull$$$0(392);
        }
        String[] stringArray = Splitters.EOL_SPLIT_DONT_TRIM_PATTERN.split(string);
        if (stringArray == null) {
            StringUtil.$$$reportNull$$$0(393);
        }
        return stringArray;
    }

    @Contract(pure=true)
    public static String @NotNull [] splitByLinesKeepSeparators(@NotNull String string) {
        if (string == null) {
            StringUtil.$$$reportNull$$$0(394);
        }
        String[] stringArray = Splitters.EOL_SPLIT_KEEP_SEPARATORS.split(string);
        if (stringArray == null) {
            StringUtil.$$$reportNull$$$0(395);
        }
        return stringArray;
    }

    @Contract(pure=true)
    @NotNull
    public static List<Pair<String, Integer>> getWordsWithOffset(@NotNull String s) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(396);
        }
        ArrayList<Pair<String, Integer>> res = new ArrayList<Pair<String, Integer>>();
        s = s + " ";
        StringBuilder name = new StringBuilder();
        int startInd = -1;
        for (int i = 0; i < s.length(); ++i) {
            if (Character.isWhitespace(s.charAt(i))) {
                if (name.length() <= 0) continue;
                res.add(Pair.create(name.toString(), startInd));
                name.setLength(0);
                startInd = -1;
                continue;
            }
            if (startInd == -1) {
                startInd = i;
            }
            name.append(s.charAt(i));
        }
        ArrayList<Pair<String, Integer>> arrayList = res;
        if (arrayList == null) {
            StringUtil.$$$reportNull$$$0(397);
        }
        return arrayList;
    }

    @Contract(pure=true)
    public static int naturalCompare(@Nullable String string1, @Nullable String string2) {
        return NaturalComparator.INSTANCE.compare(string1, string2);
    }

    @Contract(pure=true)
    public static boolean isDecimalDigit(char c) {
        return Strings.isDecimalDigit(c);
    }

    @Contract(value="null -> false")
    public static boolean isNotNegativeNumber(@Nullable CharSequence s) {
        if (s == null) {
            return false;
        }
        for (int i = 0; i < s.length(); ++i) {
            if (StringUtil.isDecimalDigit(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    @Contract(pure=true)
    public static int compare(@Nullable String s1, @Nullable String s2, boolean ignoreCase) {
        if (s1 == s2) {
            return 0;
        }
        if (s1 == null) {
            return -1;
        }
        if (s2 == null) {
            return 1;
        }
        return ignoreCase ? s1.compareToIgnoreCase(s2) : s1.compareTo(s2);
    }

    @Contract(pure=true)
    public static int compare(@Nullable CharSequence s1, @Nullable CharSequence s2, boolean ignoreCase) {
        if (s1 == s2) {
            return 0;
        }
        if (s1 == null) {
            return -1;
        }
        if (s2 == null) {
            return 1;
        }
        int length1 = s1.length();
        int length2 = s2.length();
        for (int i = 0; i < length1 && i < length2; ++i) {
            int diff = Strings.compare(s1.charAt(i), s2.charAt(i), ignoreCase);
            if (diff == 0) continue;
            return diff;
        }
        return length1 - length2;
    }

    @Contract(pure=true)
    public static int comparePairs(@Nullable String s1, @Nullable String t1, @Nullable String s2, @Nullable String t2, boolean ignoreCase) {
        int compare = StringUtil.compare(s1, s2, ignoreCase);
        return compare != 0 ? compare : StringUtil.compare(t1, t2, ignoreCase);
    }

    @Contract(pure=true)
    public static boolean equals(@Nullable CharSequence s1, @Nullable CharSequence s2) {
        return StringUtilRt.equal(s1, s2, true);
    }

    @Contract(pure=true)
    public static boolean equalsIgnoreCase(@Nullable CharSequence s1, @Nullable CharSequence s2) {
        return StringUtilRt.equal(s1, s2, false);
    }

    @Contract(pure=true)
    public static boolean equalsIgnoreWhitespaces(@Nullable CharSequence s1, @Nullable CharSequence s2) {
        return Strings.equalsIgnoreWhitespaces(s1, s2);
    }

    @Contract(pure=true)
    public static boolean equalsTrimWhitespaces(@NotNull CharSequence s1, @NotNull CharSequence s2) {
        if (s1 == null) {
            StringUtil.$$$reportNull$$$0(398);
        }
        if (s2 == null) {
            StringUtil.$$$reportNull$$$0(399);
        }
        return Strings.equalsTrimWhitespaces(s1, s2);
    }

    @NotNull
    public static String collapseWhiteSpace(@NotNull CharSequence s) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(400);
        }
        StringBuilder result = new StringBuilder();
        boolean space = false;
        int length = s.length();
        for (int i = 0; i < length; ++i) {
            char ch = s.charAt(i);
            if (StringUtil.isWhiteSpace(ch)) {
                if (space) continue;
                space = true;
                continue;
            }
            if (space && result.length() > 0) {
                result.append(' ');
            }
            result.append(ch);
            space = false;
        }
        String string = result.toString();
        if (string == null) {
            StringUtil.$$$reportNull$$$0(401);
        }
        return string;
    }

    @Contract(pure=true)
    public static boolean findIgnoreCase(@Nullable String toFind, String ... where) {
        if (where == null) {
            StringUtil.$$$reportNull$$$0(402);
        }
        for (String string : where) {
            if (!StringUtil.equalsIgnoreCase(toFind, string)) continue;
            return true;
        }
        return false;
    }

    @Contract(pure=true)
    public static int compare(char c1, char c2, boolean ignoreCase) {
        return Strings.compare(c1, c2, ignoreCase);
    }

    @Contract(pure=true)
    @NotNull
    public static String formatLinks(@NotNull String message) {
        if (message == null) {
            StringUtil.$$$reportNull$$$0(403);
        }
        Pattern linkPattern = Pattern.compile("http://[a-zA-Z\\d./\\-+]+");
        StringBuffer result = new StringBuffer();
        Matcher m = linkPattern.matcher(message);
        while (m.find()) {
            m.appendReplacement(result, "<a href=\"" + m.group() + "\">" + m.group() + "</a>");
        }
        m.appendTail(result);
        String string = result.toString();
        if (string == null) {
            StringUtil.$$$reportNull$$$0(404);
        }
        return string;
    }

    @Contract(pure=true)
    public static boolean isHexDigit(char c) {
        return '0' <= c && c <= '9' || 'a' <= c && c <= 'f' || 'A' <= c && c <= 'F';
    }

    @Contract(pure=true)
    public static boolean isOctalDigit(char c) {
        return '0' <= c && c <= '7';
    }

    @Contract(pure=true)
    @NotNull
    public static String shortenTextWithEllipsis(@NotNull String text, int maxLength, int suffixLength) {
        if (text == null) {
            StringUtil.$$$reportNull$$$0(405);
        }
        return StringUtil.shortenTextWithEllipsis(text, maxLength, suffixLength, false);
    }

    @Contract(pure=true)
    @NotNull
    public static String trimMiddle(@NotNull String text, int maxLength) {
        if (text == null) {
            StringUtil.$$$reportNull$$$0(406);
        }
        return StringUtil.shortenTextWithEllipsis(text, maxLength, maxLength >> 1, true);
    }

    @Contract(pure=true)
    @NotNull
    public static String shortenTextWithEllipsis(@NotNull String text, int maxLength, int suffixLength, @NotNull String symbol) {
        int textLength;
        if (text == null) {
            StringUtil.$$$reportNull$$$0(407);
        }
        if (symbol == null) {
            StringUtil.$$$reportNull$$$0(408);
        }
        if ((textLength = text.length()) > maxLength) {
            int prefixLength = maxLength - suffixLength - symbol.length();
            assert (prefixLength >= 0);
            String string = text.substring(0, prefixLength) + symbol + text.substring(textLength - suffixLength);
            if (string == null) {
                StringUtil.$$$reportNull$$$0(409);
            }
            return string;
        }
        String string = text;
        if (string == null) {
            StringUtil.$$$reportNull$$$0(410);
        }
        return string;
    }

    @Contract(pure=true)
    @NotNull
    public static String shortenTextWithEllipsis(@NotNull String text, int maxLength, int suffixLength, boolean useEllipsisSymbol) {
        if (text == null) {
            StringUtil.$$$reportNull$$$0(411);
        }
        String symbol = useEllipsisSymbol ? ELLIPSIS : THREE_DOTS;
        return StringUtil.shortenTextWithEllipsis(text, maxLength, suffixLength, symbol);
    }

    @Contract(pure=true)
    @NotNull
    public static String shortenPathWithEllipsis(@NotNull String path, int maxLength, boolean useEllipsisSymbol) {
        if (path == null) {
            StringUtil.$$$reportNull$$$0(412);
        }
        return StringUtil.shortenTextWithEllipsis(path, maxLength, (int)((double)maxLength * 0.7), useEllipsisSymbol);
    }

    @Contract(pure=true)
    @NotNull
    public static String shortenPathWithEllipsis(@NotNull String path, int maxLength) {
        if (path == null) {
            StringUtil.$$$reportNull$$$0(413);
        }
        return StringUtil.shortenPathWithEllipsis(path, maxLength, false);
    }

    @Contract(pure=true)
    public static boolean charsEqualIgnoreCase(char a, char b) {
        return Strings.charsEqualIgnoreCase(a, b);
    }

    @Contract(pure=true)
    public static char toUpperCase(char a) {
        return Strings.toUpperCase(a);
    }

    @Contract(value="null -> null; !null -> !null", pure=true)
    public static String toUpperCase(String s) {
        return Strings.toUpperCase(s);
    }

    @Contract(pure=true)
    public static char toLowerCase(char a) {
        return Strings.toLowerCase(a);
    }

    @Contract(pure=true)
    public static boolean isUpperCase(@NotNull CharSequence sequence) {
        if (sequence == null) {
            StringUtil.$$$reportNull$$$0(414);
        }
        for (int i = 0; i < sequence.length(); ++i) {
            if (Character.isUpperCase(sequence.charAt(i))) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public static LineSeparator detectSeparators(@NotNull CharSequence text) {
        int index;
        if (text == null) {
            StringUtil.$$$reportNull$$$0(415);
        }
        if ((index = StringUtil.indexOfAny(text, "\n\r")) == -1) {
            return null;
        }
        LineSeparator lineSeparator = StringUtil.getLineSeparatorAt(text, index);
        if (lineSeparator == null) {
            throw new AssertionError();
        }
        return lineSeparator;
    }

    @Nullable
    public static LineSeparator getLineSeparatorAt(@NotNull CharSequence text, int index) {
        if (text == null) {
            StringUtil.$$$reportNull$$$0(416);
        }
        if (index < 0 || index >= text.length()) {
            return null;
        }
        char ch = text.charAt(index);
        if (ch == '\r') {
            return index + 1 < text.length() && text.charAt(index + 1) == '\n' ? LineSeparator.CRLF : LineSeparator.CR;
        }
        return ch == '\n' ? LineSeparator.LF : null;
    }

    @Contract(pure=true)
    @NotNull
    public static String convertLineSeparators(@NotNull String text) {
        if (text == null) {
            StringUtil.$$$reportNull$$$0(417);
        }
        String string = Strings.convertLineSeparators(text);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(418);
        }
        return string;
    }

    @Contract(pure=true)
    @NotNull
    public static String convertLineSeparators(@NotNull String text, @NotNull String newSeparator) {
        if (text == null) {
            StringUtil.$$$reportNull$$$0(419);
        }
        if (newSeparator == null) {
            StringUtil.$$$reportNull$$$0(420);
        }
        String string = StringUtilRt.convertLineSeparators(text, newSeparator);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(421);
        }
        return string;
    }

    @Contract(pure=true)
    public static int parseInt(@Nullable String string, int defaultValue) {
        return StringUtilRt.parseInt(string, defaultValue);
    }

    @Contract(pure=true)
    public static long parseLong(@Nullable String string, long defaultValue) {
        return StringUtilRt.parseLong(string, defaultValue);
    }

    @Contract(pure=true)
    public static double parseDouble(@Nullable String string, double defaultValue) {
        return StringUtilRt.parseDouble(string, defaultValue);
    }

    @Contract(pure=true)
    public static <E extends Enum<E>> E parseEnum(@NotNull String string, E defaultValue, @NotNull Class<E> clazz) {
        if (string == null) {
            StringUtil.$$$reportNull$$$0(422);
        }
        if (clazz == null) {
            StringUtil.$$$reportNull$$$0(423);
        }
        return StringUtilRt.parseEnum(string, defaultValue, clazz);
    }

    @Contract(pure=true)
    @NotNull
    @NlsSafe
    public static String getShortName(@NotNull Class<?> aClass) {
        if (aClass == null) {
            StringUtil.$$$reportNull$$$0(424);
        }
        String string = StringUtilRt.getShortName(aClass);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(425);
        }
        return string;
    }

    @Contract(pure=true)
    @NotNull
    @NlsSafe
    public static String getShortName(@NotNull @NonNls String fqName) {
        if (fqName == null) {
            StringUtil.$$$reportNull$$$0(426);
        }
        String string = StringUtilRt.getShortName(fqName);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(427);
        }
        return string;
    }

    @Contract(pure=true)
    @NotNull
    @NlsSafe
    public static String getShortName(@NotNull @NonNls String fqName, char separator) {
        if (fqName == null) {
            StringUtil.$$$reportNull$$$0(428);
        }
        String string = StringUtilRt.getShortName(fqName, separator);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(429);
        }
        return string;
    }

    public static boolean isShortNameOf(@NotNull String fqName, @NotNull String shortName) {
        if (fqName == null) {
            StringUtil.$$$reportNull$$$0(430);
        }
        if (shortName == null) {
            StringUtil.$$$reportNull$$$0(431);
        }
        if (fqName.length() < shortName.length()) {
            return false;
        }
        if (fqName.length() == shortName.length()) {
            return fqName.equals(shortName);
        }
        int diff = fqName.length() - shortName.length();
        if (fqName.charAt(diff - 1) != '.') {
            return false;
        }
        return fqName.regionMatches(diff, shortName, 0, shortName.length());
    }

    @Contract(value="null->null;!null->!null")
    static String toShortString(@Nullable Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof CharSequence) {
            return o.toString();
        }
        String className = o.getClass().getName();
        String s = o.toString();
        if (!s.startsWith(className)) {
            return s;
        }
        return s.length() > className.length() && !Character.isLetter(s.charAt(className.length())) ? StringUtil.trimStart(s, className) : s;
    }

    @Contract(pure=true)
    @NotNull
    public static CharSequence newBombedCharSequence(@NotNull CharSequence sequence, long delay) {
        if (sequence == null) {
            StringUtil.$$$reportNull$$$0(432);
        }
        long myTime = System.currentTimeMillis() + delay;
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public static boolean trimEnd(@NotNull StringBuilder buffer, @NotNull CharSequence end) {
        if (buffer == null) {
            StringUtil.$$$reportNull$$$0(433);
        }
        if (end == null) {
            StringUtil.$$$reportNull$$$0(434);
        }
        if (StringUtil.endsWith(buffer, end)) {
            buffer.delete(buffer.length() - end.length(), buffer.length());
            return true;
        }
        return false;
    }

    @Contract(pure=true)
    public static boolean isBetween(@NotNull String string, @NotNull String smallPart, @NotNull String bigPart) {
        String s;
        if (string == null) {
            StringUtil.$$$reportNull$$$0(435);
        }
        if (smallPart == null) {
            StringUtil.$$$reportNull$$$0(436);
        }
        if (bigPart == null) {
            StringUtil.$$$reportNull$$$0(437);
        }
        return (s = StringUtil.toLowerCase(string)).startsWith(StringUtil.toLowerCase(smallPart)) && StringUtil.toLowerCase(bigPart).startsWith(s);
    }

    public static boolean hasUpperCaseChar(@NotNull String s) {
        char[] chars;
        if (s == null) {
            StringUtil.$$$reportNull$$$0(438);
        }
        for (char c : chars = s.toCharArray()) {
            if (!Character.isUpperCase(c)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasLowerCaseChar(@NotNull String s) {
        char[] chars;
        if (s == null) {
            StringUtil.$$$reportNull$$$0(439);
        }
        for (char c : chars = s.toCharArray()) {
            if (!Character.isLowerCase(c)) continue;
            return true;
        }
        return false;
    }

    public static String replaceUnicodeEscapeSequences(String text) {
        if (text == null) {
            return null;
        }
        Matcher matcher = UNICODE_CHAR.matcher(text);
        if (!matcher.find()) {
            return text;
        }
        matcher.reset();
        int lastEnd = 0;
        StringBuilder sb = new StringBuilder(text.length());
        while (matcher.find()) {
            sb.append(text, lastEnd, matcher.start());
            char c = (char)Integer.parseInt(matcher.group().substring(2), 16);
            sb.append(c);
            lastEnd = matcher.end();
        }
        sb.append(text.substring(lastEnd));
        return sb.toString();
    }

    @Contract(pure=true)
    @NotNull
    public static String toHexString(byte @NotNull [] bytes) {
        if (bytes == null) {
            StringUtil.$$$reportNull$$$0(440);
        }
        String digits = "0123456789abcdef";
        StringBuilder sb = new StringBuilder(2 * bytes.length);
        for (byte b : bytes) {
            sb.append(digits.charAt(b >> 4 & 0xF)).append(digits.charAt(b & 0xF));
        }
        String string = sb.toString();
        if (string == null) {
            StringUtil.$$$reportNull$$$0(441);
        }
        return string;
    }

    @Contract(pure=true)
    public static byte @NotNull [] parseHexString(@NotNull String str) {
        int len;
        if (str == null) {
            StringUtil.$$$reportNull$$$0(442);
        }
        if ((len = str.length()) % 2 != 0) {
            throw new IllegalArgumentException("Non-even-length: " + str);
        }
        byte[] bytes = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            bytes[i / 2] = (byte)((Character.digit(str.charAt(i), 16) << 4) + Character.digit(str.charAt(i + 1), 16));
        }
        if (bytes == null) {
            StringUtil.$$$reportNull$$$0(443);
        }
        return bytes;
    }

    @Contract(pure=true)
    public static boolean isLatinAlphanumeric(@Nullable CharSequence str) {
        if (StringUtil.isEmpty(str)) {
            return false;
        }
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || Character.isDigit(c)) continue;
            return false;
        }
        return true;
    }

    @Contract(value="null -> null; !null->!null", pure=true)
    public static String internEmptyString(String s) {
        return s == null ? null : (s.isEmpty() ? "" : s);
    }

    public static int skipWhitespaceForward(@NotNull CharSequence text, int pos) {
        if (text == null) {
            StringUtil.$$$reportNull$$$0(444);
        }
        int length = text.length();
        while (pos < length && StringUtil.isWhitespaceOrTab(text.charAt(pos))) {
            ++pos;
        }
        return pos;
    }

    public static int skipWhitespaceBackward(@NotNull CharSequence text, int pos) {
        if (text == null) {
            StringUtil.$$$reportNull$$$0(445);
        }
        while (pos > 0 && StringUtil.isWhitespaceOrTab(text.charAt(pos - 1))) {
            --pos;
        }
        return pos;
    }

    private static boolean isWhitespaceOrTab(char c) {
        return c == ' ' || c == '\t';
    }

    @Deprecated
    @Nls
    @NotNull
    public static String naturalJoin(List<String> strings) {
        if (strings.isEmpty()) {
            return "";
        }
        if (strings.size() == 1) {
            String string = strings.get(0);
            if (string == null) {
                StringUtil.$$$reportNull$$$0(446);
            }
            return string;
        }
        String lastWord = strings.get(strings.size() - 1);
        String leadingWords = StringUtil.join(strings.subList(0, strings.size() - 1), ", ");
        String string = leadingWords + " and " + lastWord;
        if (string == null) {
            StringUtil.$$$reportNull$$$0(447);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 6: 
            case 10: 
            case 14: 
            case 16: 
            case 34: 
            case 37: 
            case 41: 
            case 53: 
            case 56: 
            case 65: 
            case 67: 
            case 69: 
            case 71: 
            case 75: 
            case 77: 
            case 81: 
            case 83: 
            case 87: 
            case 89: 
            case 91: 
            case 93: 
            case 106: 
            case 109: 
            case 111: 
            case 113: 
            case 114: 
            case 116: 
            case 118: 
            case 120: 
            case 122: 
            case 124: 
            case 126: 
            case 128: 
            case 130: 
            case 133: 
            case 135: 
            case 137: 
            case 139: 
            case 141: 
            case 143: 
            case 146: 
            case 148: 
            case 159: 
            case 160: 
            case 164: 
            case 166: 
            case 167: 
            case 170: 
            case 175: 
            case 178: 
            case 182: 
            case 186: 
            case 190: 
            case 193: 
            case 197: 
            case 204: 
            case 210: 
            case 212: 
            case 213: 
            case 215: 
            case 216: 
            case 217: 
            case 219: 
            case 220: 
            case 222: 
            case 224: 
            case 234: 
            case 237: 
            case 242: 
            case 248: 
            case 260: 
            case 267: 
            case 300: 
            case 301: 
            case 308: 
            case 310: 
            case 311: 
            case 312: 
            case 314: 
            case 315: 
            case 316: 
            case 318: 
            case 322: 
            case 329: 
            case 331: 
            case 337: 
            case 339: 
            case 341: 
            case 344: 
            case 346: 
            case 347: 
            case 348: 
            case 351: 
            case 353: 
            case 356: 
            case 361: 
            case 363: 
            case 364: 
            case 373: 
            case 375: 
            case 376: 
            case 381: 
            case 382: 
            case 383: 
            case 385: 
            case 388: 
            case 391: 
            case 393: 
            case 395: 
            case 397: 
            case 401: 
            case 404: 
            case 409: 
            case 410: 
            case 418: 
            case 421: 
            case 425: 
            case 427: 
            case 429: 
            case 441: 
            case 443: 
            case 446: 
            case 447: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 6: 
            case 10: 
            case 14: 
            case 16: 
            case 34: 
            case 37: 
            case 41: 
            case 53: 
            case 56: 
            case 65: 
            case 67: 
            case 69: 
            case 71: 
            case 75: 
            case 77: 
            case 81: 
            case 83: 
            case 87: 
            case 89: 
            case 91: 
            case 93: 
            case 106: 
            case 109: 
            case 111: 
            case 113: 
            case 114: 
            case 116: 
            case 118: 
            case 120: 
            case 122: 
            case 124: 
            case 126: 
            case 128: 
            case 130: 
            case 133: 
            case 135: 
            case 137: 
            case 139: 
            case 141: 
            case 143: 
            case 146: 
            case 148: 
            case 159: 
            case 160: 
            case 164: 
            case 166: 
            case 167: 
            case 170: 
            case 175: 
            case 178: 
            case 182: 
            case 186: 
            case 190: 
            case 193: 
            case 197: 
            case 204: 
            case 210: 
            case 212: 
            case 213: 
            case 215: 
            case 216: 
            case 217: 
            case 219: 
            case 220: 
            case 222: 
            case 224: 
            case 234: 
            case 237: 
            case 242: 
            case 248: 
            case 260: 
            case 267: 
            case 300: 
            case 301: 
            case 308: 
            case 310: 
            case 311: 
            case 312: 
            case 314: 
            case 315: 
            case 316: 
            case 318: 
            case 322: 
            case 329: 
            case 331: 
            case 337: 
            case 339: 
            case 341: 
            case 344: 
            case 346: 
            case 347: 
            case 348: 
            case 351: 
            case 353: 
            case 356: 
            case 361: 
            case 363: 
            case 364: 
            case 373: 
            case 375: 
            case 376: 
            case 381: 
            case 382: 
            case 383: 
            case 385: 
            case 388: 
            case 391: 
            case 393: 
            case 395: 
            case 397: 
            case 401: 
            case 404: 
            case 409: 
            case 410: 
            case 418: 
            case 421: 
            case 425: 
            case 427: 
            case 429: 
            case 441: 
            case 443: 
            case 446: 
            case 447: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "charSeq";
                break;
            }
            case 1: 
            case 247: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replacement";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "find";
                break;
            }
            case 3: 
            case 6: 
            case 10: 
            case 14: 
            case 16: 
            case 34: 
            case 37: 
            case 41: 
            case 53: 
            case 56: 
            case 65: 
            case 67: 
            case 69: 
            case 71: 
            case 75: 
            case 77: 
            case 81: 
            case 83: 
            case 87: 
            case 89: 
            case 91: 
            case 93: 
            case 106: 
            case 109: 
            case 111: 
            case 113: 
            case 114: 
            case 116: 
            case 118: 
            case 120: 
            case 122: 
            case 124: 
            case 126: 
            case 128: 
            case 130: 
            case 133: 
            case 135: 
            case 137: 
            case 139: 
            case 141: 
            case 143: 
            case 146: 
            case 148: 
            case 159: 
            case 160: 
            case 164: 
            case 166: 
            case 167: 
            case 170: 
            case 175: 
            case 178: 
            case 182: 
            case 186: 
            case 190: 
            case 193: 
            case 197: 
            case 204: 
            case 210: 
            case 212: 
            case 213: 
            case 215: 
            case 216: 
            case 217: 
            case 219: 
            case 220: 
            case 222: 
            case 224: 
            case 234: 
            case 237: 
            case 242: 
            case 248: 
            case 260: 
            case 267: 
            case 300: 
            case 301: 
            case 308: 
            case 310: 
            case 311: 
            case 312: 
            case 314: 
            case 315: 
            case 316: 
            case 318: 
            case 322: 
            case 329: 
            case 331: 
            case 337: 
            case 339: 
            case 341: 
            case 344: 
            case 346: 
            case 347: 
            case 348: 
            case 351: 
            case 353: 
            case 356: 
            case 361: 
            case 363: 
            case 364: 
            case 373: 
            case 375: 
            case 376: 
            case 381: 
            case 382: 
            case 383: 
            case 385: 
            case 388: 
            case 391: 
            case 393: 
            case 395: 
            case 397: 
            case 401: 
            case 404: 
            case 409: 
            case 410: 
            case 418: 
            case 421: 
            case 425: 
            case 427: 
            case 429: 
            case 441: 
            case 443: 
            case 446: 
            case 447: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/util/text/StringUtil";
                break;
            }
            case 4: 
            case 7: 
            case 11: 
            case 17: 
            case 38: 
            case 39: 
            case 40: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 84: 
            case 85: 
            case 112: 
            case 165: 
            case 168: 
            case 169: 
            case 214: 
            case 249: 
            case 250: 
            case 252: 
            case 254: 
            case 256: 
            case 284: 
            case 296: 
            case 298: 
            case 302: 
            case 304: 
            case 307: 
            case 309: 
            case 313: 
            case 317: 
            case 338: 
            case 340: 
            case 349: 
            case 350: 
            case 352: 
            case 354: 
            case 357: 
            case 358: 
            case 365: 
            case 366: 
            case 367: 
            case 368: 
            case 371: 
            case 377: 
            case 378: 
            case 405: 
            case 406: 
            case 407: 
            case 411: 
            case 415: 
            case 416: 
            case 417: 
            case 419: 
            case 444: 
            case 445: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cls";
                break;
            }
            case 8: 
            case 12: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldS";
                break;
            }
            case 9: 
            case 13: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newS";
                break;
            }
            case 15: 
            case 58: 
            case 60: 
            case 62: 
            case 64: 
            case 79: 
            case 138: 
            case 433: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
            case 20: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 402: {
                objectArray2 = objectArray3;
                objectArray3[0] = "where";
                break;
            }
            case 21: 
            case 23: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "what";
                break;
            }
            case 28: 
            case 30: 
            case 57: 
            case 59: 
            case 61: 
            case 63: 
            case 319: 
            case 320: 
            case 324: 
            case 326: 
            case 327: 
            case 328: 
            case 330: 
            case 333: 
            case 336: 
            case 442: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
            case 29: 
            case 105: 
            case 108: 
            case 180: 
            case 255: 
            case 257: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suffix";
                break;
            }
            case 31: 
            case 132: 
            case 179: 
            case 251: 
            case 253: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 32: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "html";
                break;
            }
            case 35: 
            case 36: 
            case 426: 
            case 428: 
            case 430: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqName";
                break;
            }
            case 46: 
            case 258: 
            case 261: 
            case 263: 
            case 265: 
            case 268: 
            case 398: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s1";
                break;
            }
            case 47: 
            case 259: 
            case 262: 
            case 264: 
            case 266: 
            case 269: 
            case 399: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s2";
                break;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 54: 
            case 66: 
            case 68: 
            case 70: 
            case 72: 
            case 73: 
            case 74: 
            case 76: 
            case 78: 
            case 80: 
            case 88: 
            case 90: 
            case 92: 
            case 104: 
            case 107: 
            case 110: 
            case 131: 
            case 145: 
            case 147: 
            case 149: 
            case 151: 
            case 153: 
            case 155: 
            case 157: 
            case 161: 
            case 232: 
            case 235: 
            case 238: 
            case 240: 
            case 243: 
            case 270: 
            case 271: 
            case 272: 
            case 273: 
            case 282: 
            case 283: 
            case 286: 
            case 288: 
            case 290: 
            case 292: 
            case 294: 
            case 306: 
            case 345: 
            case 379: 
            case 386: 
            case 387: 
            case 396: 
            case 400: 
            case 438: 
            case 439: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wordsToIgnore";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prepositions";
                break;
            }
            case 82: 
            case 225: {
                objectArray2 = objectArray3;
                objectArray3[0] = "word";
                break;
            }
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokenizerDelimiters";
                break;
            }
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 228: 
            case 230: 
            case 287: 
            case 289: 
            case 291: 
            case 293: 
            case 295: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chars";
                break;
            }
            case 102: 
            case 115: 
            case 117: 
            case 119: 
            case 123: 
            case 125: 
            case 127: 
            case 245: 
            case 389: 
            case 390: 
            case 392: 
            case 394: 
            case 422: 
            case 435: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
            case 103: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefixes";
                break;
            }
            case 121: 
            case 129: 
            case 334: 
            case 335: 
            case 355: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 134: 
            case 380: 
            case 384: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 136: {
                objectArray2 = objectArray3;
                objectArray3[0] = "base";
                break;
            }
            case 140: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultValue";
                break;
            }
            case 142: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aThrowable";
                break;
            }
            case 144: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 150: 
            case 152: 
            case 154: 
            case 156: 
            case 158: 
            case 171: 
            case 173: 
            case 184: 
            case 189: 
            case 192: 
            case 196: 
            case 200: 
            case 203: 
            case 206: 
            case 208: {
                objectArray2 = objectArray3;
                objectArray3[0] = "separator";
                break;
            }
            case 162: {
                objectArray2 = objectArray3;
                objectArray3[0] = "separators";
                break;
            }
            case 163: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokenizer";
                break;
            }
            case 172: 
            case 174: 
            case 181: 
            case 202: 
            case 205: 
            case 209: 
            case 211: 
            case 362: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strings";
                break;
            }
            case 176: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strings1";
                break;
            }
            case 177: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strings2";
                break;
            }
            case 183: 
            case 188: 
            case 195: 
            case 199: {
                objectArray2 = objectArray3;
                objectArray3[0] = "f";
                break;
            }
            case 185: 
            case 187: 
            case 191: 
            case 194: 
            case 198: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 201: 
            case 207: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 218: 
            case 223: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unitSeparator";
                break;
            }
            case 221: {
                objectArray2 = objectArray3;
                objectArray3[0] = "duration";
                break;
            }
            case 226: 
            case 227: 
            case 229: 
            case 231: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 233: 
            case 236: 
            case 244: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 239: 
            case 241: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 246: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 274: 
            case 276: 
            case 278: 
            case 280: 
            case 414: 
            case 432: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sequence";
                break;
            }
            case 275: 
            case 277: 
            case 279: 
            case 281: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infix";
                break;
            }
            case 285: 
            case 297: 
            case 299: 
            case 303: 
            case 305: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subString";
                break;
            }
            case 321: {
                objectArray2 = objectArray3;
                objectArray3[0] = "character";
                break;
            }
            case 323: 
            case 325: 
            case 332: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buf";
                break;
            }
            case 342: 
            case 343: {
                objectArray2 = objectArray3;
                objectArray3[0] = "htmlString";
                break;
            }
            case 359: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 360: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 369: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 370: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
            case 372: {
                objectArray2 = objectArray3;
                objectArray3[0] = "input";
                break;
            }
            case 374: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 403: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 408: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 412: 
            case 413: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 420: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newSeparator";
                break;
            }
            case 423: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 424: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 431: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shortName";
                break;
            }
            case 434: {
                objectArray2 = objectArray3;
                objectArray3[0] = "end";
                break;
            }
            case 436: {
                objectArray2 = objectArray3;
                objectArray3[0] = "smallPart";
                break;
            }
            case 437: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bigPart";
                break;
            }
            case 440: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bytes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/util/text/StringUtil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getWordsInStringLongestFirst";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createToStringFunction";
                break;
            }
            case 10: 
            case 361: {
                objectArray = objectArray2;
                objectArray2[1] = "replace";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceIgnoreCase";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceChar";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "stripHtml";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackageName";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeLineBreak";
                break;
            }
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "fixCapitalization";
                break;
            }
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "escaper";
                break;
            }
            case 65: 
            case 67: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeStringCharacters";
                break;
            }
            case 69: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeCharCharacters";
                break;
            }
            case 71: {
                objectArray = objectArray2;
                objectArray2[1] = "unescapeStringCharacters";
                break;
            }
            case 75: 
            case 77: {
                objectArray = objectArray2;
                objectArray2[1] = "unquoteString";
                break;
            }
            case 81: {
                objectArray = objectArray2;
                objectArray2[1] = "unescapeAnsiStringCharacters";
                break;
            }
            case 83: 
            case 137: {
                objectArray = objectArray2;
                objectArray2[1] = "pluralize";
                break;
            }
            case 87: {
                objectArray = objectArray2;
                objectArray2[1] = "capitalizeWords";
                break;
            }
            case 89: {
                objectArray = objectArray2;
                objectArray2[1] = "decapitalize";
                break;
            }
            case 91: {
                objectArray = objectArray2;
                objectArray2[1] = "capitalize";
                break;
            }
            case 93: {
                objectArray = objectArray2;
                objectArray2[1] = "capitalizeWithJavaBeanConvention";
                break;
            }
            case 106: 
            case 109: 
            case 111: {
                objectArray = objectArray2;
                objectArray2[1] = "trimEnd";
                break;
            }
            case 113: 
            case 114: {
                objectArray = objectArray2;
                objectArray2[1] = "trimLog";
                break;
            }
            case 116: 
            case 118: 
            case 120: 
            case 122: {
                objectArray = objectArray2;
                objectArray2[1] = "trimLeading";
                break;
            }
            case 124: 
            case 126: 
            case 128: 
            case 130: {
                objectArray = objectArray2;
                objectArray2[1] = "trimTrailing";
                break;
            }
            case 133: {
                objectArray = objectArray2;
                objectArray2[1] = "trimStart";
                break;
            }
            case 135: {
                objectArray = objectArray2;
                objectArray2[1] = "trimExtensions";
                break;
            }
            case 139: 
            case 141: {
                objectArray = objectArray2;
                objectArray2[1] = "notNullize";
                break;
            }
            case 143: {
                objectArray = objectArray2;
                objectArray2[1] = "getThrowableText";
                break;
            }
            case 146: {
                objectArray = objectArray2;
                objectArray2[1] = "repeat";
                break;
            }
            case 148: {
                objectArray = objectArray2;
                objectArray2[1] = "splitHonorQuotes";
                break;
            }
            case 159: 
            case 160: {
                objectArray = objectArray2;
                objectArray2[1] = "split";
                break;
            }
            case 164: {
                objectArray = objectArray2;
                objectArray2[1] = "tokenize";
                break;
            }
            case 166: 
            case 167: {
                objectArray = objectArray2;
                objectArray2[1] = "getWordsIn";
                break;
            }
            case 170: {
                objectArray = objectArray2;
                objectArray2[1] = "getWordIndicesIn";
                break;
            }
            case 175: 
            case 186: 
            case 190: 
            case 193: 
            case 197: 
            case 204: 
            case 210: 
            case 212: {
                objectArray = objectArray2;
                objectArray2[1] = "join";
                break;
            }
            case 178: {
                objectArray = objectArray2;
                objectArray2[1] = "zip";
                break;
            }
            case 182: {
                objectArray = objectArray2;
                objectArray2[1] = "surround";
                break;
            }
            case 213: {
                objectArray = objectArray2;
                objectArray2[1] = "joining";
                break;
            }
            case 215: 
            case 216: {
                objectArray = objectArray2;
                objectArray2[1] = "stripQuotesAroundValue";
                break;
            }
            case 217: 
            case 219: {
                objectArray = objectArray2;
                objectArray2[1] = "formatFileSize";
                break;
            }
            case 220: 
            case 222: 
            case 224: {
                objectArray = objectArray2;
                objectArray2[1] = "formatDuration";
                break;
            }
            case 234: {
                objectArray = objectArray2;
                objectArray2[1] = "strip";
                break;
            }
            case 237: {
                objectArray = objectArray2;
                objectArray2[1] = "trim";
                break;
            }
            case 242: {
                objectArray = objectArray2;
                objectArray2[1] = "findMatches";
                break;
            }
            case 248: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceSubstring";
                break;
            }
            case 260: {
                objectArray = objectArray2;
                objectArray2[1] = "commonPrefix";
                break;
            }
            case 267: {
                objectArray = objectArray2;
                objectArray2[1] = "commonSuffix";
                break;
            }
            case 300: 
            case 301: {
                objectArray = objectArray2;
                objectArray2[1] = "substringBeforeLast";
                break;
            }
            case 308: 
            case 310: 
            case 311: 
            case 312: {
                objectArray = objectArray2;
                objectArray2[1] = "first";
                break;
            }
            case 314: 
            case 315: 
            case 316: {
                objectArray = objectArray2;
                objectArray2[1] = "last";
                break;
            }
            case 318: {
                objectArray = objectArray2;
                objectArray2[1] = "firstLast";
                break;
            }
            case 322: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeChars";
                break;
            }
            case 329: {
                objectArray = objectArray2;
                objectArray2[1] = "unescapeBackSlashes";
                break;
            }
            case 331: {
                objectArray = objectArray2;
                objectArray2[1] = "unescapeChar";
                break;
            }
            case 337: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapWithDoubleQuote";
                break;
            }
            case 339: {
                objectArray = objectArray2;
                objectArray2[1] = "unescapeXmlEntities";
                break;
            }
            case 341: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeXmlEntities";
                break;
            }
            case 344: {
                objectArray = objectArray2;
                objectArray2[1] = "removeHtmlTags";
                break;
            }
            case 346: 
            case 347: 
            case 348: {
                objectArray = objectArray2;
                objectArray2[1] = "removeEllipsisSuffix";
                break;
            }
            case 351: {
                objectArray = objectArray2;
                objectArray2[1] = "htmlEmphasize";
                break;
            }
            case 353: 
            case 356: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeToRegexp";
                break;
            }
            case 363: 
            case 364: {
                objectArray = objectArray2;
                objectArray2[1] = "filterEmptyStrings";
                break;
            }
            case 373: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeProperty";
                break;
            }
            case 375: 
            case 376: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifiedName";
                break;
            }
            case 381: 
            case 382: 
            case 383: {
                objectArray = objectArray2;
                objectArray2[1] = "fixVariableNameDerivedFromPropertyName";
                break;
            }
            case 385: {
                objectArray = objectArray2;
                objectArray2[1] = "sanitizeJavaIdentifier";
                break;
            }
            case 388: {
                objectArray = objectArray2;
                objectArray2[1] = "tail";
                break;
            }
            case 391: {
                objectArray = objectArray2;
                objectArray2[1] = "splitByLines";
                break;
            }
            case 393: {
                objectArray = objectArray2;
                objectArray2[1] = "splitByLinesDontTrim";
                break;
            }
            case 395: {
                objectArray = objectArray2;
                objectArray2[1] = "splitByLinesKeepSeparators";
                break;
            }
            case 397: {
                objectArray = objectArray2;
                objectArray2[1] = "getWordsWithOffset";
                break;
            }
            case 401: {
                objectArray = objectArray2;
                objectArray2[1] = "collapseWhiteSpace";
                break;
            }
            case 404: {
                objectArray = objectArray2;
                objectArray2[1] = "formatLinks";
                break;
            }
            case 409: 
            case 410: {
                objectArray = objectArray2;
                objectArray2[1] = "shortenTextWithEllipsis";
                break;
            }
            case 418: 
            case 421: {
                objectArray = objectArray2;
                objectArray2[1] = "convertLineSeparators";
                break;
            }
            case 425: 
            case 427: 
            case 429: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 441: {
                objectArray = objectArray2;
                objectArray2[1] = "toHexString";
                break;
            }
            case 443: {
                objectArray = objectArray2;
                objectArray2[1] = "parseHexString";
                break;
            }
            case 446: 
            case 447: {
                objectArray = objectArray2;
                objectArray2[1] = "naturalJoin";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "replaceSubSequence";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getWordsInStringLongestFirst";
                break;
            }
            case 3: 
            case 6: 
            case 10: 
            case 14: 
            case 16: 
            case 34: 
            case 37: 
            case 41: 
            case 53: 
            case 56: 
            case 65: 
            case 67: 
            case 69: 
            case 71: 
            case 75: 
            case 77: 
            case 81: 
            case 83: 
            case 87: 
            case 89: 
            case 91: 
            case 93: 
            case 106: 
            case 109: 
            case 111: 
            case 113: 
            case 114: 
            case 116: 
            case 118: 
            case 120: 
            case 122: 
            case 124: 
            case 126: 
            case 128: 
            case 130: 
            case 133: 
            case 135: 
            case 137: 
            case 139: 
            case 141: 
            case 143: 
            case 146: 
            case 148: 
            case 159: 
            case 160: 
            case 164: 
            case 166: 
            case 167: 
            case 170: 
            case 175: 
            case 178: 
            case 182: 
            case 186: 
            case 190: 
            case 193: 
            case 197: 
            case 204: 
            case 210: 
            case 212: 
            case 213: 
            case 215: 
            case 216: 
            case 217: 
            case 219: 
            case 220: 
            case 222: 
            case 224: 
            case 234: 
            case 237: 
            case 242: 
            case 248: 
            case 260: 
            case 267: 
            case 300: 
            case 301: 
            case 308: 
            case 310: 
            case 311: 
            case 312: 
            case 314: 
            case 315: 
            case 316: 
            case 318: 
            case 322: 
            case 329: 
            case 331: 
            case 337: 
            case 339: 
            case 341: 
            case 344: 
            case 346: 
            case 347: 
            case 348: 
            case 351: 
            case 353: 
            case 356: 
            case 361: 
            case 363: 
            case 364: 
            case 373: 
            case 375: 
            case 376: 
            case 381: 
            case 382: 
            case 383: 
            case 385: 
            case 388: 
            case 391: 
            case 393: 
            case 395: 
            case 397: 
            case 401: 
            case 404: 
            case 409: 
            case 410: 
            case 418: 
            case 421: 
            case 425: 
            case 427: 
            case 429: 
            case 441: 
            case 443: 
            case 446: 
            case 447: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "escapePattern";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createToStringFunction";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 17: 
            case 18: 
            case 19: 
            case 358: 
            case 359: 
            case 360: {
                objectArray = objectArray;
                objectArray[2] = "replace";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "replaceIgnoreCase";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "replaceChar";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "indexOfIgnoreCase";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "lastIndexOfIgnoreCase";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "containsIgnoreCase";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "endsWithIgnoreCase";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "startsWithIgnoreCase";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "stripHtml";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getPackageName";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getLineBreakCount";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "containsLineBreak";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "escapeLineBreak";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "endsWithLineBreak";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "lineColToOffset";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "offsetToLineNumber";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "offsetToLineColumn";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "difference";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "wordsToBeginFromUpperCase";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "wordsToBeginFromLowerCase";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "toTitleCase";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "fixCapitalization";
                break;
            }
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "isPreposition";
                break;
            }
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "escapeStringCharacters";
                break;
            }
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "escapeCharCharacters";
                break;
            }
            case 70: 
            case 78: 
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "unescapeStringCharacters";
                break;
            }
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "isQuoteAt";
                break;
            }
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "isQuotedString";
                break;
            }
            case 74: 
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "unquoteString";
                break;
            }
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "unescapeAnsiStringCharacters";
                break;
            }
            case 82: 
            case 136: {
                objectArray = objectArray;
                objectArray[2] = "pluralize";
                break;
            }
            case 84: 
            case 85: 
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "capitalizeWords";
                break;
            }
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "decapitalize";
                break;
            }
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "capitalize";
                break;
            }
            case 92: {
                objectArray = objectArray;
                objectArray[2] = "capitalizeWithJavaBeanConvention";
                break;
            }
            case 94: 
            case 95: 
            case 96: {
                objectArray = objectArray;
                objectArray[2] = "stringHashCode";
                break;
            }
            case 97: 
            case 98: 
            case 99: 
            case 100: {
                objectArray = objectArray;
                objectArray[2] = "stringHashCodeInsensitive";
                break;
            }
            case 101: {
                objectArray = objectArray;
                objectArray[2] = "stringHashCodeIgnoreWhitespaces";
                break;
            }
            case 102: 
            case 103: {
                objectArray = objectArray;
                objectArray[2] = "startsWithConcatenation";
                break;
            }
            case 104: 
            case 105: 
            case 107: 
            case 108: 
            case 110: 
            case 433: 
            case 434: {
                objectArray = objectArray;
                objectArray[2] = "trimEnd";
                break;
            }
            case 112: {
                objectArray = objectArray;
                objectArray[2] = "trimLog";
                break;
            }
            case 115: 
            case 117: 
            case 119: 
            case 121: {
                objectArray = objectArray;
                objectArray[2] = "trimLeading";
                break;
            }
            case 123: 
            case 125: 
            case 127: 
            case 129: {
                objectArray = objectArray;
                objectArray[2] = "trimTrailing";
                break;
            }
            case 131: 
            case 132: {
                objectArray = objectArray;
                objectArray[2] = "trimStart";
                break;
            }
            case 134: {
                objectArray = objectArray;
                objectArray[2] = "trimExtensions";
                break;
            }
            case 138: {
                objectArray = objectArray;
                objectArray[2] = "repeatSymbol";
                break;
            }
            case 140: {
                objectArray = objectArray;
                objectArray[2] = "notNullize";
                break;
            }
            case 142: {
                objectArray = objectArray;
                objectArray[2] = "getThrowableText";
                break;
            }
            case 144: {
                objectArray = objectArray;
                objectArray[2] = "getMessage";
                break;
            }
            case 145: {
                objectArray = objectArray;
                objectArray[2] = "repeat";
                break;
            }
            case 147: {
                objectArray = objectArray;
                objectArray[2] = "splitHonorQuotes";
                break;
            }
            case 149: 
            case 150: 
            case 151: 
            case 152: 
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: {
                objectArray = objectArray;
                objectArray[2] = "split";
                break;
            }
            case 161: 
            case 162: 
            case 163: {
                objectArray = objectArray;
                objectArray[2] = "tokenize";
                break;
            }
            case 165: {
                objectArray = objectArray;
                objectArray[2] = "getWordsIn";
                break;
            }
            case 168: 
            case 169: {
                objectArray = objectArray;
                objectArray[2] = "getWordIndicesIn";
                break;
            }
            case 171: 
            case 172: 
            case 173: 
            case 174: 
            case 183: 
            case 184: 
            case 185: 
            case 187: 
            case 188: 
            case 189: 
            case 191: 
            case 192: 
            case 194: 
            case 195: 
            case 196: 
            case 198: 
            case 199: 
            case 200: 
            case 201: 
            case 202: 
            case 203: 
            case 205: 
            case 206: 
            case 207: 
            case 208: 
            case 209: 
            case 211: {
                objectArray = objectArray;
                objectArray[2] = "join";
                break;
            }
            case 176: 
            case 177: {
                objectArray = objectArray;
                objectArray[2] = "zip";
                break;
            }
            case 179: 
            case 180: 
            case 181: {
                objectArray = objectArray;
                objectArray[2] = "surround";
                break;
            }
            case 214: {
                objectArray = objectArray;
                objectArray[2] = "stripQuotesAroundValue";
                break;
            }
            case 218: {
                objectArray = objectArray;
                objectArray[2] = "formatFileSize";
                break;
            }
            case 221: 
            case 223: {
                objectArray = objectArray;
                objectArray[2] = "formatDuration";
                break;
            }
            case 225: {
                objectArray = objectArray;
                objectArray[2] = "unpluralize";
                break;
            }
            case 226: {
                objectArray = objectArray;
                objectArray[2] = "containsAlphaCharacters";
                break;
            }
            case 227: 
            case 228: 
            case 229: 
            case 230: {
                objectArray = objectArray;
                objectArray[2] = "containsAnyChar";
                break;
            }
            case 231: {
                objectArray = objectArray;
                objectArray[2] = "containsChar";
                break;
            }
            case 232: 
            case 233: {
                objectArray = objectArray;
                objectArray[2] = "strip";
                break;
            }
            case 235: 
            case 236: {
                objectArray = objectArray;
                objectArray[2] = "trim";
                break;
            }
            case 238: 
            case 239: 
            case 240: 
            case 241: {
                objectArray = objectArray;
                objectArray[2] = "findMatches";
                break;
            }
            case 243: 
            case 244: {
                objectArray = objectArray;
                objectArray[2] = "findFirst";
                break;
            }
            case 245: 
            case 246: 
            case 247: {
                objectArray = objectArray;
                objectArray[2] = "replaceSubstring";
                break;
            }
            case 249: {
                objectArray = objectArray;
                objectArray[2] = "startsWithWhitespace";
                break;
            }
            case 250: 
            case 251: 
            case 252: 
            case 253: {
                objectArray = objectArray;
                objectArray[2] = "startsWith";
                break;
            }
            case 254: 
            case 255: 
            case 256: 
            case 257: {
                objectArray = objectArray;
                objectArray[2] = "endsWith";
                break;
            }
            case 258: 
            case 259: {
                objectArray = objectArray;
                objectArray[2] = "commonPrefix";
                break;
            }
            case 261: 
            case 262: 
            case 263: 
            case 264: {
                objectArray = objectArray;
                objectArray[2] = "commonPrefixLength";
                break;
            }
            case 265: 
            case 266: {
                objectArray = objectArray;
                objectArray[2] = "commonSuffix";
                break;
            }
            case 268: 
            case 269: {
                objectArray = objectArray;
                objectArray[2] = "commonSuffixLength";
                break;
            }
            case 270: 
            case 274: 
            case 275: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
            case 271: 
            case 272: 
            case 273: 
            case 276: 
            case 277: 
            case 278: 
            case 279: 
            case 280: 
            case 281: 
            case 282: 
            case 283: {
                objectArray = objectArray;
                objectArray[2] = "indexOf";
                break;
            }
            case 284: 
            case 285: {
                objectArray = objectArray;
                objectArray[2] = "indexOfSubstringEnd";
                break;
            }
            case 286: 
            case 287: 
            case 288: 
            case 289: 
            case 290: 
            case 291: 
            case 292: 
            case 293: {
                objectArray = objectArray;
                objectArray[2] = "indexOfAny";
                break;
            }
            case 294: 
            case 295: {
                objectArray = objectArray;
                objectArray[2] = "lastIndexOfAny";
                break;
            }
            case 296: 
            case 297: {
                objectArray = objectArray;
                objectArray[2] = "substringBefore";
                break;
            }
            case 298: 
            case 299: {
                objectArray = objectArray;
                objectArray[2] = "substringBeforeLast";
                break;
            }
            case 302: 
            case 303: {
                objectArray = objectArray;
                objectArray[2] = "substringAfter";
                break;
            }
            case 304: 
            case 305: {
                objectArray = objectArray;
                objectArray[2] = "substringAfterLast";
                break;
            }
            case 306: {
                objectArray = objectArray;
                objectArray[2] = "lastIndexOf";
                break;
            }
            case 307: 
            case 309: {
                objectArray = objectArray;
                objectArray[2] = "first";
                break;
            }
            case 313: {
                objectArray = objectArray;
                objectArray[2] = "last";
                break;
            }
            case 317: {
                objectArray = objectArray;
                objectArray[2] = "firstLast";
                break;
            }
            case 319: 
            case 323: {
                objectArray = objectArray;
                objectArray[2] = "escapeChar";
                break;
            }
            case 320: 
            case 321: {
                objectArray = objectArray;
                objectArray[2] = "escapeChars";
                break;
            }
            case 324: 
            case 325: {
                objectArray = objectArray;
                objectArray[2] = "escapeQuotes";
                break;
            }
            case 326: {
                objectArray = objectArray;
                objectArray[2] = "escapeSlashes";
                break;
            }
            case 327: {
                objectArray = objectArray;
                objectArray[2] = "escapeBackSlashes";
                break;
            }
            case 328: {
                objectArray = objectArray;
                objectArray[2] = "unescapeBackSlashes";
                break;
            }
            case 330: 
            case 332: 
            case 333: {
                objectArray = objectArray;
                objectArray[2] = "unescapeChar";
                break;
            }
            case 334: 
            case 335: {
                objectArray = objectArray;
                objectArray[2] = "quote";
                break;
            }
            case 336: {
                objectArray = objectArray;
                objectArray[2] = "wrapWithDoubleQuote";
                break;
            }
            case 338: {
                objectArray = objectArray;
                objectArray[2] = "unescapeXmlEntities";
                break;
            }
            case 340: {
                objectArray = objectArray;
                objectArray[2] = "escapeXmlEntities";
                break;
            }
            case 342: 
            case 343: {
                objectArray = objectArray;
                objectArray[2] = "removeHtmlTags";
                break;
            }
            case 345: {
                objectArray = objectArray;
                objectArray[2] = "removeEllipsisSuffix";
                break;
            }
            case 349: {
                objectArray = objectArray;
                objectArray[2] = "escapeMnemonics";
                break;
            }
            case 350: {
                objectArray = objectArray;
                objectArray[2] = "htmlEmphasize";
                break;
            }
            case 352: 
            case 354: 
            case 355: {
                objectArray = objectArray;
                objectArray[2] = "escapeToRegexp";
                break;
            }
            case 357: {
                objectArray = objectArray;
                objectArray[2] = "isEscapedBackslash";
                break;
            }
            case 362: {
                objectArray = objectArray;
                objectArray[2] = "filterEmptyStrings";
                break;
            }
            case 365: {
                objectArray = objectArray;
                objectArray[2] = "countNewLines";
                break;
            }
            case 366: 
            case 367: 
            case 368: {
                objectArray = objectArray;
                objectArray[2] = "countChars";
                break;
            }
            case 369: {
                objectArray = objectArray;
                objectArray[2] = "joinOrNull";
                break;
            }
            case 370: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyName";
                break;
            }
            case 371: {
                objectArray = objectArray;
                objectArray[2] = "isJavaIdentifier";
                break;
            }
            case 372: {
                objectArray = objectArray;
                objectArray[2] = "escapeProperty";
                break;
            }
            case 374: {
                objectArray = objectArray;
                objectArray[2] = "getQualifiedName";
                break;
            }
            case 377: 
            case 378: 
            case 379: {
                objectArray = objectArray;
                objectArray[2] = "getOccurrenceCount";
                break;
            }
            case 380: {
                objectArray = objectArray;
                objectArray[2] = "fixVariableNameDerivedFromPropertyName";
                break;
            }
            case 384: {
                objectArray = objectArray;
                objectArray[2] = "sanitizeJavaIdentifier";
                break;
            }
            case 386: {
                objectArray = objectArray;
                objectArray[2] = "assertValidSeparators";
                break;
            }
            case 387: {
                objectArray = objectArray;
                objectArray[2] = "tail";
                break;
            }
            case 389: 
            case 390: {
                objectArray = objectArray;
                objectArray[2] = "splitByLines";
                break;
            }
            case 392: {
                objectArray = objectArray;
                objectArray[2] = "splitByLinesDontTrim";
                break;
            }
            case 394: {
                objectArray = objectArray;
                objectArray[2] = "splitByLinesKeepSeparators";
                break;
            }
            case 396: {
                objectArray = objectArray;
                objectArray[2] = "getWordsWithOffset";
                break;
            }
            case 398: 
            case 399: {
                objectArray = objectArray;
                objectArray[2] = "equalsTrimWhitespaces";
                break;
            }
            case 400: {
                objectArray = objectArray;
                objectArray[2] = "collapseWhiteSpace";
                break;
            }
            case 402: {
                objectArray = objectArray;
                objectArray[2] = "findIgnoreCase";
                break;
            }
            case 403: {
                objectArray = objectArray;
                objectArray[2] = "formatLinks";
                break;
            }
            case 405: 
            case 407: 
            case 408: 
            case 411: {
                objectArray = objectArray;
                objectArray[2] = "shortenTextWithEllipsis";
                break;
            }
            case 406: {
                objectArray = objectArray;
                objectArray[2] = "trimMiddle";
                break;
            }
            case 412: 
            case 413: {
                objectArray = objectArray;
                objectArray[2] = "shortenPathWithEllipsis";
                break;
            }
            case 414: {
                objectArray = objectArray;
                objectArray[2] = "isUpperCase";
                break;
            }
            case 415: {
                objectArray = objectArray;
                objectArray[2] = "detectSeparators";
                break;
            }
            case 416: {
                objectArray = objectArray;
                objectArray[2] = "getLineSeparatorAt";
                break;
            }
            case 417: 
            case 419: 
            case 420: {
                objectArray = objectArray;
                objectArray[2] = "convertLineSeparators";
                break;
            }
            case 422: 
            case 423: {
                objectArray = objectArray;
                objectArray[2] = "parseEnum";
                break;
            }
            case 424: 
            case 426: 
            case 428: {
                objectArray = objectArray;
                objectArray[2] = "getShortName";
                break;
            }
            case 430: 
            case 431: {
                objectArray = objectArray;
                objectArray[2] = "isShortNameOf";
                break;
            }
            case 432: {
                objectArray = objectArray;
                objectArray[2] = "newBombedCharSequence";
                break;
            }
            case 435: 
            case 436: 
            case 437: {
                objectArray = objectArray;
                objectArray[2] = "isBetween";
                break;
            }
            case 438: {
                objectArray = objectArray;
                objectArray[2] = "hasUpperCaseChar";
                break;
            }
            case 439: {
                objectArray = objectArray;
                objectArray[2] = "hasLowerCaseChar";
                break;
            }
            case 440: {
                objectArray = objectArray;
                objectArray[2] = "toHexString";
                break;
            }
            case 442: {
                objectArray = objectArray;
                objectArray[2] = "parseHexString";
                break;
            }
            case 444: {
                objectArray = objectArray;
                objectArray[2] = "skipWhitespaceForward";
                break;
            }
            case 445: {
                objectArray = objectArray;
                objectArray[2] = "skipWhitespaceBackward";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 6: 
            case 10: 
            case 14: 
            case 16: 
            case 34: 
            case 37: 
            case 41: 
            case 53: 
            case 56: 
            case 65: 
            case 67: 
            case 69: 
            case 71: 
            case 75: 
            case 77: 
            case 81: 
            case 83: 
            case 87: 
            case 89: 
            case 91: 
            case 93: 
            case 106: 
            case 109: 
            case 111: 
            case 113: 
            case 114: 
            case 116: 
            case 118: 
            case 120: 
            case 122: 
            case 124: 
            case 126: 
            case 128: 
            case 130: 
            case 133: 
            case 135: 
            case 137: 
            case 139: 
            case 141: 
            case 143: 
            case 146: 
            case 148: 
            case 159: 
            case 160: 
            case 164: 
            case 166: 
            case 167: 
            case 170: 
            case 175: 
            case 178: 
            case 182: 
            case 186: 
            case 190: 
            case 193: 
            case 197: 
            case 204: 
            case 210: 
            case 212: 
            case 213: 
            case 215: 
            case 216: 
            case 217: 
            case 219: 
            case 220: 
            case 222: 
            case 224: 
            case 234: 
            case 237: 
            case 242: 
            case 248: 
            case 260: 
            case 267: 
            case 300: 
            case 301: 
            case 308: 
            case 310: 
            case 311: 
            case 312: 
            case 314: 
            case 315: 
            case 316: 
            case 318: 
            case 322: 
            case 329: 
            case 331: 
            case 337: 
            case 339: 
            case 341: 
            case 344: 
            case 346: 
            case 347: 
            case 348: 
            case 351: 
            case 353: 
            case 356: 
            case 361: 
            case 363: 
            case 364: 
            case 373: 
            case 375: 
            case 376: 
            case 381: 
            case 382: 
            case 383: 
            case 385: 
            case 388: 
            case 391: 
            case 393: 
            case 395: 
            case 397: 
            case 401: 
            case 404: 
            case 409: 
            case 410: 
            case 418: 
            case 421: 
            case 425: 
            case 427: 
            case 429: 
            case 441: 
            case 443: 
            case 446: 
            case 447: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class Splitters {
        private static final Pattern EOL_SPLIT_KEEP_SEPARATORS = Pattern.compile("(?<=(\r\n|\n))|(?<=\r)(?=[^\n])");
        private static final Pattern EOL_SPLIT_PATTERN = Pattern.compile(" *(\r|\n|\r\n)+ *");
        private static final Pattern EOL_SPLIT_PATTERN_WITH_EMPTY = Pattern.compile(" *(\r|\n|\r\n) *");
        private static final Pattern EOL_SPLIT_DONT_TRIM_PATTERN = Pattern.compile("(\r|\n|\r\n)+");

        private Splitters() {
        }
    }
}

