/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.python.internal;

import com.intellij.configurationStore.StreamProvider;
import com.intellij.ide.plugins.PluginUtil;
import com.intellij.ide.plugins.PluginUtilImpl;
import com.intellij.ide.startup.impl.StartupManagerImpl;
import com.intellij.lang.ASTNode;
import com.intellij.lang.DefaultASTFactory;
import com.intellij.lang.DefaultASTFactoryImpl;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageASTFactory;
import com.intellij.lang.LanguageExtension;
import com.intellij.lang.LanguageExtensionPoint;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.MetaLanguage;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiBuilderFactory;
import com.intellij.lang.impl.PsiBuilderFactoryImpl;
import com.intellij.mock.MockApplication;
import com.intellij.mock.MockFileDocumentManagerImpl;
import com.intellij.mock.MockProject;
import com.intellij.mock.MockPsiManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.SettingsCategory;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorKind;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.EditorEventMulticaster;
import com.intellij.openapi.editor.event.EditorFactoryListener;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.editor.event.EditorMouseMotionListener;
import com.intellij.openapi.editor.event.SelectionListener;
import com.intellij.openapi.editor.event.VisibleAreaListener;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.extensions.BaseExtensionPointName;
import com.intellij.openapi.extensions.DefaultPluginDescriptor;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.impl.ExtensionPointImpl;
import com.intellij.openapi.extensions.impl.ExtensionsAreaImpl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.FileDocumentManagerBase;
import com.intellij.openapi.fileTypes.FileNameMatcher;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeFactory;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.fileTypes.ex.FileTypeManagerEx;
import com.intellij.openapi.options.EmptySchemesManager;
import com.intellij.openapi.options.Scheme;
import com.intellij.openapi.options.SchemeManager;
import com.intellij.openapi.options.SchemeManagerFactory;
import com.intellij.openapi.options.SchemeProcessor;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.impl.ProgressManagerImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.KeyedExtensionCollector;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.PomModel;
import com.intellij.pom.core.impl.PomModelImpl;
import com.intellij.pom.tree.TreeAspect;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.psi.impl.PsiCachedValuesFactory;
import com.intellij.psi.impl.source.resolve.reference.ReferenceProvidersRegistry;
import com.intellij.psi.impl.source.resolve.reference.ReferenceProvidersRegistryImpl;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CachedValuesManagerImpl;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.KeyedLazyInstance;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.text.CharArrayCharSequence;
import com.jetbrains.python.PythonDialectsTokenSetContributor;
import com.jetbrains.python.PythonFileType;
import com.jetbrains.python.PythonLanguage;
import com.jetbrains.python.PythonParserDefinition;
import com.jetbrains.python.PythonTokenSetContributor;
import com.jetbrains.python.documentation.doctest.PyDocstringTokenSetContributor;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyPsiFacade;
import com.jetbrains.python.psi.impl.PyPsiFacadeImpl;
import com.jetbrains.python.psi.impl.PythonASTFactory;
import com.jetbrains.python.psi.impl.PythonLanguageLevelPusher;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.stream.Stream;
import javax.swing.Icon;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.MutablePicoContainer;

public class IntelliJUtils {
    private static <T> void registerExtensionPoint(PluginDescriptor pluginDescriptor, Application app, @NotNull ExtensionPointName<T> extensionPointName, @NotNull Class<T> aClass) {
        IntelliJUtils.registerExtensionPoint(pluginDescriptor, (ExtensionsAreaImpl)app.getExtensionArea(), extensionPointName, aClass);
    }

    private static <T> ExtensionPointImpl<T> registerExtensionPoint(@NotNull PluginDescriptor pluginDescriptor, @NotNull ExtensionsAreaImpl extensionArea, @NotNull BaseExtensionPointName<T> extensionPointName, @NotNull Class<T> extensionClass) {
        String name = extensionPointName.getName();
        if (extensionArea.hasExtensionPoint(name)) {
            return extensionArea.getExtensionPoint(name);
        }
        return extensionArea.registerPoint(name, extensionClass, pluginDescriptor, false);
    }

    private static <T> void registerExtension(@NotNull PluginDescriptor pluginDescriptor, @NotNull Application app, @NotNull ExtensionPointName<T> name, @NotNull T extension) {
        IntelliJUtils.registerExtensions(pluginDescriptor, app, name, extension.getClass(), Collections.singletonList(extension));
    }

    private static <T> void registerExtensions(@NotNull PluginDescriptor pluginDescriptor, @NotNull Application app, @NotNull ExtensionPointName<T> name, @NotNull Class<T> extensionClass, @NotNull List<? extends T> extensions) {
        ExtensionsAreaImpl area = (ExtensionsAreaImpl)app.getExtensionArea();
        ExtensionPointImpl<T> point = area.getExtensionPointIfRegistered(name.getName());
        if (point == null) {
            point = IntelliJUtils.registerExtensionPoint(pluginDescriptor, area, name, extensionClass);
        }
        for (T extension : extensions) {
            point.registerExtension(extension);
        }
    }

    private static <T> void addExplicitExtension(@NotNull PluginDescriptor pluginDescriptor, @NotNull Application app, @NotNull LanguageExtension<T> collector, @NotNull Language language, @NotNull T object) {
        ExtensionsAreaImpl area = (ExtensionsAreaImpl)app.getExtensionArea();
        if (!area.hasExtensionPoint(collector.getName())) {
            area.registerFakeBeanPoint(collector.getName(), pluginDescriptor);
        }
        LanguageExtensionPoint<T> extension = new LanguageExtensionPoint<T>(language.getID(), object);
        extension.setPluginDescriptor(pluginDescriptor);
        IntelliJUtils.addExtension(area, collector, extension);
    }

    private static <T, BEAN_TYPE extends KeyedLazyInstance<T>, KeyT> void addExtension(ExtensionsAreaImpl area, KeyedExtensionCollector<T, KeyT> collector, BEAN_TYPE bean) {
        ExtensionPoint point = area.getExtensionPoint(collector.getName());
        ((ExtensionPointImpl)point).registerExtension(bean);
        collector.clearCache();
    }

    private static void registerParserDefinition(@NotNull ExtensionPointImpl<KeyedLazyInstance<ParserDefinition>> languageParserDefinition, final @NotNull ParserDefinition definition) {
        final Language language = definition.getFileNodeType().getLanguage();
        languageParserDefinition.registerExtension(new KeyedLazyInstance(){

            @Override
            public String getKey() {
                return language.getID();
            }

            @NotNull
            public ParserDefinition getInstance() {
                return definition;
            }
        });
        LanguageParserDefinitions.INSTANCE.clearCache(language);
    }

    @org.openrewrite.internal.lang.Nullable
    public static PyFile parsePythonSource(String filename, String sourceText, LanguageLevel languageLevel) {
        Disposable disposable = () -> {};
        MockApplication app = MockApplication.setUp(disposable);
        MutablePicoContainer appContainer = app.getPicoContainer();
        ComponentAdapter component = appContainer.getComponentAdapter(ProgressManager.class.getName());
        if (component == null) {
            appContainer.registerComponentInstance(ProgressManager.class.getName(), new ProgressManagerImpl());
        }
        MockProject project = new MockProject(appContainer, disposable);
        MockPsiManager psiManager = new MockPsiManager(project);
        IntelliJUtils.configureProjectServices(project, psiManager);
        appContainer.registerComponentInstance(MessageBus.class, app.getMessageBus());
        appContainer.registerComponentInstance(SchemeManagerFactory.class, new MockSchemeManagerFactory());
        MockEditorFactory editorFactory = new MockEditorFactory();
        appContainer.registerComponentInstance(EditorFactory.class, editorFactory);
        app.registerService(FileDocumentManager.class, new MockFileDocumentManagerImpl(FileDocumentManagerBase.HARD_REF_TO_DOCUMENT_KEY, editorFactory::createDocument));
        app.registerService(PluginUtil.class, new PluginUtilImpl());
        app.registerService(PsiBuilderFactory.class, new PsiBuilderFactoryImpl());
        app.registerService(DefaultASTFactory.class, new DefaultASTFactoryImpl());
        app.registerService(ReferenceProvidersRegistry.class, new ReferenceProvidersRegistryImpl());
        DefaultPluginDescriptor pluginDescriptor = new DefaultPluginDescriptor("io.moderne.test");
        IntelliJUtils.registerExtensionPoint((PluginDescriptor)pluginDescriptor, app.getExtensionArea(), FileTypeFactory.FILE_TYPE_FACTORY_EP, FileTypeFactory.class);
        IntelliJUtils.registerExtensionPoint((PluginDescriptor)pluginDescriptor, app.getExtensionArea(), MetaLanguage.EP_NAME, MetaLanguage.class);
        IntelliJUtils.registerExtensionPoint((PluginDescriptor)pluginDescriptor, app, PythonDialectsTokenSetContributor.EP_NAME, PythonDialectsTokenSetContributor.class);
        IntelliJUtils.registerExtension(pluginDescriptor, app, PythonDialectsTokenSetContributor.EP_NAME, new PythonTokenSetContributor());
        IntelliJUtils.registerExtension(pluginDescriptor, app, PythonDialectsTokenSetContributor.EP_NAME, new PyDocstringTokenSetContributor());
        IntelliJUtils.addExplicitExtension(pluginDescriptor, app, LanguageASTFactory.INSTANCE, PythonLanguage.getInstance(), new PythonASTFactory());
        ExtensionPointImpl<KeyedLazyInstance<ParserDefinition>> langParserDefinition = app.getExtensionArea().registerFakeBeanPoint(LanguageParserDefinitions.INSTANCE.getName(), pluginDescriptor);
        PythonParserDefinition pythonParserDefinition = new PythonParserDefinition();
        String fileExt = "py";
        @NotNull Language language = pythonParserDefinition.getFileNodeType().getLanguage();
        IntelliJUtils.registerParserDefinition(langParserDefinition, pythonParserDefinition);
        app.registerService(FileTypeManager.class, new MockFileTypeManager(new MockLanguageFileType(language, fileExt)));
        Registry.markAsLoaded();
        LightVirtualFile lv = new LightVirtualFile(filename, (FileType)PythonFileType.INSTANCE, (CharSequence)sourceText);
        PythonLanguageLevelPusher.specifyFileLanguageLevel(lv, languageLevel);
        SingleRootFileViewProvider fileViewProvider = new SingleRootFileViewProvider(psiManager, lv);
        return (PyFile)fileViewProvider.getPsi(PythonLanguage.INSTANCE);
    }

    static void configureProjectServices(MockProject project, PsiManager psiManager) {
        project.registerService(PsiManager.class, psiManager);
        project.registerService(PyPsiFacade.class, PyPsiFacadeImpl.class);
        project.registerService(PsiDocumentManager.class, new MockPsiDocumentManager());
        project.registerService(TreeAspect.class, new TreeAspect());
        project.registerService(CachedValuesManager.class, new CachedValuesManagerImpl(project, new PsiCachedValuesFactory(project)));
        project.registerService(StartupManager.class, new StartupManagerImpl(project));
        project.registerService(PomModel.class, new PomModelImpl(project));
    }

    static class MockSchemeManagerFactory
    extends SchemeManagerFactory {
        MockSchemeManagerFactory() {
        }

        @Override
        @NotNull
        public <SCHEME extends Scheme, MUTABLE_SCHEME extends SCHEME> SchemeManager<SCHEME> create(@NotNull String s, @NotNull SchemeProcessor<SCHEME, ? super MUTABLE_SCHEME> schemeProcessor, @Nullable String s1, @NotNull RoamingType roamingType, @NotNull Function1<? super String, String> function1, @Nullable StreamProvider streamProvider, @Nullable Path path, boolean b, @NotNull SettingsCategory settingsCategory) {
            return new EmptySchemesManager();
        }
    }

    static class MockEditorFactory
    extends EditorFactory {
        MockEditorFactory() {
        }

        public Document createDocument(String text) {
            return new DocumentImpl(text);
        }

        @Override
        public Editor createEditor(@NotNull Document document) {
            return null;
        }

        @Override
        public Editor createViewer(@NotNull Document document) {
            return null;
        }

        @Override
        public Editor createEditor(@NotNull Document document, Project project) {
            return null;
        }

        @Override
        public Editor createEditor(@NotNull Document document, @Nullable Project project, @Nullable EditorKind kind) {
            return null;
        }

        @Override
        public Editor createEditor(@NotNull Document document, Project project, @NotNull VirtualFile file, boolean isViewer) {
            return null;
        }

        @Override
        public Editor createEditor(@NotNull Document document, Project project, @NotNull VirtualFile file, boolean isViewer, @NotNull EditorKind kind) {
            return null;
        }

        @Override
        public Editor createEditor(@NotNull Document document, Project project, @NotNull FileType fileType, boolean isViewer) {
            return null;
        }

        @Override
        public Editor createViewer(@NotNull Document document, Project project) {
            return null;
        }

        @Override
        public Editor createViewer(@NotNull Document document, @Nullable Project project, @Nullable EditorKind kind) {
            return null;
        }

        @Override
        public void releaseEditor(@NotNull Editor editor) {
        }

        @Override
        @NotNull
        public Stream<Editor> editors(@NotNull Document document, @Nullable Project project) {
            return Stream.empty();
        }

        @Override
        public Editor @NotNull [] getAllEditors() {
            return Editor.EMPTY_ARRAY;
        }

        @Override
        public void addEditorFactoryListener(@NotNull EditorFactoryListener listener) {
        }

        @Override
        public void addEditorFactoryListener(@NotNull EditorFactoryListener listener, @NotNull Disposable parentDisposable) {
        }

        @Override
        public void removeEditorFactoryListener(@NotNull EditorFactoryListener listener) {
        }

        @Override
        @NotNull
        public EditorEventMulticaster getEventMulticaster() {
            return new MockEditorEventMulticaster();
        }

        @Override
        @NotNull
        public Document createDocument(@NotNull CharSequence text) {
            return new DocumentImpl(text);
        }

        @Override
        @NotNull
        public Document createDocument(char @NotNull [] text) {
            return this.createDocument(new CharArrayCharSequence(text));
        }

        @Override
        public void refreshAllEditors() {
        }
    }

    static class MockFileTypeManager
    extends FileTypeManagerEx {
        private final FileType fileType;

        public MockFileTypeManager(FileType fileType) {
            this.fileType = fileType;
        }

        @Override
        public void freezeFileTypeTemporarilyIn(@NotNull VirtualFile file, @NotNull Runnable runnable) {
        }

        @Override
        @NotNull
        public String getIgnoredFilesList() {
            throw new IncorrectOperationException();
        }

        @Override
        public void setIgnoredFilesList(@NotNull String list) {
        }

        @Override
        public boolean isIgnoredFilesListEqualToCurrent(@NotNull String list) {
            return false;
        }

        public void save() {
        }

        @Override
        @NotNull
        public String getExtension(@NotNull String fileName) {
            return "";
        }

        @Override
        public void registerFileType(@NotNull FileType type, String ... defaultAssociatedExtensions) {
        }

        @Override
        public void fireFileTypesChanged() {
        }

        @Override
        @NotNull
        public FileType getFileTypeByFileName(@NotNull String fileName) {
            return this.fileType;
        }

        @Override
        @NotNull
        public FileType getFileTypeByFile(@NotNull VirtualFile file) {
            return this.fileType;
        }

        @Override
        @NotNull
        public FileType getFileTypeByExtension(@NotNull String extension) {
            return this.fileType;
        }

        @Override
        public FileType @NotNull [] getRegisteredFileTypes() {
            return FileType.EMPTY_ARRAY;
        }

        @Override
        public boolean isFileIgnored(@NotNull String name) {
            return false;
        }

        @Override
        public boolean isFileIgnored(@NotNull VirtualFile file) {
            return false;
        }

        @Override
        public String @NotNull [] getAssociatedExtensions(@NotNull FileType type) {
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }

        @Override
        public void fireBeforeFileTypesChanged() {
        }

        @Override
        public void makeFileTypesChange(@NotNull String message, @NotNull Runnable command) {
            command.run();
        }

        @Override
        public FileType getKnownFileTypeOrAssociate(@NotNull VirtualFile file, @NotNull Project project) {
            return file.getFileType();
        }

        @Override
        @NotNull
        public List<FileNameMatcher> getAssociations(@NotNull FileType type) {
            return Collections.emptyList();
        }

        @Override
        public void associate(@NotNull FileType type, @NotNull FileNameMatcher matcher) {
        }

        @Override
        public void removeAssociation(@NotNull FileType type, @NotNull FileNameMatcher matcher) {
        }

        @Override
        @NotNull
        public FileType getStdFileType(@NotNull String fileTypeName) {
            if ("ARCHIVE".equals(fileTypeName)) {
                return UnknownFileType.INSTANCE;
            }
            if ("PLAIN_TEXT".equals(fileTypeName)) {
                return PlainTextFileType.INSTANCE;
            }
            if ("CLASS".equals(fileTypeName)) {
                return MockFileTypeManager.loadFileTypeSafe("com.intellij.ide.highlighter.JavaClassFileType", fileTypeName);
            }
            if ("JAVA".equals(fileTypeName)) {
                return MockFileTypeManager.loadFileTypeSafe("com.intellij.ide.highlighter.JavaFileType", fileTypeName);
            }
            if ("XML".equals(fileTypeName)) {
                return MockFileTypeManager.loadFileTypeSafe("com.intellij.ide.highlighter.XmlFileType", fileTypeName);
            }
            if ("DTD".equals(fileTypeName)) {
                return MockFileTypeManager.loadFileTypeSafe("com.intellij.ide.highlighter.DTDFileType", fileTypeName);
            }
            if ("JSP".equals(fileTypeName)) {
                return MockFileTypeManager.loadFileTypeSafe("com.intellij.ide.highlighter.NewJspFileType", fileTypeName);
            }
            if ("JSPX".equals(fileTypeName)) {
                return MockFileTypeManager.loadFileTypeSafe("com.intellij.ide.highlighter.JspxFileType", fileTypeName);
            }
            if ("HTML".equals(fileTypeName)) {
                return MockFileTypeManager.loadFileTypeSafe("com.intellij.ide.highlighter.HtmlFileType", fileTypeName);
            }
            if ("XHTML".equals(fileTypeName)) {
                return MockFileTypeManager.loadFileTypeSafe("com.intellij.ide.highlighter.XHtmlFileType", fileTypeName);
            }
            if ("JavaScript".equals(fileTypeName)) {
                return MockFileTypeManager.loadFileTypeSafe("com.intellij.lang.javascript.JavaScriptFileType", fileTypeName);
            }
            if ("Properties".equals(fileTypeName)) {
                return MockFileTypeManager.loadFileTypeSafe("com.intellij.lang.properties.PropertiesFileType", fileTypeName);
            }
            if ("GUI_DESIGNER_FORM".equals(fileTypeName)) {
                return MockFileTypeManager.loadFileTypeSafe("com.intellij.uiDesigner.GuiFormFileType", fileTypeName);
            }
            return new MockLanguageFileType((Language)PlainTextLanguage.INSTANCE, fileTypeName.toLowerCase(Locale.ENGLISH));
        }

        private static FileType loadFileTypeSafe(String className, String fileTypeName) {
            try {
                return (FileType)Class.forName(className).getField("INSTANCE").get(null);
            }
            catch (Exception ignored) {
                return new MockLanguageFileType((Language)PlainTextLanguage.INSTANCE, fileTypeName.toLowerCase(Locale.ENGLISH));
            }
        }

        @Override
        @Nullable
        public FileType findFileTypeByName(@NotNull String fileTypeName) {
            return null;
        }
    }

    static class MockLanguageFileType
    extends LanguageFileType {
        private final String myExtension;

        public MockLanguageFileType(@NotNull Language language, String extension) {
            super(language);
            this.myExtension = extension;
        }

        @Override
        @NotNull
        public String getName() {
            return this.getLanguage().getID();
        }

        @Override
        @NotNull
        public String getDescription() {
            return "";
        }

        @Override
        @NotNull
        public String getDefaultExtension() {
            return this.myExtension;
        }

        @Override
        public Icon getIcon() {
            return null;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof LanguageFileType)) {
                return false;
            }
            return this.getLanguage().equals(((LanguageFileType)obj).getLanguage());
        }
    }

    static class MockPsiDocumentManager
    extends PsiDocumentManager {
        MockPsiDocumentManager() {
        }

        @Override
        @Nullable
        public PsiFile getPsiFile(@NotNull Document document) {
            throw new UnsupportedOperationException("Method getPsiFile is not yet implemented in " + this.getClass().getName());
        }

        @Override
        @Nullable
        public PsiFile getCachedPsiFile(@NotNull Document document) {
            throw new UnsupportedOperationException("Method getCachedPsiFile is not yet implemented in " + this.getClass().getName());
        }

        @Override
        @Nullable
        public Document getDocument(@NotNull PsiFile file) {
            return null;
        }

        @Override
        @Nullable
        public Document getCachedDocument(@NotNull PsiFile file) {
            VirtualFile vFile = file.getViewProvider().getVirtualFile();
            return FileDocumentManager.getInstance().getCachedDocument(vFile);
        }

        @Override
        public void commitAllDocuments() {
        }

        @Override
        public boolean commitAllDocumentsUnderProgress() {
            return true;
        }

        @Override
        public void performForCommittedDocument(@NotNull Document document, @NotNull Runnable action) {
            action.run();
        }

        @Override
        public void commitDocument(@NotNull Document document) {
        }

        @Override
        @NotNull
        public CharSequence getLastCommittedText(@NotNull Document document) {
            return document.getImmutableCharSequence();
        }

        @Override
        public long getLastCommittedStamp(@NotNull Document document) {
            return document.getModificationStamp();
        }

        @Override
        @Nullable
        public Document getLastCommittedDocument(@NotNull PsiFile file) {
            return null;
        }

        @Override
        public Document @NotNull [] getUncommittedDocuments() {
            throw new UnsupportedOperationException("Method getUncommittedDocuments is not yet implemented in " + this.getClass().getName());
        }

        @Override
        public boolean isUncommited(@NotNull Document document) {
            throw new UnsupportedOperationException("Method isUncommited is not yet implemented in " + this.getClass().getName());
        }

        @Override
        public boolean isCommitted(@NotNull Document document) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasUncommitedDocuments() {
            throw new UnsupportedOperationException("Method hasUncommitedDocuments is not yet implemented in " + this.getClass().getName());
        }

        @Override
        public void commitAndRunReadAction(@NotNull Runnable runnable) {
            throw new UnsupportedOperationException("Method commitAndRunReadAction is not yet implemented in " + this.getClass().getName());
        }

        @Override
        public <T> T commitAndRunReadAction(@NotNull Computable<T> computation) {
            throw new UnsupportedOperationException("Method commitAndRunReadAction is not yet implemented in " + this.getClass().getName());
        }

        @Override
        public void addListener(@NotNull PsiDocumentManager.Listener listener) {
            throw new UnsupportedOperationException("Method addListener is not yet implemented in " + this.getClass().getName());
        }

        @Override
        public boolean isDocumentBlockedByPsi(@NotNull Document doc) {
            throw new UnsupportedOperationException("Method isDocumentBlockedByPsi is not yet implemented in " + this.getClass().getName());
        }

        @Override
        public void doPostponedOperationsAndUnblockDocument(@NotNull Document doc) {
            throw new UnsupportedOperationException("Method doPostponedOperationsAndUnblockDocument is not yet implemented in " + this.getClass().getName());
        }

        @Override
        public boolean performWhenAllCommitted(@NotNull Runnable action) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void reparseFiles(@NotNull Collection<? extends VirtualFile> files, boolean includeOpenFiles) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void performLaterWhenAllCommitted(@NotNull Runnable runnable) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void performLaterWhenAllCommitted(@NotNull ModalityState modalityState, @NotNull Runnable runnable) {
            throw new UnsupportedOperationException();
        }
    }

    public static class PsiPrinter {
        private int depth;

        private String indent() {
            StringBuilder indent = new StringBuilder();
            for (int i = 0; i < this.depth; ++i) {
                indent.append("  ");
            }
            return indent.toString();
        }

        public void print(ASTNode node) {
            StringBuilder output = new StringBuilder();
            output.append(this.indent()).append(node).append(" [start=").append(node.getStartOffset()).append(", psi=").append(node.getPsi().getClass().getSimpleName());
            if (node instanceof LeafPsiElement) {
                output.append(", text=`").append(node.getText().replace("\n", "\\n").replace("\t", "\\t")).append("`");
            }
            output.append("]");
            System.out.println(output);
            ++this.depth;
            for (ASTNode child : node.getChildren(null)) {
                this.print(child);
            }
            --this.depth;
        }
    }

    static class MockEditorEventMulticaster
    implements EditorEventMulticaster {
        @Override
        public void addDocumentListener(@NotNull DocumentListener listener) {
        }

        @Override
        public void addDocumentListener(@NotNull DocumentListener listener, @NotNull Disposable parentDisposable) {
        }

        @Override
        public void removeDocumentListener(@NotNull DocumentListener listener) {
        }

        @Override
        public void addEditorMouseListener(@NotNull EditorMouseListener listener) {
        }

        @Override
        public void addEditorMouseListener(@NotNull EditorMouseListener listener, @NotNull Disposable parentDisposable) {
        }

        @Override
        public void removeEditorMouseListener(@NotNull EditorMouseListener listener) {
        }

        @Override
        public void addEditorMouseMotionListener(@NotNull EditorMouseMotionListener listener) {
        }

        @Override
        public void addEditorMouseMotionListener(@NotNull EditorMouseMotionListener listener, @NotNull Disposable parentDisposable) {
        }

        @Override
        public void removeEditorMouseMotionListener(@NotNull EditorMouseMotionListener listener) {
        }

        @Override
        public void addCaretListener(@NotNull CaretListener listener) {
        }

        @Override
        public void addCaretListener(@NotNull CaretListener listener, @NotNull Disposable parentDisposable) {
        }

        @Override
        public void removeCaretListener(@NotNull CaretListener listener) {
        }

        @Override
        public void addSelectionListener(@NotNull SelectionListener listener) {
        }

        @Override
        public void addSelectionListener(@NotNull SelectionListener listener, @NotNull Disposable parentDisposable) {
        }

        @Override
        public void removeSelectionListener(@NotNull SelectionListener listener) {
        }

        @Override
        public void addVisibleAreaListener(@NotNull VisibleAreaListener listener) {
        }

        @Override
        public void addVisibleAreaListener(@NotNull VisibleAreaListener listener, @NotNull Disposable parent) {
        }

        @Override
        public void removeVisibleAreaListener(@NotNull VisibleAreaListener listener) {
        }
    }
}

