/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubElementTypeHolderEP;
import com.intellij.psi.stubs.StubFieldAccessor;
import com.intellij.psi.stubs.StubSerializer;
import com.intellij.psi.tree.IElementType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class IStubElementType<StubT extends StubElement<?>, PsiT extends PsiElement>
extends IElementType
implements StubSerializer<StubT> {
    private static final Set<String> NOT_INITIALIZED_SET = Collections.unmodifiableSet(new HashSet(0));
    private static volatile Set<String> ourLazyExternalIds = NOT_INITIALIZED_SET;

    public IStubElementType(@NotNull @NonNls String debugName, @Nullable Language language) {
        if (debugName == null) {
            IStubElementType.$$$reportNull$$$0(0);
        }
        super(debugName, language);
        if (!this.isLazilyRegistered()) {
            this.checkNotInstantiatedTooLateWithId(this.getClass());
        }
    }

    public static void checkNotInstantiatedTooLate(@NotNull Class<?> aClass) {
        if (aClass == null) {
            IStubElementType.$$$reportNull$$$0(1);
        }
        if (IStubElementType.isInitialized()) {
            Logger.getInstance(IStubElementType.class).error("All stub element types should be created before index initialization is complete.\nPlease add the " + aClass + " containing stub element type constants to \"stubElementTypeHolder\" extension.\nRegistered extensions: " + StubElementTypeHolderEP.EP_NAME.getExtensionList());
        }
    }

    private void checkNotInstantiatedTooLateWithId(@NotNull Class<?> aClass) {
        if (aClass == null) {
            IStubElementType.$$$reportNull$$$0(2);
        }
        if (IStubElementType.isInitialized()) {
            Logger.getInstance(IStubElementType.class).error("All stub element types should be created before index initialization is complete.\nPlease add the " + aClass + " with external ID " + this.getExternalId() + " containing stub element type constants to \"stubElementTypeHolder\" extension.\nRegistered extensions: " + StubElementTypeHolderEP.EP_NAME.getExtensionList() + "\nRegistered lazy ids: " + ourLazyExternalIds);
        }
    }

    private static boolean isInitialized() {
        return ourLazyExternalIds != NOT_INITIALIZED_SET;
    }

    private boolean isLazilyRegistered() {
        try {
            return ourLazyExternalIds.contains(this.getExternalId());
        }
        catch (Throwable e) {
            return false;
        }
    }

    static void dropRegisteredTypes() {
        ourLazyExternalIds = NOT_INITIALIZED_SET;
    }

    @NotNull
    static List<StubFieldAccessor> loadRegisteredStubElementTypes() {
        ArrayList<StubFieldAccessor> result = new ArrayList<StubFieldAccessor>();
        ArrayList<String> debugStr = new ArrayList<String>();
        StubElementTypeHolderEP.EP_NAME.processWithPluginDescriptor((bean, pluginDescriptor) -> {
            int accessorCount = bean.initializeOptimized(pluginDescriptor, result);
            debugStr.add(accessorCount + " in " + bean.holderClass);
        });
        Logger.getInstance(IStubElementType.class).debug("Lazy stub element types loaded: " + StringUtil.join(debugStr, ", "));
        HashSet<String> lazyIds = new HashSet<String>(result.size());
        for (StubFieldAccessor accessor : result) {
            lazyIds.add(accessor.externalId);
        }
        ourLazyExternalIds = Collections.unmodifiableSet(lazyIds);
        ArrayList<StubFieldAccessor> arrayList = result;
        if (arrayList == null) {
            IStubElementType.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    public abstract PsiT createPsi(@NotNull StubT var1);

    @NotNull
    public abstract StubT createStub(@NotNull PsiT var1, StubElement<? extends PsiElement> var2);

    public boolean shouldCreateStub(ASTNode node) {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugName";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/stubs/IStubElementType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/stubs/IStubElementType";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "loadRegisteredStubElementTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "checkNotInstantiatedTooLate";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "checkNotInstantiatedTooLateWithId";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

