/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.python.format;

import java.util.List;
import org.openrewrite.Incubating;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.java.tree.Comment;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JContainer;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.python.PythonIsoVisitor;

@Incubating(since="0.3.1")
public class PythonSpacesVisitor<P>
extends PythonIsoVisitor<P> {
    public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, P p) {
        J.MethodDeclaration m = (J.MethodDeclaration)super.visitMethodDeclaration(method, p);
        boolean styleBeforeMethodDeclarationParentheses = false;
        if ((m = m.getPadding().withParameters(this.spaceBefore((J)m.getPadding().getParameters(), styleBeforeMethodDeclarationParentheses))).getParameters().isEmpty() || m.getParameters().iterator().next() instanceof J.Empty) {
            boolean useSpace = false;
            m = m.getPadding().withParameters(m.getPadding().getParameters().getPadding().withElements(ListUtils.map((List)m.getPadding().getParameters().getPadding().getElements(), param -> param.withElement((Object)this.spaceBefore((Statement)param.getElement(), useSpace)))));
        } else {
            int paramsSize = m.getParameters().size();
            boolean useSpace = false;
            m = m.getPadding().withParameters(m.getPadding().getParameters().getPadding().withElements(ListUtils.map((List)m.getPadding().getParameters().getPadding().getElements(), (index, param) -> {
                if (index == 0) {
                    param = param.withElement((Object)this.spaceBefore((Statement)param.getElement(), useSpace));
                } else {
                    boolean spaceAfterComma = true;
                    param = param.withElement((Object)this.spaceBefore((Statement)param.getElement(), spaceAfterComma));
                }
                if (index == paramsSize - 1) {
                    param = this.spaceAfter((JRightPadded)param, useSpace);
                } else {
                    boolean spaceBeforeComma = false;
                    param = this.spaceAfter((JRightPadded)param, spaceBeforeComma);
                }
                return param;
            })));
        }
        return m;
    }

    <T> JContainer<T> spaceBefore(JContainer<T> container, boolean spaceBefore) {
        if (!container.getBefore().getComments().isEmpty()) {
            List<Comment> comments = PythonSpacesVisitor.spaceLastCommentSuffix(container.getBefore().getComments(), spaceBefore);
            return container.withBefore(container.getBefore().withComments(comments));
        }
        if (spaceBefore && PythonSpacesVisitor.notSingleSpace(container.getBefore().getWhitespace()) && PythonSpacesVisitor.doesNotContainNewLine(container.getBefore().getWhitespace())) {
            return container.withBefore(container.getBefore().withWhitespace(" "));
        }
        if (!spaceBefore && PythonSpacesVisitor.onlySpacesAndNotEmpty(container.getBefore().getWhitespace()) && PythonSpacesVisitor.doesNotContainNewLine(container.getBefore().getWhitespace())) {
            return container.withBefore(container.getBefore().withWhitespace(""));
        }
        return container;
    }

    private static List<Comment> spaceLastCommentSuffix(List<Comment> comments, boolean spaceSuffix) {
        return ListUtils.mapLast(comments, comment -> PythonSpacesVisitor.spaceSuffix(comment, spaceSuffix));
    }

    private static Comment spaceSuffix(Comment comment, boolean spaceSuffix) {
        if (spaceSuffix && PythonSpacesVisitor.notSingleSpace(comment.getSuffix()) && PythonSpacesVisitor.doesNotContainNewLine(comment.getSuffix())) {
            return comment.withSuffix(" ");
        }
        if (!spaceSuffix && PythonSpacesVisitor.onlySpacesAndNotEmpty(comment.getSuffix()) && PythonSpacesVisitor.doesNotContainNewLine(comment.getSuffix())) {
            return comment.withSuffix("");
        }
        return comment;
    }

    <T extends J> T spaceBefore(T j, boolean spaceBefore) {
        if (!j.getComments().isEmpty()) {
            return j;
        }
        if (spaceBefore && PythonSpacesVisitor.notSingleSpace(j.getPrefix().getWhitespace()) && PythonSpacesVisitor.doesNotContainNewLine(j.getPrefix().getWhitespace())) {
            return (T)j.withPrefix(j.getPrefix().withWhitespace(" "));
        }
        if (!spaceBefore && PythonSpacesVisitor.onlySpacesAndNotEmpty(j.getPrefix().getWhitespace()) && PythonSpacesVisitor.doesNotContainNewLine(j.getPrefix().getWhitespace())) {
            return (T)j.withPrefix(j.getPrefix().withWhitespace(""));
        }
        return j;
    }

    <T extends J> JRightPadded<T> spaceAfter(JRightPadded<T> container, boolean spaceAfter) {
        if (!container.getAfter().getComments().isEmpty()) {
            List<Comment> comments = PythonSpacesVisitor.spaceLastCommentSuffix(container.getAfter().getComments(), spaceAfter);
            return container.withAfter(container.getAfter().withComments(comments));
        }
        if (spaceAfter && PythonSpacesVisitor.notSingleSpace(container.getAfter().getWhitespace()) && PythonSpacesVisitor.doesNotContainNewLine(container.getAfter().getWhitespace())) {
            return container.withAfter(container.getAfter().withWhitespace(" "));
        }
        if (!spaceAfter && PythonSpacesVisitor.onlySpacesAndNotEmpty(container.getAfter().getWhitespace()) && PythonSpacesVisitor.doesNotContainNewLine(container.getAfter().getWhitespace())) {
            return container.withAfter(container.getAfter().withWhitespace(""));
        }
        return container;
    }

    private static boolean onlySpaces(String s) {
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == ' ' || c == '\t') continue;
            return false;
        }
        return true;
    }

    private static boolean onlySpacesAndNotEmpty(String s) {
        return !StringUtils.isNullOrEmpty((String)s) && PythonSpacesVisitor.onlySpaces(s);
    }

    private static boolean notSingleSpace(String str) {
        return PythonSpacesVisitor.onlySpaces(str) && !" ".equals(str);
    }

    private static boolean doesNotContainNewLine(String str) {
        return !str.contains("\n");
    }
}

