/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.json.internal;

import java.util.List;
import java.util.function.UnaryOperator;
import org.openrewrite.Cursor;
import org.openrewrite.PrintOutputCapture;
import org.openrewrite.json.JsonVisitor;
import org.openrewrite.json.tree.Comment;
import org.openrewrite.json.tree.Json;
import org.openrewrite.json.tree.JsonRightPadded;
import org.openrewrite.json.tree.Space;
import org.openrewrite.marker.Marker;
import org.openrewrite.marker.Markers;

public class JsonPrinter<P>
extends JsonVisitor<PrintOutputCapture<P>> {
    private static final UnaryOperator<String> JSON_MARKER_WRAPPER = out -> "/*~~" + out + (out.isEmpty() ? "" : "~~") + ">*/";

    @Override
    public Json visitArray(Json.Array array, PrintOutputCapture<P> p) {
        this.beforeSyntax(array, p);
        p.append('[');
        this.visitRightPadded(array.getPadding().getValues(), ",", p);
        p.append(']');
        this.afterSyntax(array, p);
        return array;
    }

    @Override
    public Json visitDocument(Json.Document document, PrintOutputCapture<P> p) {
        this.beforeSyntax(document, p);
        this.visit(document.getValue(), p);
        this.visitSpace(document.getEof(), p);
        this.afterSyntax(document, p);
        return document;
    }

    @Override
    public Json visitEmpty(Json.Empty empty, PrintOutputCapture<P> p) {
        this.beforeSyntax(empty, p);
        this.afterSyntax(empty, p);
        return empty;
    }

    @Override
    public Json visitIdentifier(Json.Identifier ident, PrintOutputCapture<P> p) {
        this.beforeSyntax(ident, p);
        p.append(ident.getName());
        this.afterSyntax(ident, p);
        return ident;
    }

    @Override
    public Json visitLiteral(Json.Literal literal, PrintOutputCapture<P> p) {
        this.beforeSyntax(literal, p);
        p.append(literal.getSource());
        this.afterSyntax(literal, p);
        return literal;
    }

    @Override
    public Json visitMember(Json.Member member, PrintOutputCapture<P> p) {
        this.beforeSyntax(member, p);
        this.visitRightPadded(member.getPadding().getKey(), p);
        p.append(':');
        this.visit(member.getValue(), p);
        this.afterSyntax(member, p);
        return member;
    }

    @Override
    public Json visitObject(Json.JsonObject obj, PrintOutputCapture<P> p) {
        this.beforeSyntax(obj, p);
        p.append('{');
        this.visitRightPadded(obj.getPadding().getMembers(), ",", p);
        p.append('}');
        this.afterSyntax(obj, p);
        return obj;
    }

    @Override
    public Space visitSpace(Space space, PrintOutputCapture<P> p) {
        p.append(space.getWhitespace());
        for (Comment comment : space.getComments()) {
            this.visitMarkers(comment.getMarkers(), p);
            if (comment.isMultiline()) {
                p.append("/*").append(comment.getText()).append("*/");
            } else {
                p.append("//").append(comment.getText());
            }
            p.append(comment.getSuffix());
        }
        return space;
    }

    protected void visitRightPadded(List<? extends JsonRightPadded<? extends Json>> nodes, String suffixBetween, PrintOutputCapture<P> p) {
        for (int i = 0; i < nodes.size(); ++i) {
            JsonRightPadded<? extends Json> node = nodes.get(i);
            this.visit(node.getElement(), p);
            this.visitSpace(node.getAfter(), p);
            if (i >= nodes.size() - 1) continue;
            p.append(suffixBetween);
        }
    }

    private void beforeSyntax(Json j, PrintOutputCapture<P> p) {
        this.beforeSyntax(j.getPrefix(), j.getMarkers(), p);
    }

    private void beforeSyntax(Space prefix, Markers markers, PrintOutputCapture<P> p) {
        for (Marker marker : markers.getMarkers()) {
            p.append(p.getMarkerPrinter().beforePrefix(marker, new Cursor(this.getCursor(), (Object)marker), JSON_MARKER_WRAPPER));
        }
        this.visitSpace(prefix, p);
        this.visitMarkers(markers, p);
        for (Marker marker : markers.getMarkers()) {
            p.append(p.getMarkerPrinter().beforeSyntax(marker, new Cursor(this.getCursor(), (Object)marker), JSON_MARKER_WRAPPER));
        }
    }

    private void afterSyntax(Json j, PrintOutputCapture<P> p) {
        this.afterSyntax(j.getMarkers(), p);
    }

    private void afterSyntax(Markers markers, PrintOutputCapture<P> p) {
        for (Marker marker : markers.getMarkers()) {
            p.append(p.getMarkerPrinter().afterSyntax(marker, new Cursor(this.getCursor(), (Object)marker), JSON_MARKER_WRAPPER));
        }
    }
}

