/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.json.internal;

import java.util.List;
import org.openrewrite.PrintOutputCapture;
import org.openrewrite.json.JsonVisitor;
import org.openrewrite.json.tree.Comment;
import org.openrewrite.json.tree.Json;
import org.openrewrite.json.tree.JsonRightPadded;
import org.openrewrite.json.tree.Space;
import org.openrewrite.marker.Marker;
import org.openrewrite.marker.SearchResult;

public class JsonPrinter<P>
extends JsonVisitor<PrintOutputCapture<P>> {
    @Override
    public Json visitArray(Json.Array array, PrintOutputCapture<P> p) {
        this.visitSpace(array.getPrefix(), p);
        this.visitMarkers(array.getMarkers(), p);
        p.out.append('[');
        this.visitRightPadded(array.getPadding().getValues(), ",", p);
        p.out.append(']');
        return array;
    }

    @Override
    public Json visitDocument(Json.Document document, PrintOutputCapture<P> p) {
        this.visitSpace(document.getPrefix(), p);
        this.visitMarkers(document.getMarkers(), p);
        this.visit(document.getValue(), p);
        this.visitSpace(document.getEof(), p);
        return document;
    }

    @Override
    public Json visitEmpty(Json.Empty empty, PrintOutputCapture<P> p) {
        this.visitSpace(empty.getPrefix(), p);
        this.visitMarkers(empty.getMarkers(), p);
        return empty;
    }

    @Override
    public Json visitIdentifier(Json.Identifier ident, PrintOutputCapture<P> p) {
        this.visitSpace(ident.getPrefix(), p);
        this.visitMarkers(ident.getMarkers(), p);
        p.out.append(ident.getName());
        return ident;
    }

    @Override
    public Json visitLiteral(Json.Literal literal, PrintOutputCapture<P> p) {
        this.visitSpace(literal.getPrefix(), p);
        this.visitMarkers(literal.getMarkers(), p);
        p.out.append(literal.getSource());
        return literal;
    }

    @Override
    public Json visitMember(Json.Member member, PrintOutputCapture<P> p) {
        this.visitSpace(member.getPrefix(), p);
        this.visitMarkers(member.getMarkers(), p);
        this.visitRightPadded(member.getPadding().getKey(), p);
        p.out.append(':');
        this.visit(member.getValue(), p);
        return member;
    }

    @Override
    public Json visitObject(Json.JsonObject obj, PrintOutputCapture<P> p) {
        this.visitSpace(obj.getPrefix(), p);
        this.visitMarkers(obj.getMarkers(), p);
        p.out.append('{');
        this.visitRightPadded(obj.getPadding().getMembers(), ",", p);
        p.out.append('}');
        return obj;
    }

    @Override
    public Space visitSpace(Space space, PrintOutputCapture<P> p) {
        p.out.append(space.getWhitespace());
        for (Comment comment : space.getComments()) {
            this.visitMarkers(comment.getMarkers(), p);
            if (comment.isMultiline()) {
                p.out.append("/*").append(comment.getText()).append("*/");
            } else {
                p.out.append("//").append(comment.getText());
            }
            p.out.append(comment.getSuffix());
        }
        return space;
    }

    protected void visitRightPadded(List<? extends JsonRightPadded<? extends Json>> nodes, String suffixBetween, PrintOutputCapture<P> p) {
        for (int i = 0; i < nodes.size(); ++i) {
            JsonRightPadded<? extends Json> node = nodes.get(i);
            this.visit(node.getElement(), p);
            this.visitSpace(node.getAfter(), p);
            if (i >= nodes.size() - 1) continue;
            p.out.append(suffixBetween);
        }
    }

    public <M extends Marker> M visitMarker(Marker marker, PrintOutputCapture<P> p) {
        if (marker instanceof SearchResult) {
            String description = ((SearchResult)marker).getDescription();
            p.out.append("/*~~").append(description == null ? "" : "(" + description + ")~~").append(">*/");
        }
        return (M)marker;
    }
}

