/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.javascript.internal.rpc;

import java.util.List;
import java.util.Objects;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Tree;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.NameTree;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TypeTree;
import org.openrewrite.java.tree.TypedTree;
import org.openrewrite.java.tree.VariableDeclarator;
import org.openrewrite.javascript.JavaScriptIsoVisitor;
import org.openrewrite.javascript.tree.JS;
import org.openrewrite.javascript.tree.JSX;

public class JavaScriptValidator<P>
extends JavaScriptIsoVisitor<P> {
    private <T extends Tree> @Nullable T visitAndValidate(@Nullable T tree, Class<? extends Tree> expected, P p) {
        if (tree != null && !expected.isInstance(tree)) {
            throw new ClassCastException("Type " + tree.getClass() + " is not assignable to " + expected);
        }
        return (T)this.visit(tree, p);
    }

    private <T extends Tree> T visitAndValidateNonNull(@Nullable T tree, Class<? extends Tree> expected, P p) {
        Objects.requireNonNull(tree);
        if (!expected.isInstance(tree)) {
            throw new ClassCastException("Type " + tree.getClass() + " is not assignable to " + expected);
        }
        return (T)this.visitNonNull(tree, p);
    }

    private <T extends Tree> @Nullable List<T> visitAndValidate(@Nullable List<T> list, Class<? extends Tree> expected, P p) {
        return list == null ? null : ListUtils.map(list, e -> this.visitAndValidateNonNull(e, expected, p));
    }

    @Override
    public JS.CompilationUnit visitJsCompilationUnit(JS.CompilationUnit compilationUnit, P p) {
        ListUtils.map(compilationUnit.getImports(), el -> this.visitAndValidateNonNull(el, J.Import.class, p));
        ListUtils.map(compilationUnit.getStatements(), el -> this.visitAndValidateNonNull(el, Statement.class, p));
        return compilationUnit;
    }

    @Override
    public JS.Alias visitAlias(JS.Alias alias, P p) {
        this.visitAndValidateNonNull(alias.getPropertyName(), J.Identifier.class, p);
        this.visitAndValidateNonNull(alias.getAlias(), Expression.class, p);
        return alias;
    }

    @Override
    public JS.ArrowFunction visitArrowFunction(JS.ArrowFunction arrowFunction, P p) {
        ListUtils.map(arrowFunction.getLeadingAnnotations(), el -> this.visitAndValidateNonNull(el, J.Annotation.class, p));
        ListUtils.map(arrowFunction.getModifiers(), el -> this.visitAndValidateNonNull(el, J.Modifier.class, p));
        this.visitAndValidate(arrowFunction.getTypeParameters(), J.TypeParameters.class, p);
        this.visitAndValidateNonNull(arrowFunction.getLambda(), J.Lambda.class, p);
        this.visitAndValidate(arrowFunction.getReturnTypeExpression(), TypeTree.class, p);
        return arrowFunction;
    }

    @Override
    public JS.Await visitAwait(JS.Await await, P p) {
        this.visitAndValidateNonNull(await.getExpression(), Expression.class, p);
        return await;
    }

    @Override
    public JS.ConditionalType visitConditionalType(JS.ConditionalType conditionalType, P p) {
        this.visitAndValidateNonNull(conditionalType.getCheckType(), Expression.class, p);
        this.visitAndValidateNonNull(conditionalType.getCondition(), J.Ternary.class, p);
        return conditionalType;
    }

    @Override
    public JS.Delete visitDelete(JS.Delete delete, P p) {
        this.visitAndValidateNonNull(delete.getExpression(), Expression.class, p);
        return delete;
    }

    @Override
    public JS.ExpressionStatement visitExpressionStatement(JS.ExpressionStatement expressionStatement, P p) {
        this.visitAndValidateNonNull(expressionStatement.getExpression(), Expression.class, p);
        return expressionStatement;
    }

    @Override
    public JS.ExpressionWithTypeArguments visitExpressionWithTypeArguments(JS.ExpressionWithTypeArguments expressionWithTypeArguments, P p) {
        this.visitAndValidateNonNull(expressionWithTypeArguments.getClazz(), J.class, p);
        this.visitAndValidate(expressionWithTypeArguments.getTypeArguments(), Expression.class, p);
        return expressionWithTypeArguments;
    }

    @Override
    public JS.FunctionCall visitFunctionCall(JS.FunctionCall functionCall, P p) {
        this.visitAndValidate(functionCall.getFunction(), Expression.class, p);
        this.visitAndValidate(functionCall.getTypeParameters(), Expression.class, p);
        this.visitAndValidate(functionCall.getArguments(), Expression.class, p);
        return functionCall;
    }

    @Override
    public JS.FunctionType visitFunctionType(JS.FunctionType functionType, P p) {
        ListUtils.map(functionType.getModifiers(), el -> this.visitAndValidateNonNull(el, J.Modifier.class, p));
        this.visitAndValidate(functionType.getTypeParameters(), J.TypeParameters.class, p);
        this.visitAndValidate(functionType.getParameters(), Statement.class, p);
        this.visitAndValidateNonNull(functionType.getReturnType(), Expression.class, p);
        return functionType;
    }

    @Override
    public JS.InferType visitInferType(JS.InferType inferType, P p) {
        this.visitAndValidateNonNull(inferType.getTypeParameter(), J.class, p);
        return inferType;
    }

    @Override
    public JS.ImportType visitImportType(JS.ImportType importType, P p) {
        this.visitAndValidate(importType.getArgumentAndAttributes(), J.class, p);
        this.visitAndValidate(importType.getQualifier(), Expression.class, p);
        this.visitAndValidate(importType.getTypeArguments(), Expression.class, p);
        return importType;
    }

    @Override
    public JS.Import visitImportDeclaration(JS.Import import_, P p) {
        this.visitAndValidate(import_.getModifiers(), J.Modifier.class, p);
        this.visitAndValidate(import_.getImportClause(), JS.ImportClause.class, p);
        this.visitAndValidate(import_.getModuleSpecifier(), Expression.class, p);
        this.visitAndValidate(import_.getAttributes(), JS.ImportAttributes.class, p);
        this.visitAndValidate(import_.getInitializer(), Expression.class, p);
        return import_;
    }

    @Override
    public JS.ImportClause visitImportClause(JS.ImportClause importClause, P p) {
        this.visitAndValidate(importClause.getName(), J.Identifier.class, p);
        this.visitAndValidate(importClause.getNamedBindings(), Expression.class, p);
        return importClause;
    }

    @Override
    public JS.NamedImports visitNamedImports(JS.NamedImports namedImports, P p) {
        this.visitAndValidate(namedImports.getElements(), JS.ImportSpecifier.class, p);
        return namedImports;
    }

    @Override
    public JS.ImportSpecifier visitImportSpecifier(JS.ImportSpecifier importSpecifier, P p) {
        this.visitAndValidateNonNull(importSpecifier.getSpecifier(), Expression.class, p);
        return importSpecifier;
    }

    @Override
    public JS.ImportAttributes visitImportAttributes(JS.ImportAttributes importAttributes, P p) {
        this.visitAndValidate(importAttributes.getElements(), Statement.class, p);
        return importAttributes;
    }

    @Override
    public JS.ImportTypeAttributes visitImportTypeAttributes(JS.ImportTypeAttributes importTypeAttributes, P p) {
        this.visitAndValidateNonNull(importTypeAttributes.getToken(), Expression.class, p);
        this.visitAndValidate(importTypeAttributes.getElements(), JS.ImportAttribute.class, p);
        return importTypeAttributes;
    }

    @Override
    public JS.ImportAttribute visitImportAttribute(JS.ImportAttribute importAttribute, P p) {
        this.visitAndValidateNonNull(importAttribute.getName(), Expression.class, p);
        this.visitAndValidateNonNull(importAttribute.getValue(), Expression.class, p);
        return importAttribute;
    }

    @Override
    public JS.Binary visitBinaryExtensions(JS.Binary binary, P p) {
        this.visitAndValidateNonNull(binary.getLeft(), Expression.class, p);
        this.visitAndValidateNonNull(binary.getRight(), Expression.class, p);
        return binary;
    }

    @Override
    public JS.LiteralType visitLiteralType(JS.LiteralType literalType, P p) {
        this.visitAndValidateNonNull(literalType.getLiteral(), Expression.class, p);
        return literalType;
    }

    @Override
    public JS.MappedType visitMappedType(JS.MappedType mappedType, P p) {
        this.visitAndValidate(mappedType.getPrefixToken(), J.Literal.class, p);
        this.visitAndValidateNonNull(mappedType.getKeysRemapping(), JS.MappedType.KeysRemapping.class, p);
        this.visitAndValidate(mappedType.getSuffixToken(), J.Literal.class, p);
        this.visitAndValidate(mappedType.getValueType(), TypeTree.class, p);
        return mappedType;
    }

    @Override
    public JS.MappedType.KeysRemapping visitMappedTypeKeysRemapping(JS.MappedType.KeysRemapping keysRemapping, P p) {
        this.visitAndValidateNonNull(keysRemapping.getTypeParameter(), JS.MappedType.Parameter.class, p);
        this.visitAndValidate(keysRemapping.getNameType(), Expression.class, p);
        return keysRemapping;
    }

    @Override
    public JS.MappedType.Parameter visitMappedTypeParameter(JS.MappedType.Parameter parameter, P p) {
        this.visitAndValidateNonNull(parameter.getName(), Expression.class, p);
        this.visitAndValidateNonNull(parameter.getIterateType(), TypeTree.class, p);
        return parameter;
    }

    @Override
    public JS.ObjectBindingPattern visitObjectBindingPattern(JS.ObjectBindingPattern objectBindingPattern, P p) {
        ListUtils.map(objectBindingPattern.getLeadingAnnotations(), el -> this.visitAndValidateNonNull(el, J.Annotation.class, p));
        ListUtils.map(objectBindingPattern.getModifiers(), el -> this.visitAndValidateNonNull(el, J.Modifier.class, p));
        this.visitAndValidate(objectBindingPattern.getTypeExpression(), TypeTree.class, p);
        this.visitAndValidate(objectBindingPattern.getBindings(), J.class, p);
        this.visitAndValidate(objectBindingPattern.getInitializer(), Expression.class, p);
        return objectBindingPattern;
    }

    @Override
    public JS.PropertyAssignment visitPropertyAssignment(JS.PropertyAssignment propertyAssignment, P p) {
        this.visitAndValidateNonNull(propertyAssignment.getName(), Expression.class, p);
        this.visitAndValidate(propertyAssignment.getInitializer(), Expression.class, p);
        return propertyAssignment;
    }

    @Override
    public JS.SatisfiesExpression visitSatisfiesExpression(JS.SatisfiesExpression satisfiesExpression, P p) {
        this.visitAndValidateNonNull(satisfiesExpression.getExpression(), J.class, p);
        this.visitAndValidateNonNull(satisfiesExpression.getSatisfiesType(), Expression.class, p);
        return satisfiesExpression;
    }

    @Override
    public JS.ScopedVariableDeclarations visitScopedVariableDeclarations(JS.ScopedVariableDeclarations scopedVariableDeclarations, P p) {
        ListUtils.map(scopedVariableDeclarations.getModifiers(), el -> this.visitAndValidateNonNull(el, J.Modifier.class, p));
        ListUtils.map(scopedVariableDeclarations.getVariables(), el -> this.visitAndValidateNonNull(el, J.class, p));
        return scopedVariableDeclarations;
    }

    @Override
    public JS.Shebang visitShebang(JS.Shebang shebang, P p) {
        return shebang;
    }

    @Override
    public JS.Spread visitSpread(JS.Spread spread, P p) {
        this.visitAndValidateNonNull(spread.getExpression(), Expression.class, p);
        return spread;
    }

    @Override
    public JS.StatementExpression visitStatementExpression(JS.StatementExpression statementExpression, P p) {
        this.visitAndValidateNonNull(statementExpression.getStatement(), Statement.class, p);
        return statementExpression;
    }

    @Override
    public JS.WithStatement visitWithStatement(JS.WithStatement withStatement, P p) {
        this.visitAndValidateNonNull((Tree)withStatement.getExpression(), (Class<? extends Tree>)J.ControlParentheses.class, p);
        this.visitAndValidateNonNull(withStatement.getBody(), Statement.class, p);
        return withStatement;
    }

    @Override
    public JS.TaggedTemplateExpression visitTaggedTemplateExpression(JS.TaggedTemplateExpression taggedTemplateExpression, P p) {
        this.visitAndValidate(taggedTemplateExpression.getTag(), Expression.class, p);
        this.visitAndValidate(taggedTemplateExpression.getTypeArguments(), Expression.class, p);
        this.visitAndValidateNonNull(taggedTemplateExpression.getTemplateExpression(), Expression.class, p);
        return taggedTemplateExpression;
    }

    @Override
    public JS.TemplateExpression visitTemplateExpression(JS.TemplateExpression templateExpression, P p) {
        this.visitAndValidateNonNull(templateExpression.getHead(), J.Literal.class, p);
        ListUtils.map(templateExpression.getSpans(), el -> this.visitAndValidateNonNull(el, JS.TemplateExpression.Span.class, p));
        return templateExpression;
    }

    @Override
    public JS.TemplateExpression.Span visitTemplateExpressionSpan(JS.TemplateExpression.Span span, P p) {
        this.visitAndValidateNonNull(span.getExpression(), J.class, p);
        this.visitAndValidateNonNull(span.getTail(), J.Literal.class, p);
        return span;
    }

    @Override
    public JS.Tuple visitTuple(JS.Tuple tuple, P p) {
        this.visitAndValidate(tuple.getElements(), J.class, p);
        return tuple;
    }

    @Override
    public JS.TypeDeclaration visitTypeDeclaration(JS.TypeDeclaration typeDeclaration, P p) {
        ListUtils.map(typeDeclaration.getModifiers(), el -> this.visitAndValidateNonNull(el, J.Modifier.class, p));
        this.visitAndValidateNonNull(typeDeclaration.getName(), J.Identifier.class, p);
        this.visitAndValidate(typeDeclaration.getTypeParameters(), J.TypeParameters.class, p);
        this.visitAndValidateNonNull(typeDeclaration.getInitializer(), Expression.class, p);
        return typeDeclaration;
    }

    @Override
    public JS.TypeOf visitTypeOf(JS.TypeOf typeOf, P p) {
        this.visitAndValidateNonNull(typeOf.getExpression(), Expression.class, p);
        return typeOf;
    }

    @Override
    public JS.TypeQuery visitTypeQuery(JS.TypeQuery typeQuery, P p) {
        this.visitAndValidateNonNull(typeQuery.getTypeExpression(), TypeTree.class, p);
        this.visitAndValidate(typeQuery.getTypeArguments(), Expression.class, p);
        return typeQuery;
    }

    @Override
    public JS.ComputedPropertyName visitComputedPropertyName(JS.ComputedPropertyName computedPropertyName, P p) {
        this.visitAndValidateNonNull(computedPropertyName.getExpression(), Expression.class, p);
        return computedPropertyName;
    }

    @Override
    public JS.TypeOperator visitTypeOperator(JS.TypeOperator typeOperator, P p) {
        this.visitAndValidateNonNull(typeOperator.getExpression(), Expression.class, p);
        return typeOperator;
    }

    @Override
    public JS.TypePredicate visitTypePredicate(JS.TypePredicate typePredicate, P p) {
        this.visitAndValidateNonNull(typePredicate.getParameterName(), J.Identifier.class, p);
        this.visitAndValidate(typePredicate.getExpression(), Expression.class, p);
        return typePredicate;
    }

    @Override
    public JS.Union visitUnion(JS.Union union, P p) {
        ListUtils.map(union.getTypes(), el -> this.visitAndValidateNonNull(el, Expression.class, p));
        return union;
    }

    @Override
    public JS.Intersection visitIntersection(JS.Intersection intersection, P p) {
        ListUtils.map(intersection.getTypes(), el -> this.visitAndValidateNonNull(el, Expression.class, p));
        return intersection;
    }

    @Override
    public JS.Void visitVoid(JS.Void void_, P p) {
        this.visitAndValidateNonNull(void_.getExpression(), Expression.class, p);
        return void_;
    }

    @Override
    public JS.TypeInfo visitTypeInfo(JS.TypeInfo typeInfo, P p) {
        this.visitAndValidateNonNull(typeInfo.getTypeIdentifier(), TypeTree.class, p);
        return typeInfo;
    }

    @Override
    public JS.ComputedPropertyMethodDeclaration visitComputedPropertyMethodDeclaration(JS.ComputedPropertyMethodDeclaration computedPropertyMethodDeclaration, P p) {
        ListUtils.map(computedPropertyMethodDeclaration.getLeadingAnnotations(), el -> this.visitAndValidateNonNull(el, J.Annotation.class, p));
        ListUtils.map(computedPropertyMethodDeclaration.getModifiers(), el -> this.visitAndValidateNonNull(el, J.Modifier.class, p));
        this.visitAndValidate(computedPropertyMethodDeclaration.getTypeParameters(), J.TypeParameters.class, p);
        this.visitAndValidate(computedPropertyMethodDeclaration.getReturnTypeExpression(), TypeTree.class, p);
        this.visitAndValidateNonNull(computedPropertyMethodDeclaration.getName(), JS.ComputedPropertyName.class, p);
        this.visitAndValidate(computedPropertyMethodDeclaration.getParameters(), Statement.class, p);
        this.visitAndValidate(computedPropertyMethodDeclaration.getBody(), J.Block.class, p);
        return computedPropertyMethodDeclaration;
    }

    @Override
    public JS.ForOfLoop visitForOfLoop(JS.ForOfLoop forOfLoop, P p) {
        this.visitAndValidateNonNull(forOfLoop.getLoop(), J.ForEachLoop.class, p);
        return forOfLoop;
    }

    @Override
    public JS.ForInLoop visitForInLoop(JS.ForInLoop forInLoop, P p) {
        this.visitAndValidateNonNull(forInLoop.getControl(), J.ForEachLoop.Control.class, p);
        this.visitAndValidateNonNull(forInLoop.getBody(), Statement.class, p);
        return forInLoop;
    }

    @Override
    public JS.NamespaceDeclaration visitNamespaceDeclaration(JS.NamespaceDeclaration namespaceDeclaration, P p) {
        ListUtils.map(namespaceDeclaration.getModifiers(), el -> this.visitAndValidateNonNull(el, J.Modifier.class, p));
        this.visitAndValidateNonNull(namespaceDeclaration.getName(), Expression.class, p);
        this.visitAndValidate(namespaceDeclaration.getBody(), J.Block.class, p);
        return namespaceDeclaration;
    }

    @Override
    public JS.TypeLiteral visitTypeLiteral(JS.TypeLiteral typeLiteral, P p) {
        this.visitAndValidateNonNull(typeLiteral.getMembers(), J.Block.class, p);
        return typeLiteral;
    }

    @Override
    public JS.IndexSignatureDeclaration visitIndexSignatureDeclaration(JS.IndexSignatureDeclaration indexSignatureDeclaration, P p) {
        ListUtils.map(indexSignatureDeclaration.getModifiers(), el -> this.visitAndValidateNonNull(el, J.Modifier.class, p));
        this.visitAndValidate(indexSignatureDeclaration.getParameters(), J.class, p);
        this.visitAndValidateNonNull(indexSignatureDeclaration.getTypeExpression(), Expression.class, p);
        return indexSignatureDeclaration;
    }

    @Override
    public JS.ArrayBindingPattern visitArrayBindingPattern(JS.ArrayBindingPattern arrayBindingPattern, P p) {
        this.visitAndValidate(arrayBindingPattern.getElements(), Expression.class, p);
        return arrayBindingPattern;
    }

    @Override
    public JS.BindingElement visitBindingElement(JS.BindingElement bindingElement, P p) {
        this.visitAndValidate(bindingElement.getPropertyName(), Expression.class, p);
        this.visitAndValidateNonNull(bindingElement.getName(), TypedTree.class, p);
        this.visitAndValidate(bindingElement.getInitializer(), Expression.class, p);
        return bindingElement;
    }

    @Override
    public JS.ExportDeclaration visitExportDeclaration(JS.ExportDeclaration exportDeclaration, P p) {
        ListUtils.map(exportDeclaration.getModifiers(), el -> this.visitAndValidateNonNull(el, J.Modifier.class, p));
        this.visitAndValidate(exportDeclaration.getExportClause(), Expression.class, p);
        this.visitAndValidate(exportDeclaration.getModuleSpecifier(), Expression.class, p);
        this.visitAndValidate(exportDeclaration.getAttributes(), JS.ImportAttributes.class, p);
        return exportDeclaration;
    }

    @Override
    public JS.ExportAssignment visitExportAssignment(JS.ExportAssignment exportAssignment, P p) {
        this.visitAndValidateNonNull(exportAssignment.getExpression(), Expression.class, p);
        return exportAssignment;
    }

    @Override
    public JS.NamedExports visitNamedExports(JS.NamedExports namedExports, P p) {
        this.visitAndValidate(namedExports.getElements(), Expression.class, p);
        return namedExports;
    }

    @Override
    public JS.ExportSpecifier visitExportSpecifier(JS.ExportSpecifier exportSpecifier, P p) {
        this.visitAndValidateNonNull(exportSpecifier.getSpecifier(), Expression.class, p);
        return exportSpecifier;
    }

    @Override
    public JS.IndexedAccessType visitIndexedAccessType(JS.IndexedAccessType indexedAccessType, P p) {
        this.visitAndValidateNonNull(indexedAccessType.getObjectType(), TypeTree.class, p);
        this.visitAndValidateNonNull(indexedAccessType.getIndexType(), TypeTree.class, p);
        return indexedAccessType;
    }

    @Override
    public JS.IndexedAccessType.IndexType visitIndexedAccessTypeIndexType(JS.IndexedAccessType.IndexType indexType, P p) {
        this.visitAndValidateNonNull(indexType.getElement(), TypeTree.class, p);
        return indexType;
    }

    @Override
    public JS.As visitAs(JS.As as_, P p) {
        this.visitAndValidateNonNull(as_.getLeft(), Expression.class, p);
        this.visitAndValidateNonNull(as_.getRight(), Expression.class, p);
        return as_;
    }

    @Override
    public JS.AssignmentOperation visitAssignmentOperationExtensions(JS.AssignmentOperation assignmentOperation, P p) {
        this.visitAndValidateNonNull(assignmentOperation.getVariable(), Expression.class, p);
        this.visitAndValidateNonNull(assignmentOperation.getAssignment(), Expression.class, p);
        return assignmentOperation;
    }

    @Override
    public JS.TypeTreeExpression visitTypeTreeExpression(JS.TypeTreeExpression typeTreeExpression, P p) {
        this.visitAndValidateNonNull(typeTreeExpression.getExpression(), Expression.class, p);
        return typeTreeExpression;
    }

    @Override
    public J.AnnotatedType visitAnnotatedType(J.AnnotatedType annotatedType, P p) {
        ListUtils.map((List)annotatedType.getAnnotations(), el -> this.visitAndValidateNonNull(el, J.Annotation.class, p));
        this.visitAndValidateNonNull(annotatedType.getTypeExpression(), TypeTree.class, p);
        return annotatedType;
    }

    @Override
    public J.Annotation visitAnnotation(J.Annotation annotation, P p) {
        this.visitAndValidateNonNull(annotation.getAnnotationType(), NameTree.class, p);
        this.visitAndValidate(annotation.getArguments(), Expression.class, p);
        return annotation;
    }

    @Override
    public J.ArrayAccess visitArrayAccess(J.ArrayAccess arrayAccess, P p) {
        this.visitAndValidateNonNull(arrayAccess.getIndexed(), Expression.class, p);
        this.visitAndValidateNonNull(arrayAccess.getDimension(), J.ArrayDimension.class, p);
        return arrayAccess;
    }

    @Override
    public J.ArrayType visitArrayType(J.ArrayType arrayType, P p) {
        this.visitAndValidateNonNull(arrayType.getElementType(), TypeTree.class, p);
        ListUtils.map((List)arrayType.getAnnotations(), el -> this.visitAndValidateNonNull(el, J.Annotation.class, p));
        return arrayType;
    }

    @Override
    public J.Assert visitAssert(J.Assert assert_, P p) {
        this.visitAndValidateNonNull(assert_.getCondition(), Expression.class, p);
        this.visitAndValidate(assert_.getDetail() != null ? (Expression)assert_.getDetail().getElement() : null, Expression.class, p);
        return assert_;
    }

    @Override
    public J.Assignment visitAssignment(J.Assignment assignment, P p) {
        this.visitAndValidateNonNull(assignment.getVariable(), Expression.class, p);
        this.visitAndValidateNonNull(assignment.getAssignment(), Expression.class, p);
        return assignment;
    }

    @Override
    public J.AssignmentOperation visitAssignmentOperation(J.AssignmentOperation assignmentOperation, P p) {
        this.visitAndValidateNonNull(assignmentOperation.getVariable(), Expression.class, p);
        this.visitAndValidateNonNull(assignmentOperation.getAssignment(), Expression.class, p);
        return assignmentOperation;
    }

    @Override
    public J.Binary visitBinary(J.Binary binary, P p) {
        this.visitAndValidateNonNull(binary.getLeft(), Expression.class, p);
        this.visitAndValidateNonNull(binary.getRight(), Expression.class, p);
        return binary;
    }

    @Override
    public J.Block visitBlock(J.Block block, P p) {
        ListUtils.map((List)block.getStatements(), el -> this.visitAndValidateNonNull(el, Statement.class, p));
        return block;
    }

    @Override
    public J.Break visitBreak(J.Break break_, P p) {
        this.visitAndValidate(break_.getLabel(), J.Identifier.class, p);
        return break_;
    }

    @Override
    public J.Case visitCase(J.Case case_, P p) {
        this.visitAndValidate(case_.getCaseLabels(), J.class, p);
        this.visitAndValidate(case_.getStatements(), Statement.class, p);
        this.visitAndValidate(case_.getBody(), J.class, p);
        this.visitAndValidate(case_.getGuard(), Expression.class, p);
        return case_;
    }

    @Override
    public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDeclaration, P p) {
        ListUtils.map((List)classDeclaration.getLeadingAnnotations(), el -> this.visitAndValidateNonNull(el, J.Annotation.class, p));
        ListUtils.map((List)classDeclaration.getModifiers(), el -> this.visitAndValidateNonNull(el, J.Modifier.class, p));
        this.visitAndValidate(classDeclaration.getPadding().getKind().getAnnotations(), J.Annotation.class, p);
        this.visitAndValidateNonNull(classDeclaration.getName(), J.Identifier.class, p);
        this.visitAndValidate(classDeclaration.getTypeParameters(), J.TypeParameter.class, p);
        this.visitAndValidate(classDeclaration.getPrimaryConstructor(), Statement.class, p);
        this.visitAndValidate(classDeclaration.getExtends(), TypeTree.class, p);
        this.visitAndValidate(classDeclaration.getImplements(), TypeTree.class, p);
        this.visitAndValidate(classDeclaration.getPermits(), TypeTree.class, p);
        this.visitAndValidateNonNull(classDeclaration.getBody(), J.Block.class, p);
        return classDeclaration;
    }

    @Override
    public J.Continue visitContinue(J.Continue continue_, P p) {
        this.visitAndValidate(continue_.getLabel(), J.Identifier.class, p);
        return continue_;
    }

    @Override
    public J.DoWhileLoop visitDoWhileLoop(J.DoWhileLoop doWhileLoop, P p) {
        this.visitAndValidateNonNull(doWhileLoop.getBody(), Statement.class, p);
        this.visitAndValidateNonNull(doWhileLoop.getWhileCondition(), Expression.class, p);
        return doWhileLoop;
    }

    @Override
    public J.Empty visitEmpty(J.Empty empty, P p) {
        return empty;
    }

    @Override
    public J.EnumValue visitEnumValue(J.EnumValue enumValue, P p) {
        ListUtils.map((List)enumValue.getAnnotations(), el -> this.visitAndValidateNonNull(el, J.Annotation.class, p));
        this.visitAndValidateNonNull(enumValue.getName(), J.Identifier.class, p);
        this.visitAndValidate(enumValue.getInitializer(), J.NewClass.class, p);
        return enumValue;
    }

    @Override
    public J.EnumValueSet visitEnumValueSet(J.EnumValueSet enumValueSet, P p) {
        ListUtils.map((List)enumValueSet.getEnums(), el -> this.visitAndValidateNonNull(el, J.EnumValue.class, p));
        return enumValueSet;
    }

    @Override
    public J.FieldAccess visitFieldAccess(J.FieldAccess fieldAccess, P p) {
        this.visitAndValidateNonNull(fieldAccess.getTarget(), Expression.class, p);
        this.visitAndValidateNonNull(fieldAccess.getName(), J.Identifier.class, p);
        return fieldAccess;
    }

    @Override
    public J.ForEachLoop visitForEachLoop(J.ForEachLoop forEachLoop, P p) {
        this.visitAndValidateNonNull(forEachLoop.getControl(), J.ForEachLoop.Control.class, p);
        this.visitAndValidateNonNull(forEachLoop.getBody(), Statement.class, p);
        return forEachLoop;
    }

    @Override
    public J.ForEachLoop.Control visitForEachControl(J.ForEachLoop.Control control, P p) {
        this.visitAndValidateNonNull(control.getVariable(), Statement.class, p);
        this.visitAndValidateNonNull(control.getIterable(), Expression.class, p);
        return control;
    }

    @Override
    public J.ForLoop visitForLoop(J.ForLoop forLoop, P p) {
        this.visitAndValidateNonNull(forLoop.getControl(), J.ForLoop.Control.class, p);
        this.visitAndValidateNonNull(forLoop.getBody(), Statement.class, p);
        return forLoop;
    }

    @Override
    public J.ForLoop.Control visitForControl(J.ForLoop.Control control, P p) {
        ListUtils.map((List)control.getInit(), el -> this.visitAndValidateNonNull(el, Statement.class, p));
        this.visitAndValidateNonNull(control.getCondition(), Expression.class, p);
        ListUtils.map((List)control.getUpdate(), el -> this.visitAndValidateNonNull(el, Statement.class, p));
        return control;
    }

    @Override
    public J.ParenthesizedTypeTree visitParenthesizedTypeTree(J.ParenthesizedTypeTree parenthesizedTypeTree, P p) {
        ListUtils.map((List)parenthesizedTypeTree.getAnnotations(), el -> this.visitAndValidateNonNull(el, J.Annotation.class, p));
        this.visitAndValidateNonNull(parenthesizedTypeTree.getParenthesizedType(), J.Parentheses.class, p);
        return parenthesizedTypeTree;
    }

    @Override
    public J.Identifier visitIdentifier(J.Identifier identifier, P p) {
        ListUtils.map((List)identifier.getAnnotations(), el -> this.visitAndValidateNonNull(el, J.Annotation.class, p));
        return identifier;
    }

    @Override
    public J.If visitIf(J.If if_, P p) {
        this.visitAndValidateNonNull(if_.getIfCondition(), J.ControlParentheses.class, p);
        this.visitAndValidateNonNull(if_.getThenPart(), Statement.class, p);
        this.visitAndValidate(if_.getElsePart(), J.If.Else.class, p);
        return if_;
    }

    @Override
    public J.If.Else visitElse(J.If.Else else_, P p) {
        this.visitAndValidateNonNull(else_.getBody(), Statement.class, p);
        return else_;
    }

    @Override
    public J.Import visitImport(J.Import import_, P p) {
        this.visitAndValidateNonNull(import_.getQualid(), J.FieldAccess.class, p);
        this.visitAndValidate(import_.getAlias(), J.Identifier.class, p);
        return import_;
    }

    @Override
    public J.InstanceOf visitInstanceOf(J.InstanceOf instanceOf, P p) {
        this.visitAndValidateNonNull(instanceOf.getExpression(), Expression.class, p);
        this.visitAndValidateNonNull(instanceOf.getClazz(), J.class, p);
        this.visitAndValidate(instanceOf.getPattern(), J.class, p);
        this.visitAndValidate(instanceOf.getModifier(), J.Modifier.class, p);
        return instanceOf;
    }

    @Override
    public J.DeconstructionPattern visitDeconstructionPattern(J.DeconstructionPattern deconstructionPattern, P p) {
        this.visitAndValidateNonNull(deconstructionPattern.getDeconstructor(), Expression.class, p);
        this.visitAndValidate(deconstructionPattern.getNested(), J.class, p);
        return deconstructionPattern;
    }

    @Override
    public J.IntersectionType visitIntersectionType(J.IntersectionType intersectionType, P p) {
        this.visitAndValidate(intersectionType.getBounds(), TypeTree.class, p);
        return intersectionType;
    }

    @Override
    public J.Label visitLabel(J.Label label, P p) {
        this.visitAndValidateNonNull(label.getLabel(), J.Identifier.class, p);
        this.visitAndValidateNonNull(label.getStatement(), Statement.class, p);
        return label;
    }

    @Override
    public J.Lambda visitLambda(J.Lambda lambda, P p) {
        this.visitAndValidate(lambda.getParameters().getParameters(), J.class, p);
        this.visitAndValidateNonNull(lambda.getBody(), J.class, p);
        return lambda;
    }

    @Override
    public J.Literal visitLiteral(J.Literal literal, P p) {
        return literal;
    }

    @Override
    public J.MemberReference visitMemberReference(J.MemberReference memberReference, P p) {
        this.visitAndValidateNonNull(memberReference.getContaining(), Expression.class, p);
        this.visitAndValidate(memberReference.getTypeParameters(), Expression.class, p);
        this.visitAndValidateNonNull(memberReference.getReference(), J.Identifier.class, p);
        return memberReference;
    }

    @Override
    public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration methodDeclaration, P p) {
        ListUtils.map((List)methodDeclaration.getLeadingAnnotations(), el -> this.visitAndValidateNonNull(el, J.Annotation.class, p));
        ListUtils.map((List)methodDeclaration.getModifiers(), el -> this.visitAndValidateNonNull(el, J.Modifier.class, p));
        this.visitAndValidate(methodDeclaration.getPadding().getTypeParameters(), J.TypeParameters.class, p);
        this.visitAndValidate(methodDeclaration.getReturnTypeExpression(), TypeTree.class, p);
        this.visitAndValidate(methodDeclaration.getParameters(), Statement.class, p);
        this.visitAndValidate(methodDeclaration.getThrows(), NameTree.class, p);
        this.visitAndValidate(methodDeclaration.getBody(), J.Block.class, p);
        this.visitAndValidate(methodDeclaration.getDefaultValue(), Expression.class, p);
        return methodDeclaration;
    }

    @Override
    public J.MethodInvocation visitMethodInvocation(J.MethodInvocation methodInvocation, P p) {
        this.visitAndValidate(methodInvocation.getSelect(), Expression.class, p);
        this.visitAndValidate(methodInvocation.getTypeParameters(), Expression.class, p);
        this.visitAndValidateNonNull(methodInvocation.getName(), J.Identifier.class, p);
        this.visitAndValidate(methodInvocation.getArguments(), Expression.class, p);
        return methodInvocation;
    }

    @Override
    public J.Modifier visitModifier(J.Modifier modifier, P p) {
        ListUtils.map((List)modifier.getAnnotations(), el -> this.visitAndValidateNonNull(el, J.Annotation.class, p));
        return modifier;
    }

    @Override
    public J.MultiCatch visitMultiCatch(J.MultiCatch multiCatch, P p) {
        ListUtils.map((List)multiCatch.getAlternatives(), el -> this.visitAndValidateNonNull(el, NameTree.class, p));
        return multiCatch;
    }

    @Override
    public J.NewArray visitNewArray(J.NewArray newArray, P p) {
        this.visitAndValidate(newArray.getTypeExpression(), TypeTree.class, p);
        ListUtils.map((List)newArray.getDimensions(), el -> this.visitAndValidateNonNull(el, J.ArrayDimension.class, p));
        this.visitAndValidate(newArray.getInitializer(), Expression.class, p);
        return newArray;
    }

    @Override
    public J.ArrayDimension visitArrayDimension(J.ArrayDimension arrayDimension, P p) {
        this.visitAndValidateNonNull(arrayDimension.getIndex(), Expression.class, p);
        return arrayDimension;
    }

    @Override
    public J.NewClass visitNewClass(J.NewClass newClass, P p) {
        this.visitAndValidate(newClass.getEnclosing(), Expression.class, p);
        this.visitAndValidate(newClass.getClazz(), TypeTree.class, p);
        this.visitAndValidate(newClass.getArguments(), Expression.class, p);
        this.visitAndValidate(newClass.getBody(), J.Block.class, p);
        return newClass;
    }

    @Override
    public J.NullableType visitNullableType(J.NullableType nullableType, P p) {
        ListUtils.map((List)nullableType.getAnnotations(), el -> this.visitAndValidateNonNull(el, J.Annotation.class, p));
        this.visitAndValidateNonNull(nullableType.getTypeTree(), TypeTree.class, p);
        return nullableType;
    }

    @Override
    public J.Package visitPackage(J.Package package_, P p) {
        this.visitAndValidateNonNull(package_.getExpression(), Expression.class, p);
        ListUtils.map((List)package_.getAnnotations(), el -> this.visitAndValidateNonNull(el, J.Annotation.class, p));
        return package_;
    }

    @Override
    public J.ParameterizedType visitParameterizedType(J.ParameterizedType parameterizedType, P p) {
        this.visitAndValidateNonNull(parameterizedType.getClazz(), NameTree.class, p);
        this.visitAndValidate(parameterizedType.getTypeParameters(), Expression.class, p);
        return parameterizedType;
    }

    @Override
    public <J2 extends J> J.Parentheses<J2> visitParentheses(J.Parentheses<J2> parentheses, P p) {
        this.visitAndValidateNonNull(parentheses.getTree(), J.class, p);
        return parentheses;
    }

    @Override
    public <J2 extends J> J.ControlParentheses<J2> visitControlParentheses(J.ControlParentheses<J2> controlParentheses, P p) {
        this.visitAndValidateNonNull(controlParentheses.getTree(), J.class, p);
        return controlParentheses;
    }

    @Override
    public J.Primitive visitPrimitive(J.Primitive primitive, P p) {
        return primitive;
    }

    @Override
    public J.Return visitReturn(J.Return return_, P p) {
        this.visitAndValidate(return_.getExpression(), Expression.class, p);
        return return_;
    }

    @Override
    public J.Switch visitSwitch(J.Switch switch_, P p) {
        this.visitAndValidateNonNull(switch_.getSelector(), J.ControlParentheses.class, p);
        this.visitAndValidateNonNull(switch_.getCases(), J.Block.class, p);
        return switch_;
    }

    @Override
    public J.SwitchExpression visitSwitchExpression(J.SwitchExpression switchExpression, P p) {
        this.visitAndValidateNonNull(switchExpression.getSelector(), J.ControlParentheses.class, p);
        this.visitAndValidateNonNull(switchExpression.getCases(), J.Block.class, p);
        return switchExpression;
    }

    @Override
    public J.Synchronized visitSynchronized(J.Synchronized synchronized_, P p) {
        this.visitAndValidateNonNull(synchronized_.getLock(), J.ControlParentheses.class, p);
        this.visitAndValidateNonNull(synchronized_.getBody(), J.Block.class, p);
        return synchronized_;
    }

    @Override
    public J.Ternary visitTernary(J.Ternary ternary, P p) {
        this.visitAndValidateNonNull(ternary.getCondition(), Expression.class, p);
        this.visitAndValidateNonNull(ternary.getTruePart(), Expression.class, p);
        this.visitAndValidateNonNull(ternary.getFalsePart(), Expression.class, p);
        return ternary;
    }

    @Override
    public J.Throw visitThrow(J.Throw throw_, P p) {
        this.visitAndValidateNonNull(throw_.getException(), Expression.class, p);
        return throw_;
    }

    @Override
    public J.Try visitTry(J.Try try_, P p) {
        this.visitAndValidate(try_.getResources(), J.Try.Resource.class, p);
        this.visitAndValidateNonNull(try_.getBody(), J.Block.class, p);
        ListUtils.map((List)try_.getCatches(), el -> this.visitAndValidateNonNull(el, J.Try.Catch.class, p));
        this.visitAndValidate(try_.getFinally(), J.Block.class, p);
        return try_;
    }

    @Override
    public J.Try.Resource visitTryResource(J.Try.Resource resource, P p) {
        this.visitAndValidateNonNull(resource.getVariableDeclarations(), TypedTree.class, p);
        return resource;
    }

    @Override
    public J.Try.Catch visitCatch(J.Try.Catch catch_, P p) {
        this.visitAndValidateNonNull(catch_.getParameter(), J.ControlParentheses.class, p);
        this.visitAndValidateNonNull(catch_.getBody(), J.Block.class, p);
        return catch_;
    }

    @Override
    public J.TypeCast visitTypeCast(J.TypeCast typeCast, P p) {
        this.visitAndValidateNonNull(typeCast.getClazz(), J.ControlParentheses.class, p);
        this.visitAndValidateNonNull(typeCast.getExpression(), Expression.class, p);
        return typeCast;
    }

    @Override
    public J.TypeParameter visitTypeParameter(J.TypeParameter typeParameter, P p) {
        ListUtils.map((List)typeParameter.getAnnotations(), el -> this.visitAndValidateNonNull(el, J.Annotation.class, p));
        ListUtils.map((List)typeParameter.getModifiers(), el -> this.visitAndValidateNonNull(el, J.Modifier.class, p));
        this.visitAndValidateNonNull(typeParameter.getName(), Expression.class, p);
        this.visitAndValidate(typeParameter.getBounds(), TypeTree.class, p);
        return typeParameter;
    }

    @Override
    public J.Unary visitUnary(J.Unary unary, P p) {
        this.visitAndValidateNonNull(unary.getExpression(), Expression.class, p);
        return unary;
    }

    @Override
    public J.VariableDeclarations visitVariableDeclarations(J.VariableDeclarations variableDeclarations, P p) {
        ListUtils.map((List)variableDeclarations.getLeadingAnnotations(), el -> this.visitAndValidateNonNull(el, J.Annotation.class, p));
        ListUtils.map((List)variableDeclarations.getModifiers(), el -> this.visitAndValidateNonNull(el, J.Modifier.class, p));
        this.visitAndValidate(variableDeclarations.getTypeExpression(), TypeTree.class, p);
        ListUtils.map((List)variableDeclarations.getVariables(), el -> this.visitAndValidateNonNull(el, J.VariableDeclarations.NamedVariable.class, p));
        return variableDeclarations;
    }

    @Override
    public J.VariableDeclarations.NamedVariable visitVariable(J.VariableDeclarations.NamedVariable namedVariable, P p) {
        this.visitAndValidateNonNull(namedVariable.getName(), VariableDeclarator.class, p);
        this.visitAndValidate(namedVariable.getInitializer(), Expression.class, p);
        return namedVariable;
    }

    @Override
    public J.WhileLoop visitWhileLoop(J.WhileLoop whileLoop, P p) {
        this.visitAndValidateNonNull(whileLoop.getCondition(), J.ControlParentheses.class, p);
        this.visitAndValidateNonNull(whileLoop.getBody(), Statement.class, p);
        return whileLoop;
    }

    @Override
    public J.Wildcard visitWildcard(J.Wildcard wildcard, P p) {
        this.visitAndValidate(wildcard.getBoundedType(), NameTree.class, p);
        return wildcard;
    }

    @Override
    public J.Yield visitYield(J.Yield yield, P p) {
        this.visitAndValidateNonNull(yield.getValue(), Expression.class, p);
        return yield;
    }

    @Override
    public J.Unknown visitUnknown(J.Unknown unknown, P p) {
        this.visitAndValidateNonNull(unknown.getSource(), J.Unknown.Source.class, p);
        return unknown;
    }

    @Override
    public J.Unknown.Source visitUnknownSource(J.Unknown.Source source, P p) {
        return source;
    }

    @Override
    public J.Erroneous visitErroneous(J.Erroneous erroneous, P p) {
        return erroneous;
    }

    @Override
    public JSX.Tag visitJsxTag(JSX.Tag tag, P p) {
        this.visitAndValidateNonNull(tag.getOpenName(), NameTree.class, p);
        ListUtils.map(tag.getChildren(), el -> this.visitAndValidateNonNull(el, Expression.class, p));
        ListUtils.map(tag.getAttributes(), el -> this.visitAndValidateNonNull(el, JSX.class, p));
        return tag;
    }

    @Override
    public JSX.Attribute visitJsxAttribute(JSX.Attribute attribute, P p) {
        this.visitAndValidateNonNull(attribute.getKey(), NameTree.class, p);
        this.visitAndValidate(attribute.getValue(), Expression.class, p);
        return attribute;
    }

    @Override
    public JSX.SpreadAttribute visitJsxSpreadAttribute(JSX.SpreadAttribute spreadAttribute, P p) {
        this.visitAndValidateNonNull(spreadAttribute.getExpression(), Expression.class, p);
        return spreadAttribute;
    }

    @Override
    public JSX.EmbeddedExpression visitJsxEmbeddedExpression(JSX.EmbeddedExpression embeddedExpression, P p) {
        this.visitAndValidateNonNull(embeddedExpression.getExpression(), Expression.class, p);
        return embeddedExpression;
    }

    @Override
    public JSX.NamespacedName visitJsxNamespacedName(JSX.NamespacedName namespacedName, P p) {
        this.visitAndValidateNonNull(namespacedName.getNamespace(), J.Identifier.class, p);
        this.visitAndValidateNonNull(namespacedName.getName(), J.Identifier.class, p);
        return namespacedName;
    }
}

