/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.javascript.rpc;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Stream;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.config.Environment;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.javascript.rpc.InstallRecipesByFile;
import org.openrewrite.javascript.rpc.InstallRecipesByPackage;
import org.openrewrite.javascript.rpc.InstallRecipesResponse;
import org.openrewrite.rpc.RewriteRpc;
import org.openrewrite.rpc.RewriteRpcProcess;
import org.openrewrite.rpc.RewriteRpcProcessManager;
import org.openrewrite.rpc.request.PrepareRecipe;

public class JavaScriptRewriteRpc
extends RewriteRpc {
    private static final RewriteRpcProcessManager<JavaScriptRewriteRpc> MANAGER = new RewriteRpcProcessManager((Supplier)JavaScriptRewriteRpc.builder());
    private final String command;
    private final Map<String, String> commandEnv;
    private final RewriteRpcProcess process;

    JavaScriptRewriteRpc(RewriteRpcProcess process, Environment marketplace, String command, Map<String, String> commandEnv) {
        super(process.getRpcClient(), marketplace);
        this.command = command;
        this.commandEnv = commandEnv;
        this.process = process;
    }

    public static @Nullable JavaScriptRewriteRpc get() {
        return (JavaScriptRewriteRpc)MANAGER.get();
    }

    public static JavaScriptRewriteRpc getOrStart() {
        return (JavaScriptRewriteRpc)MANAGER.getOrStart();
    }

    public static void setFactory(Builder builder) {
        MANAGER.setFactory((Supplier)builder);
    }

    public void shutdown() {
        super.shutdown();
        this.process.shutdown();
    }

    public static void shutdownCurrent() {
        MANAGER.shutdown();
    }

    public int installRecipes(File recipes) {
        return ((InstallRecipesResponse)this.send("InstallRecipes", new InstallRecipesByFile(recipes), InstallRecipesResponse.class)).getRecipesInstalled();
    }

    public int installRecipes(String packageName) {
        return this.installRecipes(packageName, null);
    }

    public int installRecipes(String packageName, @Nullable String version) {
        return ((InstallRecipesResponse)this.send("InstallRecipes", new InstallRecipesByPackage(new InstallRecipesByPackage.Package(packageName, version)), InstallRecipesResponse.class)).getRecipesInstalled();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated
    public String getCommand() {
        return this.command;
    }

    @Generated
    public Map<String, String> getCommandEnv() {
        return this.commandEnv;
    }

    @Generated
    public RewriteRpcProcess getProcess() {
        return this.process;
    }

    public static class Builder
    implements Supplier<JavaScriptRewriteRpc> {
        private Environment marketplace = Environment.builder().build();
        private Path npxPath = Paths.get("npx", new String[0]);
        private @Nullable Path log;
        private @Nullable Path metricsCsv;
        private @Nullable Path recipeInstallDir;
        private Duration timeout = Duration.ofSeconds(30L);
        private boolean traceRpcMessages;
        private @Nullable Integer inspectBrk;
        private Path inspectBrkRewriteSourcePath;
        private @Nullable Integer maxHeapSize;
        private @Nullable Path workingDirectory;
        private // Could not load outer class - annotation placement on inner may be incorrect
         @Nullable PrepareRecipe.Loader recipeLoader;

        public Builder marketplace(Environment marketplace) {
            this.marketplace = marketplace;
            return this;
        }

        public Builder recipeInstallDir(@Nullable Path recipeInstallDir) {
            this.recipeInstallDir = recipeInstallDir;
            return this;
        }

        public Builder npxPath(Path npxPath) {
            if (Files.notExists(npxPath, new LinkOption[0]) || Files.isDirectory(npxPath, new LinkOption[0])) {
                throw new IllegalArgumentException("Invalid npx executable " + npxPath.toAbsolutePath().normalize());
            }
            this.npxPath = npxPath;
            return this;
        }

        public Builder timeout(Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        public Builder log(@Nullable Path log) {
            this.log = log;
            return this;
        }

        public Builder metricsCsv(@Nullable Path metricsCsv) {
            this.metricsCsv = metricsCsv;
            return this;
        }

        public Builder traceRpcMessages(boolean verboseLogging) {
            this.traceRpcMessages = verboseLogging;
            return this;
        }

        public Builder traceRpcMessages() {
            return this.traceRpcMessages(true);
        }

        public Builder inspectBrk(Path rewriteSourcePath, int inspectBrk) {
            this.inspectBrk = inspectBrk;
            this.inspectBrkRewriteSourcePath = rewriteSourcePath;
            return this;
        }

        public Builder inspectBrk(Path rewriteDistPath) {
            return this.inspectBrk(rewriteDistPath, 9229);
        }

        public Builder maxHeapSize(@Nullable Integer maxHeapSize) {
            this.maxHeapSize = maxHeapSize;
            return this;
        }

        public Builder workingDirectory(@Nullable Path workingDirectory) {
            this.workingDirectory = workingDirectory;
            return this;
        }

        public Builder recipeLoader(PrepareRecipe.Loader recipeLoader) {
            this.recipeLoader = recipeLoader;
            return this;
        }

        @Override
        public JavaScriptRewriteRpc get() {
            Stream<String> cmd;
            if (this.inspectBrk != null) {
                Path serverJs = this.inspectBrkRewriteSourcePath.resolve("dist/rpc/server.js");
                cmd = Stream.of("node", "--enable-source-maps", "--inspect-brk=" + this.inspectBrk, this.maxHeapSize != null ? "--max-old-space-size=" + this.maxHeapSize : null, serverJs.toAbsolutePath().normalize().toString(), this.log == null ? null : "--log-file=" + this.log.toAbsolutePath().normalize(), this.traceRpcMessages ? "--trace-rpc-messages" : null, this.recipeInstallDir == null ? null : "--recipe-install-dir=" + this.recipeInstallDir.toAbsolutePath().normalize());
            } else {
                String version = StringUtils.readFully((InputStream)this.getClass().getResourceAsStream("/META-INF/version.txt"));
                cmd = Stream.of(this.npxPath.toString(), version.endsWith("-SNAPSHOT") ? null : "--package=@openrewrite/rewrite@" + version, "rewrite-rpc", this.log == null ? null : "--log-file=" + this.log.toAbsolutePath().normalize(), this.metricsCsv == null ? null : "--metrics-csv=" + this.metricsCsv.toAbsolutePath().normalize(), this.traceRpcMessages ? "--trace-rpc-messages" : null, this.recipeInstallDir == null ? null : "--recipe-install-dir=" + this.recipeInstallDir.toAbsolutePath().normalize());
            }
            CharSequence[] cmdArr = (String[])cmd.filter(Objects::nonNull).toArray(String[]::new);
            RewriteRpcProcess process = new RewriteRpcProcess((String[])cmdArr);
            if (this.workingDirectory != null) {
                process.setWorkingDirectory(this.workingDirectory);
            }
            StringBuilder nodeOptions = new StringBuilder("--enable-source-maps");
            if (this.inspectBrk == null && this.maxHeapSize != null) {
                nodeOptions.append(" --max-old-space-size=").append(this.maxHeapSize);
            }
            process.environment().put("NODE_OPTIONS", nodeOptions.toString());
            if (this.npxPath.getParent() != null) {
                process.environment().put("PATH", this.npxPath.getParent() + File.pathSeparator + System.getenv("PATH"));
            }
            process.start();
            try {
                return (JavaScriptRewriteRpc)new JavaScriptRewriteRpc(process, this.marketplace, String.join((CharSequence)" ", cmdArr), process.environment()).livenessCheck(() -> ((RewriteRpcProcess)process).getLivenessCheck()).timeout(this.timeout).log(this.log == null ? null : new PrintStream(Files.newOutputStream(this.log, StandardOpenOption.APPEND, StandardOpenOption.CREATE))).recipeLoader(this.recipeLoader);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        @Generated
        public Builder() {
        }
    }
}

