/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.javascript.internal.rpc;

import org.jspecify.annotations.Nullable;
import org.openrewrite.Tree;
import org.openrewrite.java.internal.rpc.JavaSender;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JContainer;
import org.openrewrite.java.tree.JLeftPadded;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.javascript.JavaScriptVisitor;
import org.openrewrite.javascript.tree.JS;
import org.openrewrite.javascript.tree.JSX;
import org.openrewrite.rpc.Reference;
import org.openrewrite.rpc.RpcSendQueue;

public class JavaScriptSender
extends JavaScriptVisitor<RpcSendQueue> {
    private final JavaScriptSenderDelegate delegate = new JavaScriptSenderDelegate(this);

    public @Nullable J visit(@Nullable Tree tree, RpcSendQueue p) {
        if (tree instanceof JS) {
            return (J)super.visit(tree, (Object)p);
        }
        return this.delegate.visit(tree, p);
    }

    public J preVisit(J j, RpcSendQueue q) {
        q.getAndSend((Object)j, Tree::getId);
        q.getAndSend((Object)j, J::getPrefix, space -> this.visitSpace((Space)space, q));
        q.getAndSend((Object)j, Tree::getMarkers);
        return j;
    }

    @Override
    public J visitJsCompilationUnit(JS.CompilationUnit cu, RpcSendQueue q) {
        q.getAndSend((Object)cu, c -> c.getSourcePath().toString());
        q.getAndSend((Object)cu, c -> c.getCharset().name());
        q.getAndSend((Object)cu, JS.CompilationUnit::isCharsetBomMarked);
        q.getAndSend((Object)cu, JS.CompilationUnit::getChecksum);
        q.getAndSend((Object)cu, JS.CompilationUnit::getFileAttributes);
        q.getAndSendList((Object)cu, c -> c.getPadding().getStatements(), stmt -> ((Statement)stmt.getElement()).getId(), stmt -> this.visitRightPadded((JRightPadded)stmt, q));
        q.getAndSend((Object)cu, JS.CompilationUnit::getEof, space -> this.visitSpace((Space)space, q));
        return cu;
    }

    @Override
    public J visitAlias(JS.Alias alias, RpcSendQueue q) {
        q.getAndSend((Object)alias, el -> el.getPadding().getPropertyName(), el -> this.visitRightPadded((JRightPadded)el, q));
        q.getAndSend((Object)alias, JS.Alias::getAlias, el -> this.visit((Tree)el, q));
        return alias;
    }

    @Override
    public J visitArrowFunction(JS.ArrowFunction arrowFunction, RpcSendQueue q) {
        q.getAndSendList((Object)arrowFunction, JS.ArrowFunction::getLeadingAnnotations, J.Annotation::getId, el -> this.visit((Tree)el, q));
        q.getAndSendList((Object)arrowFunction, JS.ArrowFunction::getModifiers, J.Modifier::getId, el -> this.visit((Tree)el, q));
        q.getAndSend((Object)arrowFunction, JS.ArrowFunction::getTypeParameters, el -> this.visit((Tree)el, q));
        q.getAndSend((Object)arrowFunction, JS.ArrowFunction::getLambda, el -> this.visit((Tree)el, q));
        q.getAndSend((Object)arrowFunction, JS.ArrowFunction::getReturnTypeExpression, el -> this.visit((Tree)el, q));
        return arrowFunction;
    }

    @Override
    public J visitAwait(JS.Await await, RpcSendQueue q) {
        q.getAndSend((Object)await, JS.Await::getExpression, el -> this.visit((Tree)el, q));
        q.getAndSend((Object)await, el -> Reference.asRef((Object)el.getType()), el -> this.visitType((JavaType)Reference.getValueNonNull((Object)el), q));
        return await;
    }

    @Override
    public J visitConditionalType(JS.ConditionalType conditionalType, RpcSendQueue q) {
        q.getAndSend((Object)conditionalType, JS.ConditionalType::getCheckType, el -> this.visit((Tree)el, q));
        q.getAndSend((Object)conditionalType, el -> el.getPadding().getCondition(), el -> this.visitLeftPadded((JLeftPadded)el, q));
        q.getAndSend((Object)conditionalType, el -> Reference.asRef((Object)el.getType()), el -> this.visitType((JavaType)Reference.getValueNonNull((Object)el), q));
        return conditionalType;
    }

    @Override
    public J visitDelete(JS.Delete delete, RpcSendQueue q) {
        q.getAndSend((Object)delete, JS.Delete::getExpression, el -> this.visit((Tree)el, q));
        return delete;
    }

    @Override
    public J visitExpressionStatement(JS.ExpressionStatement expressionStatement, RpcSendQueue q) {
        q.getAndSend((Object)expressionStatement, JS.ExpressionStatement::getExpression, el -> this.visit((Tree)el, q));
        return expressionStatement;
    }

    @Override
    public J visitExpressionWithTypeArguments(JS.ExpressionWithTypeArguments expressionWithTypeArguments, RpcSendQueue q) {
        q.getAndSend((Object)expressionWithTypeArguments, JS.ExpressionWithTypeArguments::getClazz, el -> this.visit((Tree)el, q));
        q.getAndSend((Object)expressionWithTypeArguments, el -> el.getPadding().getTypeArguments(), el -> this.visitContainer((JContainer)el, q));
        q.getAndSend((Object)expressionWithTypeArguments, el -> Reference.asRef((Object)el.getType()), el -> this.visitType((JavaType)Reference.getValueNonNull((Object)el), q));
        return expressionWithTypeArguments;
    }

    @Override
    public J visitFunctionType(JS.FunctionType functionType, RpcSendQueue q) {
        q.getAndSendList((Object)functionType, JS.FunctionType::getModifiers, J.Modifier::getId, el -> this.visit((Tree)el, q));
        q.getAndSend((Object)functionType, el -> el.getPadding().getConstructorType(), el -> this.visitLeftPadded((JLeftPadded)el, q));
        q.getAndSend((Object)functionType, JS.FunctionType::getTypeParameters, el -> this.visit((Tree)el, q));
        q.getAndSend((Object)functionType, el -> el.getPadding().getParameters(), el -> this.visitContainer((JContainer)el, q));
        q.getAndSend((Object)functionType, el -> el.getPadding().getReturnType(), el -> this.visitLeftPadded((JLeftPadded)el, q));
        return functionType;
    }

    @Override
    public J visitInferType(JS.InferType inferType, RpcSendQueue q) {
        q.getAndSend((Object)inferType, el -> el.getPadding().getTypeParameter(), el -> this.visitLeftPadded((JLeftPadded)el, q));
        q.getAndSend((Object)inferType, el -> Reference.asRef((Object)el.getType()), el -> this.visitType((JavaType)Reference.getValueNonNull((Object)el), q));
        return inferType;
    }

    @Override
    public J visitImportType(JS.ImportType importType, RpcSendQueue q) {
        q.getAndSend((Object)importType, el -> el.getPadding().getHasTypeof(), el -> this.visitRightPadded((JRightPadded)el, q));
        q.getAndSend((Object)importType, el -> el.getPadding().getArgumentAndAttributes(), el -> this.visitContainer((JContainer)el, q));
        q.getAndSend((Object)importType, el -> el.getPadding().getQualifier(), el -> this.visitLeftPadded((JLeftPadded)el, q));
        q.getAndSend((Object)importType, el -> el.getPadding().getTypeArguments(), el -> this.visitContainer((JContainer)el, q));
        q.getAndSend((Object)importType, el -> Reference.asRef((Object)el.getType()), el -> this.visitType((JavaType)Reference.getValueNonNull((Object)el), q));
        return importType;
    }

    @Override
    public J visitImportDeclaration(JS.Import jsImport, RpcSendQueue q) {
        q.getAndSendList((Object)jsImport, JS.Import::getModifiers, J.Modifier::getId, el -> this.visit((Tree)el, q));
        q.getAndSend((Object)jsImport, JS.Import::getImportClause, el -> this.visit((Tree)el, q));
        q.getAndSend((Object)jsImport, el -> el.getPadding().getModuleSpecifier(), el -> this.visitLeftPadded((JLeftPadded)el, q));
        q.getAndSend((Object)jsImport, JS.Import::getAttributes, el -> this.visit((Tree)el, q));
        q.getAndSend((Object)jsImport, el -> el.getPadding().getInitializer(), el -> this.visitLeftPadded((JLeftPadded)el, q));
        return jsImport;
    }

    @Override
    public J visitImportClause(JS.ImportClause importClause, RpcSendQueue q) {
        q.getAndSend((Object)importClause, JS.ImportClause::isTypeOnly);
        q.getAndSend((Object)importClause, el -> el.getPadding().getName(), el -> this.visitRightPadded((JRightPadded)el, q));
        q.getAndSend((Object)importClause, JS.ImportClause::getNamedBindings, el -> this.visit((Tree)el, q));
        return importClause;
    }

    @Override
    public J visitNamedImports(JS.NamedImports namedImports, RpcSendQueue q) {
        q.getAndSend((Object)namedImports, el -> el.getPadding().getElements(), el -> this.visitContainer((JContainer)el, q));
        q.getAndSend((Object)namedImports, el -> Reference.asRef((Object)el.getType()), el -> this.visitType((JavaType)Reference.getValueNonNull((Object)el), q));
        return namedImports;
    }

    @Override
    public J visitImportSpecifier(JS.ImportSpecifier importSpecifier, RpcSendQueue q) {
        q.getAndSend((Object)importSpecifier, el -> el.getPadding().getImportType(), el -> this.visitLeftPadded((JLeftPadded)el, q));
        q.getAndSend((Object)importSpecifier, JS.ImportSpecifier::getSpecifier, el -> this.visit((Tree)el, q));
        q.getAndSend((Object)importSpecifier, el -> Reference.asRef((Object)el.getType()), el -> this.visitType((JavaType)Reference.getValueNonNull((Object)el), q));
        return importSpecifier;
    }

    @Override
    public J visitImportAttributes(JS.ImportAttributes importAttributes, RpcSendQueue q) {
        q.getAndSend((Object)importAttributes, JS.ImportAttributes::getToken);
        q.getAndSend((Object)importAttributes, el -> el.getPadding().getElements(), el -> this.visitContainer((JContainer)el, q));
        return importAttributes;
    }

    @Override
    public J visitImportTypeAttributes(JS.ImportTypeAttributes importTypeAttributes, RpcSendQueue q) {
        q.getAndSend((Object)importTypeAttributes, el -> el.getPadding().getToken(), el -> this.visitRightPadded((JRightPadded)el, q));
        q.getAndSend((Object)importTypeAttributes, el -> el.getPadding().getElements(), el -> this.visitContainer((JContainer)el, q));
        q.getAndSend((Object)importTypeAttributes, JS.ImportTypeAttributes::getEnd, el -> this.visitSpace((Space)Reference.getValueNonNull((Object)el), q));
        return importTypeAttributes;
    }

    @Override
    public J visitImportAttribute(JS.ImportAttribute importAttribute, RpcSendQueue q) {
        q.getAndSend((Object)importAttribute, JS.ImportAttribute::getName, el -> this.visit((Tree)el, q));
        q.getAndSend((Object)importAttribute, el -> el.getPadding().getValue(), el -> this.visitLeftPadded((JLeftPadded)el, q));
        return importAttribute;
    }

    @Override
    public J visitBinaryExtensions(JS.Binary binary, RpcSendQueue q) {
        q.getAndSend((Object)binary, JS.Binary::getLeft, el -> this.visit((Tree)el, q));
        q.getAndSend((Object)binary, el -> el.getPadding().getOperator(), el -> this.visitLeftPadded((JLeftPadded)el, q));
        q.getAndSend((Object)binary, JS.Binary::getRight, el -> this.visit((Tree)el, q));
        q.getAndSend((Object)binary, el -> Reference.asRef((Object)el.getType()), el -> this.visitType((JavaType)Reference.getValueNonNull((Object)el), q));
        return binary;
    }

    @Override
    public J visitLiteralType(JS.LiteralType literalType, RpcSendQueue q) {
        q.getAndSend((Object)literalType, JS.LiteralType::getLiteral, el -> this.visit((Tree)el, q));
        q.getAndSend((Object)literalType, el -> Reference.asRef((Object)el.getType()), el -> this.visitType((JavaType)Reference.getValueNonNull((Object)el), q));
        return literalType;
    }

    @Override
    public J visitMappedType(JS.MappedType mappedType, RpcSendQueue q) {
        q.getAndSend((Object)mappedType, el -> el.getPadding().getPrefixToken(), el -> this.visitLeftPadded((JLeftPadded)el, q));
        q.getAndSend((Object)mappedType, el -> el.getPadding().getHasReadonly(), el -> this.visitLeftPadded((JLeftPadded)el, q));
        q.getAndSend((Object)mappedType, JS.MappedType::getKeysRemapping, el -> this.visit((Tree)el, q));
        q.getAndSend((Object)mappedType, el -> el.getPadding().getSuffixToken(), el -> this.visitLeftPadded((JLeftPadded)el, q));
        q.getAndSend((Object)mappedType, el -> el.getPadding().getHasQuestionToken(), el -> this.visitLeftPadded((JLeftPadded)el, q));
        q.getAndSend((Object)mappedType, el -> el.getPadding().getValueType(), el -> this.visitContainer((JContainer)el, q));
        q.getAndSend((Object)mappedType, el -> Reference.asRef((Object)el.getType()), el -> this.visitType((JavaType)Reference.getValueNonNull((Object)el), q));
        return mappedType;
    }

    @Override
    public J visitMappedTypeKeysRemapping(JS.MappedType.KeysRemapping keysRemapping, RpcSendQueue q) {
        q.getAndSend((Object)keysRemapping, el -> el.getPadding().getTypeParameter(), el -> this.visitRightPadded((JRightPadded)el, q));
        q.getAndSend((Object)keysRemapping, el -> el.getPadding().getNameType(), el -> this.visitRightPadded((JRightPadded)el, q));
        return keysRemapping;
    }

    @Override
    public J visitMappedTypeParameter(JS.MappedType.Parameter parameter, RpcSendQueue q) {
        q.getAndSend((Object)parameter, JS.MappedType.Parameter::getName, el -> this.visit((Tree)el, q));
        q.getAndSend((Object)parameter, el -> el.getPadding().getIterateType(), el -> this.visitLeftPadded((JLeftPadded)el, q));
        return parameter;
    }

    @Override
    public J visitObjectBindingPattern(JS.ObjectBindingPattern objectBindingPattern, RpcSendQueue q) {
        q.getAndSendList((Object)objectBindingPattern, JS.ObjectBindingPattern::getLeadingAnnotations, J.Annotation::getId, el -> this.visit((Tree)el, q));
        q.getAndSendList((Object)objectBindingPattern, JS.ObjectBindingPattern::getModifiers, J.Modifier::getId, el -> this.visit((Tree)el, q));
        q.getAndSend((Object)objectBindingPattern, JS.ObjectBindingPattern::getTypeExpression, el -> this.visit((Tree)el, q));
        q.getAndSend((Object)objectBindingPattern, el -> el.getPadding().getBindings(), el -> this.visitContainer((JContainer)el, q));
        q.getAndSend((Object)objectBindingPattern, el -> el.getPadding().getInitializer(), el -> this.visitLeftPadded((JLeftPadded)el, q));
        return objectBindingPattern;
    }

    @Override
    public J visitPropertyAssignment(JS.PropertyAssignment propertyAssignment, RpcSendQueue q) {
        q.getAndSend((Object)propertyAssignment, el -> el.getPadding().getName(), el -> this.visitRightPadded((JRightPadded)el, q));
        q.getAndSend((Object)propertyAssignment, JS.PropertyAssignment::getAssigmentToken);
        q.getAndSend((Object)propertyAssignment, JS.PropertyAssignment::getInitializer, el -> this.visit((Tree)el, q));
        return propertyAssignment;
    }

    @Override
    public J visitSatisfiesExpression(JS.SatisfiesExpression satisfiesExpression, RpcSendQueue q) {
        q.getAndSend((Object)satisfiesExpression, JS.SatisfiesExpression::getExpression, el -> this.visit((Tree)el, q));
        q.getAndSend((Object)satisfiesExpression, el -> el.getPadding().getSatisfiesType(), el -> this.visitLeftPadded((JLeftPadded)el, q));
        q.getAndSend((Object)satisfiesExpression, el -> Reference.asRef((Object)el.getType()), el -> this.visitType((JavaType)Reference.getValueNonNull((Object)el), q));
        return satisfiesExpression;
    }

    @Override
    public J visitScopedVariableDeclarations(JS.ScopedVariableDeclarations scopedVariableDeclarations, RpcSendQueue q) {
        q.getAndSendList((Object)scopedVariableDeclarations, JS.ScopedVariableDeclarations::getModifiers, J.Modifier::getId, el -> this.visit((Tree)el, q));
        q.getAndSendList((Object)scopedVariableDeclarations, el -> el.getPadding().getVariables(), el -> ((J)el.getElement()).getId(), el -> this.visitRightPadded((JRightPadded)el, q));
        return scopedVariableDeclarations;
    }

    @Override
    public J visitStatementExpression(JS.StatementExpression statementExpression, RpcSendQueue q) {
        q.getAndSend((Object)statementExpression, JS.StatementExpression::getStatement, el -> this.visit((Tree)el, q));
        return statementExpression;
    }

    @Override
    public J visitTaggedTemplateExpression(JS.TaggedTemplateExpression taggedTemplateExpression, RpcSendQueue q) {
        q.getAndSend((Object)taggedTemplateExpression, el -> el.getPadding().getTag(), el -> this.visitRightPadded((JRightPadded)el, q));
        q.getAndSend((Object)taggedTemplateExpression, el -> el.getPadding().getTypeArguments(), el -> this.visitContainer((JContainer)el, q));
        q.getAndSend((Object)taggedTemplateExpression, JS.TaggedTemplateExpression::getTemplateExpression, el -> this.visit((Tree)el, q));
        q.getAndSend((Object)taggedTemplateExpression, el -> Reference.asRef((Object)el.getType()), el -> this.visitType((JavaType)Reference.getValueNonNull((Object)el), q));
        return taggedTemplateExpression;
    }

    @Override
    public J visitTemplateExpression(JS.TemplateExpression templateExpression, RpcSendQueue q) {
        q.getAndSend((Object)templateExpression, JS.TemplateExpression::getHead, el -> this.visit((Tree)el, q));
        q.getAndSendList((Object)templateExpression, el -> el.getPadding().getSpans(), el -> ((JS.TemplateExpression.Span)el.getElement()).getId(), el -> this.visitRightPadded((JRightPadded)el, q));
        q.getAndSend((Object)templateExpression, el -> Reference.asRef((Object)el.getType()), el -> this.visitType((JavaType)Reference.getValueNonNull((Object)el), q));
        return templateExpression;
    }

    @Override
    public J visitTemplateExpressionSpan(JS.TemplateExpression.Span span, RpcSendQueue q) {
        q.getAndSend((Object)span, JS.TemplateExpression.Span::getExpression, el -> this.visit((Tree)el, q));
        q.getAndSend((Object)span, JS.TemplateExpression.Span::getTail, el -> this.visit((Tree)el, q));
        return span;
    }

    @Override
    public J visitTuple(JS.Tuple tuple, RpcSendQueue q) {
        q.getAndSend((Object)tuple, el -> el.getPadding().getElements(), el -> this.visitContainer((JContainer)el, q));
        q.getAndSend((Object)tuple, el -> Reference.asRef((Object)el.getType()), el -> this.visitType((JavaType)Reference.getValueNonNull((Object)el), q));
        return tuple;
    }

    @Override
    public J visitTypeDeclaration(JS.TypeDeclaration typeDeclaration, RpcSendQueue q) {
        q.getAndSendList((Object)typeDeclaration, JS.TypeDeclaration::getModifiers, J.Modifier::getId, el -> this.visit((Tree)el, q));
        q.getAndSend((Object)typeDeclaration, el -> el.getPadding().getName(), el -> this.visitLeftPadded((JLeftPadded)el, q));
        q.getAndSend((Object)typeDeclaration, JS.TypeDeclaration::getTypeParameters, el -> this.visit((Tree)el, q));
        q.getAndSend((Object)typeDeclaration, el -> el.getPadding().getInitializer(), el -> this.visitLeftPadded((JLeftPadded)el, q));
        q.getAndSend((Object)typeDeclaration, el -> Reference.asRef((Object)el.getType()), el -> this.visitType((JavaType)Reference.getValueNonNull((Object)el), q));
        return typeDeclaration;
    }

    @Override
    public J visitTypeOf(JS.TypeOf typeOf, RpcSendQueue q) {
        q.getAndSend((Object)typeOf, JS.TypeOf::getExpression, el -> this.visit((Tree)el, q));
        q.getAndSend((Object)typeOf, el -> Reference.asRef((Object)el.getType()), el -> this.visitType((JavaType)Reference.getValueNonNull((Object)el), q));
        return typeOf;
    }

    @Override
    public J visitTypeTreeExpression(JS.TypeTreeExpression typeTreeExpression, RpcSendQueue q) {
        q.getAndSend((Object)typeTreeExpression, JS.TypeTreeExpression::getExpression, el -> this.visit((Tree)el, q));
        return typeTreeExpression;
    }

    @Override
    public J visitAs(JS.As as_, RpcSendQueue q) {
        q.getAndSend((Object)as_, el -> el.getPadding().getLeft(), el -> this.visitRightPadded((JRightPadded)el, q));
        q.getAndSend((Object)as_, JS.As::getRight, el -> this.visit((Tree)el, q));
        q.getAndSend((Object)as_, el -> Reference.asRef((Object)el.getType()), el -> this.visitType((JavaType)Reference.getValueNonNull((Object)el), q));
        return as_;
    }

    @Override
    public J visitAssignmentOperationExtensions(JS.AssignmentOperation assignmentOperation, RpcSendQueue q) {
        q.getAndSend((Object)assignmentOperation, JS.AssignmentOperation::getVariable, el -> this.visit((Tree)el, q));
        q.getAndSend((Object)assignmentOperation, el -> el.getPadding().getOperator(), el -> this.visitLeftPadded((JLeftPadded)el, q));
        q.getAndSend((Object)assignmentOperation, JS.AssignmentOperation::getAssignment, el -> this.visit((Tree)el, q));
        q.getAndSend((Object)assignmentOperation, el -> Reference.asRef((Object)el.getType()), el -> this.visitType((JavaType)Reference.getValueNonNull((Object)el), q));
        return assignmentOperation;
    }

    @Override
    public J visitIndexedAccessType(JS.IndexedAccessType indexedAccessType, RpcSendQueue q) {
        q.getAndSend((Object)indexedAccessType, JS.IndexedAccessType::getObjectType, el -> this.visit((Tree)el, q));
        q.getAndSend((Object)indexedAccessType, JS.IndexedAccessType::getIndexType, el -> this.visit((Tree)el, q));
        q.getAndSend((Object)indexedAccessType, el -> Reference.asRef((Object)el.getType()), el -> this.visitType((JavaType)Reference.getValueNonNull((Object)el), q));
        return indexedAccessType;
    }

    @Override
    public J visitIndexedAccessTypeIndexType(JS.IndexedAccessType.IndexType indexType, RpcSendQueue q) {
        q.getAndSend((Object)indexType, el -> el.getPadding().getElement(), el -> this.visitRightPadded((JRightPadded)el, q));
        q.getAndSend((Object)indexType, el -> Reference.asRef((Object)el.getType()), el -> this.visitType((JavaType)Reference.getValueNonNull((Object)el), q));
        return indexType;
    }

    @Override
    public J visitTypeQuery(JS.TypeQuery typeQuery, RpcSendQueue q) {
        q.getAndSend((Object)typeQuery, JS.TypeQuery::getTypeExpression, el -> this.visit((Tree)el, q));
        q.getAndSend((Object)typeQuery, el -> el.getPadding().getTypeArguments(), el -> this.visitContainer((JContainer)el, q));
        q.getAndSend((Object)typeQuery, el -> Reference.asRef((Object)el.getType()), el -> this.visitType((JavaType)Reference.getValueNonNull((Object)el), q));
        return typeQuery;
    }

    @Override
    public J visitTypeInfo(JS.TypeInfo typeInfo, RpcSendQueue q) {
        q.getAndSend((Object)typeInfo, JS.TypeInfo::getTypeIdentifier, el -> this.visit((Tree)el, q));
        return typeInfo;
    }

    @Override
    public J visitComputedPropertyName(JS.ComputedPropertyName computedPropertyName, RpcSendQueue q) {
        q.getAndSend((Object)computedPropertyName, el -> el.getPadding().getExpression(), el -> this.visitRightPadded((JRightPadded)el, q));
        return computedPropertyName;
    }

    @Override
    public J visitTypeOperator(JS.TypeOperator typeOperator, RpcSendQueue q) {
        q.getAndSend((Object)typeOperator, JS.TypeOperator::getOperator);
        q.getAndSend((Object)typeOperator, el -> el.getPadding().getExpression(), el -> this.visitLeftPadded((JLeftPadded)el, q));
        return typeOperator;
    }

    @Override
    public J visitTypePredicate(JS.TypePredicate typePredicate, RpcSendQueue q) {
        q.getAndSend((Object)typePredicate, el -> el.getPadding().getAsserts(), el -> this.visitLeftPadded((JLeftPadded)el, q));
        q.getAndSend((Object)typePredicate, JS.TypePredicate::getParameterName, el -> this.visit((Tree)el, q));
        q.getAndSend((Object)typePredicate, el -> el.getPadding().getExpression(), el -> this.visitLeftPadded((JLeftPadded)el, q));
        q.getAndSend((Object)typePredicate, el -> Reference.asRef((Object)el.getType()), el -> this.visitType((JavaType)Reference.getValueNonNull((Object)el), q));
        return typePredicate;
    }

    @Override
    public J visitUnion(JS.Union union, RpcSendQueue q) {
        q.getAndSendList((Object)union, el -> el.getPadding().getTypes(), el -> ((Expression)el.getElement()).getId(), el -> this.visitRightPadded((JRightPadded)el, q));
        q.getAndSend((Object)union, el -> Reference.asRef((Object)el.getType()), el -> this.visitType((JavaType)Reference.getValueNonNull((Object)el), q));
        return union;
    }

    @Override
    public J visitIntersection(JS.Intersection intersection, RpcSendQueue q) {
        q.getAndSendList((Object)intersection, el -> el.getPadding().getTypes(), el -> ((Expression)el.getElement()).getId(), el -> this.visitRightPadded((JRightPadded)el, q));
        q.getAndSend((Object)intersection, el -> Reference.asRef((Object)el.getType()), el -> this.visitType((JavaType)Reference.getValueNonNull((Object)el), q));
        return intersection;
    }

    @Override
    public J visitVoid(JS.Void void_, RpcSendQueue q) {
        q.getAndSend((Object)void_, JS.Void::getExpression, el -> this.visit((Tree)el, q));
        return void_;
    }

    @Override
    public J visitWithStatement(JS.WithStatement withStatement, RpcSendQueue q) {
        q.getAndSend((Object)withStatement, JS.WithStatement::getExpression, el -> this.visit((Tree)el, q));
        q.getAndSend((Object)withStatement, el -> el.getPadding().getBody(), el -> this.visitRightPadded((JRightPadded)el, q));
        return withStatement;
    }

    @Override
    public J visitJsxTag(JSX.Tag tag, RpcSendQueue q) {
        q.getAndSend((Object)tag, el -> el.getPadding().getOpenName(), el -> this.visitLeftPadded((JLeftPadded)el, q));
        q.getAndSend((Object)tag, JSX.Tag::getTypeArguments, el -> this.visitContainer((JContainer)el, q));
        q.getAndSend((Object)tag, JSX.Tag::getAfterName, space -> this.visitSpace((Space)space, q));
        q.getAndSendList((Object)tag, el -> el.getPadding().getAttributes(), attr -> ((JSX)attr.getElement()).getId(), attr -> this.visitRightPadded((JRightPadded)attr, q));
        q.getAndSend((Object)tag, JSX.Tag::getSelfClosing, space -> this.visitSpace((Space)space, q));
        q.getAndSendList((Object)tag, JSX.Tag::getChildren, Tree::getId, child -> this.visit((Tree)child, q));
        q.getAndSend((Object)tag, el -> el.getPadding().getClosingName(), el -> this.visitLeftPadded((JLeftPadded)el, q));
        q.getAndSend((Object)tag, JSX.Tag::getAfterClosingName, space -> this.visitSpace((Space)space, q));
        return tag;
    }

    @Override
    public J visitJsxAttribute(JSX.Attribute attribute, RpcSendQueue q) {
        q.getAndSend((Object)attribute, JSX.Attribute::getKey, el -> this.visit((Tree)el, q));
        q.getAndSend((Object)attribute, el -> el.getPadding().getValue(), el -> this.visitLeftPadded((JLeftPadded)el, q));
        return attribute;
    }

    @Override
    public J visitJsxSpreadAttribute(JSX.SpreadAttribute spreadAttribute, RpcSendQueue q) {
        q.getAndSend((Object)spreadAttribute, JSX.SpreadAttribute::getDots, space -> this.visitSpace((Space)space, q));
        q.getAndSend((Object)spreadAttribute, el -> el.getPadding().getExpression(), el -> this.visitRightPadded((JRightPadded)el, q));
        return spreadAttribute;
    }

    @Override
    public J visitJsxEmbeddedExpression(JSX.EmbeddedExpression embeddedExpression, RpcSendQueue q) {
        q.getAndSend((Object)embeddedExpression, el -> el.getPadding().getExpression(), el -> this.visitRightPadded((JRightPadded)el, q));
        return embeddedExpression;
    }

    @Override
    public J visitJsxNamespacedName(JSX.NamespacedName namespacedName, RpcSendQueue q) {
        q.getAndSend((Object)namespacedName, JSX.NamespacedName::getNamespace, el -> this.visit((Tree)el, q));
        q.getAndSend((Object)namespacedName, el -> el.getPadding().getName(), el -> this.visitLeftPadded((JLeftPadded)el, q));
        return namespacedName;
    }

    @Override
    public J visitIndexSignatureDeclaration(JS.IndexSignatureDeclaration indexSignatureDeclaration, RpcSendQueue q) {
        q.getAndSendList((Object)indexSignatureDeclaration, JS.IndexSignatureDeclaration::getModifiers, J.Modifier::getId, el -> this.visit((Tree)el, q));
        q.getAndSend((Object)indexSignatureDeclaration, el -> el.getPadding().getParameters(), el -> this.visitContainer((JContainer)el, q));
        q.getAndSend((Object)indexSignatureDeclaration, el -> el.getPadding().getTypeExpression(), el -> this.visitLeftPadded((JLeftPadded)el, q));
        q.getAndSend((Object)indexSignatureDeclaration, el -> Reference.asRef((Object)el.getType()), el -> this.visitType((JavaType)Reference.getValueNonNull((Object)el), q));
        return indexSignatureDeclaration;
    }

    @Override
    public J visitComputedPropertyMethodDeclaration(JS.ComputedPropertyMethodDeclaration computedPropMethod, RpcSendQueue q) {
        q.getAndSendList((Object)computedPropMethod, JS.ComputedPropertyMethodDeclaration::getLeadingAnnotations, J.Annotation::getId, el -> this.visit((Tree)el, q));
        q.getAndSendList((Object)computedPropMethod, JS.ComputedPropertyMethodDeclaration::getModifiers, J.Modifier::getId, el -> this.visit((Tree)el, q));
        q.getAndSend((Object)computedPropMethod, JS.ComputedPropertyMethodDeclaration::getTypeParameters, el -> this.visit((Tree)el, q));
        q.getAndSend((Object)computedPropMethod, JS.ComputedPropertyMethodDeclaration::getReturnTypeExpression, el -> this.visit((Tree)el, q));
        q.getAndSend((Object)computedPropMethod, JS.ComputedPropertyMethodDeclaration::getName, el -> this.visit((Tree)el, q));
        q.getAndSend((Object)computedPropMethod, el -> el.getPadding().getParameters(), el -> this.visitContainer((JContainer)el, q));
        q.getAndSend((Object)computedPropMethod, JS.ComputedPropertyMethodDeclaration::getBody, el -> this.visit((Tree)el, q));
        q.getAndSend((Object)computedPropMethod, el -> Reference.asRef((Object)el.getMethodType()), el -> this.visitType((JavaType)Reference.getValueNonNull((Object)el), q));
        return computedPropMethod;
    }

    @Override
    public J visitForOfLoop(JS.ForOfLoop forOfLoop, RpcSendQueue q) {
        q.getAndSend((Object)forOfLoop, JS.ForOfLoop::getAwait, space -> this.visitSpace((Space)space, q));
        q.getAndSend((Object)forOfLoop, JS.ForOfLoop::getLoop, el -> this.visit((Tree)el, q));
        return forOfLoop;
    }

    @Override
    public J visitForInLoop(JS.ForInLoop forInLoop, RpcSendQueue q) {
        q.getAndSend((Object)forInLoop, JS.ForInLoop::getControl, el -> this.visit((Tree)el, q));
        q.getAndSend((Object)forInLoop, el -> el.getPadding().getBody(), el -> this.visitRightPadded((JRightPadded)el, q));
        return forInLoop;
    }

    @Override
    public J visitNamespaceDeclaration(JS.NamespaceDeclaration namespaceDeclaration, RpcSendQueue q) {
        q.getAndSendList((Object)namespaceDeclaration, JS.NamespaceDeclaration::getModifiers, J.Modifier::getId, el -> this.visit((Tree)el, q));
        q.getAndSend((Object)namespaceDeclaration, el -> el.getPadding().getKeywordType(), el -> this.visitLeftPadded((JLeftPadded)el, q));
        q.getAndSend((Object)namespaceDeclaration, el -> el.getPadding().getName(), el -> this.visitRightPadded((JRightPadded)el, q));
        q.getAndSend((Object)namespaceDeclaration, JS.NamespaceDeclaration::getBody, el -> this.visit((Tree)el, q));
        return namespaceDeclaration;
    }

    @Override
    public J visitTypeLiteral(JS.TypeLiteral typeLiteral, RpcSendQueue q) {
        q.getAndSend((Object)typeLiteral, JS.TypeLiteral::getMembers, el -> this.visit((Tree)el, q));
        q.getAndSend((Object)typeLiteral, el -> Reference.asRef((Object)el.getType()), el -> this.visitType((JavaType)Reference.getValueNonNull((Object)el), q));
        return typeLiteral;
    }

    @Override
    public J visitArrayBindingPattern(JS.ArrayBindingPattern arrayBindingPattern, RpcSendQueue q) {
        q.getAndSend((Object)arrayBindingPattern, el -> el.getPadding().getElements(), el -> this.visitContainer((JContainer)el, q));
        q.getAndSend((Object)arrayBindingPattern, el -> Reference.asRef((Object)el.getType()), el -> this.visitType((JavaType)Reference.getValueNonNull((Object)el), q));
        return arrayBindingPattern;
    }

    @Override
    public J visitBindingElement(JS.BindingElement bindingElement, RpcSendQueue q) {
        q.getAndSend((Object)bindingElement, el -> el.getPadding().getPropertyName(), el -> this.visitRightPadded((JRightPadded)el, q));
        q.getAndSend((Object)bindingElement, JS.BindingElement::getName, el -> this.visit((Tree)el, q));
        q.getAndSend((Object)bindingElement, el -> el.getPadding().getInitializer(), el -> this.visitLeftPadded((JLeftPadded)el, q));
        q.getAndSend((Object)bindingElement, el -> Reference.asRef((Object)el.getVariableType()), el -> this.visitType((JavaType)Reference.getValueNonNull((Object)el), q));
        return bindingElement;
    }

    @Override
    public J visitExportDeclaration(JS.ExportDeclaration exportDeclaration, RpcSendQueue q) {
        q.getAndSendList((Object)exportDeclaration, JS.ExportDeclaration::getModifiers, J.Modifier::getId, el -> this.visit((Tree)el, q));
        q.getAndSend((Object)exportDeclaration, el -> el.getPadding().getTypeOnly(), el -> this.visitLeftPadded((JLeftPadded)el, q));
        q.getAndSend((Object)exportDeclaration, JS.ExportDeclaration::getExportClause, el -> this.visit((Tree)el, q));
        q.getAndSend((Object)exportDeclaration, el -> el.getPadding().getModuleSpecifier(), el -> this.visitLeftPadded((JLeftPadded)el, q));
        q.getAndSend((Object)exportDeclaration, JS.ExportDeclaration::getAttributes, el -> this.visit((Tree)el, q));
        return exportDeclaration;
    }

    @Override
    public J visitExportAssignment(JS.ExportAssignment exportAssignment, RpcSendQueue q) {
        q.getAndSend((Object)exportAssignment, JS.ExportAssignment::isExportEquals);
        q.getAndSend((Object)exportAssignment, el -> el.getPadding().getExpression(), el -> this.visitLeftPadded((JLeftPadded)el, q));
        return exportAssignment;
    }

    @Override
    public J visitNamedExports(JS.NamedExports namedExports, RpcSendQueue q) {
        q.getAndSend((Object)namedExports, el -> el.getPadding().getElements(), el -> this.visitContainer((JContainer)el, q));
        q.getAndSend((Object)namedExports, el -> Reference.asRef((Object)el.getType()), el -> this.visitType((JavaType)Reference.getValueNonNull((Object)el), q));
        return namedExports;
    }

    @Override
    public J visitExportSpecifier(JS.ExportSpecifier exportSpecifier, RpcSendQueue q) {
        q.getAndSend((Object)exportSpecifier, el -> el.getPadding().getTypeOnly(), el -> this.visitLeftPadded((JLeftPadded)el, q));
        q.getAndSend((Object)exportSpecifier, JS.ExportSpecifier::getSpecifier, el -> this.visit((Tree)el, q));
        q.getAndSend((Object)exportSpecifier, el -> Reference.asRef((Object)el.getType()), el -> this.visitType((JavaType)Reference.getValueNonNull((Object)el), q));
        return exportSpecifier;
    }

    @Override
    public J visitFunctionCall(JS.FunctionCall functionCall, RpcSendQueue q) {
        q.getAndSend((Object)functionCall, m -> m.getPadding().getFunction(), select -> this.visitRightPadded((JRightPadded)select, q));
        q.getAndSend((Object)functionCall, m -> m.getPadding().getTypeParameters(), typeParams -> this.visitContainer((JContainer)typeParams, q));
        q.getAndSend((Object)functionCall, m -> m.getPadding().getArguments(), args -> this.visitContainer((JContainer)args, q));
        q.getAndSend((Object)functionCall, m -> Reference.asRef((Object)m.getMethodType()), type -> this.visitType((JavaType)Reference.getValueNonNull((Object)type), q));
        return functionCall;
    }

    public <T> void visitLeftPadded(JLeftPadded<T> left, RpcSendQueue q) {
        this.delegate.visitLeftPadded(left, q);
    }

    public <T> void visitRightPadded(JRightPadded<T> right, RpcSendQueue q) {
        this.delegate.visitRightPadded(right, q);
    }

    public <J2 extends J> void visitContainer(JContainer<J2> container, RpcSendQueue q) {
        this.delegate.visitContainer(container, q);
    }

    public void visitSpace(Space space, RpcSendQueue q) {
        this.delegate.visitSpace(space, q);
    }

    public @Nullable JavaType visitType(@Nullable JavaType javaType, RpcSendQueue q) {
        return this.delegate.visitType(javaType, q);
    }

    private static class JavaScriptSenderDelegate
    extends JavaSender {
        private final JavaScriptSender delegate;

        public JavaScriptSenderDelegate(JavaScriptSender delegate) {
            this.delegate = delegate;
        }

        public @Nullable J visit(@Nullable Tree tree, RpcSendQueue p) {
            if (tree instanceof JS) {
                return this.delegate.visit(tree, p);
            }
            return (J)super.visit(tree, (Object)p);
        }
    }
}

