/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.javascript.rpc;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import io.moderne.jsonrpc.JsonRpc;
import io.moderne.jsonrpc.formatter.JsonMessageFormatter;
import io.moderne.jsonrpc.formatter.MessageFormatter;
import io.moderne.jsonrpc.handler.HeaderDelimitedMessageHandler;
import io.moderne.jsonrpc.handler.MessageHandler;
import io.moderne.jsonrpc.handler.TraceMessageHandler;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.net.Socket;
import java.nio.file.Path;
import java.nio.file.Paths;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.config.Environment;
import org.openrewrite.javascript.rpc.InstallRecipesByFile;
import org.openrewrite.javascript.rpc.InstallRecipesByPackage;
import org.openrewrite.javascript.rpc.InstallRecipesResponse;
import org.openrewrite.rpc.RewriteRpc;

public class JavaScriptRewriteRpc
extends RewriteRpc {
    private final @Nullable JavaScriptRewriteRpcProcess process;
    private final @Nullable Closeable closeable;

    private JavaScriptRewriteRpc(JavaScriptRewriteRpcProcess process, Environment marketplace) {
        super(process.getRpcClient(), marketplace);
        this.process = process;
        this.closeable = null;
    }

    private JavaScriptRewriteRpc(JsonRpc rpc, Closeable closeable, Environment marketplace) {
        super(rpc, marketplace);
        this.process = null;
        this.closeable = closeable;
    }

    public static JavaScriptRewriteRpc start(Environment marketplace, String ... command) {
        JavaScriptRewriteRpcProcess process = new JavaScriptRewriteRpcProcess(command);
        process.start();
        return new JavaScriptRewriteRpc(process, marketplace);
    }

    public static JavaScriptRewriteRpc connect(Environment marketplace, int port) {
        JsonRpc rpc;
        Socket socket;
        try {
            socket = new Socket("127.0.0.1", port);
            rpc = JavaScriptRewriteRpc.createRpcClient(socket.getInputStream(), socket.getOutputStream());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return new JavaScriptRewriteRpc(rpc, socket, marketplace);
    }

    public void shutdown() {
        super.shutdown();
        if (this.process != null) {
            this.process.interrupt();
            try {
                this.process.join();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.closeable != null) {
            try {
                this.closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public int installRecipes(File recipes) {
        return ((InstallRecipesResponse)this.send("InstallRecipes", new InstallRecipesByFile(recipes), InstallRecipesResponse.class)).getRecipesInstalled();
    }

    public int installRecipes(String packageName) {
        return this.installRecipes(packageName, null);
    }

    public int installRecipes(String packageName, @Nullable String version) {
        return ((InstallRecipesResponse)this.send("InstallRecipes", new InstallRecipesByPackage(new InstallRecipesByPackage.Package(packageName, version)), InstallRecipesResponse.class)).getRecipesInstalled();
    }

    private static JsonRpc createRpcClient(InputStream inputStream, OutputStream outputStream) {
        SimpleModule module = new SimpleModule();
        module.addSerializer(Path.class, (JsonSerializer)new PathSerializer());
        module.addDeserializer(Path.class, (JsonDeserializer)new PathDeserializer());
        JsonMessageFormatter formatter = new JsonMessageFormatter(new Module[]{module});
        HeaderDelimitedMessageHandler handler = new HeaderDelimitedMessageHandler((MessageFormatter)formatter, inputStream, outputStream);
        handler = new TraceMessageHandler("client", (MessageHandler)handler);
        return new JsonRpc((MessageHandler)handler);
    }

    private static class JavaScriptRewriteRpcProcess
    extends Thread {
        private final String[] command;
        private @Nullable Process process;
        private JsonRpc rpcClient;

        public JavaScriptRewriteRpcProcess(String ... command) {
            this.command = command;
            this.setDaemon(false);
        }

        @Override
        public void run() {
            try {
                ProcessBuilder pb = new ProcessBuilder(this.command);
                this.process = pb.start();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        @Override
        public synchronized void start() {
            super.start();
            while (this.process == null) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
            this.rpcClient = JavaScriptRewriteRpc.createRpcClient(this.process.getInputStream(), this.process.getOutputStream());
        }

        @Generated
        public JsonRpc getRpcClient() {
            return this.rpcClient;
        }
    }

    private static class PathSerializer
    extends JsonSerializer<Path> {
        private PathSerializer() {
        }

        public void serialize(Path path, JsonGenerator g, SerializerProvider serializerProvider) throws IOException {
            g.writeString(path.toString());
        }
    }

    private static class PathDeserializer
    extends JsonDeserializer<Path> {
        private PathDeserializer() {
        }

        public Path deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            String pathString = p.getValueAsString();
            return Paths.get(pathString, new String[0]);
        }
    }
}

