/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.javascript;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.SourceFile;
import org.openrewrite.config.Environment;
import org.openrewrite.javascript.rpc.JavaScriptRewriteRpc;
import org.openrewrite.javascript.tree.JS;

public class JavaScriptParser
implements Parser {
    private final JavaScriptRewriteRpc client;
    private static final List<String> EXTENSIONS = Collections.unmodifiableList(Arrays.asList(".js", ".mjs", ".cjs", ".ts", ".mts", ".cts"));
    private static final List<String> EXCLUSIONS = Collections.unmodifiableList(Arrays.asList(".pnp.cjs", ".pnp.loader.mjs"));

    private JavaScriptParser(Path nodePath, Path installationDir) {
        this.client = JavaScriptRewriteRpc.start(Environment.builder().build(), nodePath.toString(), "--enable-source-maps", installationDir.resolve("server.js").toString());
    }

    public Stream<SourceFile> parseInputs(Iterable<Parser.Input> sources, @Nullable Path relativeTo, ExecutionContext ctx) {
        return this.client.parse("javascript", sources, relativeTo).stream();
    }

    public boolean accept(Path path) {
        if (path.toString().contains("/dist/")) {
            return false;
        }
        String filename = path.getFileName().toString().toLowerCase();
        for (String ext : EXTENSIONS) {
            if (!filename.endsWith(ext) || EXCLUSIONS.contains(filename)) continue;
            return true;
        }
        return false;
    }

    public Path sourcePathFromSourceText(Path prefix, String sourceCode) {
        return prefix.resolve("source.js");
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends Parser.Builder {
        private Path nodePath = Paths.get("node", new String[0]);
        private @Nullable Path installationDir;

        Builder() {
            super(JS.CompilationUnit.class);
        }

        public Builder nodePath(Path path) {
            this.nodePath = path;
            return this;
        }

        public Builder installationDir(Path installationDir) {
            this.installationDir = installationDir;
            return this;
        }

        public JavaScriptParser build() {
            return new JavaScriptParser(this.nodePath, Objects.requireNonNull(this.installationDir));
        }

        public String getDslName() {
            return "javascript";
        }
    }
}

