/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.javascript.internal;

import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.SourceFile;
import org.openrewrite.internal.EncodingDetectingInputStream;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.internal.JavaTypeCache;
import org.openrewrite.javascript.JavaScriptParser;
import org.openrewrite.javascript.internal.JavetNativeBridge;
import org.openrewrite.javascript.internal.TypeScriptParserVisitor;
import org.openrewrite.javascript.internal.tsc.TSCNode;
import org.openrewrite.javascript.internal.tsc.TSCRuntime;
import org.openrewrite.javascript.internal.tsc.TSCSourceFileContext;
import org.openrewrite.javascript.tree.JS;
import org.openrewrite.style.NamedStyles;
import org.openrewrite.tree.ParseError;
import org.openrewrite.tree.ParsingEventListener;
import org.openrewrite.tree.ParsingExecutionContextView;

public abstract class TSCMapper
implements AutoCloseable {
    private final TSCRuntime runtime;
    @Nullable
    private final Path relativeTo;
    private final Collection<NamedStyles> styles;
    private final ExecutionContext ctx;
    private final Map<Path, SourceWrapper> sourcesByRelativePath = new LinkedHashMap<Path, SourceWrapper>();

    public TSCMapper(@Nullable Path relativeTo, Collection<NamedStyles> styles, ExecutionContext ctx) {
        JavetNativeBridge.init();
        this.runtime = TSCRuntime.init();
        this.relativeTo = relativeTo;
        this.styles = styles;
        this.ctx = ctx;
    }

    public void add(Parser.Input input) {
        EncodingDetectingInputStream is = input.getSource(this.ctx);
        String inputSourceText = is.readFully();
        Path relativePath = input.getRelativePath(this.relativeTo);
        SourceWrapper source = new SourceWrapper(input, relativePath, is.getCharset(), is.isCharsetBomMarked(), inputSourceText);
        this.sourcesByRelativePath.put(relativePath, source);
    }

    public List<SourceFile> build() {
        ArrayList<SourceFile> compilationUnits = new ArrayList<SourceFile>(this.sourcesByRelativePath.size());
        ParsingEventListener parsingListener = ParsingExecutionContextView.view((ExecutionContext)this.ctx).getParsingListener();
        LinkedHashMap<Path, String> sourceTextsForTSC = new LinkedHashMap<Path, String>();
        this.sourcesByRelativePath.forEach((relativePath, sourceText) -> sourceTextsForTSC.put((Path)relativePath, ((SourceWrapper)sourceText).sourceText));
        this.runtime.parseSourceTexts(sourceTextsForTSC, (node, context) -> {
            JS.CompilationUnit cu;
            SourceWrapper source = this.sourcesByRelativePath.get(context.getRelativeSourcePath());
            TypeScriptParserVisitor fileMapper = new TypeScriptParserVisitor((TSCNode)node, (TSCSourceFileContext)context, source.getSourcePath(), new JavaTypeCache(), source.getCharset().toString(), source.isCharsetBomMarked(), this.styles);
            try {
                cu = fileMapper.visitSourceFile();
                parsingListener.parsed(source.getInput(), (SourceFile)cu);
            }
            catch (Throwable t) {
                this.ctx.getOnError().accept(t);
                cu = ParseError.build((Parser)JavaScriptParser.builder().build(), (Parser.Input)source.getInput(), (Path)this.relativeTo, (ExecutionContext)this.ctx, (Throwable)t);
            }
            compilationUnits.add(cu);
        });
        return compilationUnits;
    }

    @Override
    public void close() {
        this.runtime.close();
    }

    private static final class SourceWrapper {
        private final Parser.Input input;
        private final Path sourcePath;
        private final Charset charset;
        private final boolean isCharsetBomMarked;
        private final String sourceText;

        public SourceWrapper(Parser.Input input, Path sourcePath, Charset charset, boolean isCharsetBomMarked, String sourceText) {
            this.input = input;
            this.sourcePath = sourcePath;
            this.charset = charset;
            this.isCharsetBomMarked = isCharsetBomMarked;
            this.sourceText = sourceText;
        }

        public Parser.Input getInput() {
            return this.input;
        }

        public Path getSourcePath() {
            return this.sourcePath;
        }

        public Charset getCharset() {
            return this.charset;
        }

        public boolean isCharsetBomMarked() {
            return this.isCharsetBomMarked;
        }

        public String getSourceText() {
            return this.sourceText;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SourceWrapper)) {
                return false;
            }
            SourceWrapper other = (SourceWrapper)o;
            if (this.isCharsetBomMarked() != other.isCharsetBomMarked()) {
                return false;
            }
            Parser.Input this$input = this.getInput();
            Parser.Input other$input = other.getInput();
            if (this$input == null ? other$input != null : !this$input.equals(other$input)) {
                return false;
            }
            Path this$sourcePath = this.getSourcePath();
            Path other$sourcePath = other.getSourcePath();
            if (this$sourcePath == null ? other$sourcePath != null : !((Object)this$sourcePath).equals(other$sourcePath)) {
                return false;
            }
            Charset this$charset = this.getCharset();
            Charset other$charset = other.getCharset();
            if (this$charset == null ? other$charset != null : !((Object)this$charset).equals(other$charset)) {
                return false;
            }
            String this$sourceText = this.getSourceText();
            String other$sourceText = other.getSourceText();
            return !(this$sourceText == null ? other$sourceText != null : !this$sourceText.equals(other$sourceText));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isCharsetBomMarked() ? 79 : 97);
            Parser.Input $input = this.getInput();
            result = result * 59 + ($input == null ? 43 : $input.hashCode());
            Path $sourcePath = this.getSourcePath();
            result = result * 59 + ($sourcePath == null ? 43 : ((Object)$sourcePath).hashCode());
            Charset $charset = this.getCharset();
            result = result * 59 + ($charset == null ? 43 : ((Object)$charset).hashCode());
            String $sourceText = this.getSourceText();
            result = result * 59 + ($sourceText == null ? 43 : $sourceText.hashCode());
            return result;
        }

        public String toString() {
            return "TSCMapper.SourceWrapper(input=" + this.getInput() + ", sourcePath=" + this.getSourcePath() + ", charset=" + this.getCharset() + ", isCharsetBomMarked=" + this.isCharsetBomMarked() + ", sourceText=" + this.getSourceText() + ")";
        }
    }
}

