/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.javascript.style;

import lombok.Generated;
import org.openrewrite.javascript.style.IntelliJ;
import org.openrewrite.javascript.style.JavaScriptStyle;
import org.openrewrite.style.Style;
import org.openrewrite.style.StyleHelper;

public final class TabsAndIndentsStyle
implements JavaScriptStyle {
    private final boolean useTabCharacter;
    private final int tabSize;
    private final int indentSize;
    private final int continuationIndent;
    private final boolean keepIndentsOnEmptyLines;
    private final boolean indentChainedMethods;
    private final boolean indentAllChainedCallsInAGroup;

    public Style applyDefaults() {
        return (Style)StyleHelper.merge((Object)IntelliJ.TypeScript.tabsAndIndents(), (Object)this);
    }

    @Generated
    public TabsAndIndentsStyle(boolean useTabCharacter, int tabSize, int indentSize, int continuationIndent, boolean keepIndentsOnEmptyLines, boolean indentChainedMethods, boolean indentAllChainedCallsInAGroup) {
        this.useTabCharacter = useTabCharacter;
        this.tabSize = tabSize;
        this.indentSize = indentSize;
        this.continuationIndent = continuationIndent;
        this.keepIndentsOnEmptyLines = keepIndentsOnEmptyLines;
        this.indentChainedMethods = indentChainedMethods;
        this.indentAllChainedCallsInAGroup = indentAllChainedCallsInAGroup;
    }

    @Generated
    public boolean isUseTabCharacter() {
        return this.useTabCharacter;
    }

    @Generated
    public int getTabSize() {
        return this.tabSize;
    }

    @Generated
    public int getIndentSize() {
        return this.indentSize;
    }

    @Generated
    public int getContinuationIndent() {
        return this.continuationIndent;
    }

    @Generated
    public boolean isKeepIndentsOnEmptyLines() {
        return this.keepIndentsOnEmptyLines;
    }

    @Generated
    public boolean isIndentChainedMethods() {
        return this.indentChainedMethods;
    }

    @Generated
    public boolean isIndentAllChainedCallsInAGroup() {
        return this.indentAllChainedCallsInAGroup;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TabsAndIndentsStyle)) {
            return false;
        }
        TabsAndIndentsStyle other = (TabsAndIndentsStyle)o;
        if (this.isUseTabCharacter() != other.isUseTabCharacter()) {
            return false;
        }
        if (this.getTabSize() != other.getTabSize()) {
            return false;
        }
        if (this.getIndentSize() != other.getIndentSize()) {
            return false;
        }
        if (this.getContinuationIndent() != other.getContinuationIndent()) {
            return false;
        }
        if (this.isKeepIndentsOnEmptyLines() != other.isKeepIndentsOnEmptyLines()) {
            return false;
        }
        if (this.isIndentChainedMethods() != other.isIndentChainedMethods()) {
            return false;
        }
        return this.isIndentAllChainedCallsInAGroup() == other.isIndentAllChainedCallsInAGroup();
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isUseTabCharacter() ? 79 : 97);
        result = result * 59 + this.getTabSize();
        result = result * 59 + this.getIndentSize();
        result = result * 59 + this.getContinuationIndent();
        result = result * 59 + (this.isKeepIndentsOnEmptyLines() ? 79 : 97);
        result = result * 59 + (this.isIndentChainedMethods() ? 79 : 97);
        result = result * 59 + (this.isIndentAllChainedCallsInAGroup() ? 79 : 97);
        return result;
    }

    @Generated
    public String toString() {
        return "TabsAndIndentsStyle(useTabCharacter=" + this.isUseTabCharacter() + ", tabSize=" + this.getTabSize() + ", indentSize=" + this.getIndentSize() + ", continuationIndent=" + this.getContinuationIndent() + ", keepIndentsOnEmptyLines=" + this.isKeepIndentsOnEmptyLines() + ", indentChainedMethods=" + this.isIndentChainedMethods() + ", indentAllChainedCallsInAGroup=" + this.isIndentAllChainedCallsInAGroup() + ")";
    }

    @Generated
    public TabsAndIndentsStyle withUseTabCharacter(boolean useTabCharacter) {
        return this.useTabCharacter == useTabCharacter ? this : new TabsAndIndentsStyle(useTabCharacter, this.tabSize, this.indentSize, this.continuationIndent, this.keepIndentsOnEmptyLines, this.indentChainedMethods, this.indentAllChainedCallsInAGroup);
    }

    @Generated
    public TabsAndIndentsStyle withTabSize(int tabSize) {
        return this.tabSize == tabSize ? this : new TabsAndIndentsStyle(this.useTabCharacter, tabSize, this.indentSize, this.continuationIndent, this.keepIndentsOnEmptyLines, this.indentChainedMethods, this.indentAllChainedCallsInAGroup);
    }

    @Generated
    public TabsAndIndentsStyle withIndentSize(int indentSize) {
        return this.indentSize == indentSize ? this : new TabsAndIndentsStyle(this.useTabCharacter, this.tabSize, indentSize, this.continuationIndent, this.keepIndentsOnEmptyLines, this.indentChainedMethods, this.indentAllChainedCallsInAGroup);
    }

    @Generated
    public TabsAndIndentsStyle withContinuationIndent(int continuationIndent) {
        return this.continuationIndent == continuationIndent ? this : new TabsAndIndentsStyle(this.useTabCharacter, this.tabSize, this.indentSize, continuationIndent, this.keepIndentsOnEmptyLines, this.indentChainedMethods, this.indentAllChainedCallsInAGroup);
    }

    @Generated
    public TabsAndIndentsStyle withKeepIndentsOnEmptyLines(boolean keepIndentsOnEmptyLines) {
        return this.keepIndentsOnEmptyLines == keepIndentsOnEmptyLines ? this : new TabsAndIndentsStyle(this.useTabCharacter, this.tabSize, this.indentSize, this.continuationIndent, keepIndentsOnEmptyLines, this.indentChainedMethods, this.indentAllChainedCallsInAGroup);
    }

    @Generated
    public TabsAndIndentsStyle withIndentChainedMethods(boolean indentChainedMethods) {
        return this.indentChainedMethods == indentChainedMethods ? this : new TabsAndIndentsStyle(this.useTabCharacter, this.tabSize, this.indentSize, this.continuationIndent, this.keepIndentsOnEmptyLines, indentChainedMethods, this.indentAllChainedCallsInAGroup);
    }

    @Generated
    public TabsAndIndentsStyle withIndentAllChainedCallsInAGroup(boolean indentAllChainedCallsInAGroup) {
        return this.indentAllChainedCallsInAGroup == indentAllChainedCallsInAGroup ? this : new TabsAndIndentsStyle(this.useTabCharacter, this.tabSize, this.indentSize, this.continuationIndent, this.keepIndentsOnEmptyLines, this.indentChainedMethods, indentAllChainedCallsInAGroup);
    }
}

