/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.javascript.internal;

import java.util.List;
import java.util.function.UnaryOperator;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.PrintOutputCapture;
import org.openrewrite.Tree;
import org.openrewrite.java.JavaPrinter;
import org.openrewrite.java.marker.OmitParentheses;
import org.openrewrite.java.marker.Semicolon;
import org.openrewrite.java.marker.TrailingComma;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JContainer;
import org.openrewrite.java.tree.JLeftPadded;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.javascript.JavaScriptVisitor;
import org.openrewrite.javascript.markers.Braces;
import org.openrewrite.javascript.markers.Comma;
import org.openrewrite.javascript.markers.Keyword;
import org.openrewrite.javascript.markers.PostFixOperator;
import org.openrewrite.javascript.tree.JS;
import org.openrewrite.javascript.tree.JsContainer;
import org.openrewrite.javascript.tree.JsLeftPadded;
import org.openrewrite.javascript.tree.JsRightPadded;
import org.openrewrite.javascript.tree.JsSpace;
import org.openrewrite.marker.Marker;
import org.openrewrite.marker.Markers;

public class JavaScriptPrinter<P>
extends JavaScriptVisitor<PrintOutputCapture<P>> {
    private static final UnaryOperator<String> JAVA_SCRIPT_MARKER_WRAPPER = out -> "/*~~" + out + (out.isEmpty() ? "" : "~~") + ">*/";
    private final JavaScriptJavaPrinter delegate = new JavaScriptJavaPrinter();

    public J visit(@Nullable Tree tree, PrintOutputCapture<P> p) {
        if (!(tree instanceof JS)) {
            return this.delegate.visit(tree, p);
        }
        return (J)super.visit(tree, p);
    }

    public void setCursor(@Nullable Cursor cursor) {
        super.setCursor(cursor);
        this.delegate.internalSetCursor(cursor);
    }

    private void internalSetCursor(@Nullable Cursor cursor) {
        super.setCursor(cursor);
    }

    @Override
    public J visitCompilationUnit(JS.CompilationUnit cu, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)cu, Space.Location.COMPILATION_UNIT_PREFIX, p);
        this.visitRightPadded(cu.getPadding().getStatements(), JRightPadded.Location.LANGUAGE_EXTENSION, "", p);
        this.visitSpace(cu.getEof(), Space.Location.COMPILATION_UNIT_EOF, p);
        this.afterSyntax(cu, p);
        return cu;
    }

    @Override
    public J visitAlias(JS.Alias alias, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)alias, JsSpace.Location.ALIAS_PREFIX, p);
        this.visitRightPadded(alias.getPadding().getPropertyName(), JsRightPadded.Location.ALIAS_PROPERTY_NAME, p);
        p.append("as");
        this.visit((Tree)alias.getAlias(), p);
        this.afterSyntax(alias, p);
        return alias;
    }

    @Override
    public J visitArrowFunction(JS.ArrowFunction arrowFunction, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)arrowFunction, JsSpace.Location.ARROW_FUNCTION_PREFIX, p);
        this.visit(arrowFunction.getLeadingAnnotations(), p);
        arrowFunction.getModifiers().forEach(m -> this.delegate.visitModifier((J.Modifier)m, p));
        J.TypeParameters typeParameters = arrowFunction.getTypeParameters();
        if (typeParameters != null) {
            this.visit(typeParameters.getAnnotations(), p);
            this.visitSpace(typeParameters.getPrefix(), Space.Location.TYPE_PARAMETERS, p);
            this.visitMarkers(typeParameters.getMarkers(), p);
            p.append("<");
            this.visitRightPadded((List<JRightPadded<J>>)typeParameters.getPadding().getTypeParameters(), JRightPadded.Location.TYPE_PARAMETER, ",", p);
            p.append(">");
        }
        if (arrowFunction.getParameters().isParenthesized()) {
            this.visitSpace(arrowFunction.getParameters().getPrefix(), Space.Location.LAMBDA_PARAMETERS_PREFIX, p);
            p.append('(');
            this.visitRightPadded((List<JRightPadded<J>>)arrowFunction.getParameters().getPadding().getParams(), JRightPadded.Location.LAMBDA_PARAM, ",", p);
            p.append(')');
        } else {
            this.visitRightPadded((List<JRightPadded<J>>)arrowFunction.getParameters().getPadding().getParams(), JRightPadded.Location.LAMBDA_PARAM, ",", p);
        }
        if (arrowFunction.getReturnTypeExpression() != null) {
            this.visit((Tree)arrowFunction.getReturnTypeExpression(), p);
        }
        this.visitLeftPadded("=>", arrowFunction.getPadding().getBody(), JsLeftPadded.Location.LAMBDA_ARROW, p);
        this.afterSyntax(arrowFunction, p);
        return arrowFunction;
    }

    @Override
    public J visitAwait(JS.Await await, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)await, JsSpace.Location.AWAIT_PREFIX, p);
        p.append("await");
        this.visit((Tree)await.getExpression(), p);
        this.afterSyntax(await, p);
        return await;
    }

    @Override
    public J visitBindingElement(JS.BindingElement binding, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)binding, JsSpace.Location.BINDING_ELEMENT_PREFIX, p);
        if (binding.getPropertyName() != null) {
            this.visitRightPadded(binding.getPadding().getPropertyName(), JsRightPadded.Location.BINDING_ELEMENT_PROPERTY_NAME, p);
            p.append(":");
        }
        this.visit((Tree)binding.getName(), p);
        this.visitLeftPadded("=", binding.getPadding().getInitializer(), JsLeftPadded.Location.BINDING_ELEMENT_INITIALIZER, p);
        this.afterSyntax(binding, p);
        return binding;
    }

    @Override
    public J visitConditionalType(JS.ConditionalType conditionalType, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)conditionalType, JsSpace.Location.CONDITIONAL_TYPE_PREFIX, p);
        this.visit((Tree)conditionalType.getCheckType(), p);
        this.visitContainer("extends", conditionalType.getPadding().getCondition(), JsContainer.Location.CONDITIONAL_TYPE_CONDITION, "", "", p);
        this.afterSyntax(conditionalType, p);
        return conditionalType;
    }

    @Override
    public J visitDefaultType(JS.DefaultType defaultType, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)defaultType, JsSpace.Location.DEFAULT_TYPE_PREFIX, p);
        this.visit((Tree)defaultType.getLeft(), p);
        this.visitSpace(defaultType.getBeforeEquals(), Space.Location.ASSIGNMENT_OPERATION_PREFIX, p);
        p.append("=");
        this.visit((Tree)defaultType.getRight(), p);
        this.afterSyntax(defaultType, p);
        return defaultType;
    }

    @Override
    public J visitDelete(JS.Delete delete, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)delete, JsSpace.Location.DELETE_PREFIX, p);
        p.append("delete");
        this.visit((Tree)delete.getExpression(), p);
        this.afterSyntax(delete, p);
        return delete;
    }

    @Override
    public J visitExpressionWithTypeArguments(JS.ExpressionWithTypeArguments type, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)type, JsSpace.Location.EXPR_WITH_TYPE_ARG_PREFIX, p);
        this.visit((Tree)type.getClazz(), p);
        this.visitContainer("<", type.getPadding().getTypeArguments(), JsContainer.Location.EXPR_WITH_TYPE_ARG_PARAMETERS, ",", ">", p);
        this.afterSyntax(type, p);
        return type;
    }

    @Override
    public J visitTrailingTokenStatement(JS.TrailingTokenStatement statement, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)statement, JsSpace.Location.TRAILING_TOKEN_PREFIX, p);
        this.visitRightPadded(statement.getPadding().getExpression(), JsRightPadded.Location.TRAILING_TOKEN_EXPRESSION, p);
        this.afterSyntax(statement, p);
        return statement;
    }

    @Override
    public J visitExport(JS.Export export, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)export, JsSpace.Location.EXPORT_PREFIX, p);
        p.append("export");
        boolean printBrackets = export.getPadding().getExports() != null && export.getPadding().getExports().getMarkers().findFirst(Braces.class).isPresent();
        this.visitContainer(printBrackets ? "{" : "", export.getPadding().getExports(), JsContainer.Location.FUNCTION_TYPE_PARAMETER, ",", printBrackets ? "}" : "", p);
        if (export.getFrom() != null) {
            this.visitSpace(export.getFrom(), Space.Location.LANGUAGE_EXTENSION, p);
            p.append("from");
        }
        this.visit((Tree)export.getTarget(), p);
        this.visitLeftPadded("default", export.getPadding().getInitializer(), JsLeftPadded.Location.IMPORT_INITIALIZER, p);
        this.afterSyntax(export, p);
        return export;
    }

    @Override
    public J visitFunctionType(JS.FunctionType functionType, PrintOutputCapture<P> p) {
        J.TypeParameters typeParameters;
        this.beforeSyntax((J)functionType, JsSpace.Location.FUNCTION_TYPE_PREFIX, p);
        functionType.getModifiers().forEach(m -> this.delegate.visitModifier((J.Modifier)m, p));
        if (functionType.isConstructorType()) {
            this.visitLeftPaddedBoolean("new", functionType.getPadding().getConstructorType(), JsLeftPadded.Location.FUNCTION_TYPE_CONSTRUCTOR, p);
        }
        if ((typeParameters = functionType.getTypeParameters()) != null) {
            this.visit(typeParameters.getAnnotations(), p);
            this.visitSpace(typeParameters.getPrefix(), Space.Location.TYPE_PARAMETERS, p);
            this.visitMarkers(typeParameters.getMarkers(), p);
            p.append("<");
            this.visitRightPadded((List<JRightPadded<J>>)typeParameters.getPadding().getTypeParameters(), JRightPadded.Location.TYPE_PARAMETER, ",", p);
            p.append(">");
        }
        this.visitContainer("(", functionType.getPadding().getParameters(), JsContainer.Location.FUNCTION_TYPE_PARAMETER, ",", ")", p);
        this.visitSpace(functionType.getArrow(), JsSpace.Location.FUNCTION_TYPE_ARROW_PREFIX, p);
        p.append("=>");
        this.visit((Tree)functionType.getReturnType(), p);
        this.afterSyntax(functionType, p);
        return functionType;
    }

    @Override
    public J visitInferType(JS.InferType inferType, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)inferType, JsSpace.Location.INFER_TYPE_PREFIX, p);
        this.visitLeftPadded("infer", inferType.getPadding().getTypeParameter(), JsLeftPadded.Location.INFER_TYPE_PARAMETER, p);
        this.afterSyntax(inferType, p);
        return inferType;
    }

    @Override
    public J visitImportType(JS.ImportType importType, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)importType, JsSpace.Location.IMPORT_TYPE_PREFIX, p);
        if (importType.isHasTypeof()) {
            p.append("typeof");
            this.visitRightPadded(importType.getPadding().getHasTypeof(), JsRightPadded.Location.IMPORT_TYPE_TYPEOF, p);
        }
        p.append("import");
        this.visit((Tree)importType.getImportArgument(), p);
        this.visitLeftPadded(".", importType.getPadding().getQualifier(), JsLeftPadded.Location.IMPORT_TYPE_QUALIFIER, p);
        this.visitContainer("<", importType.getPadding().getTypeArguments(), JsContainer.Location.IMPORT_TYPE_TYPE_ARGUMENTS, ",", ">", p);
        this.afterSyntax(importType, p);
        return importType;
    }

    @Override
    public J visitJsImport(JS.JsImport jsImport, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)jsImport, JsSpace.Location.EXPORT_PREFIX, p);
        p.append("import");
        if (jsImport.getImportType()) {
            this.visitLeftPaddedBoolean("type", jsImport.getPadding().getImportType(), JsLeftPadded.Location.JS_IMPORT_IMPORT_TYPE, p);
        }
        JS.JsImport.Padding padding = jsImport.getPadding();
        this.visitRightPadded(padding.getName(), JsRightPadded.Location.IMPORT_NAME_SUFFIX, p);
        if (jsImport.getName() != null && padding.getImports() != null) {
            p.append(",");
        }
        boolean braces = padding.getImports() != null && padding.getImports().getPadding().getElements().stream().noneMatch(e -> e.getElement() instanceof JS.Alias);
        this.visitContainer(braces ? "{" : "", padding.getImports(), JsContainer.Location.IMPORT_ELEMENT, ",", braces ? "}" : "", p);
        if (jsImport.getFrom() != null) {
            this.visitSpace(jsImport.getFrom(), Space.Location.LANGUAGE_EXTENSION, p);
            p.append("from");
        }
        this.visit((Tree)jsImport.getTarget(), p);
        this.visitLeftPadded("=", padding.getInitializer(), JsLeftPadded.Location.IMPORT_INITIALIZER, p);
        this.afterSyntax(jsImport, p);
        return jsImport;
    }

    @Override
    public J visitJsImportSpecifier(JS.JsImportSpecifier jis, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)jis, JsSpace.Location.JS_IMPORT_SPECIFIER_PREFIX, p);
        if (jis.getImportType()) {
            this.visitLeftPaddedBoolean("type", jis.getPadding().getImportType(), JsLeftPadded.Location.JS_IMPORT_SPECIFIER_IMPORT_TYPE, p);
        }
        this.visit((Tree)jis.getSpecifier(), p);
        this.afterSyntax(jis, p);
        return jis;
    }

    @Override
    public J visitJsBinary(JS.JsBinary binary, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)binary, JsSpace.Location.BINARY_PREFIX, p);
        this.visit((Tree)binary.getLeft(), p);
        String keyword = "";
        switch (binary.getOperator()) {
            case As: {
                keyword = "as";
                break;
            }
            case IdentityEquals: {
                keyword = "===";
                break;
            }
            case IdentityNotEquals: {
                keyword = "!==";
                break;
            }
            case In: {
                keyword = "in";
                break;
            }
            case QuestionQuestion: {
                keyword = "??";
                break;
            }
            case Comma: {
                keyword = ",";
            }
        }
        this.visitSpace(binary.getPadding().getOperator().getBefore(), JsSpace.Location.BINARY_PREFIX, p);
        p.append(keyword);
        this.visit((Tree)binary.getRight(), p);
        this.afterSyntax(binary, p);
        return binary;
    }

    @Override
    public J visitJsAssignmentOperation(JS.JsAssignmentOperation assignOp, PrintOutputCapture<P> p) {
        String keyword = "";
        switch (assignOp.getOperator()) {
            case QuestionQuestion: {
                keyword = "??=";
                break;
            }
            case And: {
                keyword = "&&=";
                break;
            }
            case Or: {
                keyword = "||=";
                break;
            }
            case Power: {
                keyword = "**";
            }
        }
        this.beforeSyntax((J)assignOp, JsSpace.Location.ASSIGNMENT_OPERATION_PREFIX, p);
        this.visit((Tree)assignOp.getVariable(), p);
        this.visitSpace(assignOp.getPadding().getOperator().getBefore(), JsSpace.Location.ASSIGNMENT_OPERATION_OPERATOR, p);
        p.append(keyword);
        this.visit((Tree)assignOp.getAssignment(), p);
        this.afterSyntax(assignOp, p);
        return assignOp;
    }

    @Override
    public J visitTypeTreeExpression(JS.TypeTreeExpression typeTreeExpression, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)typeTreeExpression, JsSpace.Location.TYPE_TREE_EXPRESSION_PREFIX, p);
        this.visit((Tree)typeTreeExpression.getExpression(), p);
        this.afterSyntax(typeTreeExpression, p);
        return typeTreeExpression;
    }

    @Override
    public J visitPropertyAssignment(JS.PropertyAssignment propertyAssignment, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)propertyAssignment, JsSpace.Location.PROPERTY_ASSIGNMENT_PREFIX, p);
        this.visitRightPadded(propertyAssignment.getPadding().getName(), JsRightPadded.Location.PROPERTY_ASSIGNMENT_NAME, p);
        if (propertyAssignment.getInitializer() != null) {
            if (propertyAssignment.getAssigmentToken() == JS.PropertyAssignment.AssigmentToken.Colon) {
                p.append(':');
            } else if (propertyAssignment.getAssigmentToken() == JS.PropertyAssignment.AssigmentToken.Equals) {
                p.append('=');
            }
            this.visit((Tree)propertyAssignment.getInitializer(), p);
        }
        this.afterSyntax(propertyAssignment, p);
        return propertyAssignment;
    }

    @Override
    public J visitNamespaceDeclaration(JS.NamespaceDeclaration namespaceDeclaration, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)namespaceDeclaration, JsSpace.Location.NAMESPACE_DECLARATION_PREFIX, p);
        namespaceDeclaration.getModifiers().forEach(it -> this.delegate.visitModifier((J.Modifier)it, p));
        this.visitSpace(namespaceDeclaration.getPadding().getKeywordType().getBefore(), JsSpace.Location.NAMESPACE_DECLARATION_KEYWORD_PREFIX, p);
        switch (namespaceDeclaration.getKeywordType()) {
            case Namespace: {
                p.append("namespace");
                break;
            }
            case Module: {
                p.append("module");
                break;
            }
        }
        this.visitRightPadded(namespaceDeclaration.getPadding().getName(), JsRightPadded.Location.NAMESPACE_DECLARATION_NAME, p);
        if (namespaceDeclaration.getBody() != null) {
            this.visit((Tree)namespaceDeclaration.getBody(), p);
        }
        this.afterSyntax(namespaceDeclaration, p);
        return namespaceDeclaration;
    }

    @Override
    public J visitScopedVariableDeclarations(JS.ScopedVariableDeclarations variableDeclarations, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)variableDeclarations, Space.Location.VARIABLE_DECLARATIONS_PREFIX, p);
        variableDeclarations.getModifiers().forEach(m -> this.delegate.visitModifier((J.Modifier)m, p));
        JLeftPadded<JS.ScopedVariableDeclarations.Scope> scope = variableDeclarations.getPadding().getScope();
        if (scope != null) {
            this.visitSpace(scope.getBefore(), JsSpace.Location.SCOPED_VARIABLE_DECLARATIONS_SCOPE_PREFIX, p);
            switch ((JS.ScopedVariableDeclarations.Scope)((Object)scope.getElement())) {
                case Let: {
                    p.append("let");
                    break;
                }
                case Const: {
                    p.append("const");
                    break;
                }
                case Var: {
                    p.append("var");
                }
            }
        }
        this.visitRightPadded(variableDeclarations.getPadding().getVariables(), JsRightPadded.Location.SCOPED_VARIABLE_DECLARATIONS_VARIABLE, ",", p);
        this.afterSyntax(variableDeclarations, p);
        return variableDeclarations;
    }

    @Override
    public J visitLiteralType(JS.LiteralType literalType, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)literalType, JsSpace.Location.LITERAL_TYPE_PREFIX, p);
        this.visit((Tree)literalType.getLiteral(), p);
        this.afterSyntax(literalType, p);
        return literalType;
    }

    @Override
    public J visitMappedType(JS.MappedType mappedType, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)mappedType, JsSpace.Location.MAPPED_TYPE_PREFIX, p);
        p.append("{");
        if (mappedType.getPrefixToken() != null) {
            this.visitLeftPadded(mappedType.getPadding().getPrefixToken(), JsLeftPadded.Location.MAPPED_TYPE_PREFIX_TOKEN, p);
        }
        if (mappedType.isHasReadonly()) {
            this.visitLeftPaddedBoolean("readonly", mappedType.getPadding().getHasReadonly(), JsLeftPadded.Location.MAPPED_TYPE_READONLY, p);
        }
        this.visitMappedTypeKeysRemapping(mappedType.getKeysRemapping(), p);
        if (mappedType.getSuffixToken() != null) {
            this.visitLeftPadded(mappedType.getPadding().getSuffixToken(), JsLeftPadded.Location.MAPPED_TYPE_SUFFIX_TOKEN, p);
        }
        if (mappedType.isHasQuestionToken()) {
            this.visitLeftPaddedBoolean("?", mappedType.getPadding().getHasQuestionToken(), JsLeftPadded.Location.MAPPED_TYPE_QUESTION_TOKEN, p);
        }
        this.visitContainer(":", mappedType.getPadding().getValueType(), JsContainer.Location.MAPPED_TYPE_VALUE_TYPE, "", "", p);
        p.append("}");
        this.afterSyntax(mappedType, p);
        return mappedType;
    }

    @Override
    public J visitMappedTypeKeysRemapping(JS.MappedType.KeysRemapping mappedTypeKeys, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)mappedTypeKeys, JsSpace.Location.MAPPED_TYPE_KEYS_REMAPPING_PREFIX, p);
        p.append("[");
        this.visitRightPadded(mappedTypeKeys.getPadding().getTypeParameter(), JsRightPadded.Location.MAPPED_TYPE_KEYS_REMAPPING_TYPE_PARAMETER, p);
        if (mappedTypeKeys.getNameType() != null) {
            p.append("as");
            this.visitRightPadded(mappedTypeKeys.getPadding().getNameType(), JsRightPadded.Location.MAPPED_TYPE_KEYS_REMAPPING_NAME_TYPE, p);
        }
        p.append("]");
        this.afterSyntax(mappedTypeKeys, p);
        return mappedTypeKeys;
    }

    @Override
    public J visitMappedTypeMappedTypeParameter(JS.MappedType.MappedTypeParameter mappedTypeParameter, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)mappedTypeParameter, JsSpace.Location.MAPPED_TYPE_MAPPED_TYPE_PARAMETER_PREFIX, p);
        this.visit((Tree)mappedTypeParameter.getName(), p);
        this.visitLeftPadded("in", mappedTypeParameter.getPadding().getIterateType(), JsLeftPadded.Location.MAPPED_TYPE_MAPPED_TYPE_PARAMETER_ITERATE, p);
        this.afterSyntax(mappedTypeParameter, p);
        return mappedTypeParameter;
    }

    @Override
    public J visitObjectBindingDeclarations(JS.ObjectBindingDeclarations objectBindingDeclarations, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)objectBindingDeclarations, Space.Location.VARIABLE_DECLARATIONS_PREFIX, p);
        this.visit(objectBindingDeclarations.getLeadingAnnotations(), p);
        objectBindingDeclarations.getModifiers().forEach(m -> this.delegate.visitModifier((J.Modifier)m, p));
        this.visit((Tree)objectBindingDeclarations.getTypeExpression(), p);
        this.visitContainer("{", objectBindingDeclarations.getPadding().getBindings(), JsContainer.Location.BINDING_ELEMENT, ",", "}", p);
        this.visitLeftPadded("=", objectBindingDeclarations.getPadding().getInitializer(), JsLeftPadded.Location.BINDING_ELEMENT_INITIALIZER, p);
        this.afterSyntax(objectBindingDeclarations, p);
        return objectBindingDeclarations;
    }

    @Override
    public J visitSatisfiesExpression(JS.SatisfiesExpression satisfiesExpression, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)satisfiesExpression, JsSpace.Location.SATISFIES_EXPRESSION_PREFIX, p);
        this.visit((Tree)satisfiesExpression.getExpression(), p);
        this.visitLeftPadded("satisfies", satisfiesExpression.getPadding().getSatisfiesType(), JsLeftPadded.Location.SATISFIES_EXPRESSION_TYPE, p);
        this.afterSyntax(satisfiesExpression, p);
        return satisfiesExpression;
    }

    @Override
    public J visitTaggedTemplateExpression(JS.TaggedTemplateExpression taggedTemplateExpression, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)taggedTemplateExpression, JsSpace.Location.TEMPLATE_EXPRESSION_PREFIX, p);
        this.visitRightPadded(taggedTemplateExpression.getPadding().getTag(), JsRightPadded.Location.TEMPLATE_EXPRESSION_TAG, p);
        this.visitContainer("<", taggedTemplateExpression.getPadding().getTypeArguments(), JsContainer.Location.TEMPLATE_EXPRESSION_TYPE_ARG_PARAMETERS, ",", ">", p);
        this.visit((Tree)taggedTemplateExpression.getTemplateExpression(), p);
        this.afterSyntax(taggedTemplateExpression, p);
        return taggedTemplateExpression;
    }

    @Override
    public J visitTemplateExpression(JS.TemplateExpression templateExpression, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)templateExpression, JsSpace.Location.TEMPLATE_EXPRESSION_PREFIX, p);
        this.visit((Tree)templateExpression.getHead(), p);
        this.visitRightPadded(templateExpression.getPadding().getTemplateSpans(), JsRightPadded.Location.TEMPLATE_EXPRESSION_TEMPLATE_SPAN, "", p);
        this.afterSyntax(templateExpression, p);
        return templateExpression;
    }

    @Override
    public J visitTemplateExpressionTemplateSpan(JS.TemplateExpression.TemplateSpan value, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)value, JsSpace.Location.TEMPLATE_EXPRESSION_SPAN_PREFIX, p);
        this.visit((Tree)value.getExpression(), p);
        this.visit((Tree)value.getTail(), p);
        this.afterSyntax(value, p);
        return value;
    }

    @Override
    public J visitTuple(JS.Tuple tuple, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)tuple, JsSpace.Location.TUPLE_PREFIX, p);
        this.visitContainer("[", tuple.getPadding().getElements(), JsContainer.Location.TUPLE_ELEMENT, ",", "]", p);
        this.afterSyntax(tuple, p);
        return tuple;
    }

    @Override
    public J visitTypeDeclaration(JS.TypeDeclaration typeDeclaration, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)typeDeclaration, JsSpace.Location.TYPE_DECLARATION_PREFIX, p);
        typeDeclaration.getModifiers().forEach(m -> this.delegate.visitModifier((J.Modifier)m, p));
        this.visitLeftPadded("type", typeDeclaration.getPadding().getName(), JsLeftPadded.Location.TYPE_DECLARATION_NAME, p);
        J.TypeParameters typeParameters = typeDeclaration.getTypeParameters();
        if (typeParameters != null) {
            this.visit(typeParameters.getAnnotations(), p);
            this.visitSpace(typeParameters.getPrefix(), Space.Location.TYPE_PARAMETERS, p);
            this.visitMarkers(typeParameters.getMarkers(), p);
            p.append("<");
            this.visitRightPadded((List<JRightPadded<J>>)typeParameters.getPadding().getTypeParameters(), JRightPadded.Location.TYPE_PARAMETER, ",", p);
            p.append(">");
        }
        this.visitLeftPadded("=", typeDeclaration.getPadding().getInitializer(), JsLeftPadded.Location.TYPE_DECLARATION_INITIALIZER, p);
        this.afterSyntax(typeDeclaration, p);
        return typeDeclaration;
    }

    @Override
    public J visitTypeOf(JS.TypeOf typeOf, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)typeOf, JsSpace.Location.TYPEOF_PREFIX, p);
        p.append("typeof");
        this.visit((Tree)typeOf.getExpression(), p);
        this.afterSyntax(typeOf, p);
        return typeOf;
    }

    @Override
    public J visitTypeQuery(JS.TypeQuery typeQuery, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)typeQuery, JsSpace.Location.TYPE_QUERY_PREFIX, p);
        p.append("typeof");
        this.visit((Tree)typeQuery.getTypeExpression(), p);
        this.visitContainer("<", typeQuery.getPadding().getTypeArguments(), JsContainer.Location.TYPE_QUERY_TYPE_ARGUMENTS, ",", ">", p);
        this.afterSyntax(typeQuery, p);
        return typeQuery;
    }

    @Override
    public J visitTypeOperator(JS.TypeOperator typeOperator, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)typeOperator, JsSpace.Location.TYPE_OPERATOR_PREFIX, p);
        String keyword = "";
        if (typeOperator.getOperator() == JS.TypeOperator.Type.ReadOnly) {
            keyword = "readonly";
        } else if (typeOperator.getOperator() == JS.TypeOperator.Type.KeyOf) {
            keyword = "keyof";
        } else if (typeOperator.getOperator() == JS.TypeOperator.Type.Unique) {
            keyword = "unique";
        }
        p.append(keyword);
        this.visitLeftPadded(typeOperator.getPadding().getExpression(), JsLeftPadded.Location.TYPE_OPERATOR, p);
        this.afterSyntax(typeOperator, p);
        return typeOperator;
    }

    @Override
    public J visitTypePredicate(JS.TypePredicate typePredicate, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)typePredicate, JsSpace.Location.TYPE_PREDICATE_PREFIX, p);
        if (typePredicate.isAsserts()) {
            this.visitLeftPaddedBoolean("asserts", typePredicate.getPadding().getAsserts(), JsLeftPadded.Location.TYPE_PREDICATE_ASSERTS, p);
        }
        this.visit((Tree)typePredicate.getParameterName(), p);
        this.visitLeftPadded("is", typePredicate.getPadding().getExpression(), JsLeftPadded.Location.TYPE_PREDICATE_EXPRESSION, p);
        this.afterSyntax(typePredicate, p);
        return typePredicate;
    }

    @Override
    public J visitUnary(JS.Unary unary, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)unary, Space.Location.UNARY_PREFIX, p);
        switch (unary.getOperator()) {
            case Spread: {
                this.visitSpace(unary.getPadding().getOperator().getBefore(), Space.Location.UNARY_OPERATOR, p);
                p.append("...");
                this.visit((Tree)unary.getExpression(), p);
                break;
            }
            case Optional: {
                this.visit((Tree)unary.getExpression(), p);
                this.visitSpace(unary.getPadding().getOperator().getBefore(), Space.Location.UNARY_OPERATOR, p);
                p.append("?");
                break;
            }
            case Exclamation: {
                this.visit((Tree)unary.getExpression(), p);
                this.visitSpace(unary.getPadding().getOperator().getBefore(), Space.Location.UNARY_OPERATOR, p);
                p.append("!");
                break;
            }
            case QuestionDot: {
                this.visit((Tree)unary.getExpression(), p);
                this.visitSpace(unary.getPadding().getOperator().getBefore(), Space.Location.UNARY_OPERATOR, p);
                p.append("?");
                break;
            }
            case QuestionDotWithDot: {
                this.visit((Tree)unary.getExpression(), p);
                this.visitSpace(unary.getPadding().getOperator().getBefore(), Space.Location.UNARY_OPERATOR, p);
                p.append("?.");
                break;
            }
            case Asterisk: {
                p.append("*");
                this.visitSpace(unary.getPadding().getOperator().getBefore(), Space.Location.UNARY_OPERATOR, p);
                this.visit((Tree)unary.getExpression(), p);
            }
        }
        this.afterSyntax(unary, p);
        return unary;
    }

    @Override
    public J visitUnion(JS.Union union, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)union, JsSpace.Location.UNION_PREFIX, p);
        this.visitRightPadded(union.getPadding().getTypes(), JsRightPadded.Location.UNION_TYPE, "|", p);
        this.afterSyntax(union, p);
        return union;
    }

    @Override
    public J visitIntersection(JS.Intersection intersection, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)intersection, JsSpace.Location.INTERSECTION_PREFIX, p);
        this.visitRightPadded(intersection.getPadding().getTypes(), JsRightPadded.Location.INTERSECTION_TYPE, "&", p);
        this.afterSyntax(intersection, p);
        return intersection;
    }

    @Override
    public J visitVoid(JS.Void aVoid, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)aVoid, JsSpace.Location.VOID_PREFIX, p);
        p.append("void");
        this.visit((Tree)aVoid.getExpression(), p);
        this.afterSyntax(aVoid, p);
        return aVoid;
    }

    @Override
    public J visitYield(JS.Yield yield, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)yield, JsSpace.Location.YIELD_PREFIX, p);
        p.append("yield");
        if (yield.isDelegated()) {
            this.visitLeftPaddedBoolean("*", yield.getPadding().getDelegated(), JsLeftPadded.Location.JS_YIELD_DELEGATED, p);
        }
        this.visit((Tree)yield.getExpression(), p);
        this.afterSyntax(yield, p);
        return yield;
    }

    @Override
    public J visitTypeInfo(JS.TypeInfo typeInfo, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)typeInfo, JsSpace.Location.TYPE_INFO_PREFIX, p);
        p.append(":");
        this.visit((Tree)typeInfo.getTypeIdentifier(), p);
        this.afterSyntax(typeInfo, p);
        return typeInfo;
    }

    @Override
    public J visitJSVariableDeclarations(JS.JSVariableDeclarations multiVariable, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)multiVariable, JsSpace.Location.JSVARIABLE_DECLARATIONS_PREFIX, p);
        this.visit(multiVariable.getLeadingAnnotations(), p);
        multiVariable.getModifiers().forEach(it -> this.delegate.visitModifier((J.Modifier)it, p));
        List<JRightPadded<JS.JSVariableDeclarations.JSNamedVariable>> variables = multiVariable.getPadding().getVariables();
        for (int i = 0; i < variables.size(); ++i) {
            JRightPadded<JS.JSVariableDeclarations.JSNamedVariable> variable = variables.get(i);
            this.beforeSyntax((J)variable.getElement(), JsSpace.Location.JSVARIABLE_PREFIX, p);
            if (multiVariable.getVarargs() != null) {
                p.append("...");
            }
            this.visit((Tree)((JS.JSVariableDeclarations.JSNamedVariable)variable.getElement()).getName(), p);
            this.visitSpace(variable.getAfter(), JsSpace.Location.JSNAMED_VARIABLE_SUFFIX, p);
            if (multiVariable.getTypeExpression() != null) {
                this.visit((Tree)multiVariable.getTypeExpression(), p);
            }
            if (((JS.JSVariableDeclarations.JSNamedVariable)variable.getElement()).getInitializer() != null) {
                this.visitLeftPadded("=", ((JS.JSVariableDeclarations.JSNamedVariable)variable.getElement()).getPadding().getInitializer(), JsLeftPadded.Location.JSVARIABLE_INITIALIZER, p);
            }
            this.afterSyntax((J)variable.getElement(), p);
            if (i < variables.size() - 1) {
                p.append(",");
                continue;
            }
            if (!variable.getMarkers().findFirst(Semicolon.class).isPresent()) continue;
            p.append(";");
        }
        this.afterSyntax(multiVariable, p);
        return multiVariable;
    }

    @Override
    public J visitJSVariableDeclarationsJSNamedVariable(JS.JSVariableDeclarations.JSNamedVariable variable, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)variable, JsSpace.Location.JSVARIABLE_PREFIX, p);
        this.visit((Tree)variable.getName(), p);
        JLeftPadded<Expression> initializer = variable.getPadding().getInitializer();
        this.visitLeftPadded("=", initializer, JsLeftPadded.Location.JSVARIABLE_INITIALIZER, p);
        this.afterSyntax(variable, p);
        return variable;
    }

    @Override
    public J visitJSMethodDeclaration(JS.JSMethodDeclaration method, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)method, JsSpace.Location.JSMETHOD_DECLARATION_PREFIX, p);
        this.visitSpace(Space.EMPTY, Space.Location.ANNOTATIONS, p);
        this.visit(method.getLeadingAnnotations(), p);
        method.getModifiers().forEach(it -> this.delegate.visitModifier((J.Modifier)it, p));
        this.visit((Tree)method.getName(), p);
        J.TypeParameters typeParameters = method.getTypeParameters();
        if (typeParameters != null) {
            this.visit(typeParameters.getAnnotations(), p);
            this.visitSpace(typeParameters.getPrefix(), Space.Location.TYPE_PARAMETERS, p);
            this.visitMarkers(typeParameters.getMarkers(), p);
            p.append("<");
            this.visitRightPadded((List<JRightPadded<J>>)typeParameters.getPadding().getTypeParameters(), JRightPadded.Location.TYPE_PARAMETER, ",", p);
            p.append(">");
        }
        this.visitContainer("(", method.getPadding().getParameters(), JsContainer.Location.JSMETHOD_DECLARATION_PARAMETERS, ",", ")", p);
        if (method.getReturnTypeExpression() != null) {
            this.visit((Tree)method.getReturnTypeExpression(), p);
        }
        this.visit((Tree)method.getBody(), p);
        this.afterSyntax(method, p);
        return method;
    }

    @Override
    public J visitFunctionDeclaration(JS.FunctionDeclaration functionDeclaration, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)functionDeclaration, JsSpace.Location.FUNCTION_DECLARATION_PREFIX, p);
        functionDeclaration.getModifiers().forEach(m -> this.delegate.visitModifier((J.Modifier)m, p));
        this.visitLeftPaddedBoolean("function", functionDeclaration.getPadding().getAsteriskToken(), JsLeftPadded.Location.FUNCTION_DECLARATION_ASTERISK_TOKEN, p);
        this.visitLeftPadded(functionDeclaration.hasAsteriskToken() ? "*" : "", functionDeclaration.getPadding().getName(), JsLeftPadded.Location.FUNCTION_DECLARATION_NAME, p);
        J.TypeParameters typeParameters = functionDeclaration.getTypeParameters();
        if (typeParameters != null) {
            this.visit(typeParameters.getAnnotations(), p);
            this.visitSpace(typeParameters.getPrefix(), Space.Location.TYPE_PARAMETERS, p);
            this.visitMarkers(typeParameters.getMarkers(), p);
            p.append("<");
            this.visitRightPadded((List<JRightPadded<J>>)typeParameters.getPadding().getTypeParameters(), JRightPadded.Location.TYPE_PARAMETER, ",", p);
            p.append(">");
        }
        this.visitContainer("(", functionDeclaration.getPadding().getParameters(), JsContainer.Location.JSMETHOD_DECLARATION_PARAMETERS, ",", ")", p);
        if (functionDeclaration.getReturnTypeExpression() != null) {
            this.visit((Tree)functionDeclaration.getReturnTypeExpression(), p);
        }
        if (functionDeclaration.getBody() != null) {
            this.visit((Tree)functionDeclaration.getBody(), p);
        }
        this.afterSyntax(functionDeclaration, p);
        return functionDeclaration;
    }

    @Override
    public J visitTypeLiteral(JS.TypeLiteral tl, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)tl, JsSpace.Location.TYPE_LITERAL_PREFIX, p);
        this.visit((Tree)tl.getMembers(), p);
        this.afterSyntax(tl, p);
        return tl;
    }

    @Override
    public J visitIndexSignatureDeclaration(JS.IndexSignatureDeclaration isd, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)isd, JsSpace.Location.INDEXED_SIGNATURE_DECLARATION_PREFIX, p);
        isd.getModifiers().forEach(m -> this.delegate.visitModifier((J.Modifier)m, p));
        this.visitContainer("[", isd.getPadding().getParameters(), JsContainer.Location.INDEXED_SIGNATURE_DECLARATION_PARAMETERS, "", "]", p);
        this.visitLeftPadded(":", isd.getPadding().getTypeExpression(), JsLeftPadded.Location.INDEXED_SIGNATURE_DECLARATION_TYPE_EXPRESSION, p);
        this.afterSyntax(isd, p);
        return isd;
    }

    @Override
    public J visitJSForOfLoop(JS.JSForOfLoop loop, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)loop, JsSpace.Location.FOR_OF_LOOP_PREFIX, p);
        p.append("for");
        if (loop.isAwait()) {
            this.visitLeftPaddedBoolean("await", loop.getPadding().getAwait(), JsLeftPadded.Location.FOR_OF_AWAIT, p);
        }
        JS.JSForInOfLoopControl control = loop.getControl();
        this.visitSpace(control.getPrefix(), JsSpace.Location.FOR_LOOP_CONTROL_PREFIX, p);
        p.append('(');
        this.visitRightPadded(control.getPadding().getVariable(), JsRightPadded.Location.FOR_CONTROL_VAR, p);
        p.append("of");
        this.visitRightPadded(control.getPadding().getIterable(), JsRightPadded.Location.FOR_CONTROL_ITER, p);
        p.append(')');
        this.visitRightPadded(loop.getPadding().getBody(), JsRightPadded.Location.FOR_BODY, p);
        this.afterSyntax(loop, p);
        return loop;
    }

    @Override
    public J visitJSForInLoop(JS.JSForInLoop loop, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)loop, JsSpace.Location.FOR_IN_LOOP_PREFIX, p);
        p.append("for");
        JS.JSForInOfLoopControl control = loop.getControl();
        this.visitSpace(control.getPrefix(), JsSpace.Location.FOR_LOOP_CONTROL_PREFIX, p);
        p.append('(');
        this.visitRightPadded(control.getPadding().getVariable(), JsRightPadded.Location.FOR_CONTROL_VAR, p);
        p.append("in");
        this.visitRightPadded(control.getPadding().getIterable(), JsRightPadded.Location.FOR_CONTROL_ITER, p);
        p.append(')');
        this.visitRightPadded(loop.getPadding().getBody(), JsRightPadded.Location.FOR_BODY, p);
        this.afterSyntax(loop, p);
        return loop;
    }

    @Override
    public J visitArrayBindingPattern(JS.ArrayBindingPattern abp, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)abp, JsSpace.Location.ARRAY_BINDING_PATTERN_PREFIX, p);
        this.visitContainer("[", abp.getPadding().getElements(), JsContainer.Location.ARRAY_BINDING_PATTERN_ELEMENTS, ",", "]", p);
        this.afterSyntax(abp, p);
        return abp;
    }

    @Override
    public J visitExportDeclaration(JS.ExportDeclaration ed, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)ed, JsSpace.Location.EXPORT_DECLARATION_PREFIX, p);
        p.append("export");
        ed.getModifiers().forEach(it -> this.delegate.visitModifier((J.Modifier)it, p));
        if (ed.isTypeOnly()) {
            this.visitLeftPaddedBoolean("type", ed.getPadding().getTypeOnly(), JsLeftPadded.Location.EXPORT_DECLARATION_TYPE_ONLY, p);
        }
        this.visit((Tree)ed.getExportClause(), p);
        this.visitLeftPadded("from", ed.getPadding().getModuleSpecifier(), JsLeftPadded.Location.EXPORT_DECLARATION_MODULE_SPECIFIER, p);
        this.afterSyntax(ed, p);
        return ed;
    }

    @Override
    public J visitExportAssignment(JS.ExportAssignment es, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)es, JsSpace.Location.EXPORT_ASSIGNMENT_PREFIX, p);
        p.append("export");
        es.getModifiers().forEach(it -> this.delegate.visitModifier((J.Modifier)it, p));
        if (es.isExportEquals()) {
            this.visitLeftPaddedBoolean("=", es.getPadding().getExportEquals(), JsLeftPadded.Location.EXPORT_ASSIGNMENT_EXPORT_EQUALS, p);
        }
        this.visit((Tree)es.getExpression(), p);
        this.afterSyntax(es, p);
        return es;
    }

    @Override
    public J visitNamedExports(JS.NamedExports ne, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)ne, JsSpace.Location.NAMED_EXPORTS_PREFIX, p);
        this.visitContainer("{", ne.getPadding().getElements(), JsContainer.Location.NAMED_EXPORTS_ELEMENTS, ",", "}", p);
        this.afterSyntax(ne, p);
        return ne;
    }

    @Override
    public J visitExportSpecifier(JS.ExportSpecifier es, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)es, JsSpace.Location.EXPORT_SPECIFIER_PREFIX, p);
        if (es.isTypeOnly()) {
            this.visitLeftPaddedBoolean("type", es.getPadding().getTypeOnly(), JsLeftPadded.Location.EXPORT_SPECIFIER_TYPE_ONLY, p);
        }
        this.visit((Tree)es.getSpecifier(), p);
        this.afterSyntax(es, p);
        return es;
    }

    @Override
    public J visitIndexedAccessType(JS.IndexedAccessType iat, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)iat, JsSpace.Location.INDEXED_ACCESS_TYPE_PREFIX, p);
        this.visit((Tree)iat.getObjectType(), p);
        this.visit((Tree)iat.getIndexType(), p);
        this.afterSyntax(iat, p);
        return iat;
    }

    @Override
    public J visitIndexedAccessTypeIndexType(JS.IndexedAccessType.IndexType iatit, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)iatit, JsSpace.Location.INDEXED_ACCESS_TYPE_INDEX_TYPE_PREFIX, p);
        p.append("[");
        this.visitRightPadded(iatit.getPadding().getElement(), JsRightPadded.Location.INDEXED_ACCESS_TYPE_INDEX_TYPE_ELEMENT, p);
        p.append("]");
        this.afterSyntax(iatit, p);
        return iatit;
    }

    protected void beforeSyntax(J j, JsSpace.Location loc, PrintOutputCapture<P> p) {
        this.beforeSyntax(j.getPrefix(), j.getMarkers(), loc, p);
    }

    private void beforeSyntax(Space prefix, Markers markers, @Nullable JsSpace.Location loc, PrintOutputCapture<P> p) {
        for (Marker marker : markers.getMarkers()) {
            p.append(p.getMarkerPrinter().beforePrefix(marker, new Cursor(this.getCursor(), (Object)marker), JAVA_SCRIPT_MARKER_WRAPPER));
        }
        if (loc != null) {
            this.visitSpace(prefix, loc, p);
        }
        this.visitMarkers(markers, p);
        for (Marker marker : markers.getMarkers()) {
            p.append(p.getMarkerPrinter().beforeSyntax(marker, new Cursor(this.getCursor(), (Object)marker), JAVA_SCRIPT_MARKER_WRAPPER));
        }
    }

    protected void beforeSyntax(J j, Space.Location loc, PrintOutputCapture<P> p) {
        this.beforeSyntax(j.getPrefix(), j.getMarkers(), loc, p);
    }

    protected void beforeSyntax(Space prefix, Markers markers, // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable Space.Location loc, PrintOutputCapture<P> p) {
        for (Marker marker : markers.getMarkers()) {
            p.out.append(p.getMarkerPrinter().beforePrefix(marker, new Cursor(this.getCursor(), (Object)marker), JAVA_SCRIPT_MARKER_WRAPPER));
        }
        if (loc != null) {
            this.visitSpace(prefix, loc, p);
        }
        this.visitMarkers(markers, p);
        for (Marker marker : markers.getMarkers()) {
            p.out.append(p.getMarkerPrinter().beforeSyntax(marker, new Cursor(this.getCursor(), (Object)marker), JAVA_SCRIPT_MARKER_WRAPPER));
        }
    }

    protected void afterSyntax(J j, PrintOutputCapture<P> p) {
        this.afterSyntax(j.getMarkers(), p);
    }

    protected void afterSyntax(Markers markers, PrintOutputCapture<P> p) {
        for (Marker marker : markers.getMarkers()) {
            p.out.append(p.getMarkerPrinter().afterSyntax(marker, new Cursor(this.getCursor(), (Object)marker), JAVA_SCRIPT_MARKER_WRAPPER));
        }
    }

    protected void visitContainer(String before, @Nullable JContainer<? extends J> container, JsContainer.Location location, String suffixBetween, @Nullable String after, PrintOutputCapture<P> p) {
        if (container == null) {
            return;
        }
        this.visitSpace(container.getBefore(), location.getBeforeLocation(), p);
        p.append(before);
        this.visitRightPadded((List<JRightPadded<J>>)container.getPadding().getElements(), location.getElementLocation(), suffixBetween, p);
        p.append(after == null ? "" : after);
    }

    protected void visitRightPadded(JRightPadded<? extends J> node, JsRightPadded.Location location, String suffixBetween, PrintOutputCapture<P> p) {
        this.visit((Tree)node.getElement(), p);
        p.append(suffixBetween);
        this.visitSpace(node.getAfter(), location.getAfterLocation(), p);
        this.afterSyntax(node.getMarkers(), p);
    }

    protected void visitLeftPadded(@Nullable String prefix, @Nullable JLeftPadded<? extends J> leftPadded, JsLeftPadded.Location location, PrintOutputCapture<P> p) {
        if (leftPadded != null) {
            this.beforeSyntax(leftPadded.getBefore(), leftPadded.getMarkers(), location.getBeforeLocation(), p);
            if (prefix != null) {
                p.append(prefix);
            }
            this.visit((Tree)leftPadded.getElement(), p);
            this.afterSyntax(leftPadded.getMarkers(), p);
        }
    }

    protected void visitLeftPadded(@Nullable String prefix, @Nullable JLeftPadded<? extends J> leftPadded, JLeftPadded.Location location, PrintOutputCapture<P> p) {
        if (leftPadded != null) {
            this.beforeSyntax(leftPadded.getBefore(), leftPadded.getMarkers(), location.getBeforeLocation(), p);
            if (prefix != null) {
                p.append(prefix);
            }
            this.visit((Tree)leftPadded.getElement(), p);
            this.afterSyntax(leftPadded.getMarkers(), p);
        }
    }

    protected void visitLeftPaddedBoolean(@Nullable String prefix, @Nullable JLeftPadded<Boolean> leftPadded, JsLeftPadded.Location location, PrintOutputCapture<P> p) {
        if (leftPadded != null) {
            this.beforeSyntax(leftPadded.getBefore(), leftPadded.getMarkers(), location.getBeforeLocation(), p);
            if (prefix != null) {
                p.append(prefix);
            }
            this.afterSyntax(leftPadded.getMarkers(), p);
        }
    }

    protected void visitRightPadded(List<? extends JRightPadded<? extends J>> nodes, JsRightPadded.Location location, String suffixBetween, PrintOutputCapture<P> p) {
        for (int i = 0; i < nodes.size(); ++i) {
            JRightPadded<? extends J> node = nodes.get(i);
            this.visit((Tree)node.getElement(), p);
            this.visitSpace(node.getAfter(), location.getAfterLocation(), p);
            this.visitMarkers(node.getMarkers(), p);
            if (i >= nodes.size() - 1) continue;
            p.append(suffixBetween);
        }
    }

    protected void visitRightPadded(List<? extends JRightPadded<? extends J>> nodes, JRightPadded.Location location, String suffixBetween, PrintOutputCapture<P> p) {
        for (int i = 0; i < nodes.size(); ++i) {
            JRightPadded<? extends J> node = nodes.get(i);
            this.visit((Tree)node.getElement(), p);
            this.visitSpace(node.getAfter(), location.getAfterLocation(), p);
            this.visitMarkers(node.getMarkers(), p);
            if (i >= nodes.size() - 1) continue;
            p.append(suffixBetween);
        }
    }

    @Override
    public Space visitSpace(Space space, JsSpace.Location loc, PrintOutputCapture<P> p) {
        return this.delegate.visitSpace(space, Space.Location.LANGUAGE_EXTENSION, p);
    }

    public Space visitSpace(Space space, Space.Location loc, PrintOutputCapture<P> p) {
        return this.delegate.visitSpace(space, loc, p);
    }

    public Markers visitMarkers(@Nullable Markers markers, PrintOutputCapture<P> pPrintOutputCapture) {
        return this.delegate.visitMarkers(markers, pPrintOutputCapture);
    }

    private class JavaScriptJavaPrinter
    extends JavaPrinter<P> {
        private JavaScriptJavaPrinter() {
        }

        public J visit(@Nullable Tree tree, PrintOutputCapture<P> p) {
            if (tree instanceof JS) {
                return JavaScriptPrinter.this.visit(tree, p);
            }
            return (J)super.visit(tree, p);
        }

        public void setCursor(@Nullable Cursor cursor) {
            super.setCursor(cursor);
            JavaScriptPrinter.this.internalSetCursor(cursor);
        }

        public void internalSetCursor(@Nullable Cursor cursor) {
            super.setCursor(cursor);
        }

        public J visitEnumValue(J.EnumValue enum_, PrintOutputCapture<P> p) {
            this.beforeSyntax((J)enum_, Space.Location.ENUM_VALUE_PREFIX, p);
            this.visit((Tree)enum_.getName(), p);
            J.NewClass initializer = enum_.getInitializer();
            if (initializer != null) {
                this.visitSpace(initializer.getPrefix(), Space.Location.NEW_CLASS_PREFIX, p);
                p.append("=");
                Expression expression = (Expression)initializer.getArguments().get(0);
                this.visit((Tree)expression, p);
                return enum_;
            }
            this.afterSyntax((J)enum_, p);
            return enum_;
        }

        public J visitEnumValueSet(J.EnumValueSet enums, PrintOutputCapture<P> p) {
            this.beforeSyntax((J)enums, Space.Location.ENUM_VALUE_SET_PREFIX, p);
            this.visitRightPadded(enums.getPadding().getEnums(), JRightPadded.Location.ENUM_VALUE, ",", p);
            if (enums.isTerminatedWithSemicolon()) {
                p.append(',');
            }
            this.afterSyntax((J)enums, p);
            return enums;
        }

        public J visitAnnotation(J.Annotation annotation, PrintOutputCapture<P> p) {
            this.beforeSyntax((J)annotation, Space.Location.ANNOTATION_PREFIX, p);
            if (!annotation.getMarkers().findFirst(Keyword.class).isPresent()) {
                p.append("@");
            }
            this.visit((Tree)annotation.getAnnotationType(), p);
            this.visitContainer("(", annotation.getPadding().getArguments(), JContainer.Location.ANNOTATION_ARGUMENTS, ",", ")", p);
            this.afterSyntax((J)annotation, p);
            return annotation;
        }

        public J visitBinary(J.Binary binary, PrintOutputCapture<P> p) {
            String keyword = "";
            switch (binary.getOperator()) {
                case Addition: {
                    keyword = "+";
                    break;
                }
                case Subtraction: {
                    keyword = "-";
                    break;
                }
                case Multiplication: {
                    keyword = "*";
                    break;
                }
                case Division: {
                    keyword = "/";
                    break;
                }
                case Modulo: {
                    keyword = "%";
                    break;
                }
                case LessThan: {
                    keyword = "<";
                    break;
                }
                case GreaterThan: {
                    keyword = ">";
                    break;
                }
                case LessThanOrEqual: {
                    keyword = "<=";
                    break;
                }
                case GreaterThanOrEqual: {
                    keyword = ">=";
                    break;
                }
                case Equal: {
                    keyword = "==";
                    break;
                }
                case NotEqual: {
                    keyword = "!=";
                    break;
                }
                case BitAnd: {
                    keyword = "&";
                    break;
                }
                case BitOr: {
                    keyword = "|";
                    break;
                }
                case BitXor: {
                    keyword = "^";
                    break;
                }
                case LeftShift: {
                    keyword = "<<";
                    break;
                }
                case RightShift: {
                    keyword = ">>";
                    break;
                }
                case UnsignedRightShift: {
                    keyword = ">>>";
                    break;
                }
                case Or: {
                    keyword = binary.getMarkers().findFirst(Comma.class).isPresent() ? "," : "||";
                    break;
                }
                case And: {
                    keyword = "&&";
                }
            }
            this.beforeSyntax((J)binary, Space.Location.BINARY_PREFIX, p);
            this.visit((Tree)binary.getLeft(), p);
            this.visitSpace(binary.getPadding().getOperator().getBefore(), Space.Location.BINARY_OPERATOR, p);
            p.append(keyword);
            this.visit((Tree)binary.getRight(), p);
            this.afterSyntax((J)binary, p);
            return binary;
        }

        public J visitFieldAccess(J.FieldAccess fieldAccess, PrintOutputCapture<P> p) {
            this.beforeSyntax((J)fieldAccess, Space.Location.FIELD_ACCESS_PREFIX, p);
            this.visit((Tree)fieldAccess.getTarget(), p);
            PostFixOperator postFixOperator = fieldAccess.getMarkers().findFirst(PostFixOperator.class).orElse(null);
            this.visitLeftPadded(postFixOperator != null ? "?." : ".", fieldAccess.getPadding().getName(), JLeftPadded.Location.FIELD_ACCESS_NAME, p);
            this.afterSyntax((J)fieldAccess, p);
            return fieldAccess;
        }

        public J visitCatch(J.Try.Catch catch_, PrintOutputCapture<P> p) {
            this.beforeSyntax((J)catch_, Space.Location.CATCH_PREFIX, p);
            p.append("catch");
            if (!((J.VariableDeclarations)catch_.getParameter().getTree()).getVariables().isEmpty()) {
                this.visit((Tree)catch_.getParameter(), p);
            }
            this.visit((Tree)catch_.getBody(), p);
            this.afterSyntax((J)catch_, p);
            return catch_;
        }

        public J visitImport(J.Import import_, PrintOutputCapture<P> p) {
            this.beforeSyntax((J)import_, Space.Location.IMPORT_PREFIX, p);
            p.append("import");
            this.visit((Tree)import_.getAlias(), p);
            this.visitSpace(import_.getQualid().getPrefix(), Space.Location.LANGUAGE_EXTENSION, p);
            p.append("from");
            this.visitLeftPadded(import_.getQualid().getPadding().getName(), JLeftPadded.Location.LANGUAGE_EXTENSION, p);
            this.afterSyntax((J)import_, p);
            return import_;
        }

        public J visitMethodDeclaration(J.MethodDeclaration method, PrintOutputCapture<P> p) {
            this.beforeSyntax((J)method, Space.Location.METHOD_DECLARATION_PREFIX, p);
            this.visitSpace(Space.EMPTY, Space.Location.ANNOTATIONS, p);
            this.visit(method.getLeadingAnnotations(), p);
            method.getModifiers().forEach(it -> JavaScriptPrinter.this.delegate.visitModifier((J.Modifier)it, p));
            this.visit((Tree)method.getName(), p);
            J.TypeParameters typeParameters = method.getAnnotations().getTypeParameters();
            if (typeParameters != null) {
                this.visit(typeParameters.getAnnotations(), p);
                this.visitSpace(typeParameters.getPrefix(), Space.Location.TYPE_PARAMETERS, p);
                this.visitMarkers(typeParameters.getMarkers(), p);
                p.append("<");
                this.visitRightPadded(typeParameters.getPadding().getTypeParameters(), JRightPadded.Location.TYPE_PARAMETER, ",", p);
                p.append(">");
            }
            this.visitContainer("(", method.getPadding().getParameters(), JContainer.Location.METHOD_DECLARATION_PARAMETERS, ",", ")", p);
            if (method.getReturnTypeExpression() != null) {
                this.visit((Tree)method.getReturnTypeExpression(), p);
            }
            this.visit((Tree)method.getBody(), p);
            this.afterSyntax((J)method, p);
            return method;
        }

        public J visitMethodInvocation(J.MethodInvocation method, PrintOutputCapture<P> p) {
            this.beforeSyntax((J)method, Space.Location.METHOD_INVOCATION_PREFIX, p);
            if (method.getName().toString().isEmpty()) {
                this.visitRightPadded(method.getPadding().getSelect(), JRightPadded.Location.METHOD_SELECT, p);
            } else {
                this.visitRightPadded(method.getPadding().getSelect(), JRightPadded.Location.METHOD_SELECT, ".", p);
                this.visit((Tree)method.getName(), p);
            }
            this.visitContainer("<", method.getPadding().getTypeParameters(), JContainer.Location.TYPE_PARAMETERS, ",", ">", p);
            this.visitContainer("(", method.getPadding().getArguments(), JContainer.Location.METHOD_INVOCATION_ARGUMENTS, ",", ")", p);
            this.afterSyntax((J)method, p);
            return method;
        }

        public J visitModifier(J.Modifier mod, PrintOutputCapture<P> p) {
            String keyword;
            this.visit(mod.getAnnotations(), p);
            switch (mod.getType()) {
                case Default: {
                    keyword = "default";
                    break;
                }
                case Public: {
                    keyword = "public";
                    break;
                }
                case Protected: {
                    keyword = "protected";
                    break;
                }
                case Private: {
                    keyword = "private";
                    break;
                }
                case Abstract: {
                    keyword = "abstract";
                    break;
                }
                case Async: {
                    keyword = "async";
                    break;
                }
                case Static: {
                    keyword = "static";
                    break;
                }
                case Final: {
                    keyword = "final";
                    break;
                }
                case Native: {
                    keyword = "native";
                    break;
                }
                case NonSealed: {
                    keyword = "non-sealed";
                    break;
                }
                case Sealed: {
                    keyword = "sealed";
                    break;
                }
                case Strictfp: {
                    keyword = "strictfp";
                    break;
                }
                case Synchronized: {
                    keyword = "synchronized";
                    break;
                }
                case Transient: {
                    keyword = "transient";
                    break;
                }
                case Volatile: {
                    keyword = "volatile";
                    break;
                }
                default: {
                    keyword = mod.getKeyword();
                }
            }
            this.beforeSyntax((J)mod, Space.Location.MODIFIER_PREFIX, p);
            p.append(keyword);
            this.afterSyntax((J)mod, p);
            return mod;
        }

        public J visitNewArray(J.NewArray newArray, PrintOutputCapture<P> p) {
            this.beforeSyntax((J)newArray, Space.Location.NEW_ARRAY_PREFIX, p);
            this.visit((Tree)newArray.getTypeExpression(), p);
            this.visit(newArray.getDimensions(), p);
            this.visitContainer("[", newArray.getPadding().getInitializer(), JContainer.Location.NEW_ARRAY_INITIALIZER, ",", "]", p);
            this.afterSyntax((J)newArray, p);
            return newArray;
        }

        public J visitNewClass(J.NewClass newClass, PrintOutputCapture<P> p) {
            this.beforeSyntax((J)newClass, Space.Location.NEW_CLASS_PREFIX, p);
            this.visitRightPadded(newClass.getPadding().getEnclosing(), JRightPadded.Location.NEW_CLASS_ENCLOSING, ".", p);
            this.visitSpace(newClass.getNew(), Space.Location.NEW_PREFIX, p);
            if (newClass.getClazz() != null) {
                p.append("new");
                this.visit((Tree)newClass.getClazz(), p);
                if (!newClass.getPadding().getArguments().getMarkers().findFirst(OmitParentheses.class).isPresent()) {
                    this.visitContainer("(", newClass.getPadding().getArguments(), JContainer.Location.NEW_CLASS_ARGUMENTS, ",", ")", p);
                }
            }
            this.visit((Tree)newClass.getBody(), p);
            this.afterSyntax((J)newClass, p);
            return newClass;
        }

        public <T extends J> J visitControlParentheses(J.ControlParentheses<T> controlParens, PrintOutputCapture<P> p) {
            this.beforeSyntax((J)controlParens, Space.Location.CONTROL_PARENTHESES_PREFIX, p);
            if (this.getCursor().getParentTreeCursor().getValue() instanceof J.TypeCast) {
                p.append('<');
                this.visitRightPadded(controlParens.getPadding().getTree(), JRightPadded.Location.PARENTHESES, ">", p);
            } else {
                p.append('(');
                this.visitRightPadded(controlParens.getPadding().getTree(), JRightPadded.Location.PARENTHESES, ")", p);
            }
            this.afterSyntax((J)controlParens, p);
            return controlParens;
        }

        protected void visitStatements(List<JRightPadded<Statement>> statements, JRightPadded.Location location, PrintOutputCapture<P> p) {
            boolean objectLiteral = this.getCursor().getParent(0).getValue() instanceof J.Block && this.getCursor().getParent(1).getValue() instanceof J.NewClass;
            for (int i = 0; i < statements.size(); ++i) {
                JRightPadded<Statement> paddedStat = statements.get(i);
                this.visitStatement(paddedStat, location, p);
                if (i >= statements.size() - 1 || !objectLiteral) continue;
                p.append(',');
            }
        }

        public J visitTypeCast(J.TypeCast typeCast, PrintOutputCapture<P> p) {
            this.beforeSyntax((J)typeCast, Space.Location.TYPE_CAST_PREFIX, p);
            this.visit((Tree)typeCast.getClazz(), p);
            this.visit((Tree)typeCast.getExpression(), p);
            this.afterSyntax((J)typeCast, p);
            return typeCast;
        }

        public J visitTypeParameter(J.TypeParameter typeParameter, PrintOutputCapture<P> p) {
            this.beforeSyntax((J)typeParameter, Space.Location.TYPE_PARAMETERS_PREFIX, p);
            this.visit(typeParameter.getAnnotations(), p);
            typeParameter.getModifiers().forEach(m -> JavaScriptPrinter.this.delegate.visitModifier((J.Modifier)m, p));
            this.visit((Tree)typeParameter.getName(), p);
            JContainer bounds = typeParameter.getPadding().getBounds();
            if (bounds != null) {
                JRightPadded defaultType;
                this.visitSpace(bounds.getBefore(), JContainer.Location.TYPE_BOUNDS.getBeforeLocation(), p);
                JRightPadded constraintType = (JRightPadded)bounds.getPadding().getElements().get(0);
                if (!(constraintType.getElement() instanceof J.Empty)) {
                    p.append("extends");
                    this.visitRightPadded(constraintType, JContainer.Location.TYPE_BOUNDS.getElementLocation(), p);
                }
                if (!((defaultType = (JRightPadded)bounds.getPadding().getElements().get(1)).getElement() instanceof J.Empty)) {
                    p.append("=");
                    this.visitRightPadded(defaultType, JContainer.Location.TYPE_BOUNDS.getElementLocation(), p);
                }
            }
            this.afterSyntax((J)typeParameter, p);
            return typeParameter;
        }

        public J visitVariableDeclarations(J.VariableDeclarations multiVariable, PrintOutputCapture<P> p) {
            this.beforeSyntax((J)multiVariable, Space.Location.VARIABLE_DECLARATIONS_PREFIX, p);
            this.visit(multiVariable.getLeadingAnnotations(), p);
            multiVariable.getModifiers().forEach(it -> JavaScriptPrinter.this.delegate.visitModifier((J.Modifier)it, p));
            List variables = multiVariable.getPadding().getVariables();
            for (int i = 0; i < variables.size(); ++i) {
                JRightPadded variable = (JRightPadded)variables.get(i);
                this.beforeSyntax((J)variable.getElement(), Space.Location.VARIABLE_PREFIX, p);
                if (multiVariable.getVarargs() != null) {
                    p.append("...");
                }
                this.visit((Tree)((J.VariableDeclarations.NamedVariable)variable.getElement()).getName(), p);
                this.visitSpace(variable.getAfter(), Space.Location.NAMED_VARIABLE_SUFFIX, p);
                if (multiVariable.getTypeExpression() != null) {
                    this.visit((Tree)multiVariable.getTypeExpression(), p);
                }
                if (((J.VariableDeclarations.NamedVariable)variable.getElement()).getInitializer() != null) {
                    JavaScriptPrinter.this.visitLeftPadded("=", (JLeftPadded<J>)((J.VariableDeclarations.NamedVariable)variable.getElement()).getPadding().getInitializer(), JLeftPadded.Location.VARIABLE_INITIALIZER, p);
                }
                this.afterSyntax((J)variable.getElement(), p);
                if (i < variables.size() - 1) {
                    p.append(",");
                    continue;
                }
                if (!variable.getMarkers().findFirst(Semicolon.class).isPresent()) continue;
                p.append(";");
            }
            this.afterSyntax((J)multiVariable, p);
            return multiVariable;
        }

        public J visitVariable(J.VariableDeclarations.NamedVariable variable, PrintOutputCapture<P> p) {
            this.beforeSyntax((J)variable, Space.Location.VARIABLE_PREFIX, p);
            this.visit((Tree)variable.getName(), p);
            JLeftPadded initializer = variable.getPadding().getInitializer();
            this.visitLeftPadded("=", initializer, JLeftPadded.Location.VARIABLE_INITIALIZER, p);
            this.afterSyntax((J)variable, p);
            return variable;
        }

        protected void visitStatement(@Nullable JRightPadded<Statement> paddedStat, JRightPadded.Location location, PrintOutputCapture<P> p) {
            if (paddedStat != null) {
                this.visit((Tree)paddedStat.getElement(), p);
                this.visitSpace(paddedStat.getAfter(), location.getAfterLocation(), p);
                this.visitMarkers(paddedStat.getMarkers(), p);
            }
        }

        public <M extends Marker> M visitMarker(Marker marker, PrintOutputCapture<P> p) {
            if (marker instanceof TrailingComma) {
                p.append(",");
                this.visitSpace(((TrailingComma)marker).getSuffix(), Space.Location.LANGUAGE_EXTENSION, p);
            } else if (marker instanceof Semicolon) {
                p.append(';');
            }
            return (M)super.visitMarker(marker, p);
        }
    }
}

