/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.javascript;

import java.io.ByteArrayInputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Stream;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.InMemoryExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.SourceFile;
import org.openrewrite.internal.EncodingDetectingInputStream;
import org.openrewrite.java.internal.JavaTypeCache;
import org.openrewrite.javascript.internal.JavetNativeBridge;
import org.openrewrite.javascript.internal.TypeScriptParserVisitor;
import org.openrewrite.javascript.internal.tsc.TSCNode;
import org.openrewrite.javascript.internal.tsc.TSCRuntime;
import org.openrewrite.javascript.internal.tsc.TSCSourceFileContext;
import org.openrewrite.javascript.tree.JS;
import org.openrewrite.style.NamedStyles;
import org.openrewrite.tree.ParseError;
import org.openrewrite.tree.ParsingEventListener;
import org.openrewrite.tree.ParsingExecutionContextView;

public class JavaScriptParser
implements Parser {
    private static @Nullable TSCRuntime RUNTIME;
    private final Collection<NamedStyles> styles;
    private static final List<String> EXTENSIONS;
    private static final List<String> EXCLUSIONS;

    private static TSCRuntime runtime() {
        if (RUNTIME == null) {
            JavetNativeBridge.init();
            RUNTIME = TSCRuntime.init();
            Runtime.getRuntime().addShutdownHook(new Thread(() -> RUNTIME.close()));
        }
        return RUNTIME;
    }

    private JavaScriptParser(Collection<NamedStyles> styles) {
        this.styles = styles;
    }

    public Stream<SourceFile> parse(String ... sources) {
        ArrayList<Parser.Input> inputs = new ArrayList<Parser.Input>(sources.length);
        int i = 0;
        while (i < sources.length) {
            Path path = Paths.get("f" + i + ".ts", new String[0]);
            int j = i++;
            inputs.add(new Parser.Input(path, null, () -> new ByteArrayInputStream(sources[j].getBytes(StandardCharsets.UTF_8)), true));
        }
        return this.parseInputs(inputs, null, (ExecutionContext)new InMemoryExecutionContext());
    }

    public Stream<SourceFile> parseInputs(Iterable<Parser.Input> sources, @Nullable Path relativeTo, ExecutionContext ctx) {
        ParsingExecutionContextView pctx = ParsingExecutionContextView.view((ExecutionContext)ctx);
        LinkedHashMap<Path, SourceWrapper> sourcesByRelativePath = new LinkedHashMap<Path, SourceWrapper>();
        for (Parser.Input input2 : sources) {
            EncodingDetectingInputStream is = input2.getSource((ExecutionContext)pctx);
            String inputSourceText = is.readFully();
            Path relativePath2 = input2.getRelativePath(relativeTo);
            SourceWrapper source = new SourceWrapper(input2, relativePath2, is.getCharset(), is.isCharsetBomMarked(), inputSourceText);
            sourcesByRelativePath.put(relativePath2, source);
        }
        ArrayList compilationUnits = new ArrayList(sourcesByRelativePath.size());
        ParsingEventListener parsingListener = ParsingExecutionContextView.view((ExecutionContext)pctx).getParsingListener();
        LinkedHashMap<Path, String> sourceTextsForTSC = new LinkedHashMap<Path, String>();
        sourcesByRelativePath.forEach((relativePath, sourceText) -> sourceTextsForTSC.put((Path)relativePath, ((SourceWrapper)sourceText).sourceText));
        try {
            JavaScriptParser.runtime().parseSourceTexts(sourceTextsForTSC, (node, context) -> {
                JS.CompilationUnit cu;
                SourceWrapper source = (SourceWrapper)sourcesByRelativePath.get(context.getRelativeSourcePath());
                parsingListener.startedParsing(source.getInput());
                TypeScriptParserVisitor fileMapper = new TypeScriptParserVisitor((TSCNode)node, (TSCSourceFileContext)context, source.getSourcePath(), new JavaTypeCache(), source.getCharset().toString(), source.isCharsetBomMarked(), this.styles);
                try {
                    cu = fileMapper.visitSourceFile();
                    parsingListener.parsed(source.getInput(), (SourceFile)cu);
                }
                catch (Throwable t) {
                    pctx.getOnError().accept(t);
                    cu = ParseError.build((Parser)JavaScriptParser.builder().build(), (Parser.Input)source.getInput(), (Path)relativeTo, (ExecutionContext)pctx, (Throwable)t);
                }
                compilationUnits.add(cu);
            });
        }
        catch (Exception e) {
            return this.acceptedInputs(sources).map(input -> ParseError.build((Parser)this, (Parser.Input)input, (Path)relativeTo, (ExecutionContext)ctx, (Throwable)e));
        }
        return compilationUnits.stream();
    }

    public boolean accept(Path path) {
        if (path.toString().contains("/dist/")) {
            return false;
        }
        String filename = path.getFileName().toString().toLowerCase();
        for (String ext : EXTENSIONS) {
            if (!filename.endsWith(ext) || EXCLUSIONS.contains(filename)) continue;
            return true;
        }
        return false;
    }

    public Path sourcePathFromSourceText(Path prefix, String sourceCode) {
        return prefix.resolve("file.ts");
    }

    public static Builder builder() {
        return new Builder();
    }

    static {
        EXTENSIONS = Collections.unmodifiableList(Arrays.asList(".js", ".jsx", ".mjs", ".cjs", ".ts", ".tsx", ".mts", ".cts"));
        EXCLUSIONS = Collections.unmodifiableList(Arrays.asList(".pnp.cjs", ".pnp.loader.mjs"));
    }

    private static final class SourceWrapper {
        private final Parser.Input input;
        private final Path sourcePath;
        private final Charset charset;
        private final boolean isCharsetBomMarked;
        private final String sourceText;

        @Generated
        public SourceWrapper(Parser.Input input, Path sourcePath, Charset charset, boolean isCharsetBomMarked, String sourceText) {
            this.input = input;
            this.sourcePath = sourcePath;
            this.charset = charset;
            this.isCharsetBomMarked = isCharsetBomMarked;
            this.sourceText = sourceText;
        }

        @Generated
        public Parser.Input getInput() {
            return this.input;
        }

        @Generated
        public Path getSourcePath() {
            return this.sourcePath;
        }

        @Generated
        public Charset getCharset() {
            return this.charset;
        }

        @Generated
        public boolean isCharsetBomMarked() {
            return this.isCharsetBomMarked;
        }

        @Generated
        public String getSourceText() {
            return this.sourceText;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SourceWrapper)) {
                return false;
            }
            SourceWrapper other = (SourceWrapper)o;
            if (this.isCharsetBomMarked() != other.isCharsetBomMarked()) {
                return false;
            }
            Parser.Input this$input = this.getInput();
            Parser.Input other$input = other.getInput();
            if (this$input == null ? other$input != null : !this$input.equals(other$input)) {
                return false;
            }
            Path this$sourcePath = this.getSourcePath();
            Path other$sourcePath = other.getSourcePath();
            if (this$sourcePath == null ? other$sourcePath != null : !((Object)this$sourcePath).equals(other$sourcePath)) {
                return false;
            }
            Charset this$charset = this.getCharset();
            Charset other$charset = other.getCharset();
            if (this$charset == null ? other$charset != null : !((Object)this$charset).equals(other$charset)) {
                return false;
            }
            String this$sourceText = this.getSourceText();
            String other$sourceText = other.getSourceText();
            return !(this$sourceText == null ? other$sourceText != null : !this$sourceText.equals(other$sourceText));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isCharsetBomMarked() ? 79 : 97);
            Parser.Input $input = this.getInput();
            result = result * 59 + ($input == null ? 43 : $input.hashCode());
            Path $sourcePath = this.getSourcePath();
            result = result * 59 + ($sourcePath == null ? 43 : ((Object)$sourcePath).hashCode());
            Charset $charset = this.getCharset();
            result = result * 59 + ($charset == null ? 43 : ((Object)$charset).hashCode());
            String $sourceText = this.getSourceText();
            result = result * 59 + ($sourceText == null ? 43 : $sourceText.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "JavaScriptParser.SourceWrapper(input=" + this.getInput() + ", sourcePath=" + this.getSourcePath() + ", charset=" + this.getCharset() + ", isCharsetBomMarked=" + this.isCharsetBomMarked() + ", sourceText=" + this.getSourceText() + ")";
        }
    }

    public static class Builder
    extends Parser.Builder {
        Collection<NamedStyles> styles = new ArrayList<NamedStyles>();

        public Builder() {
            super(JS.CompilationUnit.class);
        }

        public Builder styles(Iterable<? extends NamedStyles> styles) {
            for (NamedStyles namedStyles : styles) {
                this.styles.add(namedStyles);
            }
            return this;
        }

        public JavaScriptParser build() {
            return new JavaScriptParser(this.styles);
        }

        public String getDslName() {
            return "javascript";
        }
    }
}

