/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.javascript.internal.tsc;

import com.caoccao.javet.exceptions.JavetException;
import com.caoccao.javet.interop.V8Runtime;
import com.caoccao.javet.values.V8Value;
import com.caoccao.javet.values.reference.IV8ValueObject;
import com.caoccao.javet.values.reference.V8ValueFunction;
import java.util.ArrayList;
import java.util.regex.Pattern;
import org.intellij.lang.annotations.Language;

public class TSCV8Utils {
    private static final Pattern IDENTIFIER_PATTERN = Pattern.compile("^([a-zA-Z_$][a-zA-Z\\\\d_$]*)$");

    private TSCV8Utils() {
    }

    public static void assertValidIdentifier(String name) {
        if (!IDENTIFIER_PATTERN.matcher(name).matches()) {
            throw new IllegalArgumentException(String.format("not a valid JS identifier: `%s`", name));
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static V8ValueFunction makeFunction(V8Runtime runtime, @Language(value="typescript") String innerCode, IV8ValueObject variables) {
        ArrayList varNames;
        try {
            varNames = new ArrayList();
            variables.forEach((varName, varValue) -> {
                TSCV8Utils.assertValidIdentifier((String)varName.getValue());
                varNames.add((String)varName.getValue());
            });
        }
        catch (JavetException e) {
            throw new RuntimeException(e);
        }
        String outerArgs = "{" + String.join((CharSequence)",", varNames) + "}";
        String outerCode = String.format("(%s) => {return %s;}", outerArgs, innerCode);
        try (V8ValueFunction outerFn = runtime.createV8ValueFunction(outerCode);){
            V8ValueFunction v8ValueFunction;
            block17: {
                V8Value innerFnObject = outerFn.call(null, new Object[]{variables});
                try {
                    if (!(innerFnObject instanceof V8ValueFunction)) {
                        throw new IllegalStateException("expected a function; found: " + innerFnObject.getClass().getSimpleName());
                    }
                    v8ValueFunction = (V8ValueFunction)innerFnObject.toClone();
                    if (innerFnObject == null) break block17;
                }
                catch (Throwable throwable) {
                    if (innerFnObject != null) {
                        try {
                            innerFnObject.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                innerFnObject.close();
            }
            return v8ValueFunction;
        }
        catch (JavetException e) {
            throw new RuntimeException(e);
        }
    }
}

