/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.javascript.table;

import java.beans.ConstructorProperties;
import org.openrewrite.Column;
import org.openrewrite.DataTable;
import org.openrewrite.Incubating;
import org.openrewrite.Recipe;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;

@Incubating(since="0.0")
public class ParseExceptionAnalysis
extends DataTable<Row> {
    public ParseExceptionAnalysis(Recipe recipe) {
        super(recipe, "Find and aggregate parsing errors", "Finds and aggregates parsing exceptions to fix the most common issues first.");
    }

    public static String getAnalysisMessage(String nodeType) {
        return ParseExceptionAnalysis.getAnalysisMessage(nodeType, null);
    }

    public static String getAnalysisMessage(String nodeType, @Nullable String sourceSnippet) {
        return "Unable to parse node of type {{" + nodeType + (sourceSnippet != null ? "}} at :" + sourceSnippet : "}}");
    }

    public static String getNodeType(String message) {
        if (message.contains("{{")) {
            return message.substring(message.indexOf("{{") + 2, message.indexOf("}}"));
        }
        return message.substring(0, message.indexOf(":"));
    }

    public static String getSourceSnippet(String message) {
        int start = message.indexOf("}} at :") + 7;
        return start > 6 ? message.substring(start) : "";
    }

    public static final class Row {
        @Column(displayName="Source file extension", description="The file extension of the source.")
        private final String fileExtension;
        @Column(displayName="Node type", description="The type of the node that caused a parsing exception.")
        private final String nodeType;
        @Column(displayName="Exception count", description="Count of exceptions of the Node `syntaxKind`.")
        private final int exceptionCount;

        @ConstructorProperties(value={"fileExtension", "nodeType", "exceptionCount"})
        public Row(String fileExtension, String nodeType, int exceptionCount) {
            this.fileExtension = fileExtension;
            this.nodeType = nodeType;
            this.exceptionCount = exceptionCount;
        }

        public String getFileExtension() {
            return this.fileExtension;
        }

        public String getNodeType() {
            return this.nodeType;
        }

        public int getExceptionCount() {
            return this.exceptionCount;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Row)) {
                return false;
            }
            Row other = (Row)o;
            if (this.getExceptionCount() != other.getExceptionCount()) {
                return false;
            }
            String this$fileExtension = this.getFileExtension();
            String other$fileExtension = other.getFileExtension();
            if (this$fileExtension == null ? other$fileExtension != null : !this$fileExtension.equals(other$fileExtension)) {
                return false;
            }
            String this$nodeType = this.getNodeType();
            String other$nodeType = other.getNodeType();
            return !(this$nodeType == null ? other$nodeType != null : !this$nodeType.equals(other$nodeType));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getExceptionCount();
            String $fileExtension = this.getFileExtension();
            result = result * 59 + ($fileExtension == null ? 43 : $fileExtension.hashCode());
            String $nodeType = this.getNodeType();
            result = result * 59 + ($nodeType == null ? 43 : $nodeType.hashCode());
            return result;
        }

        @NonNull
        public String toString() {
            return "ParseExceptionAnalysis.Row(fileExtension=" + this.getFileExtension() + ", nodeType=" + this.getNodeType() + ", exceptionCount=" + this.getExceptionCount() + ")";
        }
    }
}

