/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.javascript.table;

import java.beans.ConstructorProperties;
import org.openrewrite.Column;
import org.openrewrite.DataTable;
import org.openrewrite.Recipe;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;

public class JavaScriptSourceFile
extends DataTable<Row> {
    public JavaScriptSourceFile(Recipe recipe) {
        super(recipe, "JavaScript or TypeScript source files", "JavaScript or TypeScript sources present in LSTs on the SAAS.");
    }

    public static enum SourceFileType {
        JavaScript,
        TypeScript,
        Quark,
        PlainText;

    }

    public static final class Row {
        @Column(displayName="Source path before the run", description="The source path of the file before the run.")
        private final String sourcePath;
        @Column(displayName="Source file type", description="The source file type that was created.")
        private final SourceFileType sourceFileType;

        @ConstructorProperties(value={"sourcePath", "sourceFileType"})
        public Row(String sourcePath, SourceFileType sourceFileType) {
            this.sourcePath = sourcePath;
            this.sourceFileType = sourceFileType;
        }

        public String getSourcePath() {
            return this.sourcePath;
        }

        public SourceFileType getSourceFileType() {
            return this.sourceFileType;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Row)) {
                return false;
            }
            Row other = (Row)o;
            String this$sourcePath = this.getSourcePath();
            String other$sourcePath = other.getSourcePath();
            if (this$sourcePath == null ? other$sourcePath != null : !this$sourcePath.equals(other$sourcePath)) {
                return false;
            }
            SourceFileType this$sourceFileType = this.getSourceFileType();
            SourceFileType other$sourceFileType = other.getSourceFileType();
            return !(this$sourceFileType == null ? other$sourceFileType != null : !((Object)((Object)this$sourceFileType)).equals((Object)other$sourceFileType));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $sourcePath = this.getSourcePath();
            result = result * 59 + ($sourcePath == null ? 43 : $sourcePath.hashCode());
            SourceFileType $sourceFileType = this.getSourceFileType();
            result = result * 59 + ($sourceFileType == null ? 43 : ((Object)((Object)$sourceFileType)).hashCode());
            return result;
        }

        @NonNull
        public String toString() {
            return "JavaScriptSourceFile.Row(sourcePath=" + this.getSourcePath() + ", sourceFileType=" + (Object)((Object)this.getSourceFileType()) + ")";
        }
    }
}

