/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.javascript.internal;

import java.beans.ConstructorProperties;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.internal.EncodingDetectingInputStream;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.internal.JavaTypeCache;
import org.openrewrite.javascript.internal.TypeScriptParserVisitor;
import org.openrewrite.javascript.internal.tsc.TSCNode;
import org.openrewrite.javascript.internal.tsc.TSCRuntime;
import org.openrewrite.javascript.internal.tsc.TSCSourceFileContext;
import org.openrewrite.javascript.tree.JS;

public abstract class TSCMapper
implements AutoCloseable {
    private final TSCRuntime runtime;
    @Nullable
    private final Path relativeTo;
    private final Map<Path, SourceWrapper> sourcesByRelativePath = new HashMap<Path, SourceWrapper>();

    public TSCMapper(@Nullable Path relativeTo) {
        this.runtime = TSCRuntime.init();
        this.relativeTo = relativeTo;
    }

    public void add(Parser.Input input, ExecutionContext ctx) {
        EncodingDetectingInputStream is = input.getSource(ctx);
        String inputSourceText = is.readFully();
        Path relativePath = input.getRelativePath(this.relativeTo);
        SourceWrapper source = new SourceWrapper(relativePath, is.getCharset(), is.isCharsetBomMarked(), inputSourceText);
        this.sourcesByRelativePath.put(relativePath, source);
    }

    protected abstract void onParseFailure(Parser.Input var1, Throwable var2);

    public List<JS.CompilationUnit> build() {
        ArrayList<JS.CompilationUnit> compilationUnits = new ArrayList<JS.CompilationUnit>(this.sourcesByRelativePath.size());
        HashMap<Path, String> sourceTextsForTSC = new HashMap<Path, String>();
        this.sourcesByRelativePath.forEach((relativePath, sourceText) -> sourceTextsForTSC.put((Path)relativePath, ((SourceWrapper)sourceText).sourceText));
        this.runtime.parseSourceTexts(sourceTextsForTSC, (node, context) -> {
            SourceWrapper source = this.sourcesByRelativePath.get(context.getRelativeSourcePath());
            TypeScriptParserVisitor fileMapper = new TypeScriptParserVisitor((TSCNode)node, (TSCSourceFileContext)context, source.getSourcePath(), new JavaTypeCache(), source.getCharset().toString(), source.isCharsetBomMarked());
            compilationUnits.add(fileMapper.visitSourceFile());
        });
        return compilationUnits;
    }

    @Override
    public void close() {
        this.runtime.close();
    }

    private static final class SourceWrapper {
        private final Path sourcePath;
        private final Charset charset;
        private final boolean isCharsetBomMarked;
        private final String sourceText;

        @ConstructorProperties(value={"sourcePath", "charset", "isCharsetBomMarked", "sourceText"})
        public SourceWrapper(Path sourcePath, Charset charset, boolean isCharsetBomMarked, String sourceText) {
            this.sourcePath = sourcePath;
            this.charset = charset;
            this.isCharsetBomMarked = isCharsetBomMarked;
            this.sourceText = sourceText;
        }

        public Path getSourcePath() {
            return this.sourcePath;
        }

        public Charset getCharset() {
            return this.charset;
        }

        public boolean isCharsetBomMarked() {
            return this.isCharsetBomMarked;
        }

        public String getSourceText() {
            return this.sourceText;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SourceWrapper)) {
                return false;
            }
            SourceWrapper other = (SourceWrapper)o;
            if (this.isCharsetBomMarked() != other.isCharsetBomMarked()) {
                return false;
            }
            Path this$sourcePath = this.getSourcePath();
            Path other$sourcePath = other.getSourcePath();
            if (this$sourcePath == null ? other$sourcePath != null : !((Object)this$sourcePath).equals(other$sourcePath)) {
                return false;
            }
            Charset this$charset = this.getCharset();
            Charset other$charset = other.getCharset();
            if (this$charset == null ? other$charset != null : !((Object)this$charset).equals(other$charset)) {
                return false;
            }
            String this$sourceText = this.getSourceText();
            String other$sourceText = other.getSourceText();
            return !(this$sourceText == null ? other$sourceText != null : !this$sourceText.equals(other$sourceText));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isCharsetBomMarked() ? 79 : 97);
            Path $sourcePath = this.getSourcePath();
            result = result * 59 + ($sourcePath == null ? 43 : ((Object)$sourcePath).hashCode());
            Charset $charset = this.getCharset();
            result = result * 59 + ($charset == null ? 43 : ((Object)$charset).hashCode());
            String $sourceText = this.getSourceText();
            result = result * 59 + ($sourceText == null ? 43 : $sourceText.hashCode());
            return result;
        }

        @NonNull
        public String toString() {
            return "TSCMapper.SourceWrapper(sourcePath=" + this.getSourcePath() + ", charset=" + this.getCharset() + ", isCharsetBomMarked=" + this.isCharsetBomMarked() + ", sourceText=" + this.getSourceText() + ")";
        }
    }
}

