/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.service;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.Incubating;
import org.openrewrite.PrintOutputCapture;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.java.JavaPrinter;
import org.openrewrite.java.search.SemanticallyEqual;
import org.openrewrite.java.service.Span;
import org.openrewrite.java.tree.Comment;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JContainer;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.Space;

@Incubating(since="8.63.0")
public class SourcePositionService {
    public int computeColumnToAlignTo(Cursor cursor, int continuation) {
        final Cursor alignWith = this.alignsWith(cursor);
        if (alignWith == null) {
            Cursor newLinedElementCursor = this.computeNewLinedCursorElement(cursor.getParentTreeCursor());
            return ((J)newLinedElementCursor.getValue()).getPrefix().getIndent().length() + continuation;
        }
        Cursor newLinedElementCursor = this.computeNewLinedCursorElement(alignWith);
        if (alignWith == newLinedElementCursor) {
            Cursor parentCursor = this.computeNewLinedCursorElement(newLinedElementCursor.getParentTreeCursor());
            return ((J)parentCursor.getValue()).getPrefix().getIndent().length() + continuation;
        }
        if (newLinedElementCursor.getValue() instanceof J) {
            J j = (J)newLinedElementCursor.getValue();
            final AtomicInteger indentation = new AtomicInteger(-1);
            JavaPrinter javaPrinter = new JavaPrinter<TreeVisitor<?, ?>>(){

                @Override
                public J visitVariableDeclarations(J.VariableDeclarations multiVariable, PrintOutputCapture<TreeVisitor<?, ?>> p) {
                    if (multiVariable == alignWith.getValue() || SemanticallyEqual.areEqual(multiVariable, (J)alignWith.getValue())) {
                        this.beforeSyntax(multiVariable, Space.Location.VARIABLE_DECLARATIONS_PREFIX, p);
                        this.visitSpace(Space.EMPTY, Space.Location.ANNOTATIONS, p);
                        indentation.set(p.getOut().length());
                        return multiVariable;
                    }
                    return super.visitVariableDeclarations(multiVariable, p);
                }

                @Override
                public J visitMethodInvocation(J.MethodInvocation method, PrintOutputCapture<TreeVisitor<?, ?>> p) {
                    if (method == alignWith.getValue() || SemanticallyEqual.areEqual(method, (J)alignWith.getValue())) {
                        this.beforeSyntax(method, Space.Location.METHOD_INVOCATION_PREFIX, p);
                        this.visitRightPadded(method.getPadding().getSelect(), JRightPadded.Location.METHOD_SELECT, "", p);
                        indentation.set(p.getOut().length());
                        return method;
                    }
                    return super.visitMethodInvocation(method, p);
                }
            };
            PrintOutputCapture printLine = new PrintOutputCapture<TreeVisitor<?, ?>>(javaPrinter, PrintOutputCapture.MarkerPrinter.SANITIZED){

                public PrintOutputCapture<TreeVisitor<?, ?>> append(@Nullable String text) {
                    if (text != null && text.contains("\n")) {
                        this.out.setLength(0);
                        text = text.substring(text.lastIndexOf("\n") + 1);
                    }
                    return super.append(text);
                }
            };
            javaPrinter.visit(j, printLine, cursor.getParentOrThrow());
            return indentation.get();
        }
        throw new RuntimeException("Unable to calculate length due to unexpected cursor value: " + newLinedElementCursor.getValue().getClass());
    }

    public Span positionOf(Cursor cursor) {
        return this.positionOfChild(cursor, cursor.getValue());
    }

    public Span positionOf(Cursor cursor, JContainer<? extends J> container) {
        return this.positionOfChild(cursor, container);
    }

    public Span positionOf(Cursor cursor, JRightPadded<J> rightPadded) {
        return this.positionOfChild(cursor, rightPadded);
    }

    public Span positionOf(Cursor cursor, J child) {
        return this.positionOfChild(cursor, child);
    }

    private Cursor computeNewLinedCursorElement(Cursor cursor) {
        Object cursorValue = cursor.getValue();
        while (cursorValue instanceof J.MethodInvocation && ((J.MethodInvocation)cursorValue).getSelect() instanceof J.MethodInvocation) {
            cursorValue = ((J.MethodInvocation)cursorValue).getSelect();
        }
        if (cursorValue instanceof J) {
            J j = (J)cursorValue;
            boolean hasNewLine = j.getPrefix().getWhitespace().contains("\n") || j.getComments().stream().anyMatch(c -> c.getSuffix().contains("\n"));
            Cursor parent = cursor.getParentTreeCursor();
            boolean isCompilationUnit = parent.getValue() instanceof J.CompilationUnit;
            if (!hasNewLine && !isCompilationUnit) {
                return this.computeNewLinedCursorElement(parent);
            }
        }
        return cursor;
    }

    private @Nullable Cursor alignsWith(Cursor cursor) {
        J cursorValue = (J)cursor.getValue();
        for (Cursor parent = cursor; parent != null && !(parent.getValue() instanceof SourceFile); parent = parent.getParent()) {
            Object parentValue = parent.getValue();
            if (parentValue instanceof JContainer) {
                JContainer container = (JContainer)parent.getValue();
                if (!container.getElements().stream().anyMatch(e -> e == cursorValue || SemanticallyEqual.areEqual(e, cursorValue))) continue;
                J firstElement = (J)container.getElements().get(0);
                if (!firstElement.getPrefix().getLastWhitespace().contains("\n")) {
                    if (firstElement == cursorValue || SemanticallyEqual.areEqual(firstElement, cursorValue)) {
                        return cursor;
                    }
                    return new Cursor(parent, (Object)firstElement);
                }
                return null;
            }
            if (!(parentValue instanceof J.MethodInvocation)) continue;
            while (((J.MethodInvocation)parentValue).getSelect() instanceof J.MethodInvocation) {
                parentValue = ((J.MethodInvocation)parentValue).getSelect();
                parent = new Cursor(parent, parentValue);
            }
            J.MethodInvocation method = (J.MethodInvocation)parentValue;
            if (!parent.getPathAsStream(o -> o instanceof J.MethodInvocation).anyMatch(value -> value == cursorValue || SemanticallyEqual.areEqual((J)value, cursorValue))) continue;
            if (method.getPadding().getSelect() != null && !method.getPadding().getSelect().getAfter().getLastWhitespace().contains("\n")) {
                return parent;
            }
            return null;
        }
        return null;
    }

    private Span positionOfChild(final Cursor cursor, Object child) {
        JRightPadded findJRightPadded;
        J findJ;
        JContainer findJContainer;
        if (child instanceof J) {
            findJContainer = null;
            findJ = (J)child;
            findJRightPadded = null;
        } else if (child instanceof JContainer) {
            findJContainer = (JContainer)child;
            findJ = null;
            findJRightPadded = null;
        } else if (child instanceof JRightPadded) {
            findJContainer = null;
            findJ = null;
            findJRightPadded = (JRightPadded)child;
        } else {
            if (child instanceof Collection) {
                throw new IllegalArgumentException("Can only find J elements or their containers. Did you create a Cursor from a `get...()` method which should be done on the `getPadding().get...()` instead?");
            }
            throw new IllegalArgumentException("Can only find J elements or their containers. Not on " + child.getClass().getSimpleName() + ".");
        }
        final AtomicInteger startLine = new AtomicInteger(1);
        final AtomicInteger startCol = new AtomicInteger(1);
        final AtomicBoolean printing = new AtomicBoolean(false);
        final AtomicBoolean found = new AtomicBoolean(false);
        JavaPrinter javaPrinter = new JavaPrinter<TreeVisitor<?, ?>>(){
            @Nullable J foundJ = null;

            @Override
            protected void visitRightPadded(List<? extends JRightPadded<? extends J>> nodes, JRightPadded.Location location, String suffixBetween, PrintOutputCapture<TreeVisitor<?, ?>> p) {
                if (findJContainer != null && nodes == findJContainer.getPadding().getElements()) {
                    for (int i = 0; i < nodes.size(); ++i) {
                        JRightPadded<? extends J> node = nodes.get(i);
                        if (i == 0) {
                            this.visit((Tree)this.startFind(node.getElement(), p), p);
                        } else {
                            this.visit(node.getElement(), p);
                        }
                        this.visitSpace(node.getAfter(), location.getAfterLocation(), p);
                        this.visitMarkers(node.getMarkers(), p);
                        if (i >= nodes.size() - 1) continue;
                        p.append(suffixBetween);
                    }
                    found.set(true);
                } else {
                    super.visitRightPadded(nodes, location, suffixBetween, p);
                }
            }

            @Override
            protected void visitRightPadded(@Nullable JRightPadded<? extends J> rightPadded, JRightPadded.Location location, @Nullable String suffix, PrintOutputCapture<TreeVisitor<?, ?>> p) {
                if (findJRightPadded != null && rightPadded == findJRightPadded) {
                    super.visitRightPadded(rightPadded.withElement((J)this.startFind(rightPadded.getElement(), p)), location, suffix, p);
                    found.set(true);
                } else {
                    super.visitRightPadded(rightPadded, location, suffix, p);
                }
            }

            public @Nullable J preVisit(@NonNull J tree, PrintOutputCapture<TreeVisitor<?, ?>> p) {
                if (found.get()) {
                    this.stopAfterPreVisit();
                }
                if (tree != cursor.getValue() && cursor.getValue() instanceof J && tree.getId().equals(((J)cursor.getValue()).getId())) {
                    this.setCursor(cursor);
                    tree = (J)cursor.getValue();
                }
                if (findJ != null && tree == findJ) {
                    tree = this.foundJ = this.startFind(tree, p);
                }
                return (J)super.preVisit((Tree)tree, p);
            }

            public @Nullable J postVisit(@NonNull J tree, PrintOutputCapture<TreeVisitor<?, ?>> p) {
                if (tree == this.foundJ) {
                    found.set(true);
                }
                return (J)super.postVisit((Tree)tree, p);
            }

            public <T extends J> T startFind(J tree, PrintOutputCapture<TreeVisitor<?, ?>> p) {
                Space space = tree.getPrefix();
                p.append(space.getWhitespace());
                List<Comment> comments = space.getComments();
                for (int i = 0; i < comments.size(); ++i) {
                    Comment comment = comments.get(i);
                    comment.printComment(this.getCursor(), p);
                    p.append(comment.getSuffix());
                }
                printing.set(true);
                return (T)tree.withPrefix(Space.EMPTY);
            }
        };
        PrintOutputCapture printLine = new PrintOutputCapture<TreeVisitor<?, ?>>(javaPrinter, PrintOutputCapture.MarkerPrinter.SANITIZED){

            public PrintOutputCapture<TreeVisitor<?, ?>> append(@Nullable String text) {
                if (text == null || text.isEmpty() || found.get()) {
                    return this;
                }
                if (printing.get()) {
                    return super.append(text);
                }
                for (int i = 0; i < text.length(); ++i) {
                    char c = text.charAt(i);
                    if (c == '\n') {
                        startLine.incrementAndGet();
                        startCol.set(1);
                        continue;
                    }
                    if (c == '\r') {
                        if (i + 1 < text.length() && text.charAt(i + 1) == '\n') continue;
                        startLine.incrementAndGet();
                        startCol.set(1);
                        continue;
                    }
                    startCol.incrementAndGet();
                }
                return this;
            }

            public PrintOutputCapture<TreeVisitor<?, ?>> append(char c) {
                if (found.get()) {
                    return this;
                }
                if (printing.get()) {
                    return super.append(c);
                }
                if (c == '\n' || c == '\r') {
                    startLine.incrementAndGet();
                    startCol.set(1);
                } else {
                    startCol.incrementAndGet();
                }
                return this;
            }
        };
        Cursor printCursor = cursor;
        if (!(cursor.getValue() instanceof JavaSourceFile)) {
            printCursor = cursor.dropParentUntil(c -> c instanceof JavaSourceFile);
        }
        javaPrinter.visit((Tree)printCursor.getValue(), printLine, printCursor.getParent());
        String content = printLine.getOut();
        if (found.get()) {
            int indent = StringUtils.indent((String)content).length();
            int col = startCol.get();
            int maxColumn = 1;
            int lines = 0;
            for (int i = 0; i < content.length(); ++i) {
                char c2 = content.charAt(i);
                if ('\n' == c2) {
                    ++lines;
                    if (maxColumn < col) {
                        maxColumn = col;
                    }
                    col = 1;
                    continue;
                }
                if (c2 == '\r') {
                    if (i + 1 < content.length() && content.charAt(i + 1) == '\n') continue;
                    ++lines;
                    if (maxColumn < col) {
                        maxColumn = col;
                    }
                    col = 1;
                    continue;
                }
                ++col;
            }
            if (maxColumn < col) {
                maxColumn = col;
            }
            return Span.builder().startLine(startLine.get()).startColumn(startCol.get() + indent).endLine(startLine.get() + lines).endColumn(col).maxColumn(maxColumn).build();
        }
        throw new IllegalArgumentException("The child was not found in the sourceFile. Are you sure the passed in cursor's value contains the child and you are not searching for a mutated element in a non-mutated Cursor value?");
    }
}

