/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.internal.parser;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UncheckedIOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipException;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.util.CheckClassAdapter;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Incubating;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.java.JavaParserExecutionContextView;
import org.openrewrite.java.internal.parser.JavaParserCaller;
import org.openrewrite.java.internal.parser.JavaParserClasspathLoader;

@Incubating(since="8.44.0")
public final class TypeTable
implements JavaParserClasspathLoader {
    public static final String VERIFY_CLASS_WRITING = "org.openrewrite.java.TypeTableClassWritingVerification";
    public static final String DEFAULT_RESOURCE_PATH = "META-INF/rewrite/classpath.tsv.zip";
    private static final Map<GroupArtifactVersion, Path> classesDirByArtifact = new LinkedHashMap<GroupArtifactVersion, Path>();

    public static @Nullable TypeTable fromClasspath(ExecutionContext ctx, Collection<String> artifactNames) {
        try {
            Enumeration<URL> resources = JavaParserCaller.findCaller().getClassLoader().getResources(DEFAULT_RESOURCE_PATH);
            if (resources.hasMoreElements()) {
                return new TypeTable(ctx, resources, artifactNames);
            }
            return null;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    TypeTable(ExecutionContext ctx, URL url, Collection<String> artifactNames) {
        TypeTable.read(url, artifactNames, ctx);
    }

    TypeTable(ExecutionContext ctx, Enumeration<URL> resources, Collection<String> artifactNames) {
        while (resources.hasMoreElements()) {
            TypeTable.read(resources.nextElement(), artifactNames, ctx);
        }
    }

    private static void read(URL url, Collection<String> artifactNames, ExecutionContext ctx) {
        Collection<String> missingArtifacts = TypeTable.artifactsNotYetWritten(artifactNames);
        if (missingArtifacts.isEmpty()) {
            return;
        }
        try (InputStream is = url.openStream();
             GZIPInputStream inflate = new GZIPInputStream(is);){
            new Reader(ctx).read(inflate, missingArtifacts);
        }
        catch (ZipException e) {
            try (InputStream is2 = url.openStream();
                 InflaterInputStream inflate2 = new InflaterInputStream(is2);){
                new Reader(ctx).read(inflate2, missingArtifacts);
            }
            catch (IOException e1) {
                throw new UncheckedIOException(e1);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static Collection<String> artifactsNotYetWritten(Collection<String> artifactNames) {
        ArrayList<String> notWritten = new ArrayList<String>(artifactNames);
        for (String artifactName : artifactNames) {
            Pattern artifactPattern = Pattern.compile(artifactName + ".*");
            for (GroupArtifactVersion groupArtifactVersion : classesDirByArtifact.keySet()) {
                if (!artifactPattern.matcher(groupArtifactVersion.getArtifactId() + "-" + groupArtifactVersion.getVersion()).matches()) continue;
                notWritten.remove(artifactName);
            }
        }
        return notWritten;
    }

    private static Path getClassesDir(ExecutionContext ctx, GroupArtifactVersion gav) {
        Path jarsFolder = JavaParserExecutionContextView.view(ctx).getParserClasspathDownloadTarget().toPath().resolve(".tt");
        if (!jarsFolder.toFile().mkdirs() && !Files.exists(jarsFolder, new LinkOption[0])) {
            throw new UncheckedIOException(new IOException("Failed to create directory " + jarsFolder));
        }
        Path classesDir = jarsFolder;
        for (String g : gav.getGroupId().split("\\.")) {
            classesDir = classesDir.resolve(g);
        }
        if (!(classesDir = classesDir.resolve(gav.getArtifactId()).resolve(gav.getVersion())).toFile().mkdirs() && !Files.exists(classesDir, new LinkOption[0])) {
            throw new UncheckedIOException(new IOException("Failed to create directory " + classesDir));
        }
        return classesDir;
    }

    public static Writer newWriter(OutputStream out) {
        try {
            return new Writer(out);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public @Nullable Path load(String artifactName) {
        for (Map.Entry<GroupArtifactVersion, Path> gavAndClassesDir : classesDirByArtifact.entrySet()) {
            GroupArtifactVersion gav = gavAndClassesDir.getKey();
            if (!Pattern.compile(artifactName + ".*").matcher(gav.getArtifactId() + "-" + gav.getVersion()).matches()) continue;
            return gavAndClassesDir.getValue();
        }
        return null;
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        return o instanceof TypeTable;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }

    @NonNull
    @Generated
    public String toString() {
        return "TypeTable()";
    }

    private static final class GroupArtifactVersion {
        private final String groupId;
        private final String artifactId;
        private final String version;

        @Generated
        public GroupArtifactVersion(String groupId, String artifactId, String version) {
            this.groupId = groupId;
            this.artifactId = artifactId;
            this.version = version;
        }

        @Generated
        public String getGroupId() {
            return this.groupId;
        }

        @Generated
        public String getArtifactId() {
            return this.artifactId;
        }

        @Generated
        public String getVersion() {
            return this.version;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GroupArtifactVersion)) {
                return false;
            }
            GroupArtifactVersion other = (GroupArtifactVersion)o;
            String this$groupId = this.getGroupId();
            String other$groupId = other.getGroupId();
            if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
                return false;
            }
            String this$artifactId = this.getArtifactId();
            String other$artifactId = other.getArtifactId();
            if (this$artifactId == null ? other$artifactId != null : !this$artifactId.equals(other$artifactId)) {
                return false;
            }
            String this$version = this.getVersion();
            String other$version = other.getVersion();
            return !(this$version == null ? other$version != null : !this$version.equals(other$version));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $groupId = this.getGroupId();
            result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
            String $artifactId = this.getArtifactId();
            result = result * 59 + ($artifactId == null ? 43 : $artifactId.hashCode());
            String $version = this.getVersion();
            result = result * 59 + ($version == null ? 43 : $version.hashCode());
            return result;
        }

        @NonNull
        @Generated
        public String toString() {
            return "TypeTable.GroupArtifactVersion(groupId=" + this.getGroupId() + ", artifactId=" + this.getArtifactId() + ", version=" + this.getVersion() + ")";
        }
    }

    static class Reader {
        private static final int NESTED_TYPE_ACCESS_MASK = 30239;
        private final ExecutionContext ctx;

        public void read(InputStream is, Collection<String> artifactNames) throws IOException {
            if (artifactNames.isEmpty()) {
                return;
            }
            Set artifactNamePatterns = artifactNames.stream().map(name -> Pattern.compile(name + ".*")).collect(Collectors.toSet());
            AtomicReference<@Nullable V> matchedGav = new AtomicReference();
            HashMap<String, ClassDefinition> classesByName = new HashMap<String, ClassDefinition>();
            HashMap<String, List<ClassDefinition>> nestedTypesByOwner = new HashMap<String, List<ClassDefinition>>();
            try (BufferedReader in = new BufferedReader(new InputStreamReader(is));){
                AtomicReference<@Nullable V> lastGav = new AtomicReference();
                in.lines().skip(1L).forEach(line -> {
                    String[] fields = line.split("\t", -1);
                    GroupArtifactVersion rowGav = new GroupArtifactVersion(fields[0], fields[1], fields[2]);
                    if (!Objects.equals(rowGav, lastGav.get())) {
                        this.writeClassesDir((GroupArtifactVersion)matchedGav.get(), classesByName, nestedTypesByOwner);
                        matchedGav.set(null);
                        classesByName.clear();
                        nestedTypesByOwner.clear();
                        String artifactVersion = fields[1] + "-" + fields[2];
                        for (Pattern artifactNamePattern : artifactNamePatterns) {
                            if (!artifactNamePattern.matcher(artifactVersion).matches()) continue;
                            matchedGav.set(rowGav);
                            break;
                        }
                    }
                    lastGav.set(rowGav);
                    if (matchedGav.get() != null) {
                        int memberAccess;
                        String className = fields[4];
                        ClassDefinition classDefinition = classesByName.computeIfAbsent(className, name -> new ClassDefinition(Integer.parseInt(fields[3]), (String)name, fields[5].isEmpty() ? null : fields[5], fields[6].isEmpty() ? null : fields[6], fields[7].isEmpty() ? null : fields[7].split("\\|")));
                        int lastIndexOf$ = className.lastIndexOf(36);
                        if (lastIndexOf$ != -1) {
                            String ownerName = className.substring(0, lastIndexOf$);
                            nestedTypesByOwner.computeIfAbsent(ownerName, k -> new ArrayList(4)).add(classDefinition);
                        }
                        if ((memberAccess = Integer.parseInt(fields[8])) != -1) {
                            classDefinition.addMember(new Member(classDefinition, memberAccess, fields[9], fields[10], fields[11].isEmpty() ? null : fields[11], fields[12].isEmpty() ? null : fields[12].split("\\|"), fields[13].isEmpty() ? null : fields[13].split("\\|")));
                        }
                    }
                });
            }
            this.writeClassesDir((GroupArtifactVersion)matchedGav.get(), classesByName, nestedTypesByOwner);
        }

        private void writeClassesDir(@Nullable GroupArtifactVersion gav, Map<String, ClassDefinition> classes, Map<String, List<ClassDefinition>> nestedTypesByOwner) {
            if (gav == null) {
                return;
            }
            Path classesDir = TypeTable.getClassesDir(this.ctx, gav);
            classesDirByArtifact.put(gav, classesDir);
            classes.values().forEach(classDef -> {
                Path classFile = classesDir.resolve(classDef.getName() + ".class");
                if (!classFile.getParent().toFile().mkdirs() && !Files.exists(classFile.getParent(), new LinkOption[0])) {
                    throw new UncheckedIOException(new IOException("Failed to create directory " + classesDir.getParent()));
                }
                ClassWriter cw = new ClassWriter(1);
                ClassWriter classWriter = (Boolean)this.ctx.getMessage(TypeTable.VERIFY_CLASS_WRITING, (Object)false) != false ? new CheckClassAdapter((ClassVisitor)cw) : cw;
                classWriter.visit(52, classDef.getAccess(), classDef.getName(), classDef.getSignature(), classDef.getSuperclassSignature(), classDef.getSuperinterfaceSignatures());
                for (ClassDefinition innerClassDef : nestedTypesByOwner.getOrDefault(classDef.getName(), Collections.emptyList())) {
                    classWriter.visitInnerClass(innerClassDef.getName(), classDef.getName(), innerClassDef.getName().substring(classDef.getName().length() + 1), innerClassDef.getAccess() & 0x761F);
                }
                for (Member member : classDef.getMembers()) {
                    if (member.getDescriptor().contains("(")) {
                        MethodVisitor mv = classWriter.visitMethod(member.getAccess(), member.getName(), member.getDescriptor(), member.getSignature(), member.getExceptions());
                        String[] parameterNames = member.getParameterNames();
                        if (parameterNames != null) {
                            for (String parameterName : parameterNames) {
                                mv.visitParameter(parameterName, 0);
                            }
                        }
                        this.writeMethodBody(member, mv);
                        mv.visitEnd();
                        continue;
                    }
                    classWriter.visitField(member.getAccess(), member.getName(), member.getDescriptor(), member.getSignature(), null).visitEnd();
                }
                try {
                    Files.write(classFile, cw.toByteArray(), new OpenOption[0]);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            });
        }

        private void writeMethodBody(Member member, MethodVisitor mv) {
            if ((member.getAccess() & 0x400) == 0) {
                mv.visitCode();
                if ("<init>".equals(member.getName())) {
                    mv.visitVarInsn(25, 0);
                    mv.visitMethodInsn(183, member.getClassDefinition().getSuperclassSignature(), "<init>", "()V", false);
                }
                Type returnType = Type.getReturnType((String)member.getDescriptor());
                switch (returnType.getSort()) {
                    case 0: {
                        mv.visitInsn(177);
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        mv.visitInsn(3);
                        mv.visitInsn(172);
                        break;
                    }
                    case 7: {
                        mv.visitInsn(9);
                        mv.visitInsn(173);
                        break;
                    }
                    case 6: {
                        mv.visitInsn(11);
                        mv.visitInsn(174);
                        break;
                    }
                    case 8: {
                        mv.visitInsn(14);
                        mv.visitInsn(175);
                        break;
                    }
                    case 9: 
                    case 10: {
                        mv.visitInsn(1);
                        mv.visitInsn(176);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown return type: " + returnType);
                    }
                }
                mv.visitMaxs(0, 0);
            }
        }

        @Generated
        public Reader(ExecutionContext ctx) {
            this.ctx = ctx;
        }
    }

    public static class Writer
    implements AutoCloseable {
        private final PrintStream out;
        private final GZIPOutputStream deflater;

        public Writer(OutputStream out) throws IOException {
            this.deflater = new GZIPOutputStream(out);
            this.out = new PrintStream(this.deflater);
            this.out.println("groupId\tartifactId\tversion\tclassAccess\tclassName\tclassSignature\tclassSuperclassSignature\tclassSuperinterfaceSignatures\taccess\tname\tdescriptor\tsignature\tparameterNames\texceptions");
        }

        public Jar jar(String groupId, String artifactId, String version) {
            return new Jar(groupId, artifactId, version);
        }

        @Override
        public void close() throws IOException {
            this.deflater.flush();
            this.out.close();
        }

        public final class Jar {
            private final String groupId;
            private final String artifactId;
            private final String version;

            public void write(Path jar) {
                try (JarFile jarFile = new JarFile(jar.toFile());){
                    Enumeration<JarEntry> entries = jarFile.entries();
                    while (entries.hasMoreElements()) {
                        JarEntry entry = entries.nextElement();
                        if (!entry.getName().endsWith(".class")) continue;
                        InputStream inputStream = jarFile.getInputStream(entry);
                        try {
                            new ClassReader(inputStream).accept(new ClassVisitor(589824){
                                @Nullable ClassDefinition classDefinition;
                                boolean wroteFieldOrMethod;
                                final List<String> collectedParameterNames;
                                {
                                    this.collectedParameterNames = new ArrayList<String>();
                                }

                                public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                                    int lastIndexOf$ = name.lastIndexOf(36);
                                    if (lastIndexOf$ != -1 && lastIndexOf$ < name.length() - 1 && !Character.isJavaIdentifierStart(name.charAt(lastIndexOf$ + 1))) {
                                        this.classDefinition = null;
                                    } else {
                                        this.classDefinition = new ClassDefinition(Jar.this, access, name, signature, superName, interfaces);
                                        this.wroteFieldOrMethod = false;
                                        super.visit(version, access, name, signature, superName, interfaces);
                                        if (!this.wroteFieldOrMethod && !"module-info".equals(name)) {
                                            this.classDefinition.writeClass();
                                        }
                                    }
                                }

                                public @Nullable FieldVisitor visitField(int access, String name, String descriptor, String signature, Object value) {
                                    if (this.classDefinition != null) {
                                        this.wroteFieldOrMethod |= this.classDefinition.writeField(access, name, descriptor, signature);
                                    }
                                    return null;
                                }

                                public @Nullable MethodVisitor visitMethod(final int access, final @Nullable String name, final String descriptor, final String signature, final String[] exceptions) {
                                    if (this.classDefinition != null && (0x1002 & access) == 0 && name != null && !"<clinit>".equals(name)) {
                                        return new MethodVisitor(589824){

                                            public void visitParameter(@Nullable String name2, int access2) {
                                                if (name2 != null) {
                                                    collectedParameterNames.add(name2);
                                                }
                                            }

                                            public void visitEnd() {
                                                wroteFieldOrMethod = wroteFieldOrMethod | classDefinition.writeMethod(access, name, descriptor, signature, collectedParameterNames.isEmpty() ? null : collectedParameterNames, exceptions);
                                                collectedParameterNames.clear();
                                            }
                                        };
                                    }
                                    return null;
                                }
                            }, 1);
                        }
                        finally {
                            if (inputStream == null) continue;
                            inputStream.close();
                        }
                    }
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }

            @Generated
            public Jar(String groupId, String artifactId, String version) {
                this.groupId = groupId;
                this.artifactId = artifactId;
                this.version = version;
            }

            @Generated
            public String getGroupId() {
                return this.groupId;
            }

            @Generated
            public String getArtifactId() {
                return this.artifactId;
            }

            @Generated
            public String getVersion() {
                return this.version;
            }

            @Generated
            public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Jar)) {
                    return false;
                }
                Jar other = (Jar)o;
                String this$groupId = this.getGroupId();
                String other$groupId = other.getGroupId();
                if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
                    return false;
                }
                String this$artifactId = this.getArtifactId();
                String other$artifactId = other.getArtifactId();
                if (this$artifactId == null ? other$artifactId != null : !this$artifactId.equals(other$artifactId)) {
                    return false;
                }
                String this$version = this.getVersion();
                String other$version = other.getVersion();
                return !(this$version == null ? other$version != null : !this$version.equals(other$version));
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $groupId = this.getGroupId();
                result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
                String $artifactId = this.getArtifactId();
                result = result * 59 + ($artifactId == null ? 43 : $artifactId.hashCode());
                String $version = this.getVersion();
                result = result * 59 + ($version == null ? 43 : $version.hashCode());
                return result;
            }

            @NonNull
            @Generated
            public String toString() {
                return "TypeTable.Writer.Jar(groupId=" + this.getGroupId() + ", artifactId=" + this.getArtifactId() + ", version=" + this.getVersion() + ")";
            }
        }

        public final class ClassDefinition {
            private final Jar jar;
            private final int classAccess;
            private final String className;
            private final @Nullable String classSignature;
            private final String classSuperclassName;
            private final String @Nullable [] classSuperinterfaceSignatures;

            public void writeClass() {
                if ((0x1002 & this.classAccess) == 0) {
                    Writer.this.out.printf("%s\t%s\t%s\t%d\t%s\t%s\t%s\t%s\t%d\t%s\t%s\t%s\t%s\t%s%n", this.jar.groupId, this.jar.artifactId, this.jar.version, this.classAccess, this.className, this.classSignature == null ? "" : this.classSignature, this.classSuperclassName, this.classSuperinterfaceSignatures == null ? "" : String.join((CharSequence)"|", this.classSuperinterfaceSignatures), -1, "", "", "", "", "");
                }
            }

            public boolean writeMethod(int access, @Nullable String name, String descriptor, @Nullable String signature, @Nullable List<String> parameterNames, String @Nullable [] exceptions) {
                if ((0x1002 & access) == 0 && name != null && !name.equals("<clinit>")) {
                    Writer.this.out.printf("%s\t%s\t%s\t%d\t%s\t%s\t%s\t%s\t%d\t%s\t%s\t%s\t%s\t%s%n", this.jar.groupId, this.jar.artifactId, this.jar.version, this.classAccess, this.className, this.classSignature == null ? "" : this.classSignature, this.classSuperclassName, this.classSuperinterfaceSignatures == null ? "" : String.join((CharSequence)"|", this.classSuperinterfaceSignatures), access, name, descriptor, signature == null ? "" : signature, parameterNames == null ? "" : String.join((CharSequence)"|", parameterNames), exceptions == null ? "" : String.join((CharSequence)"|", exceptions));
                    return true;
                }
                return false;
            }

            public boolean writeField(int access, String name, String descriptor, @Nullable String signature) {
                return this.writeMethod(access, name, descriptor, signature, null, null);
            }

            @Generated
            public ClassDefinition(Jar jar, int classAccess, @Nullable String className, String classSignature, @Nullable String classSuperclassName, String[] classSuperinterfaceSignatures) {
                this.jar = jar;
                this.classAccess = classAccess;
                this.className = className;
                this.classSignature = classSignature;
                this.classSuperclassName = classSuperclassName;
                this.classSuperinterfaceSignatures = classSuperinterfaceSignatures;
            }

            @Generated
            public Jar getJar() {
                return this.jar;
            }

            @Generated
            public int getClassAccess() {
                return this.classAccess;
            }

            @Generated
            public String getClassName() {
                return this.className;
            }

            @Generated
            public @Nullable String getClassSignature() {
                return this.classSignature;
            }

            @Generated
            public String getClassSuperclassName() {
                return this.classSuperclassName;
            }

            @Generated
            public String @Nullable [] getClassSuperinterfaceSignatures() {
                return this.classSuperinterfaceSignatures;
            }

            @Generated
            public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ClassDefinition)) {
                    return false;
                }
                ClassDefinition other = (ClassDefinition)o;
                if (this.getClassAccess() != other.getClassAccess()) {
                    return false;
                }
                Jar this$jar = this.getJar();
                Jar other$jar = other.getJar();
                if (this$jar == null ? other$jar != null : !((Object)this$jar).equals(other$jar)) {
                    return false;
                }
                String this$className = this.getClassName();
                String other$className = other.getClassName();
                if (this$className == null ? other$className != null : !this$className.equals(other$className)) {
                    return false;
                }
                String this$classSignature = this.getClassSignature();
                String other$classSignature = other.getClassSignature();
                if (this$classSignature == null ? other$classSignature != null : !this$classSignature.equals(other$classSignature)) {
                    return false;
                }
                String this$classSuperclassName = this.getClassSuperclassName();
                String other$classSuperclassName = other.getClassSuperclassName();
                if (this$classSuperclassName == null ? other$classSuperclassName != null : !this$classSuperclassName.equals(other$classSuperclassName)) {
                    return false;
                }
                return Arrays.deepEquals(this.getClassSuperinterfaceSignatures(), other.getClassSuperinterfaceSignatures());
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                result = result * 59 + this.getClassAccess();
                Jar $jar = this.getJar();
                result = result * 59 + ($jar == null ? 43 : ((Object)$jar).hashCode());
                String $className = this.getClassName();
                result = result * 59 + ($className == null ? 43 : $className.hashCode());
                String $classSignature = this.getClassSignature();
                result = result * 59 + ($classSignature == null ? 43 : $classSignature.hashCode());
                String $classSuperclassName = this.getClassSuperclassName();
                result = result * 59 + ($classSuperclassName == null ? 43 : $classSuperclassName.hashCode());
                result = result * 59 + Arrays.deepHashCode(this.getClassSuperinterfaceSignatures());
                return result;
            }

            @NonNull
            @Generated
            public String toString() {
                return "TypeTable.Writer.ClassDefinition(jar=" + this.getJar() + ", classAccess=" + this.getClassAccess() + ", className=" + this.getClassName() + ", classSignature=" + this.getClassSignature() + ", classSuperclassName=" + this.getClassSuperclassName() + ", classSuperinterfaceSignatures=" + Arrays.deepToString(this.getClassSuperinterfaceSignatures()) + ")";
            }
        }
    }

    private static final class Member {
        private final ClassDefinition classDefinition;
        private final int access;
        private final String name;
        private final String descriptor;
        private final @Nullable String signature;
        private final String @Nullable [] parameterNames;
        private final String @Nullable [] exceptions;

        @Generated
        public Member(ClassDefinition classDefinition, int access, String name, String descriptor, @Nullable String signature, String @Nullable [] parameterNames, String @Nullable [] exceptions) {
            this.classDefinition = classDefinition;
            this.access = access;
            this.name = name;
            this.descriptor = descriptor;
            this.signature = signature;
            this.parameterNames = parameterNames;
            this.exceptions = exceptions;
        }

        @Generated
        public ClassDefinition getClassDefinition() {
            return this.classDefinition;
        }

        @Generated
        public int getAccess() {
            return this.access;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String getDescriptor() {
            return this.descriptor;
        }

        @Generated
        public @Nullable String getSignature() {
            return this.signature;
        }

        @Generated
        public String @Nullable [] getParameterNames() {
            return this.parameterNames;
        }

        @Generated
        public String @Nullable [] getExceptions() {
            return this.exceptions;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Member)) {
                return false;
            }
            Member other = (Member)o;
            if (this.getAccess() != other.getAccess()) {
                return false;
            }
            ClassDefinition this$classDefinition = this.getClassDefinition();
            ClassDefinition other$classDefinition = other.getClassDefinition();
            if (this$classDefinition == null ? other$classDefinition != null : !((Object)this$classDefinition).equals(other$classDefinition)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$descriptor = this.getDescriptor();
            String other$descriptor = other.getDescriptor();
            if (this$descriptor == null ? other$descriptor != null : !this$descriptor.equals(other$descriptor)) {
                return false;
            }
            String this$signature = this.getSignature();
            String other$signature = other.getSignature();
            if (this$signature == null ? other$signature != null : !this$signature.equals(other$signature)) {
                return false;
            }
            if (!Arrays.deepEquals(this.getParameterNames(), other.getParameterNames())) {
                return false;
            }
            return Arrays.deepEquals(this.getExceptions(), other.getExceptions());
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getAccess();
            ClassDefinition $classDefinition = this.getClassDefinition();
            result = result * 59 + ($classDefinition == null ? 43 : ((Object)$classDefinition).hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $descriptor = this.getDescriptor();
            result = result * 59 + ($descriptor == null ? 43 : $descriptor.hashCode());
            String $signature = this.getSignature();
            result = result * 59 + ($signature == null ? 43 : $signature.hashCode());
            result = result * 59 + Arrays.deepHashCode(this.getParameterNames());
            result = result * 59 + Arrays.deepHashCode(this.getExceptions());
            return result;
        }

        @NonNull
        @Generated
        public String toString() {
            return "TypeTable.Member(classDefinition=" + this.getClassDefinition() + ", access=" + this.getAccess() + ", name=" + this.getName() + ", descriptor=" + this.getDescriptor() + ", signature=" + this.getSignature() + ", parameterNames=" + Arrays.deepToString(this.getParameterNames()) + ", exceptions=" + Arrays.deepToString(this.getExceptions()) + ")";
        }
    }

    private static final class ClassDefinition {
        private final int access;
        private final String name;
        private final @Nullable String signature;
        private final @Nullable String superclassSignature;
        private final String @Nullable [] superinterfaceSignatures;
        private @Nullable List<Member> members;

        public List<Member> getMembers() {
            return this.members != null ? this.members : Collections.emptyList();
        }

        public void addMember(Member member) {
            if (this.members == null) {
                this.members = new ArrayList<Member>();
            }
            this.members.add(member);
        }

        @Generated
        public int getAccess() {
            return this.access;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public @Nullable String getSignature() {
            return this.signature;
        }

        @Generated
        public @Nullable String getSuperclassSignature() {
            return this.superclassSignature;
        }

        @Generated
        public String @Nullable [] getSuperinterfaceSignatures() {
            return this.superinterfaceSignatures;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ClassDefinition)) {
                return false;
            }
            ClassDefinition other = (ClassDefinition)o;
            if (this.getAccess() != other.getAccess()) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$signature = this.getSignature();
            String other$signature = other.getSignature();
            if (this$signature == null ? other$signature != null : !this$signature.equals(other$signature)) {
                return false;
            }
            String this$superclassSignature = this.getSuperclassSignature();
            String other$superclassSignature = other.getSuperclassSignature();
            if (this$superclassSignature == null ? other$superclassSignature != null : !this$superclassSignature.equals(other$superclassSignature)) {
                return false;
            }
            if (!Arrays.deepEquals(this.getSuperinterfaceSignatures(), other.getSuperinterfaceSignatures())) {
                return false;
            }
            List<Member> this$members = this.getMembers();
            List<Member> other$members = other.getMembers();
            return !(this$members == null ? other$members != null : !((Object)this$members).equals(other$members));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getAccess();
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $signature = this.getSignature();
            result = result * 59 + ($signature == null ? 43 : $signature.hashCode());
            String $superclassSignature = this.getSuperclassSignature();
            result = result * 59 + ($superclassSignature == null ? 43 : $superclassSignature.hashCode());
            result = result * 59 + Arrays.deepHashCode(this.getSuperinterfaceSignatures());
            List<Member> $members = this.getMembers();
            result = result * 59 + ($members == null ? 43 : ((Object)$members).hashCode());
            return result;
        }

        @NonNull
        @Generated
        public String toString() {
            return "TypeTable.ClassDefinition(access=" + this.getAccess() + ", name=" + this.getName() + ", signature=" + this.getSignature() + ", superclassSignature=" + this.getSuperclassSignature() + ", superinterfaceSignatures=" + Arrays.deepToString(this.getSuperinterfaceSignatures()) + ")";
        }

        @Generated
        public ClassDefinition(int access, String name, @Nullable String signature, @Nullable String superclassSignature, String @Nullable [] superinterfaceSignatures) {
            this.access = access;
            this.name = name;
            this.signature = signature;
            this.superclassSignature = superclassSignature;
            this.superinterfaceSignatures = superinterfaceSignatures;
        }
    }
}

