/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.tree;

import java.util.Arrays;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Incubating;
import org.openrewrite.java.internal.DefaultJavaTypeSignatureBuilder;
import org.openrewrite.java.tree.Flag;
import org.openrewrite.java.tree.JavaType;

public class TypeUtils {
    private static final JavaType.Class TYPE_OBJECT = JavaType.ShallowClass.build("java.lang.Object");
    private static final Set<String> COMMON_JAVA_LANG_TYPES = new HashSet<String>(Arrays.asList("Appendable", "AutoCloseable", "Boolean", "Byte", "Character", "CharSequence", "Class", "ClassLoader", "Cloneable", "Comparable", "Double", "Enum", "Error", "Exception", "Float", "FunctionalInterface", "Integer", "Iterable", "Long", "Math", "Number", "Object", "Readable", "Record", "Runnable", "Short", "String", "StringBuffer", "StringBuilder", "System", "Thread", "Throwable", "Void"));

    private TypeUtils() {
    }

    public static boolean isObject(@Nullable JavaType type) {
        return type instanceof JavaType.FullyQualified && "java.lang.Object".equals(((JavaType.FullyQualified)type).getFullyQualifiedName());
    }

    public static @Nullable String findQualifiedJavaLangTypeName(String name) {
        return COMMON_JAVA_LANG_TYPES.contains(name) ? "java.lang." + name : null;
    }

    public static boolean isString(@Nullable JavaType type) {
        return type == JavaType.Primitive.String || type instanceof JavaType.Class && "java.lang.String".equals(((JavaType.Class)type).getFullyQualifiedName());
    }

    public static String toFullyQualifiedName(String fqn) {
        return fqn.replace('$', '.');
    }

    public static boolean fullyQualifiedNamesAreEqual(@Nullable String fqn1, @Nullable String fqn2) {
        if (fqn1 != null && fqn2 != null) {
            return fqn1.equals(fqn2) || fqn1.length() == fqn2.length() && TypeUtils.toFullyQualifiedName(fqn1).equals(TypeUtils.toFullyQualifiedName(fqn2));
        }
        return fqn1 == null && fqn2 == null;
    }

    public static boolean isOfType(@Nullable JavaType type1, @Nullable JavaType type2) {
        if (type1 instanceof JavaType.Unknown || type2 instanceof JavaType.Unknown) {
            return false;
        }
        if (type1 == type2) {
            return true;
        }
        if (type1 == null || type2 == null) {
            return false;
        }
        if (TypeUtils.isString(type1) && TypeUtils.isString(type2)) {
            return true;
        }
        if (type1 instanceof JavaType.Primitive && type2 instanceof JavaType.Primitive) {
            return ((JavaType.Primitive)type1).getKeyword().equals(((JavaType.Primitive)type2).getKeyword());
        }
        if (type1 instanceof JavaType.FullyQualified && type2 instanceof JavaType.FullyQualified && TypeUtils.fullyQualifiedNamesAreEqual(((JavaType.FullyQualified)type1).getFullyQualifiedName(), ((JavaType.FullyQualified)type2).getFullyQualifiedName())) {
            if (type1 instanceof JavaType.Class && type2 instanceof JavaType.Class) {
                return true;
            }
            if (type1 instanceof JavaType.Parameterized && type2 instanceof JavaType.Parameterized) {
                DefaultJavaTypeSignatureBuilder signatureBuilder = new DefaultJavaTypeSignatureBuilder();
                return signatureBuilder.signature(type1).equals(signatureBuilder.signature(type2));
            }
            if (type1 instanceof JavaType.Annotation && type2 instanceof JavaType.Annotation) {
                return TypeUtils.isOfType((JavaType.Annotation)type1, (JavaType.Annotation)type2);
            }
        }
        if (type1 instanceof JavaType.Array && type2 instanceof JavaType.Array) {
            return TypeUtils.isOfType(((JavaType.Array)type1).getElemType(), ((JavaType.Array)type2).getElemType());
        }
        if (type1 instanceof JavaType.GenericTypeVariable && type2 instanceof JavaType.GenericTypeVariable) {
            DefaultJavaTypeSignatureBuilder signatureBuilder = new DefaultJavaTypeSignatureBuilder();
            return signatureBuilder.signature(type1).equals(signatureBuilder.signature(type2));
        }
        if (type1 instanceof JavaType.Method && type2 instanceof JavaType.Method) {
            int index;
            JavaType.Method method1 = (JavaType.Method)type1;
            JavaType.Method method2 = (JavaType.Method)type2;
            if (!(method1.getName().equals(method2.getName()) && method1.getFlagsBitMap() == method2.getFlagsBitMap() && TypeUtils.isOfType(method1.getDeclaringType(), method2.getDeclaringType()) && TypeUtils.isOfType(method1.getReturnType(), method2.getReturnType()) && method1.getThrownExceptions().size() == method2.getThrownExceptions().size() && method1.getParameterTypes().size() == method2.getParameterTypes().size())) {
                return false;
            }
            for (index = 0; index < method1.getParameterTypes().size(); ++index) {
                if (TypeUtils.isOfType(method1.getParameterTypes().get(index), method2.getParameterTypes().get(index))) continue;
                return false;
            }
            for (index = 0; index < method1.getThrownExceptions().size(); ++index) {
                if (TypeUtils.isOfType(method1.getThrownExceptions().get(index), method2.getThrownExceptions().get(index))) continue;
                return false;
            }
            return true;
        }
        return type1.equals(type2);
    }

    private static boolean isOfType(JavaType.Annotation annotation1, JavaType.Annotation annotation2) {
        if (!TypeUtils.isOfType(annotation1.getType(), annotation2.getType())) {
            return false;
        }
        List<JavaType.Annotation.ElementValue> values1 = annotation1.getValues();
        List<JavaType.Annotation.ElementValue> values2 = annotation2.getValues();
        if (values1.size() != values2.size()) {
            return false;
        }
        for (int i = 0; i < values1.size(); ++i) {
            if (TypeUtils.isOfType(values1.get(i), values2.get(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean isOfType(JavaType.Annotation.ElementValue value1, JavaType.Annotation.ElementValue value2) {
        if (!TypeUtils.isOfType(value1.getElement(), value2.getElement())) {
            return false;
        }
        if (value1 instanceof JavaType.Annotation.SingleElementValue) {
            JavaType.Annotation.SingleElementValue singleValue1 = (JavaType.Annotation.SingleElementValue)value1;
            if (value2 instanceof JavaType.Annotation.SingleElementValue) {
                JavaType.Annotation.SingleElementValue singleValue2 = (JavaType.Annotation.SingleElementValue)value2;
                return TypeUtils.isOfType(singleValue1.getReferenceValue(), singleValue2.getReferenceValue()) && Objects.equals(singleValue1.getConstantValue(), singleValue2.getConstantValue());
            }
            JavaType.Annotation.ArrayElementValue arrayValue2 = (JavaType.Annotation.ArrayElementValue)value2;
            return arrayValue2.getReferenceValues() != null && arrayValue2.getReferenceValues().length == 1 && TypeUtils.isOfType(singleValue1.getReferenceValue(), arrayValue2.getReferenceValues()[0]) || arrayValue2.getConstantValues() != null && arrayValue2.getConstantValues().length == 1 && Objects.equals(singleValue1.getConstantValue(), arrayValue2.getConstantValues()[0]);
        }
        if (value2 instanceof JavaType.Annotation.ArrayElementValue) {
            JavaType.Annotation.ArrayElementValue arrayValue1 = (JavaType.Annotation.ArrayElementValue)value1;
            JavaType.Annotation.ArrayElementValue arrayValue2 = (JavaType.Annotation.ArrayElementValue)value2;
            if (arrayValue1.getConstantValues() != null) {
                Object[] constantValues1 = arrayValue1.getConstantValues();
                if (arrayValue2.getConstantValues() == null || arrayValue2.getConstantValues().length != constantValues1.length) {
                    return false;
                }
                for (int i = 0; i < constantValues1.length; ++i) {
                    if (Objects.equals(constantValues1[i], arrayValue2.getConstantValues()[i])) continue;
                    return false;
                }
                return true;
            }
            if (arrayValue1.getReferenceValues() != null) {
                JavaType[] referenceValues1 = arrayValue1.getReferenceValues();
                if (arrayValue2.getReferenceValues() == null || arrayValue2.getReferenceValues().length != referenceValues1.length) {
                    return false;
                }
                for (int i = 0; i < referenceValues1.length; ++i) {
                    if (TypeUtils.isOfType(referenceValues1[i], arrayValue2.getReferenceValues()[i])) continue;
                    return false;
                }
                return true;
            }
        } else {
            return TypeUtils.isOfType(value2, value1);
        }
        return false;
    }

    public static boolean isOfClassType(@Nullable JavaType type, String fqn) {
        if (type instanceof JavaType.FullyQualified) {
            return TypeUtils.fullyQualifiedNamesAreEqual(((JavaType.FullyQualified)type).getFullyQualifiedName(), fqn);
        }
        if (type instanceof JavaType.Variable) {
            return TypeUtils.isOfClassType(((JavaType.Variable)type).getType(), fqn);
        }
        if (type instanceof JavaType.Method) {
            return TypeUtils.isOfClassType(((JavaType.Method)type).getReturnType(), fqn);
        }
        if (type instanceof JavaType.Array) {
            return TypeUtils.isOfClassType(((JavaType.Array)type).getElemType(), fqn);
        }
        if (type instanceof JavaType.Primitive) {
            return type == JavaType.Primitive.fromKeyword(fqn);
        }
        return false;
    }

    @Incubating(since="8.1.4")
    public static boolean isOfTypeWithName(@Nullable JavaType.FullyQualified type, boolean matchOverride, Predicate<String> matcher) {
        if (type == null || type instanceof JavaType.Unknown) {
            return false;
        }
        if (matcher.test(type.getFullyQualifiedName())) {
            return true;
        }
        if (matchOverride) {
            if (!"java.lang.Object".equals(type.getFullyQualifiedName()) && TypeUtils.isOfTypeWithName(TYPE_OBJECT, true, matcher)) {
                return true;
            }
            if (TypeUtils.isOfTypeWithName(type.getSupertype(), true, matcher)) {
                return true;
            }
            for (JavaType.FullyQualified anInterface : type.getInterfaces()) {
                if (!TypeUtils.isOfTypeWithName(anInterface, true, matcher)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isAssignableTo(@Nullable JavaType to, @Nullable JavaType from) {
        return TypeUtils.isAssignableTo(to, from, TypePosition.Invariant);
    }

    public static boolean isAssignableTo(@Nullable JavaType to, @Nullable JavaType from, TypePosition position) {
        try {
            if (to instanceof JavaType.Unknown || from instanceof JavaType.Unknown) {
                return false;
            }
            if (to == from) {
                return true;
            }
            if (to instanceof JavaType.Parameterized) {
                JavaType.Parameterized toParameterized = (JavaType.Parameterized)to;
                if (!(from instanceof JavaType.Parameterized)) {
                    for (JavaType typeParameter : toParameterized.getTypeParameters()) {
                        if (typeParameter instanceof JavaType.GenericTypeVariable && ((JavaType.GenericTypeVariable)typeParameter).getName().equals("?")) continue;
                        return false;
                    }
                    return TypeUtils.isAssignableTo(toParameterized.getType(), from);
                }
                JavaType.Parameterized fromParameterized = (JavaType.Parameterized)from;
                List<JavaType> toParameters = toParameterized.getTypeParameters();
                List<JavaType> fromParameters = fromParameterized.getTypeParameters();
                if (toParameters.size() != fromParameters.size() || !TypeUtils.isAssignableTo(toParameterized.getType(), fromParameterized.getType(), position)) {
                    return false;
                }
                for (int i = 0; i < toParameters.size(); ++i) {
                    JavaType.GenericTypeVariable toGeneric;
                    JavaType toParam = toParameters.get(i);
                    JavaType fromParam = fromParameters.get(i);
                    if (toParam instanceof JavaType.GenericTypeVariable && (toGeneric = (JavaType.GenericTypeVariable)toParam).getName().equals("?")) {
                        if (fromParam instanceof JavaType.GenericTypeVariable && ((JavaType.GenericTypeVariable)fromParam).getName().equals("?")) {
                            if (toGeneric.getBounds().isEmpty() && ((JavaType.GenericTypeVariable)fromParam).getBounds().isEmpty()) continue;
                            return TypeUtils.areWildcardBoundsCompatible(toGeneric, (JavaType.GenericTypeVariable)fromParam, position);
                        }
                        if (toGeneric.getBounds().isEmpty()) {
                            return true;
                        }
                        TypePosition wildcardPosition = TypeUtils.convertVarianceToPosition(toGeneric.getVariance());
                        for (JavaType bound : toGeneric.getBounds()) {
                            if (TypeUtils.isAssignableTo(bound, fromParam, wildcardPosition)) continue;
                            return false;
                        }
                        return true;
                    }
                    if (TypeUtils.isOfType(toParam, fromParam)) continue;
                    return false;
                }
                return true;
            }
            if (to instanceof JavaType.GenericTypeVariable) {
                JavaType.GenericTypeVariable toGeneric = (JavaType.GenericTypeVariable)to;
                switch (position) {
                    case In: {
                        for (JavaType bound : toGeneric.getBounds()) {
                            if (!TypeUtils.isAssignableTo(from, bound, TypePosition.Invariant)) continue;
                            return true;
                        }
                        return false;
                    }
                    case Out: {
                        for (JavaType bound : toGeneric.getBounds()) {
                            if (TypeUtils.isAssignableTo(bound, from, TypePosition.Invariant)) continue;
                            return false;
                        }
                        return true;
                    }
                    case Invariant: {
                        if (from instanceof JavaType.GenericTypeVariable) {
                            return toGeneric.getName().equals(((JavaType.GenericTypeVariable)from).getName());
                        }
                        return false;
                    }
                }
            } else {
                if (to instanceof JavaType.FullyQualified) {
                    JavaType.FullyQualified toFq = (JavaType.FullyQualified)to;
                    if (from instanceof JavaType.Primitive) {
                        JavaType.Primitive toPrimitive = JavaType.Primitive.fromClassName(toFq.getFullyQualifiedName());
                        if (toPrimitive != null) {
                            return TypeUtils.isAssignableTo(toPrimitive, from, position);
                        }
                        if (TypeUtils.isObject(toFq)) {
                            return true;
                        }
                    } else if (from instanceof JavaType.Intersection) {
                        for (JavaType intersectionType : ((JavaType.Intersection)from).getBounds()) {
                            if (!TypeUtils.isAssignableTo(to, intersectionType, position)) continue;
                            return true;
                        }
                        return false;
                    }
                    return !(from instanceof JavaType.GenericTypeVariable) && TypeUtils.isAssignableTo(toFq.getFullyQualifiedName(), from);
                }
                if (to instanceof JavaType.Variable) {
                    return TypeUtils.isAssignableTo(((JavaType.Variable)to).getType(), from, position);
                }
                if (to instanceof JavaType.Method) {
                    return TypeUtils.isAssignableTo(((JavaType.Method)to).getReturnType(), from, position);
                }
                if (to instanceof JavaType.Array && from instanceof JavaType.Array) {
                    JavaType.Array toArray = (JavaType.Array)to;
                    JavaType.Array fromArray = (JavaType.Array)from;
                    if (toArray.getElemType() instanceof JavaType.Primitive) {
                        return TypeUtils.isOfType(toArray.getElemType(), fromArray.getElemType());
                    }
                    return TypeUtils.isAssignableTo(toArray.getElemType(), fromArray.getElemType(), TypePosition.Invariant);
                }
                if (to instanceof JavaType.Primitive) {
                    return TypeUtils.handlePrimitiveAssignability((JavaType.Primitive)to, from);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private static boolean areWildcardBoundsCompatible(JavaType.GenericTypeVariable to, JavaType.GenericTypeVariable from, TypePosition position) {
        if (to.getBounds().isEmpty() && from.getBounds().isEmpty()) {
            return true;
        }
        if (to.getBounds().isEmpty()) {
            return false;
        }
        if (from.getBounds().isEmpty()) {
            return false;
        }
        switch (position) {
            case Out: {
                for (JavaType bound : to.getBounds()) {
                    if (TypeUtils.isAssignableTo(bound, from.getBounds().get(0), TypePosition.Invariant)) continue;
                    return false;
                }
                return true;
            }
            case In: {
                for (JavaType bound : from.getBounds()) {
                    if (TypeUtils.isAssignableTo(bound, to.getBounds().get(0), TypePosition.Invariant)) continue;
                    return false;
                }
                return true;
            }
            case Invariant: {
                return to.getBounds().equals(from.getBounds());
            }
        }
        return false;
    }

    private static TypePosition convertVarianceToPosition(JavaType.GenericTypeVariable.Variance variance) {
        switch (variance) {
            case COVARIANT: {
                return TypePosition.Out;
            }
            case CONTRAVARIANT: {
                return TypePosition.In;
            }
        }
        return TypePosition.Invariant;
    }

    private static boolean handlePrimitiveAssignability(JavaType.Primitive to, @Nullable JavaType from) {
        if (from instanceof JavaType.FullyQualified) {
            JavaType.ShallowClass boxed = JavaType.ShallowClass.build(to.getClassName());
            return TypeUtils.isAssignableTo(boxed, from);
        }
        if (from instanceof JavaType.Primitive) {
            JavaType.Primitive fromPrimitive = (JavaType.Primitive)from;
            switch (fromPrimitive) {
                case Boolean: 
                case Void: 
                case None: 
                case Null: 
                case String: {
                    return false;
                }
            }
            switch (to) {
                case Char: {
                    return false;
                }
                case Short: {
                    switch (fromPrimitive) {
                        case Byte: 
                        case Char: {
                            return true;
                        }
                    }
                    return false;
                }
                case Int: {
                    switch (fromPrimitive) {
                        case Byte: 
                        case Char: 
                        case Short: {
                            return true;
                        }
                    }
                    return false;
                }
                case Long: {
                    switch (fromPrimitive) {
                        case Byte: 
                        case Char: 
                        case Short: 
                        case Int: {
                            return true;
                        }
                    }
                    return false;
                }
                case Float: {
                    return fromPrimitive != JavaType.Primitive.Double;
                }
                case Double: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public static boolean isAssignableTo(String to, @Nullable JavaType from) {
        try {
            if (from instanceof JavaType.FullyQualified) {
                if (from instanceof JavaType.Parameterized && to.equals(from.toString())) {
                    return true;
                }
                JavaType.FullyQualified classFrom = (JavaType.FullyQualified)from;
                if (TypeUtils.fullyQualifiedNamesAreEqual(to, classFrom.getFullyQualifiedName()) || TypeUtils.isAssignableTo(to, (JavaType)classFrom.getSupertype())) {
                    return true;
                }
                for (JavaType.FullyQualified i : classFrom.getInterfaces()) {
                    if (!TypeUtils.isAssignableTo(to, (JavaType)i)) continue;
                    return true;
                }
                return false;
            }
            if (from instanceof JavaType.GenericTypeVariable) {
                JavaType.GenericTypeVariable genericFrom = (JavaType.GenericTypeVariable)from;
                for (JavaType bound : genericFrom.getBounds()) {
                    if (!TypeUtils.isAssignableTo(to, bound)) continue;
                    return true;
                }
            } else if (from instanceof JavaType.Primitive) {
                JavaType.Primitive toPrimitive = JavaType.Primitive.fromKeyword(to);
                if (toPrimitive != null) {
                    return TypeUtils.isAssignableTo(toPrimitive, from);
                }
                if ("java.lang.String".equals(to)) {
                    return TypeUtils.isAssignableTo(JavaType.Primitive.String, from);
                }
            } else {
                if (from instanceof JavaType.Variable) {
                    return TypeUtils.isAssignableTo(to, ((JavaType.Variable)from).getType());
                }
                if (from instanceof JavaType.Method) {
                    return TypeUtils.isAssignableTo(to, ((JavaType.Method)from).getReturnType());
                }
                if (from instanceof JavaType.Intersection) {
                    for (JavaType bound : ((JavaType.Intersection)from).getBounds()) {
                        if (!TypeUtils.isAssignableTo(to, bound)) continue;
                        return true;
                    }
                }
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    public static boolean isAssignableTo(Pattern to, @Nullable JavaType from) {
        return TypeUtils.isAssignableTo((JavaType type) -> {
            if (type instanceof JavaType.FullyQualified) {
                return to.matcher(((JavaType.FullyQualified)type).getFullyQualifiedName()).matches();
            }
            if (type instanceof JavaType.Primitive) {
                return to.matcher(((JavaType.Primitive)type).getKeyword()).matches();
            }
            return false;
        }, from);
    }

    public static boolean isAssignableTo(Predicate<JavaType> predicate, @Nullable JavaType from) {
        try {
            if (from instanceof JavaType.FullyQualified) {
                JavaType.FullyQualified classFrom = (JavaType.FullyQualified)from;
                if (predicate.test(classFrom) || TypeUtils.isAssignableTo(predicate, (JavaType)classFrom.getSupertype())) {
                    return true;
                }
                for (JavaType.FullyQualified anInterface : classFrom.getInterfaces()) {
                    if (!TypeUtils.isAssignableTo(predicate, (JavaType)anInterface)) continue;
                    return true;
                }
                return false;
            }
            if (from instanceof JavaType.GenericTypeVariable) {
                JavaType.GenericTypeVariable genericFrom = (JavaType.GenericTypeVariable)from;
                for (JavaType bound : genericFrom.getBounds()) {
                    if (!TypeUtils.isAssignableTo(predicate, bound)) continue;
                    return true;
                }
            } else {
                if (from instanceof JavaType.Variable) {
                    return TypeUtils.isAssignableTo(predicate, ((JavaType.Variable)from).getType());
                }
                if (from instanceof JavaType.Method) {
                    return TypeUtils.isAssignableTo(predicate, ((JavaType.Method)from).getReturnType());
                }
                if (from instanceof JavaType.Primitive) {
                    JavaType.Primitive primitive = (JavaType.Primitive)from;
                    return predicate.test(primitive);
                }
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    public static @Nullable JavaType.Class asClass(@Nullable JavaType type) {
        return type instanceof JavaType.Class ? (JavaType.Class)type : null;
    }

    public static @Nullable JavaType.Parameterized asParameterized(@Nullable JavaType type) {
        return type instanceof JavaType.Parameterized ? (JavaType.Parameterized)type : null;
    }

    public static @Nullable JavaType.Array asArray(@Nullable JavaType type) {
        return type instanceof JavaType.Array ? (JavaType.Array)type : null;
    }

    public static @Nullable JavaType.GenericTypeVariable asGeneric(@Nullable JavaType type) {
        return type instanceof JavaType.GenericTypeVariable ? (JavaType.GenericTypeVariable)type : null;
    }

    public static @Nullable JavaType.Primitive asPrimitive(@Nullable JavaType type) {
        return type instanceof JavaType.Primitive ? (JavaType.Primitive)type : null;
    }

    public static @Nullable JavaType.FullyQualified asFullyQualified(@Nullable JavaType type) {
        if (type instanceof JavaType.FullyQualified && !(type instanceof JavaType.Unknown)) {
            return (JavaType.FullyQualified)type;
        }
        return null;
    }

    public static boolean isOverride(@Nullable JavaType.Method method) {
        return TypeUtils.findOverriddenMethod(method).isPresent();
    }

    public static Optional<JavaType.Method> findOverriddenMethod(@Nullable JavaType.Method method) {
        Optional<JavaType.Method> methodResult;
        JavaType.FullyQualified dt;
        block2: {
            JavaType.FullyQualified i;
            if (method == null) {
                return Optional.empty();
            }
            dt = method.getDeclaringType();
            List<JavaType> argTypes = method.getParameterTypes();
            methodResult = TypeUtils.findDeclaredMethod(dt.getSupertype(), method.getName(), argTypes);
            if (methodResult.isPresent()) break block2;
            Iterator<JavaType.FullyQualified> iterator = dt.getInterfaces().iterator();
            while (iterator.hasNext() && !(methodResult = TypeUtils.findDeclaredMethod(i = iterator.next(), method.getName(), argTypes)).isPresent()) {
            }
        }
        return methodResult.filter(m -> !m.getFlags().contains((Object)Flag.Private)).filter(m -> !m.getFlags().contains((Object)Flag.Static)).filter(m -> m.getFlags().contains((Object)Flag.Public) || m.getDeclaringType().getPackageName().equals(dt.getPackageName()));
    }

    public static Optional<JavaType.Method> findDeclaredMethod(@Nullable JavaType.FullyQualified clazz, String name, List<JavaType> argumentTypes) {
        if (clazz == null) {
            return Optional.empty();
        }
        for (JavaType.Method method : clazz.getMethods()) {
            if (!TypeUtils.methodHasSignature(clazz, method, name, argumentTypes)) continue;
            return Optional.of(method);
        }
        Optional<JavaType.Method> methodResult = TypeUtils.findDeclaredMethod(clazz.getSupertype(), name, argumentTypes);
        if (methodResult.isPresent()) {
            return methodResult;
        }
        for (JavaType.FullyQualified i : clazz.getInterfaces()) {
            methodResult = TypeUtils.findDeclaredMethod(i, name, argumentTypes);
            if (!methodResult.isPresent()) continue;
            return methodResult;
        }
        return Optional.empty();
    }

    private static boolean methodHasSignature(JavaType.FullyQualified clazz, JavaType.Method m, String name, List<JavaType> argTypes) {
        if (!name.equals(m.getName())) {
            return false;
        }
        List<JavaType> mArgs = m.getParameterTypes();
        if (mArgs.size() != argTypes.size()) {
            return false;
        }
        IdentityHashMap<JavaType, JavaType> parameterMap = new IdentityHashMap<JavaType, JavaType>();
        List<JavaType> declaringTypeParams = m.getDeclaringType().getTypeParameters();
        List<JavaType> typeParameters = clazz.getTypeParameters();
        if (typeParameters.size() != declaringTypeParams.size()) {
            return false;
        }
        for (int j = 0; j < typeParameters.size(); ++j) {
            JavaType typeAttributed = typeParameters.get(j);
            JavaType generic = declaringTypeParams.get(j);
            parameterMap.put(generic, typeAttributed);
        }
        for (int i = 0; i < mArgs.size(); ++i) {
            JavaType actual;
            JavaType declared = mArgs.get(i);
            if (TypeUtils.isOfType(declared, actual = argTypes.get(i)) || parameterMap.get(declared) == actual) continue;
            return false;
        }
        return true;
    }

    public static boolean isWellFormedType(@Nullable JavaType type) {
        return TypeUtils.isWellFormedType(type, new HashSet<JavaType>());
    }

    public static boolean isWellFormedType(@Nullable JavaType type, Set<JavaType> seen) {
        if (type == null || type instanceof JavaType.Unknown) {
            return false;
        }
        return TypeUtils.isWellFormedType0(type, seen);
    }

    private static boolean isWellFormedType0(JavaType type, Set<JavaType> seen) {
        if (!seen.add(type)) {
            return true;
        }
        if (type instanceof JavaType.Parameterized) {
            JavaType.Parameterized parameterized = (JavaType.Parameterized)type;
            return TypeUtils.isWellFormedType(parameterized.getType(), seen) && parameterized.getTypeParameters().stream().allMatch(it -> TypeUtils.isWellFormedType(it, seen));
        }
        if (type instanceof JavaType.Array) {
            JavaType.Array arr = (JavaType.Array)type;
            return TypeUtils.isWellFormedType(arr.getElemType(), seen);
        }
        if (type instanceof JavaType.GenericTypeVariable) {
            JavaType.GenericTypeVariable gen = (JavaType.GenericTypeVariable)type;
            return gen.getBounds().stream().allMatch(it -> TypeUtils.isWellFormedType(it, seen));
        }
        if (type instanceof JavaType.Variable) {
            JavaType.Variable var = (JavaType.Variable)type;
            return TypeUtils.isWellFormedType(var.getType(), seen) && TypeUtils.isWellFormedType(var.getOwner(), seen);
        }
        if (type instanceof JavaType.MultiCatch) {
            JavaType.MultiCatch mc = (JavaType.MultiCatch)type;
            return mc.getThrowableTypes().stream().allMatch(it -> TypeUtils.isWellFormedType(it, seen));
        }
        if (type instanceof JavaType.Method) {
            JavaType.Method m = (JavaType.Method)type;
            return TypeUtils.isWellFormedType(m.getReturnType(), seen) && TypeUtils.isWellFormedType(m.getDeclaringType(), seen) && m.getParameterTypes().stream().allMatch(it -> TypeUtils.isWellFormedType(it, seen));
        }
        return true;
    }

    public static JavaType.FullyQualified unknownIfNull(@Nullable JavaType.FullyQualified t) {
        if (t == null) {
            return JavaType.Unknown.getInstance();
        }
        return t;
    }

    public static JavaType unknownIfNull(@Nullable JavaType t) {
        if (t == null) {
            return JavaType.Unknown.getInstance();
        }
        return t;
    }

    static boolean deepEquals(@Nullable List<? extends JavaType> ts1, @Nullable List<? extends JavaType> ts2) {
        if (ts1 == null || ts2 == null) {
            return ts1 == null && ts2 == null;
        }
        if (ts1.size() != ts2.size()) {
            return false;
        }
        for (int i = 0; i < ts1.size(); ++i) {
            JavaType t1 = ts1.get(i);
            JavaType t2 = ts2.get(i);
            if (!(t1 == null ? t2 != null : !TypeUtils.deepEquals(t1, t2))) continue;
            return false;
        }
        return true;
    }

    static boolean deepEquals(@Nullable JavaType t, @Nullable JavaType t2) {
        return t == null ? t2 == null : t == t2 || t.equals(t2);
    }

    public static String toString(JavaType type) {
        if (type instanceof JavaType.Primitive) {
            return ((JavaType.Primitive)type).getKeyword();
        }
        if (type instanceof JavaType.Class) {
            return ((JavaType.Class)type).getFullyQualifiedName();
        }
        if (type instanceof JavaType.Parameterized) {
            JavaType.Parameterized parameterized = (JavaType.Parameterized)type;
            String base = TypeUtils.toString(parameterized.getType());
            StringJoiner joiner = new StringJoiner(", ", "<", ">");
            for (JavaType parameter : parameterized.getTypeParameters()) {
                joiner.add(TypeUtils.toString(parameter));
            }
            return base + joiner;
        }
        if (type instanceof JavaType.GenericTypeVariable) {
            JavaType.GenericTypeVariable genericType = (JavaType.GenericTypeVariable)type;
            if (!genericType.getName().equals("?")) {
                return genericType.getName();
            }
            if (genericType.getVariance() == JavaType.GenericTypeVariable.Variance.INVARIANT || genericType.getBounds().size() != 1) {
                return "?";
            }
            String variance = genericType.getVariance() == JavaType.GenericTypeVariable.Variance.COVARIANT ? "? extends " : "? super ";
            return variance + TypeUtils.toString(genericType.getBounds().get(0));
        }
        if (type instanceof JavaType.Array) {
            return TypeUtils.toString(((JavaType.Array)type).getElemType()) + "[]";
        }
        return type.toString();
    }

    public static String toGenericTypeString(JavaType.GenericTypeVariable type) {
        if (type.getVariance() != JavaType.GenericTypeVariable.Variance.COVARIANT || type.getBounds().isEmpty()) {
            return type.getName();
        }
        StringJoiner bounds = new StringJoiner(" & ");
        for (JavaType bound : type.getBounds()) {
            bounds.add(TypeUtils.toString(bound));
        }
        return type.getName() + " extends " + bounds;
    }

    public static enum TypePosition {
        In,
        Out,
        Invariant;

    }
}

