/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.tree;

import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.openrewrite.internal.lang.Nullable;

public enum Flag {
    Public(1L),
    Private(2L),
    Protected(4L),
    Static(8L),
    Final(16L),
    Synchronized(32L),
    Volatile(64L),
    Transient(128L),
    Native(256L),
    Interface(512L),
    Abstract(1024L),
    Strictfp(2048L),
    HasInit(262144L),
    Varargs(0x400000000L),
    Union(0x8000000000L),
    Default(0x80000000000L),
    SignaturePolymorphic(0x400000000000L),
    PotentiallyAmbiguous(0x1000000000000L),
    Sealed(0x4000000000000000L),
    NonSealed(Long.MIN_VALUE);

    private final long bitMask;
    public static final long VALID_CLASS_FLAGS;
    public static final long VALID_FLAGS;
    private static final Map<Long, Set<Flag>> flagSets;

    private Flag(long bitMask) {
        this.bitMask = bitMask;
    }

    public long getBitMask() {
        return this.bitMask;
    }

    public static Set<Flag> bitMapToFlags(long flagsBitMap) {
        Set<Flag> flags = flagSets.get(flagsBitMap);
        if (flags == null) {
            flags = EnumSet.noneOf(Flag.class);
            for (Flag flag : Flag.values()) {
                if ((flagsBitMap & flag.bitMask) == 0L) continue;
                flags.add(flag);
            }
            flags = Collections.unmodifiableSet(flags);
            flagSets.put(flagsBitMap, flags);
        }
        return flags;
    }

    public static long flagsToBitMap(@Nullable Set<Flag> flags) {
        long mask = 0L;
        if (flags != null) {
            for (Flag flag : flags) {
                mask |= flag.bitMask;
            }
        }
        return mask;
    }

    public static boolean hasFlags(long flagsBitMap, Flag ... flags) {
        for (Flag flag : flags) {
            if ((flag.bitMask & flagsBitMap) != 0L) continue;
            return false;
        }
        return true;
    }

    static {
        VALID_CLASS_FLAGS = Stream.of(Public, Private, Protected, Static, Final, Interface, Abstract, Strictfp).map(Flag::getBitMask).reduce(0L, (m1, m2) -> m1 | m2);
        VALID_FLAGS = Arrays.stream(Flag.values()).map(Flag::getBitMask).reduce(0L, (m1, m2) -> m1 | m2);
        flagSets = new HashMap<Long, Set<Flag>>(64);
    }
}

