/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.search;

import java.util.Objects;
import java.util.Optional;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Tree;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.marker.JavaVersion;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.marker.SearchResult;

public class UsesJavaVersion<P>
extends JavaIsoVisitor<P> {
    int majorVersionMin;
    int majorVersionMax;

    public UsesJavaVersion(int majorVersion) {
        this.majorVersionMin = majorVersion;
        this.majorVersionMax = Integer.MAX_VALUE;
    }

    public UsesJavaVersion(int majorVersionMin, int majorVersionMax) {
        this.majorVersionMin = majorVersionMin;
        this.majorVersionMax = majorVersionMax;
    }

    public J visit(@Nullable Tree tree, P p) {
        JavaSourceFile cu;
        Optional javaVersion;
        if (tree instanceof JavaSourceFile && (javaVersion = (cu = (JavaSourceFile)Objects.requireNonNull(tree)).getMarkers().findFirst(JavaVersion.class)).isPresent() && this.isVersionInRange(((JavaVersion)javaVersion.get()).getMajorVersion())) {
            return (J)SearchResult.found((Tree)cu);
        }
        return (J)tree;
    }

    private boolean isVersionInRange(int majorVersion) {
        return this.majorVersionMin > 0 && this.majorVersionMin <= majorVersion && majorVersion <= this.majorVersionMax;
    }
}

