/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.openrewrite.Cursor;
import org.openrewrite.Incubating;
import org.openrewrite.java.AnnotationMatcher;
import org.openrewrite.java.tree.J;

@Incubating(since="8.12.0")
public class AnnotationService {
    public boolean matches(Cursor cursor, AnnotationMatcher matcher) {
        for (J.Annotation annotation : this.getAllAnnotations(cursor)) {
            if (!matcher.matches(annotation)) continue;
            return true;
        }
        return false;
    }

    public List<J.Annotation> getAllAnnotations(Cursor cursor) {
        J j = (J)cursor.getValue();
        if (j instanceof J.VariableDeclarations) {
            return this.getAllAnnotations((J.VariableDeclarations)j);
        }
        if (j instanceof J.MethodDeclaration) {
            return ((J.MethodDeclaration)j).getAllAnnotations();
        }
        if (j instanceof J.ClassDeclaration) {
            return ((J.ClassDeclaration)j).getAllAnnotations();
        }
        if (j instanceof J.TypeParameter) {
            return ((J.TypeParameter)j).getAnnotations();
        }
        if (j instanceof J.TypeParameters) {
            return ((J.TypeParameters)j).getAnnotations();
        }
        if (j instanceof J.Package) {
            return ((J.Package)j).getAnnotations();
        }
        if (j instanceof J.AnnotatedType) {
            return this.getAllAnnotations((J.AnnotatedType)j);
        }
        if (j instanceof J.ArrayType) {
            return this.getAllAnnotations((J.ArrayType)j);
        }
        if (j instanceof J.FieldAccess) {
            return this.getAllAnnotations((J.FieldAccess)j);
        }
        if (j instanceof J.Identifier) {
            return this.getAllAnnotations((J.Identifier)j);
        }
        return Collections.emptyList();
    }

    private List<J.Annotation> getAllAnnotations(J j) {
        if (j instanceof J.AnnotatedType) {
            return this.getAllAnnotations((J.AnnotatedType)j);
        }
        if (j instanceof J.ArrayType) {
            return this.getAllAnnotations((J.ArrayType)j);
        }
        if (j instanceof J.Identifier) {
            return this.getAllAnnotations((J.Identifier)j);
        }
        if (j instanceof J.FieldAccess) {
            return this.getAllAnnotations((J.FieldAccess)j);
        }
        if (j instanceof J.VariableDeclarations) {
            return this.getAllAnnotations((J.VariableDeclarations)j);
        }
        return Collections.emptyList();
    }

    private List<J.Annotation> getAllAnnotations(J.VariableDeclarations variableDeclarations) {
        ArrayList<J.Annotation> allAnnotations = new ArrayList<J.Annotation>(variableDeclarations.getLeadingAnnotations());
        for (J.Modifier modifier : variableDeclarations.getModifiers()) {
            allAnnotations.addAll(modifier.getAnnotations());
        }
        if (variableDeclarations.getTypeExpression() instanceof J.AnnotatedType) {
            allAnnotations.addAll(this.getAllAnnotations((J.AnnotatedType)variableDeclarations.getTypeExpression()));
        }
        return allAnnotations;
    }

    private List<J.Annotation> getAllAnnotations(J.AnnotatedType annotatedType) {
        List<J.Annotation> targetAnnotations = this.getAllAnnotations(annotatedType.getTypeExpression());
        if (targetAnnotations.isEmpty()) {
            return annotatedType.getAnnotations();
        }
        ArrayList<J.Annotation> annotations = new ArrayList<J.Annotation>(annotatedType.getAnnotations().size() + targetAnnotations.size());
        annotations.addAll(annotatedType.getAnnotations());
        annotations.addAll(targetAnnotations);
        return annotations;
    }

    private List<J.Annotation> getAllAnnotations(J.ArrayType arrayType) {
        if (arrayType.getAnnotations() != null) {
            return arrayType.getAnnotations();
        }
        return Collections.emptyList();
    }

    private List<J.Annotation> getAllAnnotations(J.FieldAccess fieldAccess) {
        return this.getAllAnnotations(fieldAccess.getName());
    }

    private List<J.Annotation> getAllAnnotations(J.Identifier identifier) {
        return identifier.getAnnotations();
    }
}

