/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.search;

import java.util.HashSet;
import java.util.Set;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.TypeMatcher;
import org.openrewrite.java.search.UsesField;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.marker.SearchResult;

public final class FindFields
extends Recipe {
    @Option(displayName="Fully-qualified type name", description="A fully-qualified Java type name, that is used to find matching fields.", example="com.fasterxml.jackson.core.json.JsonWriteFeature")
    private final String fullyQualifiedTypeName;
    @Option(displayName="Match inherited", description="When enabled, find types that inherit from a deprecated type.", required=false)
    private final @Nullable Boolean matchInherited;
    @Option(displayName="Field name", description="The name of a field on the type.", example="QUOTE_FIELD_NAMES")
    private final String fieldName;

    public String getDisplayName() {
        return "Find fields";
    }

    public String getInstanceNameSuffix() {
        return "on types `" + this.fullyQualifiedTypeName + "`";
    }

    public String getDescription() {
        return "Find uses of a field.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check(new UsesField(this.fullyQualifiedTypeName, this.fieldName), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            @Override
            public J.FieldAccess visitFieldAccess(J.FieldAccess fieldAccess, ExecutionContext ctx) {
                JavaType.Variable varType = fieldAccess.getName().getFieldType();
                if (varType != null && new TypeMatcher(FindFields.this.fullyQualifiedTypeName, Boolean.TRUE.equals(FindFields.this.matchInherited)).matches(varType.getOwner()) && StringUtils.matchesGlob((String)varType.getName(), (String)FindFields.this.fieldName)) {
                    return (J.FieldAccess)SearchResult.found((Tree)fieldAccess);
                }
                return super.visitFieldAccess(fieldAccess, ctx);
            }

            @Override
            public J.Identifier visitIdentifier(J.Identifier identifier, ExecutionContext ctx) {
                J i = super.visitIdentifier(identifier, ctx);
                JavaType.Variable varType = identifier.getFieldType();
                if (varType != null && new TypeMatcher(FindFields.this.fullyQualifiedTypeName, Boolean.TRUE.equals(FindFields.this.matchInherited)).matches(varType.getOwner()) && StringUtils.matchesGlob((String)varType.getName(), (String)FindFields.this.fieldName)) {
                    i = (J.Identifier)SearchResult.found((Tree)i);
                }
                return i;
            }

            @Override
            public J.MemberReference visitMemberReference(J.MemberReference memberRef, ExecutionContext ctx) {
                J m = super.visitMemberReference(memberRef, ctx);
                JavaType.Variable varType = memberRef.getVariableType();
                if (varType != null && new TypeMatcher(FindFields.this.fullyQualifiedTypeName, Boolean.TRUE.equals(FindFields.this.matchInherited)).matches(varType.getOwner()) && StringUtils.matchesGlob((String)varType.getName(), (String)FindFields.this.fieldName)) {
                    m = ((J.MemberReference)m).withReference((J.Identifier)SearchResult.found((Tree)((J.MemberReference)m).getReference()));
                }
                return m;
            }
        });
    }

    public static Set<J> find(J j, final String fullyQualifiedTypeName, final String fieldName) {
        JavaIsoVisitor<Set<J>> findVisitor = new JavaIsoVisitor<Set<J>>(){

            @Override
            public J.FieldAccess visitFieldAccess(J.FieldAccess fieldAccess, Set<J> vs) {
                J f = super.visitFieldAccess(fieldAccess, vs);
                JavaType.Variable varType = fieldAccess.getName().getFieldType();
                if (varType != null && new TypeMatcher(fullyQualifiedTypeName, true).matches(varType.getOwner()) && StringUtils.matchesGlob((String)varType.getName(), (String)fieldName)) {
                    vs.add(f);
                }
                return f;
            }

            @Override
            public J.Identifier visitIdentifier(J.Identifier identifier, Set<J> vs) {
                J i = super.visitIdentifier(identifier, vs);
                JavaType.Variable varType = identifier.getFieldType();
                if (varType != null && new TypeMatcher(fullyQualifiedTypeName, true).matches(varType.getOwner()) && StringUtils.matchesGlob((String)varType.getName(), (String)fieldName)) {
                    vs.add(i);
                }
                return i;
            }

            @Override
            public J.MemberReference visitMemberReference(J.MemberReference memberRef, Set<J> vs) {
                J m = super.visitMemberReference(memberRef, vs);
                JavaType.Variable varType = memberRef.getVariableType();
                if (varType != null && new TypeMatcher(fullyQualifiedTypeName, true).matches(varType.getOwner()) && StringUtils.matchesGlob((String)varType.getName(), (String)fieldName)) {
                    vs.add(m);
                }
                return m;
            }
        };
        HashSet<J> vs = new HashSet<J>();
        findVisitor.visit(j, vs);
        return vs;
    }

    @Generated
    public FindFields(String fullyQualifiedTypeName, @Nullable Boolean matchInherited, String fieldName) {
        this.fullyQualifiedTypeName = fullyQualifiedTypeName;
        this.matchInherited = matchInherited;
        this.fieldName = fieldName;
    }

    @Generated
    public String getFullyQualifiedTypeName() {
        return this.fullyQualifiedTypeName;
    }

    @Generated
    public @Nullable Boolean getMatchInherited() {
        return this.matchInherited;
    }

    @Generated
    public String getFieldName() {
        return this.fieldName;
    }

    @NonNull
    @Generated
    public String toString() {
        return "FindFields(fullyQualifiedTypeName=" + this.getFullyQualifiedTypeName() + ", matchInherited=" + this.getMatchInherited() + ", fieldName=" + this.getFieldName() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindFields)) {
            return false;
        }
        FindFields other = (FindFields)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$matchInherited = this.getMatchInherited();
        Boolean other$matchInherited = other.getMatchInherited();
        if (this$matchInherited == null ? other$matchInherited != null : !((Object)this$matchInherited).equals(other$matchInherited)) {
            return false;
        }
        String this$fullyQualifiedTypeName = this.getFullyQualifiedTypeName();
        String other$fullyQualifiedTypeName = other.getFullyQualifiedTypeName();
        if (this$fullyQualifiedTypeName == null ? other$fullyQualifiedTypeName != null : !this$fullyQualifiedTypeName.equals(other$fullyQualifiedTypeName)) {
            return false;
        }
        String this$fieldName = this.getFieldName();
        String other$fieldName = other.getFieldName();
        return !(this$fieldName == null ? other$fieldName != null : !this$fieldName.equals(other$fieldName));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof FindFields;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $matchInherited = this.getMatchInherited();
        result = result * 59 + ($matchInherited == null ? 43 : ((Object)$matchInherited).hashCode());
        String $fullyQualifiedTypeName = this.getFullyQualifiedTypeName();
        result = result * 59 + ($fullyQualifiedTypeName == null ? 43 : $fullyQualifiedTypeName.hashCode());
        String $fieldName = this.getFieldName();
        result = result * 59 + ($fieldName == null ? 43 : $fieldName.hashCode());
        return result;
    }
}

