/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.recipes;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.ValueNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.AnnotationMatcher;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.marker.SearchResult;
import org.openrewrite.table.RewriteRecipeSource;

public class FindRecipes
extends Recipe {
    RewriteRecipeSource recipeSource = new RewriteRecipeSource((Recipe)this);

    public String getDisplayName() {
        return "Find OpenRewrite recipes";
    }

    public String getDescription() {
        return "This recipe finds all OpenRewrite recipes, primarily to produce a data table that is being used to experiment with fine-tuning a large language model to produce more recipes.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        final MethodMatcher getDisplayName = new MethodMatcher("org.openrewrite.Recipe getDisplayName()", true);
        final MethodMatcher getDescription = new MethodMatcher("org.openrewrite.Recipe getDescription()", true);
        final AnnotationMatcher optionAnnotation = new AnnotationMatcher("@org.openrewrite.Option");
        return Preconditions.check(new UsesType("org.openrewrite.Recipe", false), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){
            final List<J.VariableDeclarations> options = new ArrayList<J.VariableDeclarations>();

            @Override
            public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext ctx) {
                J cd = super.visitClassDeclaration(classDecl, ctx);
                if (TypeUtils.isAssignableTo("org.openrewrite.Recipe", (JavaType)classDecl.getType())) {
                    FindRecipes.this.recipeSource.insertRow(ctx, (Object)new RewriteRecipeSource.Row((String)this.getCursor().getMessage("displayName"), (String)this.getCursor().getMessage("description"), RewriteRecipeSource.RecipeType.Java, ((J.CompilationUnit)this.getCursor().firstEnclosingOrThrow(J.CompilationUnit.class)).printAllTrimmed(), this.convertOptionsToJSON(this.options)));
                    return classDecl.withName((J.Identifier)SearchResult.found((Tree)classDecl.getName()));
                }
                return cd;
            }

            @Override
            public J.VariableDeclarations visitVariableDeclarations(J.VariableDeclarations multiVariable, ExecutionContext ctx) {
                if (multiVariable.getLeadingAnnotations().stream().anyMatch(optionAnnotation::matches)) {
                    this.options.add(multiVariable);
                }
                return super.visitVariableDeclarations(multiVariable, ctx);
            }

            @Override
            public J.Return visitReturn(J.Return aReturn, ExecutionContext ctx) {
                J j = (J)this.getCursor().dropParentUntil(it -> it instanceof J.MethodDeclaration || it instanceof J.ClassDeclaration).getValue();
                if (j instanceof J.MethodDeclaration) {
                    J.MethodDeclaration method = (J.MethodDeclaration)j;
                    if (getDisplayName.matches(method.getMethodType()) && aReturn.getExpression() instanceof J.Literal) {
                        this.getCursor().putMessageOnFirstEnclosing(J.ClassDeclaration.class, "displayName", Objects.requireNonNull(((J.Literal)aReturn.getExpression()).getValue()));
                    }
                    if (getDescription.matches(method.getMethodType()) && aReturn.getExpression() instanceof J.Literal) {
                        this.getCursor().putMessageOnFirstEnclosing(J.ClassDeclaration.class, "description", Objects.requireNonNull(((J.Literal)aReturn.getExpression()).getValue()));
                    }
                }
                return super.visitReturn(aReturn, ctx);
            }

            private String convertOptionsToJSON(List<J.VariableDeclarations> options) {
                ArrayNode optionsArray = JsonNodeFactory.instance.arrayNode();
                for (J.VariableDeclarations option : options) {
                    ObjectNode optionNode = optionsArray.addObject();
                    optionNode.put("name", option.getVariables().get(0).getSimpleName());
                    this.mapOptionAnnotation(option.getLeadingAnnotations(), optionNode);
                }
                return optionsArray.toString();
            }

            private void mapOptionAnnotation(List<J.Annotation> leadingAnnotations, ObjectNode optionNode) {
                for (J.Annotation annotation : leadingAnnotations) {
                    if (!optionAnnotation.matches(annotation) || annotation.getArguments() == null) continue;
                    for (Expression argument : annotation.getArguments()) {
                        J.NewArray newArray;
                        J.Assignment assignment;
                        if (!(argument instanceof J.Assignment) || !((assignment = (J.Assignment)argument).getVariable() instanceof J.Identifier)) continue;
                        J.Identifier identifier = (J.Identifier)assignment.getVariable();
                        if (assignment.getAssignment() instanceof J.Literal) {
                            optionNode.set(identifier.getSimpleName(), (JsonNode)this.mapValue(((J.Literal)assignment.getAssignment()).getValue()));
                            continue;
                        }
                        if (!(assignment.getAssignment() instanceof J.NewArray) || (newArray = (J.NewArray)assignment.getAssignment()).getInitializer() == null) continue;
                        ArrayNode valuesArray = optionNode.putArray(identifier.getSimpleName());
                        for (Expression expression : newArray.getInitializer()) {
                            if (!(expression instanceof J.Literal)) continue;
                            valuesArray.add((JsonNode)this.mapValue(((J.Literal)expression).getValue()));
                        }
                    }
                }
            }

            private ValueNode mapValue(@Nullable Object value) {
                if (value instanceof String) {
                    return JsonNodeFactory.instance.textNode((String)value);
                }
                if (value instanceof Boolean) {
                    return JsonNodeFactory.instance.booleanNode(((Boolean)value).booleanValue());
                }
                if (value instanceof Integer) {
                    return JsonNodeFactory.instance.numberNode((Integer)value);
                }
                if (value == null) {
                    return JsonNodeFactory.instance.nullNode();
                }
                throw new IllegalArgumentException(String.valueOf(value));
            }
        });
    }
}

