/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.internal.template;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Timer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import org.openrewrite.Cursor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.tree.Comment;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TextComment;
import org.openrewrite.java.tree.TypeUtils;

public class AnnotationTemplateGenerator {
    private static final String TEMPLATE_COMMENT = "__TEMPLATE_cfcc2025-6662__";
    private final Set<String> imports;

    public String cacheKey(Cursor cursor, String template) {
        StringBuilder after = new StringBuilder();
        J j = (J)cursor.getValue();
        if (j instanceof J.MethodDeclaration) {
            after.insert(0, " void $method() {}");
        } else if (j instanceof J.VariableDeclarations) {
            after.insert(0, " int $variable;");
        } else if (j instanceof J.ClassDeclaration) {
            if (cursor.getParentOrThrow().getValue() instanceof JavaSourceFile) {
                after.insert(0, "class $Clazz {}");
            } else {
                after.insert(0, "static class $Clazz {}");
            }
        }
        if (cursor.getParentOrThrow().getValue() instanceof J.ClassDeclaration && cursor.getParentOrThrow().getParentOrThrow().getValue() instanceof JavaSourceFile) {
            after.append("class $Template {}");
        }
        return "/*__TEMPLATE_cfcc2025-6662__*/" + template + "\n" + after;
    }

    public String template(Cursor cursor, String template) {
        return (String)Timer.builder((String)"rewrite.template.generate.statement").register((MeterRegistry)Metrics.globalRegistry).record(() -> {
            J annotationParent;
            StringBuilder before = new StringBuilder();
            StringBuilder after = new StringBuilder();
            this.template(this.next(cursor), (J)cursor.getValue(), before, after, Collections.newSetFromMap(new IdentityHashMap()));
            J j = (J)cursor.getValue();
            J j2 = annotationParent = j instanceof J.Annotation && cursor.getParent() != null ? (J)cursor.getParent().firstEnclosing(J.class) : null;
            if (j instanceof J.MethodDeclaration || annotationParent instanceof J.MethodDeclaration) {
                after.insert(0, " void $method() {}");
            } else if (j instanceof J.VariableDeclarations || annotationParent instanceof J.VariableDeclarations) {
                after.insert(0, " int $variable;");
            } else if (j instanceof J.ClassDeclaration) {
                if (cursor.getParentOrThrow().getValue() instanceof JavaSourceFile) {
                    after.insert(0, "class $Clazz {}");
                } else {
                    after.insert(0, "static class $Clazz {}");
                }
            }
            return before + "/*" + TEMPLATE_COMMENT + "*/" + template + "\n" + after;
        });
    }

    public List<J.Annotation> listAnnotations(JavaSourceFile cu) {
        final ArrayList<J.Annotation> annotations = new ArrayList<J.Annotation>();
        new JavaIsoVisitor<Integer>(){

            @Nullable
            private Comment filterTemplateComment(Comment comment) {
                return comment instanceof TextComment && ((TextComment)comment).getText().equals(AnnotationTemplateGenerator.TEMPLATE_COMMENT) ? null : comment;
            }

            @Override
            public J.Annotation visitAnnotation(J.Annotation annotation, Integer integer) {
                J.Annotation withoutTemplateComment = (J.Annotation)annotation.withComments(ListUtils.concatAll((List)ListUtils.map(((J)this.getCursor().getParentOrThrow().getValue()).getComments(), this::filterTemplateComment), (List)ListUtils.map(annotation.getComments(), this::filterTemplateComment)));
                annotations.add(withoutTemplateComment);
                return annotation;
            }
        }.visit(cu, 0);
        return annotations;
    }

    private void template(Cursor cursor, J prior, StringBuilder before, StringBuilder after, Set<J> templated) {
        templated.add((J)cursor.getValue());
        J j = (J)cursor.getValue();
        if (j instanceof JavaSourceFile) {
            List<J.ClassDeclaration> classes;
            JavaSourceFile cu = (JavaSourceFile)j;
            for (J.Import import_ : cu.getImports()) {
                before.insert(0, import_.withPrefix(Space.EMPTY).printTrimmed(cursor) + ";\n");
            }
            for (String string : this.imports) {
                before.insert(0, string);
            }
            if (cu.getPackageDeclaration() != null) {
                before.insert(0, cu.getPackageDeclaration().withPrefix(Space.EMPTY).printTrimmed(cursor) + ";\n");
            }
            if (!(classes = cu.getClasses()).get(classes.size() - 1).getName().getSimpleName().equals("$Placeholder")) {
                after.append("@interface $Placeholder {}");
            }
            return;
        }
        if (j instanceof J.Block) {
            J parent = (J)this.next(cursor).getValue();
            if (parent instanceof J.ClassDeclaration) {
                this.classDeclaration(before, (J.ClassDeclaration)parent, templated, cursor);
                after.append('}');
            } else if (parent instanceof J.MethodDeclaration) {
                J.MethodDeclaration m = (J.MethodDeclaration)parent;
                assert (m.getBody() != null);
                for (Statement statement : m.getBody().getStatements()) {
                    if (statement == prior) break;
                    if (!(statement instanceof J.VariableDeclarations)) continue;
                    before.insert(0, "\n" + this.variable((J.VariableDeclarations)statement, cursor) + ";\n");
                }
                if (m.getReturnTypeExpression() != null && !JavaType.Primitive.Void.equals(m.getReturnTypeExpression().getType())) {
                    after.append("return ").append(this.valueOfType(m.getReturnTypeExpression().getType())).append(";\n");
                }
                before.insert(0, m.withBody(null).withLeadingAnnotations(Collections.emptyList()).withPrefix(Space.EMPTY).printTrimmed(cursor).trim() + '{');
                after.append('}');
            } else if (parent instanceof J.Block) {
                J.Block b = (J.Block)j;
                for (Statement statement : b.getStatements()) {
                    J.VariableDeclarations v;
                    if (statement == prior) break;
                    if (!(statement instanceof J.VariableDeclarations) || !(v = (J.VariableDeclarations)statement).hasModifier(J.Modifier.Type.Final)) continue;
                    before.insert(0, "\n" + this.variable(v, cursor) + ";\n");
                }
                before.insert(0, "{\n");
                if (b.isStatic()) {
                    before.insert(0, "static");
                }
                after.append('}');
            }
        } else if (j instanceof J.NewClass) {
            J.NewClass n = (J.NewClass)j;
            n = n.withBody(null).withPrefix(Space.EMPTY);
            before.insert(0, '{');
            before.insert(0, n.printTrimmed(cursor.getParentOrThrow()).trim());
            after.append("};");
        }
        this.template(this.next(cursor), j, before, after, templated);
    }

    private void classDeclaration(StringBuilder before, J.ClassDeclaration parent, Set<J> templated, Cursor cursor) {
        J.ClassDeclaration c = parent;
        for (Statement statement : c.getBody().getStatements()) {
            if (templated.contains(statement)) continue;
            if (statement instanceof J.VariableDeclarations) {
                J.VariableDeclarations v = (J.VariableDeclarations)statement;
                if (!v.hasModifier(J.Modifier.Type.Final) || !v.hasModifier(J.Modifier.Type.Static)) continue;
                before.insert(0, this.variable((J.VariableDeclarations)statement, cursor) + ";\n");
                continue;
            }
            if (!(statement instanceof J.ClassDeclaration)) continue;
            before.insert(0, '}');
            this.classDeclaration(before, (J.ClassDeclaration)statement, templated, cursor);
        }
        String printed = (c = c.withBody(J.Block.createEmptyBlock()).withLeadingAnnotations(null).withPrefix(Space.EMPTY)).printTrimmed(cursor);
        int braceIndex = printed.lastIndexOf(123);
        before.insert(0, braceIndex == -1 ? printed + '{' : printed.substring(0, braceIndex + 1));
    }

    private String variable(J.VariableDeclarations variable, Cursor cursor) {
        StringBuilder varBuilder = new StringBuilder();
        if (variable.getTypeExpression() != null) {
            for (J.Modifier modifier : variable.getModifiers()) {
                varBuilder.append(modifier.getType().toString().toLowerCase()).append(' ');
            }
            varBuilder.append(variable.getTypeExpression().withPrefix(Space.EMPTY).printTrimmed(cursor)).append(' ');
        }
        List<J.VariableDeclarations.NamedVariable> variables = variable.getVariables();
        int variablesSize = variables.size();
        for (int i = 0; i < variablesSize; ++i) {
            J.VariableDeclarations.NamedVariable nv = variables.get(i);
            varBuilder.append(nv.getSimpleName());
            if (i >= variables.size() - 1) continue;
            varBuilder.append(',');
        }
        return varBuilder.toString();
    }

    private String valueOfType(@Nullable JavaType type) {
        JavaType.Primitive primitive = TypeUtils.asPrimitive(type);
        if (primitive != null) {
            switch (primitive) {
                case Boolean: {
                    return "true";
                }
                case Byte: 
                case Char: 
                case Int: 
                case Double: 
                case Float: 
                case Long: 
                case Short: {
                    return "0";
                }
                case String: 
                case Null: {
                    return "null";
                }
            }
            return "";
        }
        return "null";
    }

    private Cursor next(Cursor c) {
        return c.getParentTreeCursor();
    }

    public AnnotationTemplateGenerator(Set<String> imports) {
        this.imports = imports;
    }
}

