/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.format;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.openrewrite.Tree;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.style.BlankLinesStyle;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.Javadoc;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;

public class BlankLinesVisitor<P>
extends JavaIsoVisitor<P> {
    @Nullable
    private final Tree stopAfter;
    private final BlankLinesStyle style;

    public BlankLinesVisitor(BlankLinesStyle style) {
        this(style, null);
    }

    public BlankLinesVisitor(BlankLinesStyle style, @Nullable Tree stopAfter) {
        this.style = style;
        this.stopAfter = stopAfter;
    }

    public J visit(@Nullable Tree tree, P p) {
        if (this.getCursor().getNearestMessage("stop") != null) {
            return (J)tree;
        }
        if (tree instanceof JavaSourceFile) {
            JavaSourceFile cu = (JavaSourceFile)Objects.requireNonNull(tree);
            if (cu.getPackageDeclaration() != null) {
                cu = !cu.getPrefix().getComments().isEmpty() ? (JavaSourceFile)cu.withComments(ListUtils.mapLast(cu.getComments(), c -> {
                    String suffix = this.keepMaximumLines(c.getSuffix(), (int)this.style.getKeepMaximum().getBetweenHeaderAndPackage());
                    suffix = BlankLinesVisitor.minimumLines(suffix, this.style.getMinimum().getBeforePackage());
                    return c.withSuffix(suffix);
                })) : (JavaSourceFile)cu.withPrefix(Space.EMPTY);
            }
            cu = cu.getPackageDeclaration() == null ? (cu.getComments().isEmpty() ? (JavaSourceFile)cu.withPrefix(Space.EMPTY) : (JavaSourceFile)cu.withComments(ListUtils.mapLast(cu.getComments(), c -> c.withSuffix(BlankLinesVisitor.minimumLines(c.getSuffix(), this.style.getMinimum().getBeforeImports()))))) : cu.getPadding().withImports(ListUtils.mapFirst(cu.getPadding().getImports(), i -> this.minimumLines((J)((Object)i), (int)this.style.getMinimum().getAfterPackage())));
            return (J)super.visit((Tree)cu, p);
        }
        return (J)super.visit(tree, p);
    }

    @Override
    public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, P p) {
        JavaSourceFile cu;
        J j = super.visitClassDeclaration(classDecl, (Object)p);
        if (((J.ClassDeclaration)j).getBody() != null) {
            List<JRightPadded<Statement>> statements = ((J.ClassDeclaration)j).getBody().getPadding().getStatements();
            J.ClassDeclaration.Kind.Type classKind = ((J.ClassDeclaration)j).getKind();
            j = ((J.ClassDeclaration)j).withBody(((J.ClassDeclaration)j).getBody().getPadding().withStatements(ListUtils.map(statements, (i, s) -> {
                if (i == 0) {
                    if (classKind != J.ClassDeclaration.Kind.Type.Enum) {
                        s = this.minimumLines((J)((Object)s), (int)this.style.getMinimum().getAfterClassHeader());
                    }
                } else if (((JRightPadded)statements.get(i - 1)).getElement() instanceof J.Block) {
                    s = this.minimumLines((J)((Object)s), (int)this.style.getMinimum().getAroundInitializer());
                } else if (s.getElement() instanceof J.ClassDeclaration) {
                    s = this.minimumLines((J)((Object)s), (int)this.style.getMinimum().getAroundClass());
                }
                return s;
            })));
            j = ((J.ClassDeclaration)j).withBody(((J.ClassDeclaration)j).getBody().withEnd(this.minimumLines(((J.ClassDeclaration)j).getBody().getEnd(), (int)this.style.getMinimum().getBeforeClassEnd())));
        }
        boolean hasImports = !(cu = (JavaSourceFile)this.getCursor().firstEnclosingOrThrow(JavaSourceFile.class)).getImports().isEmpty();
        boolean firstClass = ((J.ClassDeclaration)j).equals(cu.getClasses().get(0));
        HashSet<J.ClassDeclaration> classes = new HashSet<J.ClassDeclaration>(cu.getClasses());
        J j2 = firstClass ? (hasImports ? (J.ClassDeclaration)this.minimumLines(j, (int)this.style.getMinimum().getAfterImports()) : j) : (j = classes.contains(j) ? (J.ClassDeclaration)this.minimumLines(j, (int)this.style.getMinimum().getAroundClass()) : j);
        J j3 = firstClass ? (hasImports ? (J.ClassDeclaration)this.keepMaximumLines(j, Math.max(this.style.getKeepMaximum().getInDeclarations(), this.style.getMinimum().getAfterImports())) : j) : (j = classes.contains(j) ? (J.ClassDeclaration)this.keepMaximumLines(j, (int)this.style.getKeepMaximum().getInDeclarations()) : j);
        if (!hasImports && firstClass) {
            if (cu.getPackageDeclaration() == null) {
                if (!((J.ClassDeclaration)j).getPrefix().getWhitespace().isEmpty()) {
                    j = ((J.ClassDeclaration)j).withPrefix(((J.ClassDeclaration)j).getPrefix().withWhitespace(""));
                }
            } else {
                j = (J.ClassDeclaration)this.minimumLines(j, (int)this.style.getMinimum().getAfterPackage());
            }
        }
        return j;
    }

    @Override
    public J.EnumValue visitEnumValue(J.EnumValue _enum, P p) {
        J e = super.visitEnumValue(_enum, (Object)p);
        return (J.EnumValue)this.keepMaximumLines(e, (int)this.style.getKeepMaximum().getInDeclarations());
    }

    @Override
    public J.Import visitImport(J.Import import_, P p) {
        JavaSourceFile cu;
        J i = super.visitImport(import_, (Object)p);
        if (((J.Import)i).equals((cu = (JavaSourceFile)this.getCursor().firstEnclosingOrThrow(JavaSourceFile.class)).getImports().get(0)) && cu.getPackageDeclaration() == null && cu.getPrefix().equals(Space.EMPTY)) {
            i = ((J.Import)i).withPrefix(((J.Import)i).getPrefix().withWhitespace(""));
        }
        return i;
    }

    @Override
    public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, P p) {
        J j = super.visitMethodDeclaration(method, (Object)p);
        if (((J.MethodDeclaration)j).getBody() != null) {
            if (((J.MethodDeclaration)j).getBody().getStatements().isEmpty()) {
                Space end = this.minimumLines(((J.MethodDeclaration)j).getBody().getEnd(), (int)this.style.getMinimum().getBeforeMethodBody());
                if (end.getIndent().isEmpty() && this.style.getMinimum().getBeforeMethodBody() > 0) {
                    end = end.withWhitespace(end.getWhitespace() + method.getPrefix().getIndent());
                }
                j = ((J.MethodDeclaration)j).withBody(((J.MethodDeclaration)j).getBody().withEnd(end));
            } else {
                j = ((J.MethodDeclaration)j).withBody(((J.MethodDeclaration)j).getBody().withStatements(ListUtils.mapFirst(((J.MethodDeclaration)j).getBody().getStatements(), s -> this.minimumLines(s, (int)this.style.getMinimum().getBeforeMethodBody()))));
            }
        }
        return j;
    }

    @Override
    public J.NewClass visitNewClass(J.NewClass newClass, P p) {
        J j = super.visitNewClass(newClass, (Object)p);
        if (((J.NewClass)j).getBody() != null) {
            j = ((J.NewClass)j).withBody(((J.NewClass)j).getBody().withStatements(ListUtils.mapFirst(((J.NewClass)j).getBody().getStatements(), s -> this.minimumLines(s, (int)this.style.getMinimum().getAfterAnonymousClassHeader()))));
        }
        return j;
    }

    @Override
    public Statement visitStatement(Statement statement, P p) {
        J j = super.visitStatement(statement, (Object)p);
        Iterator cursorPath = this.getCursor().getParentOrThrow().getPath(J.class::isInstance);
        Object parentTree = cursorPath.next();
        if (cursorPath.hasNext()) {
            Object grandparentTree = cursorPath.next();
            if (grandparentTree instanceof J.ClassDeclaration && parentTree instanceof J.Block) {
                J.Block block = (J.Block)parentTree;
                J.ClassDeclaration classDecl = (J.ClassDeclaration)grandparentTree;
                int declMax = this.style.getKeepMaximum().getInDeclarations();
                if (!block.getStatements().isEmpty() && !block.getStatements().iterator().next().isScope(j)) {
                    if (j instanceof J.VariableDeclarations) {
                        if (classDecl.getKind() == J.ClassDeclaration.Kind.Type.Interface) {
                            declMax = Math.max(declMax, this.style.getMinimum().getAroundFieldInInterface());
                            j = (Statement)this.minimumLines(j, (int)this.style.getMinimum().getAroundFieldInInterface());
                        } else {
                            declMax = Math.max(declMax, this.style.getMinimum().getAroundField());
                            j = (Statement)this.minimumLines(j, (int)this.style.getMinimum().getAroundField());
                        }
                    } else if (j instanceof J.MethodDeclaration) {
                        if (classDecl.getKind() == J.ClassDeclaration.Kind.Type.Interface) {
                            declMax = Math.max(declMax, this.style.getMinimum().getAroundMethodInInterface());
                            j = (Statement)this.minimumLines(j, (int)this.style.getMinimum().getAroundMethodInInterface());
                        } else {
                            declMax = Math.max(declMax, this.style.getMinimum().getAroundMethod());
                            j = (Statement)this.minimumLines(j, (int)this.style.getMinimum().getAroundMethod());
                        }
                    } else if (j instanceof J.Block) {
                        declMax = Math.max(declMax, this.style.getMinimum().getAroundInitializer());
                        j = (Statement)this.minimumLines(j, (int)this.style.getMinimum().getAroundInitializer());
                    } else if (j instanceof J.ClassDeclaration) {
                        declMax = Math.max(declMax, this.style.getMinimum().getAroundClass());
                        j = (Statement)this.minimumLines(j, (int)this.style.getMinimum().getAroundClass());
                    }
                }
                j = (Statement)this.keepMaximumLines(j, declMax);
            } else {
                return (Statement)this.keepMaximumLines(j, (int)this.style.getKeepMaximum().getInCode());
            }
        }
        return j;
    }

    @Override
    public J.Block visitBlock(J.Block block, P p) {
        J j = super.visitBlock(block, (Object)p);
        j = ((J.Block)j).withEnd(this.keepMaximumLines(((J.Block)j).getEnd(), (int)this.style.getKeepMaximum().getBeforeEndOfBlock()));
        return j;
    }

    private <J2 extends J> J2 keepMaximumLines(J2 tree, int max) {
        return tree.withPrefix(this.keepMaximumLines(tree.getPrefix(), max));
    }

    private Space keepMaximumLines(Space prefix, int max) {
        return prefix.withWhitespace(this.keepMaximumLines(prefix.getWhitespace(), max));
    }

    private String keepMaximumLines(String whitespace, int max) {
        long blankLines = BlankLinesVisitor.getNewLineCount(whitespace) - 1;
        if (blankLines > (long)max) {
            int startWhitespaceAtIndex = 0;
            int i = 0;
            while ((long)i < blankLines - (long)max + 1L) {
                startWhitespaceAtIndex = whitespace.indexOf(10, startWhitespaceAtIndex);
                ++i;
                ++startWhitespaceAtIndex;
            }
            return whitespace.substring(--startWhitespaceAtIndex);
        }
        return whitespace;
    }

    private <J2 extends J> JRightPadded<J2> minimumLines(JRightPadded<J2> tree, int min) {
        return tree.withElement(this.minimumLines((J)tree.getElement(), min));
    }

    private <J2 extends J> J2 minimumLines(J2 tree, int min) {
        return tree.withPrefix(this.minimumLines(tree.getPrefix(), min));
    }

    private Space minimumLines(Space prefix, int min) {
        if (min == 0) {
            return prefix;
        }
        if (prefix.getComments().isEmpty() || prefix.getWhitespace().contains("\n") || prefix.getComments().get(0) instanceof Javadoc || prefix.getComments().get(0).isMultiline() && prefix.getComments().get(0).printComment(this.getCursor()).contains("\n")) {
            return prefix.withWhitespace(BlankLinesVisitor.minimumLines(prefix.getWhitespace(), min));
        }
        return prefix.withComments(ListUtils.map(prefix.getComments(), (i, c) -> i == 0 ? c.withSuffix(BlankLinesVisitor.minimumLines(c.getSuffix(), min)) : c));
    }

    public static String minimumLines(String whitespace, int min) {
        if (min == 0) {
            return whitespace;
        }
        String minWhitespace = whitespace;
        for (int i = 0; i < min - BlankLinesVisitor.getNewLineCount(whitespace) + 1; ++i) {
            minWhitespace = "\n" + minWhitespace;
        }
        return minWhitespace;
    }

    private static int getNewLineCount(String whitespace) {
        int newLineCount = 0;
        for (int i = 0; i < whitespace.length(); ++i) {
            char c = whitespace.charAt(i);
            if (c != '\n') continue;
            ++newLineCount;
        }
        return newLineCount;
    }

    @Nullable
    public J postVisit(J tree, P p) {
        if (this.stopAfter != null && this.stopAfter.isScope((Tree)tree)) {
            this.getCursor().putMessageOnFirstEnclosing(JavaSourceFile.class, "stop", (Object)true);
        }
        return (J)super.postVisit((Tree)tree, p);
    }
}

