/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.recipes;

import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.TypeUtils;

public class RecipeEqualsAndHashCodeCallSuper
extends Recipe {
    public String getDisplayName() {
        return "Use of `@EqualsAndHashCode` on `Recipe`";
    }

    public String getDescription() {
        return "Recipes are value objects, so should use `@EqualsAndHashCode(callSuper = false)`. While in most cases recipes do not extend other classes and so the option is moot, as a matter of stylistic consistency and to enforce the idea that recipes are value objects, this value should be set to `false`.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){

            @Override
            public J.Annotation visitAnnotation(J.Annotation annotation, ExecutionContext ctx) {
                if (TypeUtils.isOfClassType(annotation.getType(), "lombok.EqualsAndHashCode") && this.getCursor().getParentTreeCursor().getValue() instanceof J.ClassDeclaration) {
                    return (J.Annotation)new JavaIsoVisitor<ExecutionContext>(){

                        @Override
                        public J.Literal visitLiteral(J.Literal literal, ExecutionContext ctx) {
                            return literal.withValue(false).withValueSource("false");
                        }
                    }.visitNonNull(annotation, ctx, this.getCursor().getParentOrThrow());
                }
                return super.visitAnnotation(annotation, ctx);
            }
        };
    }
}

