/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import org.openrewrite.Cursor;
import org.openrewrite.Incubating;
import org.openrewrite.Tree;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplateSemanticallyEqual;
import org.openrewrite.java.internal.template.JavaTemplateJavaExtension;
import org.openrewrite.java.internal.template.JavaTemplateParser;
import org.openrewrite.java.internal.template.Substitutions;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaCoordinates;
import org.openrewrite.template.SourceTemplate;

public class JavaTemplate
implements SourceTemplate<J, JavaCoordinates> {
    private final String code;
    private final Consumer<String> onAfterVariableSubstitution;
    private final JavaTemplateParser templateParser;

    private JavaTemplate(boolean contextSensitive, JavaParser.Builder<?, ?> javaParser, String code, Set<String> imports, Consumer<String> onAfterVariableSubstitution, Consumer<String> onBeforeParseTemplate) {
        this.code = code;
        this.onAfterVariableSubstitution = onAfterVariableSubstitution;
        this.templateParser = new JavaTemplateParser(contextSensitive, javaParser, onAfterVariableSubstitution, onBeforeParseTemplate, imports);
    }

    public <J2 extends J> J2 apply(Cursor scope, JavaCoordinates coordinates, Object ... parameters) {
        if (!(scope.getValue() instanceof J)) {
            throw new IllegalArgumentException("`scope` must point to a J instance.");
        }
        Substitutions substitutions = new Substitutions(this.code, parameters);
        String substitutedTemplate = substitutions.substitute();
        this.onAfterVariableSubstitution.accept(substitutedTemplate);
        return (J2)((J)new JavaTemplateJavaExtension(this.templateParser, substitutions, substitutedTemplate, coordinates).getMixin().visit((Tree)scope.getValue(), (Object)0, scope.getParentOrThrow()));
    }

    @Incubating(since="8.0.0")
    public static boolean matches(String template, Cursor cursor) {
        return JavaTemplate.builder(template).build().matches(cursor);
    }

    @Incubating(since="7.38.0")
    public boolean matches(Cursor cursor) {
        return this.matcher(cursor).find();
    }

    @Incubating(since="7.38.0")
    public Matcher matcher(Cursor cursor) {
        return new Matcher(cursor);
    }

    public static <J2 extends J> J2 apply(String template, Cursor scope, JavaCoordinates coordinates, Object ... parameters) {
        return JavaTemplate.builder(template).build().apply(scope, coordinates, parameters);
    }

    public static Builder builder(String code) {
        return new Builder(code);
    }

    public String getCode() {
        return this.code;
    }

    public static class Builder {
        private final String code;
        private final Set<String> imports = new HashSet<String>();
        private boolean contextSensitive;
        private JavaParser.Builder<?, ?> javaParser = JavaParser.fromJavaVersion();
        private Consumer<String> onAfterVariableSubstitution = s -> {};
        private Consumer<String> onBeforeParseTemplate = s -> {};

        Builder(String code) {
            this.code = code.trim();
        }

        public Builder contextSensitive() {
            this.contextSensitive = true;
            return this;
        }

        public Builder imports(String ... fullyQualifiedTypeNames) {
            for (String typeName : fullyQualifiedTypeNames) {
                this.validateImport(typeName);
                this.imports.add("import " + typeName + ";\n");
            }
            return this;
        }

        public Builder staticImports(String ... fullyQualifiedMemberTypeNames) {
            for (String typeName : fullyQualifiedMemberTypeNames) {
                this.validateImport(typeName);
                this.imports.add("import static " + typeName + ";\n");
            }
            return this;
        }

        private void validateImport(String typeName) {
            if (StringUtils.isBlank((String)typeName)) {
                throw new IllegalArgumentException("Imports must not be blank");
            }
            if (typeName.startsWith("import ") || typeName.startsWith("static ")) {
                throw new IllegalArgumentException("Imports are expressed as fully-qualified names and should not include an \"import \" or \"static \" prefix");
            }
            if (typeName.endsWith(";") || typeName.endsWith("\n")) {
                throw new IllegalArgumentException("Imports are expressed as fully-qualified names and should not include a suffixed terminator");
            }
        }

        public Builder javaParser(JavaParser.Builder<?, ?> javaParser) {
            this.javaParser = javaParser;
            return this;
        }

        public Builder doAfterVariableSubstitution(Consumer<String> afterVariableSubstitution) {
            this.onAfterVariableSubstitution = afterVariableSubstitution;
            return this;
        }

        public Builder doBeforeParseTemplate(Consumer<String> beforeParseTemplate) {
            this.onBeforeParseTemplate = beforeParseTemplate;
            return this;
        }

        public JavaTemplate build() {
            return new JavaTemplate(this.contextSensitive, this.javaParser, this.code, this.imports, this.onAfterVariableSubstitution, this.onBeforeParseTemplate);
        }
    }

    @Incubating(since="7.38.0")
    public final class Matcher {
        private final Cursor cursor;
        private JavaTemplateSemanticallyEqual.TemplateMatchResult matchResult;

        Matcher(Cursor cursor) {
            this.cursor = cursor;
        }

        public boolean find() {
            this.matchResult = JavaTemplateSemanticallyEqual.matchesTemplate(JavaTemplate.this, this.cursor);
            return this.matchResult.isMatch();
        }

        public J parameter(int i) {
            return this.matchResult.getMatchedParameters().get(i);
        }

        public Cursor getCursor() {
            return this.cursor;
        }

        public JavaTemplateSemanticallyEqual.TemplateMatchResult getMatchResult() {
            return this.matchResult;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Matcher)) {
                return false;
            }
            Matcher other = (Matcher)o;
            Cursor this$cursor = this.getCursor();
            Cursor other$cursor = other.getCursor();
            if (this$cursor == null ? other$cursor != null : !this$cursor.equals(other$cursor)) {
                return false;
            }
            JavaTemplateSemanticallyEqual.TemplateMatchResult this$matchResult = this.getMatchResult();
            JavaTemplateSemanticallyEqual.TemplateMatchResult other$matchResult = other.getMatchResult();
            return !(this$matchResult == null ? other$matchResult != null : !((Object)this$matchResult).equals(other$matchResult));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Cursor $cursor = this.getCursor();
            result = result * 59 + ($cursor == null ? 43 : $cursor.hashCode());
            JavaTemplateSemanticallyEqual.TemplateMatchResult $matchResult = this.getMatchResult();
            result = result * 59 + ($matchResult == null ? 43 : ((Object)$matchResult).hashCode());
            return result;
        }

        @NonNull
        public String toString() {
            return "JavaTemplate.Matcher(cursor=" + this.getCursor() + ", matchResult=" + this.getMatchResult() + ")";
        }
    }
}

