/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.search;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.ScanningRecipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.table.TypeMappings;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.TypedTree;

public final class FindTypeMappings
extends ScanningRecipe<Accumulator> {
    private final transient TypeMappings typeMappingsPerSource = new TypeMappings((Recipe)this);

    public String getDisplayName() {
        return "Find type mappings";
    }

    public String getDescription() {
        return "Find types mapped to J trees.";
    }

    public Accumulator getInitialValue(ExecutionContext ctx) {
        return new Accumulator();
    }

    public TreeVisitor<?, ExecutionContext> getScanner(final Accumulator acc) {
        return new JavaIsoVisitor<ExecutionContext>(){
            String sourcePath = "";

            @Override
            public J.CompilationUnit visitCompilationUnit(J.CompilationUnit cu, ExecutionContext executionContext) {
                this.sourcePath = cu.getSourcePath().toString();
                return super.visitCompilationUnit(cu, executionContext);
            }

            @Nullable
            public J visit(@Nullable Tree tree, ExecutionContext executionContext) {
                if (tree instanceof TypedTree) {
                    J.VariableDeclarations.NamedVariable n;
                    Map counts = acc.getSourceToMappedTypeCount().computeIfAbsent(this.sourcePath, k -> new HashMap()).computeIfAbsent(tree.getClass().getName(), k -> new HashMap());
                    if (tree instanceof J.Identifier) {
                        J.Identifier i = (J.Identifier)tree;
                        if (i.getFieldType() != null) {
                            counts.computeIfAbsent(i.getFieldType().getClass().getName(), k -> new AtomicInteger(0)).incrementAndGet();
                        }
                    } else if (tree instanceof J.MemberReference) {
                        J.MemberReference m = (J.MemberReference)tree;
                        if (m.getVariableType() != null) {
                            counts.computeIfAbsent(m.getVariableType().getClass().getName(), k -> new AtomicInteger(0)).incrementAndGet();
                        } else if (m.getMethodType() != null) {
                            counts.computeIfAbsent(m.getMethodType().getClass().getName(), k -> new AtomicInteger(0)).incrementAndGet();
                        }
                    } else if (tree instanceof J.MethodDeclaration) {
                        J.MethodDeclaration m = (J.MethodDeclaration)tree;
                        if (m.getMethodType() != null) {
                            counts.computeIfAbsent(m.getMethodType().getClass().getName(), k -> new AtomicInteger(0)).incrementAndGet();
                        }
                    } else if (tree instanceof J.MethodInvocation) {
                        J.MethodInvocation m = (J.MethodInvocation)tree;
                        if (m.getMethodType() != null) {
                            counts.computeIfAbsent(m.getMethodType().getClass().getName(), k -> new AtomicInteger(0)).incrementAndGet();
                        }
                    } else if (tree instanceof J.NewClass) {
                        J.NewClass m = (J.NewClass)tree;
                        if (m.getMethodType() != null) {
                            counts.computeIfAbsent(m.getMethodType().getClass().getName(), k -> new AtomicInteger(0)).incrementAndGet();
                        }
                    } else if (tree instanceof J.VariableDeclarations.NamedVariable && (n = (J.VariableDeclarations.NamedVariable)tree).getVariableType() != null) {
                        counts.computeIfAbsent(n.getVariableType().getClass().getName(), k -> new AtomicInteger(0)).incrementAndGet();
                    }
                    counts.computeIfAbsent(((TypedTree)tree).getType() == null ? "null" : ((TypedTree)tree).getType().getClass().getName(), k -> new AtomicInteger(0)).incrementAndGet();
                }
                return (J)super.visit(tree, (Object)executionContext);
            }
        };
    }

    public Collection<? extends SourceFile> generate(Accumulator acc, ExecutionContext ctx) {
        for (Map.Entry<String, Map<String, Map<String, AtomicInteger>>> sources : acc.getSourceToMappedTypeCount().entrySet()) {
            for (Map.Entry<String, Map<String, AtomicInteger>> trees : sources.getValue().entrySet()) {
                for (Map.Entry<String, AtomicInteger> types : trees.getValue().entrySet()) {
                    this.typeMappingsPerSource.insertRow(ctx, new TypeMappings.Row(sources.getKey(), trees.getKey(), types.getKey(), types.getValue().get()));
                }
            }
        }
        return Collections.emptyList();
    }

    public TypeMappings getTypeMappingsPerSource() {
        return this.typeMappingsPerSource;
    }

    @NonNull
    public String toString() {
        return "FindTypeMappings(typeMappingsPerSource=" + (Object)((Object)this.getTypeMappingsPerSource()) + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindTypeMappings)) {
            return false;
        }
        FindTypeMappings other = (FindTypeMappings)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        return super.equals(o);
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof FindTypeMappings;
    }

    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    public static class Accumulator {
        Map<String, Map<String, Map<String, AtomicInteger>>> sourceToMappedTypeCount = new HashMap<String, Map<String, Map<String, AtomicInteger>>>();

        public Map<String, Map<String, Map<String, AtomicInteger>>> getSourceToMappedTypeCount() {
            return this.sourceToMappedTypeCount;
        }

        public void setSourceToMappedTypeCount(Map<String, Map<String, Map<String, AtomicInteger>>> sourceToMappedTypeCount) {
            this.sourceToMappedTypeCount = sourceToMappedTypeCount;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Accumulator)) {
                return false;
            }
            Accumulator other = (Accumulator)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Map<String, Map<String, Map<String, AtomicInteger>>> this$sourceToMappedTypeCount = this.getSourceToMappedTypeCount();
            Map<String, Map<String, Map<String, AtomicInteger>>> other$sourceToMappedTypeCount = other.getSourceToMappedTypeCount();
            return !(this$sourceToMappedTypeCount == null ? other$sourceToMappedTypeCount != null : !((Object)this$sourceToMappedTypeCount).equals(other$sourceToMappedTypeCount));
        }

        protected boolean canEqual(@Nullable Object other) {
            return other instanceof Accumulator;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Map<String, Map<String, Map<String, AtomicInteger>>> $sourceToMappedTypeCount = this.getSourceToMappedTypeCount();
            result = result * 59 + ($sourceToMappedTypeCount == null ? 43 : ((Object)$sourceToMappedTypeCount).hashCode());
            return result;
        }

        @NonNull
        public String toString() {
            return "FindTypeMappings.Accumulator(sourceToMappedTypeCount=" + this.getSourceToMappedTypeCount() + ")";
        }
    }
}

