/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.search;

import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.marker.SearchResult;

public final class FindImplementations
extends Recipe {
    @Option(displayName="Interface fully-qualified name", description="A fully-qualified interface name to search for.", example="org.openrewrite.Recipe")
    private final String interfaceFullyQualifiedName;
    @Option(displayName="Match on inherited types", description="When enabled, find methods that are overrides of the method pattern.", required=false)
    @Nullable
    private final Boolean matchInherited;

    public String getDisplayName() {
        return "Find class declarations implementing an interface";
    }

    public String getDescription() {
        return "Find source files that contain a class declaration implementing a specific interface.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){

            @Override
            public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext ctx) {
                if (!TypeUtils.isOfClassType(((J.ClassDeclaration)(classDecl = super.visitClassDeclaration((J.ClassDeclaration)classDecl, ctx))).getType(), FindImplementations.this.interfaceFullyQualifiedName) && TypeUtils.isAssignableTo(FindImplementations.this.interfaceFullyQualifiedName, (JavaType)((J.ClassDeclaration)classDecl).getType())) {
                    return (J.ClassDeclaration)SearchResult.found((Tree)classDecl);
                }
                return classDecl;
            }
        };
    }

    public FindImplementations(String interfaceFullyQualifiedName, @Nullable Boolean matchInherited) {
        this.interfaceFullyQualifiedName = interfaceFullyQualifiedName;
        this.matchInherited = matchInherited;
    }

    public String getInterfaceFullyQualifiedName() {
        return this.interfaceFullyQualifiedName;
    }

    @Nullable
    public Boolean getMatchInherited() {
        return this.matchInherited;
    }

    @NonNull
    public String toString() {
        return "FindImplementations(interfaceFullyQualifiedName=" + this.getInterfaceFullyQualifiedName() + ", matchInherited=" + this.getMatchInherited() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindImplementations)) {
            return false;
        }
        FindImplementations other = (FindImplementations)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Boolean this$matchInherited = this.getMatchInherited();
        Boolean other$matchInherited = other.getMatchInherited();
        if (this$matchInherited == null ? other$matchInherited != null : !((Object)this$matchInherited).equals(other$matchInherited)) {
            return false;
        }
        String this$interfaceFullyQualifiedName = this.getInterfaceFullyQualifiedName();
        String other$interfaceFullyQualifiedName = other.getInterfaceFullyQualifiedName();
        return !(this$interfaceFullyQualifiedName == null ? other$interfaceFullyQualifiedName != null : !this$interfaceFullyQualifiedName.equals(other$interfaceFullyQualifiedName));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof FindImplementations;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $matchInherited = this.getMatchInherited();
        result = result * 59 + ($matchInherited == null ? 43 : ((Object)$matchInherited).hashCode());
        String $interfaceFullyQualifiedName = this.getInterfaceFullyQualifiedName();
        result = result * 59 + ($interfaceFullyQualifiedName == null ? 43 : $interfaceFullyQualifiedName.hashCode());
        return result;
    }
}

