/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.DeclaresMethod;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.Space;

public final class ReorderMethodArguments
extends Recipe {
    @Option(displayName="Method pattern", description="A method pattern that is used to find matching method invocations.", example="com.yourorg.A foo(String, Integer, Integer)")
    private final String methodPattern;
    @Option(displayName="New parameter names", description="An array of parameter names that indicates the new order in which those arguments should be arranged.", example="[foo, bar, baz]")
    private final String[] newParameterNames;
    @Option(displayName="Old parameter names", description="If the original method signature is not type-attributed, this is an optional list that indicates the original order in which the arguments were arranged.", required=false, example="[baz, bar, foo]")
    @Nullable
    private final String[] oldParameterNames;
    @Option(displayName="Ignore type definition", description="When set to `true` the definition of the old type will be left untouched. This is useful when you're replacing usage of a class but don't want to rename it.", required=false)
    @Nullable
    private final Boolean ignoreDefinition;

    public String getDisplayName() {
        return "Reorder method arguments";
    }

    public String getDescription() {
        return "Reorder method arguments into the specified order.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new JavaVisitor<ExecutionContext>(){

            public J visit(@Nullable Tree tree, ExecutionContext ctx) {
                if (tree instanceof JavaSourceFile) {
                    J j;
                    JavaSourceFile cu = (JavaSourceFile)Objects.requireNonNull(tree);
                    if (Boolean.TRUE.equals(ReorderMethodArguments.this.ignoreDefinition) && cu != (j = (J)new DeclaresMethod(ReorderMethodArguments.this.methodPattern, true).visitNonNull(cu, ctx))) {
                        return cu;
                    }
                    return (J)new UsesMethod(ReorderMethodArguments.this.methodPattern).visitNonNull(cu, ctx);
                }
                return (J)super.visit(tree, (Object)ctx);
            }
        }, (TreeVisitor)new ReorderMethodArgumentsVisitor(new MethodMatcher(this.methodPattern)));
    }

    public ReorderMethodArguments(String methodPattern, String[] newParameterNames, @Nullable String[] oldParameterNames, @Nullable Boolean ignoreDefinition) {
        this.methodPattern = methodPattern;
        this.newParameterNames = newParameterNames;
        this.oldParameterNames = oldParameterNames;
        this.ignoreDefinition = ignoreDefinition;
    }

    public String getMethodPattern() {
        return this.methodPattern;
    }

    public String[] getNewParameterNames() {
        return this.newParameterNames;
    }

    @Nullable
    public String[] getOldParameterNames() {
        return this.oldParameterNames;
    }

    @Nullable
    public Boolean getIgnoreDefinition() {
        return this.ignoreDefinition;
    }

    @NonNull
    public String toString() {
        return "ReorderMethodArguments(methodPattern=" + this.getMethodPattern() + ", newParameterNames=" + Arrays.deepToString(this.getNewParameterNames()) + ", oldParameterNames=" + Arrays.deepToString(this.getOldParameterNames()) + ", ignoreDefinition=" + this.getIgnoreDefinition() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReorderMethodArguments)) {
            return false;
        }
        ReorderMethodArguments other = (ReorderMethodArguments)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$ignoreDefinition = this.getIgnoreDefinition();
        Boolean other$ignoreDefinition = other.getIgnoreDefinition();
        if (this$ignoreDefinition == null ? other$ignoreDefinition != null : !((Object)this$ignoreDefinition).equals(other$ignoreDefinition)) {
            return false;
        }
        String this$methodPattern = this.getMethodPattern();
        String other$methodPattern = other.getMethodPattern();
        if (this$methodPattern == null ? other$methodPattern != null : !this$methodPattern.equals(other$methodPattern)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getNewParameterNames(), other.getNewParameterNames())) {
            return false;
        }
        return Arrays.deepEquals(this.getOldParameterNames(), other.getOldParameterNames());
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ReorderMethodArguments;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $ignoreDefinition = this.getIgnoreDefinition();
        result = result * 59 + ($ignoreDefinition == null ? 43 : ((Object)$ignoreDefinition).hashCode());
        String $methodPattern = this.getMethodPattern();
        result = result * 59 + ($methodPattern == null ? 43 : $methodPattern.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getNewParameterNames());
        result = result * 59 + Arrays.deepHashCode(this.getOldParameterNames());
        return result;
    }

    private class ReorderMethodArgumentsVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private final MethodMatcher methodMatcher;

        private ReorderMethodArgumentsVisitor(MethodMatcher methodMatcher) {
            this.methodMatcher = methodMatcher;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
            J m = super.visitMethodInvocation(method, ctx);
            if (this.methodMatcher.matches((MethodCall)m) && ((J.MethodInvocation)m).getMethodType() != null) {
                void var13_16;
                List<String> paramNames = ReorderMethodArguments.this.oldParameterNames == null || ReorderMethodArguments.this.oldParameterNames.length == 0 ? ((J.MethodInvocation)m).getMethodType().getParameterNames() : Arrays.asList(ReorderMethodArguments.this.oldParameterNames);
                List<JRightPadded<Expression>> originalArgs = ((J.MethodInvocation)m).getPadding().getArguments().getPadding().getElements();
                int resolvedParamCount = ((J.MethodInvocation)m).getMethodType().getParameterTypes().size();
                int i = 0;
                ArrayList reordered = new ArrayList(originalArgs.size());
                ArrayList<Space> formattings = new ArrayList<Space>(originalArgs.size());
                ArrayList<Space> rightFormattings = new ArrayList<Space>(originalArgs.size());
                String[] stringArray = ReorderMethodArguments.this.newParameterNames;
                int n = stringArray.length;
                boolean bl = false;
                while (var13_16 < n) {
                    String name = stringArray[var13_16];
                    int fromPos = paramNames.indexOf(name);
                    if (originalArgs.size() > resolvedParamCount && fromPos == resolvedParamCount - 1) {
                        List<JRightPadded<Expression>> varargs = originalArgs.subList(fromPos, originalArgs.size());
                        reordered.addAll(varargs);
                        for (JRightPadded<Expression> exp : originalArgs.subList(i, i++ + varargs.size())) {
                            formattings.add(exp.getElement().getPrefix());
                            rightFormattings.add(exp.getAfter());
                        }
                    } else if (fromPos >= 0 && originalArgs.size() > fromPos) {
                        reordered.add(originalArgs.get(fromPos));
                        formattings.add(originalArgs.get(i).getElement().getPrefix());
                        rightFormattings.add(originalArgs.get(i++).getAfter());
                    }
                    ++var13_16;
                }
                boolean changed = false;
                i = 0;
                for (JRightPadded jRightPadded : reordered) {
                    int index = i;
                    reordered.set(i, jRightPadded.map(e -> (Expression)e.withPrefix((Space)formattings.get(index))).withAfter((Space)rightFormattings.get(index)));
                    if (reordered.get(i) != originalArgs.get(i)) {
                        changed = true;
                    }
                    ++i;
                }
                if (changed) {
                    m = ((J.MethodInvocation)m).getPadding().withArguments(((J.MethodInvocation)m).getPadding().getArguments().getPadding().withElements(reordered));
                }
            }
            return m;
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
    }
}

