/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.search;

import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaTypeSignatureBuilder;
import org.openrewrite.java.internal.DefaultJavaTypeSignatureBuilder;
import org.openrewrite.java.table.MethodCallGraph;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;

public class FindCallGraph
extends Recipe {
    final transient MethodCallGraph methodCallGraph = new MethodCallGraph(this);

    public String getDisplayName() {
        return "Build call graph";
    }

    public String getDescription() {
        return "Produce the call graph describing the relationships between methods.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){
            final JavaTypeSignatureBuilder signatureBuilder = new CallGraphSignatureBuilder();
            final Set<JavaType.Method> methodsCalledInDeclaration = Collections.newSetFromMap(new IdentityHashMap());

            @Override
            public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, ExecutionContext executionContext) {
                J m = super.visitMethodDeclaration(method, executionContext);
                this.methodsCalledInDeclaration.clear();
                return m;
            }

            @Override
            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                this.recordCall(method.getMethodType(), ctx);
                return super.visitMethodInvocation(method, ctx);
            }

            @Override
            public J.MemberReference visitMemberReference(J.MemberReference memberRef, ExecutionContext ctx) {
                this.recordCall(memberRef.getMethodType(), ctx);
                return super.visitMemberReference(memberRef, ctx);
            }

            private void recordCall(@Nullable JavaType.Method method, ExecutionContext ctx) {
                if (method == null) {
                    return;
                }
                J.MethodDeclaration declaration = (J.MethodDeclaration)this.getCursor().firstEnclosing(J.MethodDeclaration.class);
                if (declaration != null && declaration.getMethodType() != null && this.methodsCalledInDeclaration.add(method)) {
                    this.methodsCalledInDeclaration.add(method);
                    FindCallGraph.this.methodCallGraph.insertRow(ctx, new MethodCallGraph.Row(this.signatureBuilder.signature(declaration.getMethodType()), this.signatureBuilder.signature(method)));
                }
            }
        };
    }

    private static class CallGraphSignatureBuilder
    extends DefaultJavaTypeSignatureBuilder {
        private CallGraphSignatureBuilder() {
        }

        @Override
        public String genericSignature(Object type) {
            return super.genericSignature(type).replace("Generic{", "<").replace("}", ">");
        }

        @Override
        public String methodSignature(JavaType.Method method) {
            StringBuilder s = new StringBuilder(this.signature(method.getDeclaringType()));
            s.append(" ").append(method.getName()).append("(");
            List<JavaType> parameterTypes = method.getParameterTypes();
            for (int i = 0; i < parameterTypes.size(); ++i) {
                JavaType parameterType = parameterTypes.get(i);
                s.append(i == 0 ? "" : ", ");
                s.append(this.signature(parameterType));
            }
            s.append(")");
            return s.toString();
        }
    }
}

