/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.search;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.InMemoryExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.marker.Marker;
import org.openrewrite.marker.SearchResult;

public class FindMissingTypes
extends Recipe {
    public String getDisplayName() {
        return "Find missing type information on Java ASTs";
    }

    public String getDescription() {
        return "This is a diagnostic recipe to highlight where ASTs are missing type attribution information.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new FindMissingTypesVisitor();
    }

    public static List<MissingTypeResult> findMissingTypes(J j) {
        J j1 = (J)new FindMissingTypesVisitor().visit(j, new InMemoryExecutionContext());
        ArrayList<MissingTypeResult> results = new ArrayList<MissingTypeResult>();
        if (j1 != j) {
            new JavaIsoVisitor<List<MissingTypeResult>>(){

                public <M extends Marker> M visitMarker(Marker marker, List<MissingTypeResult> missingTypeResults) {
                    if (marker instanceof SearchResult) {
                        String message = ((SearchResult)marker).getDescription();
                        String path = this.getCursor().getPathAsStream().filter(J.class::isInstance).map(t -> t.getClass().getSimpleName()).collect(Collectors.joining("->"));
                        J j = (J)this.getCursor().firstEnclosing(J.class);
                        String printedTree = this.getCursor().firstEnclosing(JavaSourceFile.class) != null ? (j != null ? j.printTrimmed(new InMemoryExecutionContext(), this.getCursor().getParentOrThrow()) : "") : String.valueOf(j);
                        missingTypeResults.add(new MissingTypeResult(message, path, printedTree, j));
                    }
                    return (M)super.visitMarker(marker, missingTypeResults);
                }
            }.visit(j1, results);
        }
        return results;
    }

    static class FindMissingTypesVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private final Set<JavaType> seenTypes = new HashSet<JavaType>();

        FindMissingTypesVisitor() {
        }

        @Override
        public J.Identifier visitIdentifier(J.Identifier identifier, ExecutionContext ctx) {
            if (!TypeUtils.isWellFormedType(identifier.getType(), this.seenTypes) && !this.isAllowedToHaveNullType(identifier)) {
                identifier = (J.Identifier)SearchResult.found((Tree)identifier, (String)"Identifier type is missing or malformed");
            }
            return identifier;
        }

        @Override
        public J.VariableDeclarations.NamedVariable visitVariable(J.VariableDeclarations.NamedVariable variable, ExecutionContext ctx) {
            J v = super.visitVariable(variable, ctx);
            if (v == variable) {
                JavaType.Variable variableType = ((J.VariableDeclarations.NamedVariable)v).getVariableType();
                if (!TypeUtils.isWellFormedType(variableType, this.seenTypes) && !this.isAllowedToHaveUnknownType(variable)) {
                    v = (J.VariableDeclarations.NamedVariable)SearchResult.found((Tree)v, (String)"Variable type is missing or malformed");
                } else if (variableType != null && !variableType.getName().equals(((J.VariableDeclarations.NamedVariable)v).getSimpleName())) {
                    v = (J.VariableDeclarations.NamedVariable)SearchResult.found((Tree)v, (String)("type information has a different variable name '" + variableType.getName() + "'"));
                }
            }
            return v;
        }

        private boolean isAllowedToHaveUnknownType(J.VariableDeclarations.NamedVariable variable) {
            Cursor parent;
            for (parent = this.getCursor().getParent(); parent != null && parent.getParent() != null && !(parent.getParentTreeCursor().getValue() instanceof J.ClassDeclaration); parent = parent.getParentTreeCursor()) {
            }
            return parent != null && parent.getValue() instanceof J.Block;
        }

        @Override
        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
            J mi = super.visitMethodInvocation(method, ctx);
            if (mi == method) {
                JavaType.Method type = ((J.MethodInvocation)mi).getMethodType();
                if (!TypeUtils.isWellFormedType(type, this.seenTypes)) {
                    mi = (J.MethodInvocation)SearchResult.found((Tree)mi, (String)"MethodInvocation type is missing or malformed");
                } else if (!type.getName().equals(((J.MethodInvocation)mi).getSimpleName()) && !type.isConstructor()) {
                    mi = (J.MethodInvocation)SearchResult.found((Tree)mi, (String)("type information has a different method name '" + type.getName() + "'"));
                }
            }
            return mi;
        }

        @Override
        public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, ExecutionContext ctx) {
            J md = super.visitMethodDeclaration(method, ctx);
            JavaType.Method type = ((J.MethodDeclaration)md).getMethodType();
            if (!TypeUtils.isWellFormedType(type, this.seenTypes)) {
                md = (J.MethodDeclaration)SearchResult.found((Tree)md, (String)"MethodDeclaration type is missing or malformed");
            } else if (!((J.MethodDeclaration)md).getSimpleName().equals(type.getName()) && !type.isConstructor()) {
                md = (J.MethodDeclaration)SearchResult.found((Tree)md, (String)("type information has a different method name '" + type.getName() + "'"));
            }
            return md;
        }

        @Override
        public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext ctx) {
            J.Package pkg;
            J.CompilationUnit jc;
            J cd = super.visitClassDeclaration(classDecl, ctx);
            JavaType.FullyQualified t = ((J.ClassDeclaration)cd).getType();
            if (!TypeUtils.isWellFormedType(t, this.seenTypes)) {
                return (J.ClassDeclaration)SearchResult.found((Tree)cd, (String)"ClassDeclaration type is missing or malformed");
            }
            if (!((J.ClassDeclaration)cd).getKind().name().equals(t.getKind().name())) {
                cd = (J.ClassDeclaration)SearchResult.found((Tree)cd, (String)(" J.ClassDeclaration kind " + (Object)((Object)((J.ClassDeclaration)cd).getKind()) + " does not match the kind in its type information " + (Object)((Object)t.getKind())));
            }
            if ((jc = (J.CompilationUnit)this.getCursor().firstEnclosing(J.CompilationUnit.class)) != null && (pkg = jc.getPackageDeclaration()) != null && t.getPackageName().equals(pkg.printTrimmed(this.getCursor()))) {
                cd = (J.ClassDeclaration)SearchResult.found((Tree)cd, (String)(" J.ClassDeclaration package " + pkg + " does not match the package in its type information " + pkg.printTrimmed(this.getCursor())));
            }
            return cd;
        }

        @Override
        public J.NewClass visitNewClass(J.NewClass newClass, ExecutionContext executionContext) {
            J n = super.visitNewClass(newClass, executionContext);
            if (n == newClass && !TypeUtils.isWellFormedType(((J.NewClass)n).getType(), this.seenTypes)) {
                n = (J.NewClass)SearchResult.found((Tree)n, (String)"NewClass type is missing or malformed");
            }
            return n;
        }

        private boolean isAllowedToHaveNullType(J.Identifier ident) {
            return this.inPackageDeclaration() || this.inImport() || this.isClassName() || this.isMethodName() || this.isMethodInvocationName() || this.isFieldAccess(ident) || this.isBeingDeclared(ident) || this.isParameterizedType(ident) || this.isNewClass(ident) || this.isTypeParameter() || this.isMemberReference(ident) || this.isCaseLabel() || this.isLabel() || this.isAnnotationField(ident);
        }

        private boolean inPackageDeclaration() {
            return this.getCursor().firstEnclosing(J.Package.class) != null;
        }

        private boolean inImport() {
            return this.getCursor().firstEnclosing(J.Import.class) != null;
        }

        private boolean isClassName() {
            Cursor parent = this.getCursor().getParent();
            return parent != null && parent.getValue() instanceof J.ClassDeclaration;
        }

        private boolean isMethodName() {
            Cursor parent = this.getCursor().getParent();
            return parent != null && parent.getValue() instanceof J.MethodDeclaration;
        }

        private boolean isMethodInvocationName() {
            Cursor parent = this.getCursor().getParent();
            return parent != null && parent.getValue() instanceof J.MethodInvocation;
        }

        private boolean isFieldAccess(J.Identifier ident) {
            J value = (J)this.getCursor().getParentTreeCursor().getValue();
            return value instanceof J.FieldAccess && (ident.equals(((J.FieldAccess)value).getName()) || ident.equals(((J.FieldAccess)value).getTarget()));
        }

        private boolean isBeingDeclared(J.Identifier ident) {
            J value = (J)this.getCursor().getParentTreeCursor().getValue();
            return value instanceof J.VariableDeclarations.NamedVariable && ident.equals(((J.VariableDeclarations.NamedVariable)value).getName());
        }

        private boolean isParameterizedType(J.Identifier ident) {
            J value = (J)this.getCursor().getParentTreeCursor().getValue();
            return value instanceof J.ParameterizedType && ident.equals(((J.ParameterizedType)value).getClazz());
        }

        private boolean isNewClass(J.Identifier ident) {
            J value = (J)this.getCursor().getParentTreeCursor().getValue();
            return value instanceof J.NewClass && ident.equals(((J.NewClass)value).getClazz());
        }

        private boolean isTypeParameter() {
            return this.getCursor().getParent() != null && this.getCursor().getParent().getValue() instanceof J.TypeParameter;
        }

        private boolean isMemberReference(J.Identifier ident) {
            J value = (J)this.getCursor().getParentTreeCursor().getValue();
            return value instanceof J.MemberReference && ident.equals(((J.MemberReference)value).getReference());
        }

        private boolean isCaseLabel() {
            return this.getCursor().getParentTreeCursor().getValue() instanceof J.Case;
        }

        private boolean isLabel() {
            return this.getCursor().firstEnclosing(J.Label.class) != null;
        }

        private boolean isAnnotationField(J.Identifier ident) {
            Cursor parent = this.getCursor().getParent();
            return parent != null && parent.getValue() instanceof J.Assignment && ident.equals(((J.Assignment)parent.getValue()).getVariable()) && this.getCursor().firstEnclosing(J.Annotation.class) != null;
        }
    }

    public static class MissingTypeResult {
        String message;
        String path;
        String printedTree;
        J j;

        public String getMessage() {
            return this.message;
        }

        public String getPath() {
            return this.path;
        }

        public String getPrintedTree() {
            return this.printedTree;
        }

        public J getJ() {
            return this.j;
        }

        public MissingTypeResult(String message, String path, String printedTree, J j) {
            this.message = message;
            this.path = path;
            this.printedTree = printedTree;
            this.j = j;
        }
    }
}

