/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.table;

import org.openrewrite.Column;
import org.openrewrite.DataTable;
import org.openrewrite.Recipe;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;

public class MethodCallGraph
extends DataTable<Row> {
    public MethodCallGraph(Recipe recipe) {
        super(recipe, "Method call graph", "The call relationships between methods.");
    }

    public static final class Row {
        @Column(displayName="From", description="The containing method that is making the call.")
        private final String from;
        @Column(displayName="To", description="The method that is being called.")
        private final String to;

        public Row(String from, String to) {
            this.from = from;
            this.to = to;
        }

        public String getFrom() {
            return this.from;
        }

        public String getTo() {
            return this.to;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Row)) {
                return false;
            }
            Row other = (Row)o;
            String this$from = this.getFrom();
            String other$from = other.getFrom();
            if (this$from == null ? other$from != null : !this$from.equals(other$from)) {
                return false;
            }
            String this$to = this.getTo();
            String other$to = other.getTo();
            return !(this$to == null ? other$to != null : !this$to.equals(other$to));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $from = this.getFrom();
            result = result * 59 + ($from == null ? 43 : $from.hashCode());
            String $to = this.getTo();
            result = result * 59 + ($to == null ? 43 : $to.hashCode());
            return result;
        }

        @NonNull
        public String toString() {
            return "MethodCallGraph.Row(from=" + this.getFrom() + ", to=" + this.getTo() + ")";
        }
    }
}

