/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import java.util.Collections;
import java.util.Objects;
import org.openrewrite.Cursor;
import org.openrewrite.Incubating;
import org.openrewrite.Tree;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.format.BlankLines;
import org.openrewrite.java.tree.Flag;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.marker.Markers;

@Incubating(since="7.35.0")
public class ExtractField<P>
extends JavaVisitor<P> {
    private final J.VariableDeclarations scope;

    public ExtractField(J.VariableDeclarations scope) {
        if (scope.getTypeAsFullyQualified() == null) {
            throw new IllegalArgumentException("Scope must have a fully qualified type");
        }
        this.scope = scope;
    }

    @Override
    public J visitBlock(J.Block block, P p) {
        J.Block b = (J.Block)super.visitBlock(block, p);
        if (((Boolean)this.getCursor().getMessage("extractTo", (Object)false)).booleanValue()) {
            J.VariableDeclarations field = this.autoFormat(this.scope.withId(Tree.randomId()).withVariables(ListUtils.map(this.scope.getVariables(), v -> v.withInitializer(null).withVariableType(new JavaType.Variable(null, Flag.Private.getBitMask(), v.getSimpleName(), (JavaType)((J.ClassDeclaration)this.getCursor().firstEnclosingOrThrow(J.ClassDeclaration.class)).getType(), v.getType(), Collections.emptyList())))).withModifiers(Collections.singletonList(new J.Modifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, J.Modifier.Type.Private, Collections.emptyList()))), p, this.getCursor());
            b = b.withStatements(ListUtils.concat((Object)field, b.getStatements()));
            Cursor updatedCursor = new Cursor(this.getCursor().getParentOrThrow(), (Object)b);
            b = b.withStatements(ListUtils.map(b.getStatements(), (n, stat) -> n == 1 ? (Statement)BlankLines.formatBlankLines(stat, updatedCursor) : stat));
        }
        return b;
    }

    @Override
    public J visitVariableDeclarations(J.VariableDeclarations multiVariable, P p) {
        if (multiVariable == this.scope) {
            ((Cursor)this.getCursor().getPathAsCursors(c -> c.getValue() instanceof J.Block && c.getParentTreeCursor().getValue() instanceof J.ClassDeclaration).next()).putMessage("extractTo", (Object)true);
            String fieldType = Objects.requireNonNull(multiVariable.getTypeAsFullyQualified()).getFullyQualifiedName();
            J.Assignment assignment = (J.Assignment)JavaTemplate.builder("this.#{} = #{any(" + fieldType + ")}").contextSensitive().build().apply(this.getCursor(), multiVariable.getCoordinates().replace(), multiVariable.getVariables().get(0).getSimpleName(), multiVariable.getVariables().get(0).getInitializer());
            return assignment.withType(multiVariable.getType());
        }
        return super.visitVariableDeclarations(multiVariable, p);
    }
}

