/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java;

import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.cleanup.UnnecessaryParentheses;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;

public class RemoveObjectsIsNull
extends Recipe {
    private static final MethodMatcher IS_NULL = new MethodMatcher("java.util.Objects isNull(..)");
    private static final MethodMatcher NON_NULL = new MethodMatcher("java.util.Objects nonNull(..)");

    public String getDisplayName() {
        return "Transform calls to `Objects.isNull(..)` and `Objects.nonNull(..)`";
    }

    public String getDescription() {
        return "Replace calls to `Objects.isNull(..)` and `Objects.nonNull(..)` with a simple null check. Using these methods outside of stream predicates is not idiomatic.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod(IS_NULL), new UsesMethod(NON_NULL)}), (TreeVisitor)new JavaVisitor<ExecutionContext>(){

            public Expression visitMethodInvocation(J.MethodInvocation method, ExecutionContext executionContext) {
                J.MethodInvocation m = (J.MethodInvocation)super.visitMethodInvocation(method, executionContext);
                if (IS_NULL.matches(m)) {
                    return this.replace(executionContext, m, "(#{any(boolean)}) == null");
                }
                if (NON_NULL.matches(m)) {
                    return this.replace(executionContext, m, "(#{any(boolean)}) != null");
                }
                return m;
            }

            private Expression replace(ExecutionContext executionContext, J.MethodInvocation m, String pattern) {
                Expression e = m.getArguments().get(0);
                Expression replaced = (Expression)JavaTemplate.apply(pattern, this.getCursor(), m.getCoordinates().replace(), e);
                return (Expression)new UnnecessaryParentheses().getVisitor().visitNonNull((Tree)replaced, (Object)executionContext, this.getCursor());
            }
        });
    }
}

