/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.tree;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.tree.Flag;
import org.openrewrite.java.tree.TypeUtils;

@JsonIdentityInfo(generator=ObjectIdGenerators.IntSequenceGenerator.class, property="@ref")
@JsonTypeInfo(use=JsonTypeInfo.Id.MINIMAL_CLASS, property="@c")
public interface JavaType
extends Serializable {
    public static void clearCaches() {
        Class.flyweights.clear();
        Method.flyweights.clear();
        Parameterized.flyweight.children.clear();
        Variable.flyweights.clear();
    }

    public boolean deepEquals(@Nullable JavaType var1);

    public static JavaType buildType(String typeName) {
        Primitive primitive = Primitive.fromKeyword(typeName);
        if (primitive != null) {
            return primitive;
        }
        return Class.build(typeName);
    }

    public static enum Primitive implements JavaType
    {
        Boolean,
        Byte,
        Char,
        Double,
        Float,
        Int,
        Long,
        Short,
        Void,
        String,
        None,
        Wildcard,
        Null;


        @Nullable
        public static Primitive fromKeyword(String keyword) {
            switch (keyword) {
                case "boolean": {
                    return Boolean;
                }
                case "byte": {
                    return Byte;
                }
                case "char": {
                    return Char;
                }
                case "double": {
                    return Double;
                }
                case "float": {
                    return Float;
                }
                case "int": {
                    return Int;
                }
                case "long": {
                    return Long;
                }
                case "short": {
                    return Short;
                }
                case "void": {
                    return Void;
                }
                case "String": {
                    return String;
                }
                case "*": {
                    return Wildcard;
                }
                case "null": {
                    return Null;
                }
                case "": {
                    return None;
                }
            }
            return null;
        }

        public String getKeyword() {
            switch (this) {
                case Boolean: {
                    return "boolean";
                }
                case Byte: {
                    return "byte";
                }
                case Char: {
                    return "char";
                }
                case Double: {
                    return "double";
                }
                case Float: {
                    return "float";
                }
                case Int: {
                    return "int";
                }
                case Long: {
                    return "long";
                }
                case Short: {
                    return "short";
                }
                case Void: {
                    return "void";
                }
                case String: {
                    return "String";
                }
                case Wildcard: {
                    return "*";
                }
                case Null: {
                    return "null";
                }
            }
            return "";
        }

        @Override
        public boolean deepEquals(@Nullable JavaType type) {
            return this == type;
        }
    }

    public static class Array
    implements JavaType {
        @Nullable
        private final JavaType elemType;

        public Array(@Nullable JavaType elemType) {
            this.elemType = elemType;
        }

        @Override
        public boolean deepEquals(@Nullable JavaType type) {
            return type instanceof Array && (this == type || this.elemType != null && this.elemType.deepEquals(((Array)type).elemType));
        }

        @Nullable
        public JavaType getElemType() {
            return this.elemType;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Array)) {
                return false;
            }
            Array other = (Array)o;
            if (!other.canEqual(this)) {
                return false;
            }
            JavaType this$elemType = this.getElemType();
            JavaType other$elemType = other.getElemType();
            return !(this$elemType == null ? other$elemType != null : !this$elemType.equals(other$elemType));
        }

        protected boolean canEqual(@Nullable Object other) {
            return other instanceof Array;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            JavaType $elemType = this.getElemType();
            result = result * 59 + ($elemType == null ? 43 : $elemType.hashCode());
            return result;
        }

        @NonNull
        public String toString() {
            return "JavaType.Array(elemType=" + this.getElemType() + ")";
        }
    }

    public static class GenericTypeVariable
    extends FullyQualified {
        private final String fullyQualifiedName;
        @Nullable
        private final FullyQualified bound;

        @Override
        public Class.Kind getKind() {
            return Class.Kind.Class;
        }

        @Override
        public boolean hasFlags(Flag ... test) {
            return this.bound != null && this.bound.hasFlags(test);
        }

        @Override
        public Set<Flag> getFlags() {
            return this.bound == null ? Collections.emptySet() : this.bound.getFlags();
        }

        @Override
        public List<FullyQualified> getInterfaces() {
            return this.bound == null ? Collections.emptyList() : this.bound.getInterfaces();
        }

        @Override
        public List<Variable> getMembers() {
            return this.bound == null ? Collections.emptyList() : this.bound.getMembers();
        }

        @Override
        public FullyQualified getOwningClass() {
            return this.bound == null ? null : this.bound.getOwningClass();
        }

        @Override
        public FullyQualified getSupertype() {
            return this.bound == null ? null : this.bound.getSupertype();
        }

        @Override
        public List<Variable> getVisibleSupertypeMembers() {
            return this.bound == null ? Collections.emptyList() : this.bound.getVisibleSupertypeMembers();
        }

        @Override
        public boolean deepEquals(@Nullable JavaType type) {
            if (!(type instanceof GenericTypeVariable)) {
                return false;
            }
            GenericTypeVariable generic = (GenericTypeVariable)type;
            return this == generic || this.fullyQualifiedName.equals(generic.fullyQualifiedName) && TypeUtils.deepEquals(this.bound, generic.bound);
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GenericTypeVariable)) {
                return false;
            }
            GenericTypeVariable other = (GenericTypeVariable)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$fullyQualifiedName = this.getFullyQualifiedName();
            String other$fullyQualifiedName = other.getFullyQualifiedName();
            if (this$fullyQualifiedName == null ? other$fullyQualifiedName != null : !this$fullyQualifiedName.equals(other$fullyQualifiedName)) {
                return false;
            }
            FullyQualified this$bound = this.getBound();
            FullyQualified other$bound = other.getBound();
            return !(this$bound == null ? other$bound != null : !this$bound.equals(other$bound));
        }

        protected boolean canEqual(@Nullable Object other) {
            return other instanceof GenericTypeVariable;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $fullyQualifiedName = this.getFullyQualifiedName();
            result = result * 59 + ($fullyQualifiedName == null ? 43 : $fullyQualifiedName.hashCode());
            FullyQualified $bound = this.getBound();
            result = result * 59 + ($bound == null ? 43 : $bound.hashCode());
            return result;
        }

        public GenericTypeVariable(String fullyQualifiedName, @Nullable FullyQualified bound) {
            this.fullyQualifiedName = fullyQualifiedName;
            this.bound = bound;
        }

        @Override
        public String getFullyQualifiedName() {
            return this.fullyQualifiedName;
        }

        @Nullable
        public FullyQualified getBound() {
            return this.bound;
        }

        @NonNull
        public String toString() {
            return "JavaType.GenericTypeVariable(fullyQualifiedName=" + this.getFullyQualifiedName() + ", bound=" + this.getBound() + ")";
        }

        @NonNull
        public GenericTypeVariable withBound(@Nullable FullyQualified bound) {
            return this.bound == bound ? this : new GenericTypeVariable(this.fullyQualifiedName, bound);
        }
    }

    public static class Method
    implements JavaType {
        private static final Map<FullyQualified, Map<String, Set<Method>>> flyweights = new WeakHashMap<FullyQualified, Map<String, Set<Method>>>();
        private final int flagsBitMap;
        private final FullyQualified declaringType;
        private final String name;
        @Nullable
        private final Signature genericSignature;
        private final Signature resolvedSignature;
        private final List<String> paramNames;
        private final List<FullyQualified> thrownExceptions;

        private Method(int flagsBitMap, FullyQualified declaringType, String name, @Nullable Signature genericSignature, Signature resolvedSignature, List<String> paramNames, List<FullyQualified> thrownExceptions) {
            this.flagsBitMap = flagsBitMap;
            this.declaringType = declaringType;
            this.name = name;
            this.genericSignature = genericSignature;
            this.resolvedSignature = resolvedSignature;
            this.paramNames = paramNames;
            this.thrownExceptions = thrownExceptions;
        }

        public static Method build(Set<Flag> flags, FullyQualified declaringType, String name, @Nullable Signature genericSignature, Signature resolvedSignature, List<String> paramNames, List<FullyQualified> thrownExceptions) {
            return Method.build(Flag.flagsToBitMap(flags), declaringType, name, genericSignature, resolvedSignature, paramNames, thrownExceptions);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JsonCreator
        public static Method build(int flagsBitMap, FullyQualified declaringType, String name, @Nullable Signature genericSignature, Signature resolvedSignature, List<String> paramNames, List<FullyQualified> thrownExceptions) {
            Method test = new Method(flagsBitMap, declaringType, name, genericSignature, resolvedSignature, paramNames, thrownExceptions);
            Map<FullyQualified, Map<String, Set<Method>>> map = flyweights;
            synchronized (map) {
                Set methods = flyweights.computeIfAbsent(declaringType, dt -> new WeakHashMap()).computeIfAbsent(name, n -> Collections.newSetFromMap(new WeakHashMap()));
                for (Method method : methods) {
                    if (!method.deepEquals(test)) continue;
                    return method;
                }
                methods.add(test);
                return test;
            }
        }

        private static boolean signatureDeepEquals(@Nullable Signature s1, @Nullable Signature s2) {
            return s1 == null ? s2 == null : s1 == s2 || s2 != null && TypeUtils.deepEquals(s1.returnType, s2.returnType) && TypeUtils.deepEquals(s1.paramTypes, s2.paramTypes);
        }

        public boolean hasFlags(Flag ... test) {
            return Flag.hasFlags(this.flagsBitMap, test);
        }

        public Set<Flag> getFlags() {
            return Flag.bitMapToFlags(this.flagsBitMap);
        }

        public Method withName(String name) {
            if (this.name.equals(name)) {
                return this;
            }
            return Method.build(this.flagsBitMap, this.declaringType, name, this.genericSignature, this.resolvedSignature, this.paramNames, this.thrownExceptions);
        }

        public Method withFlags(Set<Flag> flags) {
            int flagsBitMap = Flag.flagsToBitMap(flags);
            if (this.flagsBitMap == flagsBitMap) {
                return this;
            }
            return Method.build(flagsBitMap, this.declaringType, this.name, this.genericSignature, this.resolvedSignature, this.paramNames, this.thrownExceptions);
        }

        public Method withDeclaringType(FullyQualified declaringType) {
            if (this.declaringType.equals(declaringType)) {
                return this;
            }
            return Method.build(this.flagsBitMap, declaringType, this.name, this.genericSignature, this.resolvedSignature, this.paramNames, this.thrownExceptions);
        }

        public Method withGenericSignature(Signature genericSignature) {
            if (genericSignature.equals(this.genericSignature)) {
                return this;
            }
            return Method.build(this.flagsBitMap, this.declaringType, this.name, genericSignature, this.resolvedSignature, this.paramNames, this.thrownExceptions);
        }

        public Method withResolvedSignature(Signature resolvedSignature) {
            if (resolvedSignature.equals(this.resolvedSignature)) {
                return this;
            }
            return Method.build(this.flagsBitMap, this.declaringType, this.name, this.genericSignature, resolvedSignature, this.paramNames, this.thrownExceptions);
        }

        @Override
        public boolean deepEquals(@Nullable JavaType type) {
            if (!(type instanceof Method)) {
                return false;
            }
            Method m = (Method)type;
            return this == m || this.paramNames.equals(m.paramNames) && this.flagsBitMap == m.flagsBitMap && this.declaringType.deepEquals(m.declaringType) && Method.signatureDeepEquals(this.genericSignature, m.genericSignature) && Method.signatureDeepEquals(this.resolvedSignature, m.resolvedSignature) && TypeUtils.deepEquals(this.thrownExceptions, m.thrownExceptions);
        }

        public String toString() {
            return "Method{" + this.declaringType.getFullyQualifiedName() + " " + this.name + "(" + String.join((CharSequence)", ", this.paramNames) + ")}";
        }

        public FullyQualified getDeclaringType() {
            return this.declaringType;
        }

        public String getName() {
            return this.name;
        }

        @Nullable
        public Signature getGenericSignature() {
            return this.genericSignature;
        }

        public Signature getResolvedSignature() {
            return this.resolvedSignature;
        }

        public List<String> getParamNames() {
            return this.paramNames;
        }

        public List<FullyQualified> getThrownExceptions() {
            return this.thrownExceptions;
        }

        public static class Signature
        implements Serializable {
            @Nullable
            private final JavaType returnType;
            private final List<JavaType> paramTypes;

            public Signature(@Nullable JavaType returnType, List<JavaType> paramTypes) {
                this.returnType = returnType;
                this.paramTypes = paramTypes;
            }

            @Nullable
            public JavaType getReturnType() {
                return this.returnType;
            }

            public List<JavaType> getParamTypes() {
                return this.paramTypes;
            }

            public boolean equals(@Nullable Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Signature)) {
                    return false;
                }
                Signature other = (Signature)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                JavaType this$returnType = this.getReturnType();
                JavaType other$returnType = other.getReturnType();
                if (this$returnType == null ? other$returnType != null : !this$returnType.equals(other$returnType)) {
                    return false;
                }
                List<JavaType> this$paramTypes = this.getParamTypes();
                List<JavaType> other$paramTypes = other.getParamTypes();
                return !(this$paramTypes == null ? other$paramTypes != null : !((Object)this$paramTypes).equals(other$paramTypes));
            }

            protected boolean canEqual(@Nullable Object other) {
                return other instanceof Signature;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                JavaType $returnType = this.getReturnType();
                result = result * 59 + ($returnType == null ? 43 : $returnType.hashCode());
                List<JavaType> $paramTypes = this.getParamTypes();
                result = result * 59 + ($paramTypes == null ? 43 : ((Object)$paramTypes).hashCode());
                return result;
            }

            @NonNull
            public String toString() {
                return "JavaType.Method.Signature(returnType=" + this.getReturnType() + ", paramTypes=" + this.getParamTypes() + ")";
            }

            @NonNull
            public Signature withReturnType(@Nullable JavaType returnType) {
                return this.returnType == returnType ? this : new Signature(returnType, this.paramTypes);
            }

            @NonNull
            public Signature withParamTypes(List<JavaType> paramTypes) {
                return this.paramTypes == paramTypes ? this : new Signature(this.returnType, paramTypes);
            }
        }
    }

    public static class Variable
    implements JavaType {
        private static final Map<String, Map<JavaType, Set<Variable>>> flyweights = new WeakHashMap<String, Map<JavaType, Set<Variable>>>();
        private final String name;
        @Nullable
        private final JavaType type;
        private final int flagsBitMap;

        private Variable(String name, @Nullable JavaType type, int flagsBitMap) {
            this.name = name;
            this.type = type;
            this.flagsBitMap = flagsBitMap;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JsonCreator
        public static Variable build(String name, @Nullable JavaType type, int flagsBitMap) {
            Variable test = new Variable(name, type, flagsBitMap);
            Map<String, Map<JavaType, Set<Variable>>> map = flyweights;
            synchronized (map) {
                Set variables = flyweights.computeIfAbsent(name, n -> new WeakHashMap()).computeIfAbsent(type, fq -> Collections.newSetFromMap(new WeakHashMap()));
                for (Variable variable : variables) {
                    if (!variable.deepEquals(test)) continue;
                    return variable;
                }
                variables.add(test);
                return test;
            }
        }

        public boolean hasFlags(Flag ... test) {
            return Flag.hasFlags(this.flagsBitMap, test);
        }

        public Set<Flag> getFlags() {
            return Flag.bitMapToFlags(this.flagsBitMap);
        }

        @Override
        public boolean deepEquals(@Nullable JavaType type) {
            if (!(type instanceof Variable)) {
                return false;
            }
            Variable v = (Variable)type;
            return this == v || this.name.equals(v.name) && this.flagsBitMap == v.flagsBitMap && TypeUtils.deepEquals(this.type, v.type);
        }

        public String getName() {
            return this.name;
        }

        @Nullable
        public JavaType getType() {
            return this.type;
        }

        @NonNull
        public String toString() {
            return "JavaType.Variable(name=" + this.getName() + ", type=" + this.getType() + ", flagsBitMap=" + this.flagsBitMap + ")";
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Variable)) {
                return false;
            }
            Variable other = (Variable)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.flagsBitMap != other.flagsBitMap) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            JavaType this$type = this.getType();
            JavaType other$type = other.getType();
            return !(this$type == null ? other$type != null : !this$type.equals(other$type));
        }

        protected boolean canEqual(@Nullable Object other) {
            return other instanceof Variable;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.flagsBitMap;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            JavaType $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            return result;
        }
    }

    public static class Cyclic
    extends FullyQualified {
        private final String fullyQualifiedName;

        public Cyclic(String fullyQualifiedName) {
            this.fullyQualifiedName = fullyQualifiedName;
        }

        @Override
        public Class.Kind getKind() {
            return Class.Kind.Class;
        }

        @Override
        public boolean hasFlags(Flag ... test) {
            return test.length == 1 && test[0] == Flag.Public;
        }

        @Override
        public Set<Flag> getFlags() {
            return Collections.singleton(Flag.Public);
        }

        @Override
        public List<FullyQualified> getInterfaces() {
            return Collections.emptyList();
        }

        @Override
        public List<Variable> getMembers() {
            return Collections.emptyList();
        }

        @Override
        public Class getOwningClass() {
            return null;
        }

        @Override
        public Class getSupertype() {
            return Class.OBJECT;
        }

        @Override
        public List<Variable> getVisibleSupertypeMembers() {
            return Collections.emptyList();
        }

        @Override
        public boolean deepEquals(@Nullable JavaType type) {
            return this.equals(type);
        }

        public String toString() {
            return "Cyclic{" + this.fullyQualifiedName + '}';
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Cyclic)) {
                return false;
            }
            Cyclic other = (Cyclic)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$fullyQualifiedName = this.getFullyQualifiedName();
            String other$fullyQualifiedName = other.getFullyQualifiedName();
            return !(this$fullyQualifiedName == null ? other$fullyQualifiedName != null : !this$fullyQualifiedName.equals(other$fullyQualifiedName));
        }

        protected boolean canEqual(@Nullable Object other) {
            return other instanceof Cyclic;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $fullyQualifiedName = this.getFullyQualifiedName();
            result = result * 59 + ($fullyQualifiedName == null ? 43 : $fullyQualifiedName.hashCode());
            return result;
        }

        @Override
        public String getFullyQualifiedName() {
            return this.fullyQualifiedName;
        }
    }

    public static class Parameterized
    extends FullyQualified {
        private static final TypeTrieNode flyweight = new TypeTrieNode();
        private final FullyQualified type;
        private final List<JavaType> typeParameters;

        @JsonCreator
        public static Parameterized build(FullyQualified type, List<JavaType> typeParameters) {
            return flyweight.find(type, typeParameters);
        }

        private Parameterized(FullyQualified type, List<JavaType> typeParameters) {
            this.type = type;
            this.typeParameters = typeParameters;
        }

        @Override
        public String getFullyQualifiedName() {
            return this.type.getFullyQualifiedName();
        }

        @Override
        public boolean hasFlags(Flag ... test) {
            return this.type.hasFlags(new Flag[0]);
        }

        @Override
        public Set<Flag> getFlags() {
            return this.type.getFlags();
        }

        @Override
        public List<FullyQualified> getInterfaces() {
            return this.type.getInterfaces();
        }

        @Override
        public Class.Kind getKind() {
            return this.type.getKind();
        }

        @Override
        public List<Variable> getMembers() {
            return this.type.getMembers();
        }

        @Override
        public FullyQualified getOwningClass() {
            return this.type.getOwningClass();
        }

        @Override
        public FullyQualified getSupertype() {
            return this.type.getSupertype();
        }

        @Override
        public List<Variable> getVisibleSupertypeMembers() {
            return this.type.getVisibleSupertypeMembers();
        }

        @Override
        public boolean deepEquals(@Nullable JavaType type) {
            if (!(type instanceof Parameterized)) {
                return false;
            }
            Parameterized p = (Parameterized)type;
            return this == p || TypeUtils.deepEquals(this.type, p.type) && TypeUtils.deepEquals(this.typeParameters, p.typeParameters);
        }

        public FullyQualified getType() {
            return this.type;
        }

        public List<JavaType> getTypeParameters() {
            return this.typeParameters;
        }

        @NonNull
        public String toString() {
            return "JavaType.Parameterized(type=" + this.getType() + ", typeParameters=" + this.getTypeParameters() + ")";
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Parameterized)) {
                return false;
            }
            Parameterized other = (Parameterized)o;
            if (!other.canEqual(this)) {
                return false;
            }
            FullyQualified this$type = this.getType();
            FullyQualified other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            List<JavaType> this$typeParameters = this.getTypeParameters();
            List<JavaType> other$typeParameters = other.getTypeParameters();
            return !(this$typeParameters == null ? other$typeParameters != null : !((Object)this$typeParameters).equals(other$typeParameters));
        }

        protected boolean canEqual(@Nullable Object other) {
            return other instanceof Parameterized;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            FullyQualified $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            List<JavaType> $typeParameters = this.getTypeParameters();
            result = result * 59 + ($typeParameters == null ? 43 : ((Object)$typeParameters).hashCode());
            return result;
        }

        private static class TypeTrieNode {
            private Map<JavaType, TypeTrieNode> children;
            private Parameterized parameterized;

            private TypeTrieNode() {
            }

            public Parameterized find(FullyQualified type, List<JavaType> typeParameters) {
                TypeTrieNode node = this.find(type, typeParameters, -1);
                return node.parameterized;
            }

            private TypeTrieNode find(FullyQualified type, List<JavaType> typeParameters, int index) {
                if (this.children == null) {
                    this.children = new IdentityHashMap<JavaType, TypeTrieNode>(4);
                }
                TypeTrieNode node = index == -1 ? this.children.computeIfAbsent(type, t -> new TypeTrieNode()) : this.children.computeIfAbsent(typeParameters.get(index), t -> new TypeTrieNode());
                if (index == typeParameters.size() - 1) {
                    if (node.parameterized == null) {
                        node.parameterized = new Parameterized(type, typeParameters);
                    }
                    return node;
                }
                return node.find(type, typeParameters, index + 1);
            }
        }
    }

    public static class Class
    extends FullyQualified {
        private static final Map<String, Set<Class>> flyweights = new WeakHashMap<String, Set<Class>>();
        public static final Class OBJECT = Class.build("java.lang.Object");
        private final String fullyQualifiedName;
        private final int flagsBitMap;
        private final Kind kind;
        private final List<Variable> members;
        private final List<FullyQualified> interfaces;
        @Nullable
        private final List<Method> constructors;
        @Nullable
        private final FullyQualified supertype;
        @Nullable
        private final FullyQualified owningClass;

        private Class(int flagsBitMap, String fullyQualifiedName, Kind kind, List<Variable> members, List<FullyQualified> interfaces, @Nullable List<Method> constructors, @Nullable FullyQualified supertype, @Nullable FullyQualified owningClass) {
            this.fullyQualifiedName = fullyQualifiedName;
            this.flagsBitMap = flagsBitMap;
            this.kind = kind;
            this.members = members;
            this.interfaces = interfaces;
            this.constructors = constructors;
            this.supertype = supertype;
            this.owningClass = owningClass;
        }

        @Override
        public boolean hasFlags(Flag ... test) {
            return Flag.hasFlags(this.flagsBitMap, test);
        }

        @Override
        public Set<Flag> getFlags() {
            return Flag.bitMapToFlags(this.flagsBitMap);
        }

        public static Class build(String fullyQualifiedName) {
            return Class.build(1, fullyQualifiedName, Kind.Class, Collections.emptyList(), Collections.emptyList(), null, null, null, true);
        }

        public static Class build(String fullyQualifiedName, Kind kind) {
            return Class.build(1, fullyQualifiedName, kind, Collections.emptyList(), Collections.emptyList(), null, null, null, true);
        }

        public static Class build(Set<Flag> flags, String fullyQualifiedName, Kind kind, List<Variable> members, List<FullyQualified> interfaces, List<Method> constructors, @Nullable FullyQualified supertype, @Nullable FullyQualified owningClass) {
            return Class.build(Flag.flagsToBitMap(flags), fullyQualifiedName, kind, members, interfaces, constructors, supertype, owningClass, false);
        }

        @JsonCreator
        protected static Class build(int flagsBitMap, String fullyQualifiedName, Kind kind, List<Variable> members, List<FullyQualified> interfaces, @Nullable List<Method> constructors, @Nullable FullyQualified supertype, @Nullable FullyQualified owningClass) {
            return Class.build(flagsBitMap, fullyQualifiedName, kind, members, interfaces, constructors, supertype, owningClass, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static Class build(int flagsBitMap, String fullyQualifiedName, Kind kind, List<Variable> members, List<FullyQualified> interfaces, @Nullable List<Method> constructors, @Nullable FullyQualified supertype, @Nullable FullyQualified owningClass, boolean relaxedClassTypeMatching) {
            Set variants = flyweights.get(fullyQualifiedName);
            if (relaxedClassTypeMatching && variants != null && !variants.isEmpty()) {
                return variants.iterator().next();
            }
            Map<String, Set<Class>> map = flyweights;
            synchronized (map) {
                variants = flyweights.computeIfAbsent(fullyQualifiedName, fqn -> new HashSet());
                if (relaxedClassTypeMatching) {
                    if (variants.isEmpty()) {
                        Class candidate = Class.buildCandidate(flagsBitMap, fullyQualifiedName, kind, members, interfaces, constructors, supertype, owningClass);
                        variants.add(candidate);
                        return candidate;
                    }
                    return (Class)variants.iterator().next();
                }
                Class candidate = Class.buildCandidate(flagsBitMap, fullyQualifiedName, kind, members, interfaces, constructors, supertype, owningClass);
                Iterator iterator = variants.iterator();
                while (iterator.hasNext()) {
                    Class v = (Class)iterator.next();
                    if (!v.deepEquals(candidate)) continue;
                    return v;
                }
                if (candidate.supertype == null && (iterator = variants.iterator()).hasNext()) {
                    Class variant = (Class)iterator.next();
                    if (variant.supertype != null) {
                        return variant;
                    }
                    variants.add(candidate);
                    return candidate;
                }
                variants.add(candidate);
                return candidate;
            }
        }

        private static Class buildCandidate(int flagsBitMap, String fullyQualifiedName, Kind kind, List<Variable> members, List<FullyQualified> interfaces, @Nullable List<Method> constructors, @Nullable FullyQualified supertype, @Nullable FullyQualified owningClass) {
            List<Variable> sortedMembers;
            if (!members.isEmpty()) {
                if (fullyQualifiedName.equals("java.lang.String")) {
                    sortedMembers = new ArrayList<Variable>(members.size() - 1);
                    for (Variable m : members) {
                        if (m.getName().equals("serialPersistentFields")) continue;
                        sortedMembers.add(m);
                    }
                } else {
                    sortedMembers = new ArrayList<Variable>(members);
                }
                sortedMembers.sort(Comparator.comparing(Variable::getName));
            } else {
                sortedMembers = members;
            }
            return new Class(flagsBitMap, fullyQualifiedName, kind, sortedMembers, interfaces, constructors, supertype, owningClass);
        }

        @Override
        public List<Variable> getVisibleSupertypeMembers() {
            ArrayList<Variable> members = new ArrayList<Variable>();
            if (this.supertype != null) {
                for (Variable member : this.supertype.getMembers()) {
                    if (member.hasFlags(Flag.Private)) continue;
                    members.add(member);
                }
                members.addAll(this.supertype.getVisibleSupertypeMembers());
            }
            return members;
        }

        @Override
        public boolean deepEquals(@Nullable JavaType type) {
            if (!(type instanceof Class)) {
                return false;
            }
            Class c = (Class)type;
            return this == c || this.kind == c.kind && this.flagsBitMap == c.flagsBitMap && this.fullyQualifiedName.equals(c.fullyQualifiedName) && TypeUtils.deepEquals(this.members, c.members) && TypeUtils.deepEquals(this.interfaces, c.interfaces) && TypeUtils.deepEquals(this.supertype, c.supertype);
        }

        public String toString() {
            return "Class{" + this.fullyQualifiedName + '}';
        }

        @Override
        public String getFullyQualifiedName() {
            return this.fullyQualifiedName;
        }

        @Override
        public Kind getKind() {
            return this.kind;
        }

        @Override
        public List<Variable> getMembers() {
            return this.members;
        }

        @Override
        public List<FullyQualified> getInterfaces() {
            return this.interfaces;
        }

        @Nullable
        public List<Method> getConstructors() {
            return this.constructors;
        }

        @Override
        @Nullable
        public FullyQualified getSupertype() {
            return this.supertype;
        }

        @Override
        @Nullable
        public FullyQualified getOwningClass() {
            return this.owningClass;
        }

        public static enum Kind {
            Class,
            Enum,
            Interface,
            Annotation;

        }
    }

    public static class ShallowClass
    extends FullyQualified {
        private final String fullyQualifiedName;

        public ShallowClass(String fullyQualifiedName) {
            this.fullyQualifiedName = fullyQualifiedName;
        }

        @Override
        public Class.Kind getKind() {
            return Class.Kind.Class;
        }

        @Override
        public boolean hasFlags(Flag ... test) {
            return test.length == 1 && test[0] == Flag.Public;
        }

        @Override
        public Set<Flag> getFlags() {
            return Collections.singleton(Flag.Public);
        }

        @Override
        public List<FullyQualified> getInterfaces() {
            return Collections.emptyList();
        }

        @Override
        public List<Variable> getMembers() {
            return Collections.emptyList();
        }

        @Override
        public FullyQualified getOwningClass() {
            return null;
        }

        @Override
        public FullyQualified getSupertype() {
            return Class.OBJECT;
        }

        @Override
        public List<Variable> getVisibleSupertypeMembers() {
            return Collections.emptyList();
        }

        @Override
        public boolean deepEquals(@Nullable JavaType type) {
            return this == type || type instanceof ShallowClass && this.fullyQualifiedName.equals(((ShallowClass)type).fullyQualifiedName);
        }

        public String toString() {
            return "ShallowClass(" + this.fullyQualifiedName + ")";
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ShallowClass)) {
                return false;
            }
            ShallowClass other = (ShallowClass)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$fullyQualifiedName = this.getFullyQualifiedName();
            String other$fullyQualifiedName = other.getFullyQualifiedName();
            return !(this$fullyQualifiedName == null ? other$fullyQualifiedName != null : !this$fullyQualifiedName.equals(other$fullyQualifiedName));
        }

        protected boolean canEqual(@Nullable Object other) {
            return other instanceof ShallowClass;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $fullyQualifiedName = this.getFullyQualifiedName();
            result = result * 59 + ($fullyQualifiedName == null ? 43 : $fullyQualifiedName.hashCode());
            return result;
        }

        @Override
        public String getFullyQualifiedName() {
            return this.fullyQualifiedName;
        }
    }

    public static abstract class FullyQualified
    implements JavaType {
        public abstract String getFullyQualifiedName();

        public abstract boolean hasFlags(Flag ... var1);

        public abstract Set<Flag> getFlags();

        public abstract List<FullyQualified> getInterfaces();

        public abstract Class.Kind getKind();

        public abstract List<Variable> getMembers();

        @Nullable
        public abstract FullyQualified getOwningClass();

        @Nullable
        public abstract FullyQualified getSupertype();

        public abstract List<Variable> getVisibleSupertypeMembers();

        public String getClassName() {
            AtomicBoolean dropWhile = new AtomicBoolean(false);
            return Arrays.stream(this.getFullyQualifiedName().split("\\.")).filter(part -> {
                dropWhile.set(dropWhile.get() || !Character.isLowerCase(part.charAt(0)));
                return dropWhile.get();
            }).collect(Collectors.joining("."));
        }

        public String getPackageName() {
            AtomicBoolean takeWhile = new AtomicBoolean(true);
            return Arrays.stream(this.getFullyQualifiedName().split("\\.")).filter(part -> {
                takeWhile.set(takeWhile.get() && !Character.isUpperCase(part.charAt(0)));
                return takeWhile.get();
            }).collect(Collectors.joining("."));
        }

        public boolean isAssignableFrom(@Nullable FullyQualified clazz) {
            return clazz != null && (this == Class.OBJECT || this.getFullyQualifiedName().equals(clazz.getFullyQualifiedName()) || this.isAssignableFrom(clazz.getSupertype()) || clazz.getInterfaces().stream().anyMatch(this::isAssignableFrom));
        }
    }

    public static class MultiCatch
    implements JavaType {
        private final List<JavaType> throwableTypes;

        public MultiCatch(List<JavaType> throwableTypes) {
            this.throwableTypes = throwableTypes;
        }

        @Override
        public boolean deepEquals(@Nullable JavaType type) {
            return this == type || type instanceof MultiCatch && TypeUtils.deepEquals(this.throwableTypes, ((MultiCatch)type).throwableTypes);
        }

        public List<JavaType> getThrowableTypes() {
            return this.throwableTypes;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MultiCatch)) {
                return false;
            }
            MultiCatch other = (MultiCatch)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<JavaType> this$throwableTypes = this.getThrowableTypes();
            List<JavaType> other$throwableTypes = other.getThrowableTypes();
            return !(this$throwableTypes == null ? other$throwableTypes != null : !((Object)this$throwableTypes).equals(other$throwableTypes));
        }

        protected boolean canEqual(@Nullable Object other) {
            return other instanceof MultiCatch;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<JavaType> $throwableTypes = this.getThrowableTypes();
            result = result * 59 + ($throwableTypes == null ? 43 : ((Object)$throwableTypes).hashCode());
            return result;
        }

        @NonNull
        public String toString() {
            return "JavaType.MultiCatch(throwableTypes=" + this.getThrowableTypes() + ")";
        }
    }
}

